package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a `AWS::ApiGateway::Resource`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-22T08:27:19.634Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnResourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::ApiGateway::Resource.ParentId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html#cfn-apigateway-resource-parentid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getParentId();

    /**
     * `AWS::ApiGateway::Resource.PathPart`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html#cfn-apigateway-resource-pathpart
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getPathPart();

    /**
     * `AWS::ApiGateway::Resource.RestApiId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html#cfn-apigateway-resource-restapiid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getRestApiId();

    /**
     * @return a {@link Builder} of {@link CfnResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String parentId;
        private java.lang.String pathPart;
        private java.lang.String restApiId;

        /**
         * Sets the value of ParentId
         * @param parentId `AWS::ApiGateway::Resource.ParentId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder parentId(java.lang.String parentId) {
            this.parentId = parentId;
            return this;
        }

        /**
         * Sets the value of PathPart
         * @param pathPart `AWS::ApiGateway::Resource.PathPart`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder pathPart(java.lang.String pathPart) {
            this.pathPart = pathPart;
            return this;
        }

        /**
         * Sets the value of RestApiId
         * @param restApiId `AWS::ApiGateway::Resource.RestApiId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder restApiId(java.lang.String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnResourceProps build() {
            return new Jsii$Proxy(parentId, pathPart, restApiId);
        }
    }

    /**
     * An implementation for {@link CfnResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResourceProps {
        private final java.lang.String parentId;
        private final java.lang.String pathPart;
        private final java.lang.String restApiId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.parentId = this.jsiiGet("parentId", java.lang.String.class);
            this.pathPart = this.jsiiGet("pathPart", java.lang.String.class);
            this.restApiId = this.jsiiGet("restApiId", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String parentId, java.lang.String pathPart, java.lang.String restApiId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.parentId = java.util.Objects.requireNonNull(parentId, "parentId is required");
            this.pathPart = java.util.Objects.requireNonNull(pathPart, "pathPart is required");
            this.restApiId = java.util.Objects.requireNonNull(restApiId, "restApiId is required");
        }

        @Override
        public java.lang.String getParentId() {
            return this.parentId;
        }

        @Override
        public java.lang.String getPathPart() {
            return this.pathPart;
        }

        @Override
        public java.lang.String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("parentId", om.valueToTree(this.getParentId()));
            obj.set("pathPart", om.valueToTree(this.getPathPart()));
            obj.set("restApiId", om.valueToTree(this.getRestApiId()));
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResourceProps.Jsii$Proxy that = (CfnResourceProps.Jsii$Proxy) o;

            if (!parentId.equals(that.parentId)) return false;
            if (!pathPart.equals(that.pathPart)) return false;
            return this.restApiId.equals(that.restApiId);
        }

        @Override
        public int hashCode() {
            int result = this.parentId.hashCode();
            result = 31 * result + (this.pathPart.hashCode());
            result = 31 * result + (this.restApiId.hashCode());
            return result;
        }
    }
}
