package software.amazon.awscdk.services.apigateway;

/**
 * A CloudFormation `AWS::ApiGateway::UsagePlan`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-22T08:27:19.656Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnUsagePlan")
public class CfnUsagePlan extends software.amazon.awscdk.core.CfnResource {

    protected CfnUsagePlan(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnUsagePlan(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnUsagePlan.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ApiGateway::UsagePlan`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnUsagePlan(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.apigateway.CfnUsagePlanProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props }));
    }

    /**
     * Create a new `AWS::ApiGateway::UsagePlan`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnUsagePlan(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") }));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::ApiGateway::UsagePlan.ApiStages`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-apistages
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getApiStages() {
        return this.jsiiGet("apiStages", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::UsagePlan.ApiStages`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-apistages
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApiStages(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("apiStages", value);
    }

    /**
     * `AWS::ApiGateway::UsagePlan.ApiStages`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-apistages
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApiStages(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("apiStages", value);
    }

    /**
     * `AWS::ApiGateway::UsagePlan.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::UsagePlan.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDescription(final java.lang.String value) {
        this.jsiiSet("description", value);
    }

    /**
     * `AWS::ApiGateway::UsagePlan.Quota`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-quota
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getQuota() {
        return this.jsiiGet("quota", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::UsagePlan.Quota`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-quota
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setQuota(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("quota", value);
    }

    /**
     * `AWS::ApiGateway::UsagePlan.Quota`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-quota
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setQuota(final software.amazon.awscdk.services.apigateway.CfnUsagePlan.QuotaSettingsProperty value) {
        this.jsiiSet("quota", value);
    }

    /**
     * `AWS::ApiGateway::UsagePlan.Throttle`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-throttle
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getThrottle() {
        return this.jsiiGet("throttle", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::UsagePlan.Throttle`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-throttle
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setThrottle(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("throttle", value);
    }

    /**
     * `AWS::ApiGateway::UsagePlan.Throttle`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-throttle
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setThrottle(final software.amazon.awscdk.services.apigateway.CfnUsagePlan.ThrottleSettingsProperty value) {
        this.jsiiSet("throttle", value);
    }

    /**
     * `AWS::ApiGateway::UsagePlan.UsagePlanName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-usageplanname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getUsagePlanName() {
        return this.jsiiGet("usagePlanName", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::UsagePlan.UsagePlanName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-usageplanname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setUsagePlanName(final java.lang.String value) {
        this.jsiiSet("usagePlanName", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ApiStageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnUsagePlan.ApiStageProperty.ApiId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-apiid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getApiId();

        /**
         * `CfnUsagePlan.ApiStageProperty.Stage`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-stage
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStage();

        /**
         * `CfnUsagePlan.ApiStageProperty.Throttle`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-throttle
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getThrottle();

        /**
         * @return a {@link Builder} of {@link ApiStageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApiStageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String apiId;
            private java.lang.String stage;
            private java.lang.Object throttle;

            /**
             * Sets the value of ApiId
             * @param apiId `CfnUsagePlan.ApiStageProperty.ApiId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder apiId(java.lang.String apiId) {
                this.apiId = apiId;
                return this;
            }

            /**
             * Sets the value of Stage
             * @param stage `CfnUsagePlan.ApiStageProperty.Stage`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder stage(java.lang.String stage) {
                this.stage = stage;
                return this;
            }

            /**
             * Sets the value of Throttle
             * @param throttle `CfnUsagePlan.ApiStageProperty.Throttle`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder throttle(software.amazon.awscdk.core.IResolvable throttle) {
                this.throttle = throttle;
                return this;
            }

            /**
             * Sets the value of Throttle
             * @param throttle `CfnUsagePlan.ApiStageProperty.Throttle`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder throttle(java.util.Map<java.lang.String, java.lang.Object> throttle) {
                this.throttle = throttle;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApiStageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ApiStageProperty build() {
                return new Jsii$Proxy(apiId, stage, throttle);
            }
        }

        /**
         * An implementation for {@link ApiStageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiStageProperty {
            private final java.lang.String apiId;
            private final java.lang.String stage;
            private final java.lang.Object throttle;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.apiId = this.jsiiGet("apiId", java.lang.String.class);
                this.stage = this.jsiiGet("stage", java.lang.String.class);
                this.throttle = this.jsiiGet("throttle", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String apiId, java.lang.String stage, java.lang.Object throttle) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiId = apiId;
                this.stage = stage;
                this.throttle = throttle;
            }

            @Override
            public java.lang.String getApiId() {
                return this.apiId;
            }

            @Override
            public java.lang.String getStage() {
                return this.stage;
            }

            @Override
            public java.lang.Object getThrottle() {
                return this.throttle;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getApiId() != null) {
                    obj.set("apiId", om.valueToTree(this.getApiId()));
                }
                if (this.getStage() != null) {
                    obj.set("stage", om.valueToTree(this.getStage()));
                }
                if (this.getThrottle() != null) {
                    obj.set("throttle", om.valueToTree(this.getThrottle()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApiStageProperty.Jsii$Proxy that = (ApiStageProperty.Jsii$Proxy) o;

                if (this.apiId != null ? !this.apiId.equals(that.apiId) : that.apiId != null) return false;
                if (this.stage != null ? !this.stage.equals(that.stage) : that.stage != null) return false;
                return this.throttle != null ? this.throttle.equals(that.throttle) : that.throttle == null;
            }

            @Override
            public int hashCode() {
                int result = this.apiId != null ? this.apiId.hashCode() : 0;
                result = 31 * result + (this.stage != null ? this.stage.hashCode() : 0);
                result = 31 * result + (this.throttle != null ? this.throttle.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface QuotaSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnUsagePlan.QuotaSettingsProperty.Limit`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-limit
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getLimit();

        /**
         * `CfnUsagePlan.QuotaSettingsProperty.Offset`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-offset
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getOffset();

        /**
         * `CfnUsagePlan.QuotaSettingsProperty.Period`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-period
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPeriod();

        /**
         * @return a {@link Builder} of {@link QuotaSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QuotaSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Number limit;
            private java.lang.Number offset;
            private java.lang.String period;

            /**
             * Sets the value of Limit
             * @param limit `CfnUsagePlan.QuotaSettingsProperty.Limit`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder limit(java.lang.Number limit) {
                this.limit = limit;
                return this;
            }

            /**
             * Sets the value of Offset
             * @param offset `CfnUsagePlan.QuotaSettingsProperty.Offset`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder offset(java.lang.Number offset) {
                this.offset = offset;
                return this;
            }

            /**
             * Sets the value of Period
             * @param period `CfnUsagePlan.QuotaSettingsProperty.Period`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder period(java.lang.String period) {
                this.period = period;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QuotaSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public QuotaSettingsProperty build() {
                return new Jsii$Proxy(limit, offset, period);
            }
        }

        /**
         * An implementation for {@link QuotaSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QuotaSettingsProperty {
            private final java.lang.Number limit;
            private final java.lang.Number offset;
            private final java.lang.String period;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.limit = this.jsiiGet("limit", java.lang.Number.class);
                this.offset = this.jsiiGet("offset", java.lang.Number.class);
                this.period = this.jsiiGet("period", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Number limit, java.lang.Number offset, java.lang.String period) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.limit = limit;
                this.offset = offset;
                this.period = period;
            }

            @Override
            public java.lang.Number getLimit() {
                return this.limit;
            }

            @Override
            public java.lang.Number getOffset() {
                return this.offset;
            }

            @Override
            public java.lang.String getPeriod() {
                return this.period;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getLimit() != null) {
                    obj.set("limit", om.valueToTree(this.getLimit()));
                }
                if (this.getOffset() != null) {
                    obj.set("offset", om.valueToTree(this.getOffset()));
                }
                if (this.getPeriod() != null) {
                    obj.set("period", om.valueToTree(this.getPeriod()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QuotaSettingsProperty.Jsii$Proxy that = (QuotaSettingsProperty.Jsii$Proxy) o;

                if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) return false;
                if (this.offset != null ? !this.offset.equals(that.offset) : that.offset != null) return false;
                return this.period != null ? this.period.equals(that.period) : that.period == null;
            }

            @Override
            public int hashCode() {
                int result = this.limit != null ? this.limit.hashCode() : 0;
                result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
                result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface ThrottleSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnUsagePlan.ThrottleSettingsProperty.BurstLimit`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-burstlimit
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getBurstLimit();

        /**
         * `CfnUsagePlan.ThrottleSettingsProperty.RateLimit`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-ratelimit
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getRateLimit();

        /**
         * @return a {@link Builder} of {@link ThrottleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ThrottleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Number burstLimit;
            private java.lang.Number rateLimit;

            /**
             * Sets the value of BurstLimit
             * @param burstLimit `CfnUsagePlan.ThrottleSettingsProperty.BurstLimit`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder burstLimit(java.lang.Number burstLimit) {
                this.burstLimit = burstLimit;
                return this;
            }

            /**
             * Sets the value of RateLimit
             * @param rateLimit `CfnUsagePlan.ThrottleSettingsProperty.RateLimit`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder rateLimit(java.lang.Number rateLimit) {
                this.rateLimit = rateLimit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ThrottleSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public ThrottleSettingsProperty build() {
                return new Jsii$Proxy(burstLimit, rateLimit);
            }
        }

        /**
         * An implementation for {@link ThrottleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThrottleSettingsProperty {
            private final java.lang.Number burstLimit;
            private final java.lang.Number rateLimit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.burstLimit = this.jsiiGet("burstLimit", java.lang.Number.class);
                this.rateLimit = this.jsiiGet("rateLimit", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.Number burstLimit, java.lang.Number rateLimit) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.burstLimit = burstLimit;
                this.rateLimit = rateLimit;
            }

            @Override
            public java.lang.Number getBurstLimit() {
                return this.burstLimit;
            }

            @Override
            public java.lang.Number getRateLimit() {
                return this.rateLimit;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getBurstLimit() != null) {
                    obj.set("burstLimit", om.valueToTree(this.getBurstLimit()));
                }
                if (this.getRateLimit() != null) {
                    obj.set("rateLimit", om.valueToTree(this.getRateLimit()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ThrottleSettingsProperty.Jsii$Proxy that = (ThrottleSettingsProperty.Jsii$Proxy) o;

                if (this.burstLimit != null ? !this.burstLimit.equals(that.burstLimit) : that.burstLimit != null) return false;
                return this.rateLimit != null ? this.rateLimit.equals(that.rateLimit) : that.rateLimit == null;
            }

            @Override
            public int hashCode() {
                int result = this.burstLimit != null ? this.burstLimit.hashCode() : 0;
                result = 31 * result + (this.rateLimit != null ? this.rateLimit.hashCode() : 0);
                return result;
            }
        }
    }
}
