package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-22T08:27:19.673Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MethodOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates whether the method requires clients to submit a valid API key.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getApiKeyRequired();

    /**
     * Method authorization.
     * 
     * Default: None open access
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.AuthorizationType getAuthorizationType();

    /**
     * If `authorizationType` is `Custom`, this specifies the ID of the method authorizer resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.IAuthorizer getAuthorizer();

    /**
     * The responses that can be sent to the client who calls the method.
     * 
     * Default: None
     * 
     * This property is not required, but if these are not supplied for a Lambda
     * proxy integration, the Lambda function must return a value of the correct format,
     * for the integration response to be correctly mapped to a response to the client.
     * 
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-settings-method-response.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.apigateway.MethodResponse> getMethodResponses();

    /**
     * A friendly operation name for the method.
     * 
     * For example, you can assign the
     * OperationName of ListPets for the GET /pets method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getOperationName();

    /**
     * The resources that are used for the response's content type.
     * 
     * Specify request
     * models as key-value pairs (string-to-string mapping), with a content type
     * as the key and a Model resource name as the value
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> getRequestModels();

    /**
     * The request parameters that API Gateway accepts.
     * 
     * Specify request parameters
     * as key-value pairs (string-to-Boolean mapping), with a source as the key and
     * a Boolean as the value. The Boolean specifies whether a parameter is required.
     * A source must match the format method.request.location.name, where the location
     * is querystring, path, or header, and name is a valid, unique parameter name.
     * 
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.Map<java.lang.String, java.lang.Boolean> getRequestParameters();

    /**
     * The ID of the associated request validator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.IRequestValidator getRequestValidator();

    /**
     * @return a {@link Builder} of {@link MethodOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MethodOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.Boolean apiKeyRequired;
        private software.amazon.awscdk.services.apigateway.AuthorizationType authorizationType;
        private software.amazon.awscdk.services.apigateway.IAuthorizer authorizer;
        private java.util.List<software.amazon.awscdk.services.apigateway.MethodResponse> methodResponses;
        private java.lang.String operationName;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> requestModels;
        private java.util.Map<java.lang.String, java.lang.Boolean> requestParameters;
        private software.amazon.awscdk.services.apigateway.IRequestValidator requestValidator;

        /**
         * Sets the value of ApiKeyRequired
         * @param apiKeyRequired Indicates whether the method requires clients to submit a valid API key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyRequired(java.lang.Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        /**
         * Sets the value of AuthorizationType
         * @param authorizationType Method authorization.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationType(software.amazon.awscdk.services.apigateway.AuthorizationType authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        /**
         * Sets the value of Authorizer
         * @param authorizer If `authorizationType` is `Custom`, this specifies the ID of the method authorizer resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizer(software.amazon.awscdk.services.apigateway.IAuthorizer authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        /**
         * Sets the value of MethodResponses
         * @param methodResponses The responses that can be sent to the client who calls the method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder methodResponses(java.util.List<software.amazon.awscdk.services.apigateway.MethodResponse> methodResponses) {
            this.methodResponses = methodResponses;
            return this;
        }

        /**
         * Sets the value of OperationName
         * @param operationName A friendly operation name for the method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operationName(java.lang.String operationName) {
            this.operationName = operationName;
            return this;
        }

        /**
         * Sets the value of RequestModels
         * @param requestModels The resources that are used for the response's content type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestModels(java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> requestModels) {
            this.requestModels = requestModels;
            return this;
        }

        /**
         * Sets the value of RequestParameters
         * @param requestParameters The request parameters that API Gateway accepts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(java.util.Map<java.lang.String, java.lang.Boolean> requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        /**
         * Sets the value of RequestValidator
         * @param requestValidator The ID of the associated request validator.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestValidator(software.amazon.awscdk.services.apigateway.IRequestValidator requestValidator) {
            this.requestValidator = requestValidator;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MethodOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public MethodOptions build() {
            return new Jsii$Proxy(apiKeyRequired, authorizationType, authorizer, methodResponses, operationName, requestModels, requestParameters, requestValidator);
        }
    }

    /**
     * An implementation for {@link MethodOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MethodOptions {
        private final java.lang.Boolean apiKeyRequired;
        private final software.amazon.awscdk.services.apigateway.AuthorizationType authorizationType;
        private final software.amazon.awscdk.services.apigateway.IAuthorizer authorizer;
        private final java.util.List<software.amazon.awscdk.services.apigateway.MethodResponse> methodResponses;
        private final java.lang.String operationName;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> requestModels;
        private final java.util.Map<java.lang.String, java.lang.Boolean> requestParameters;
        private final software.amazon.awscdk.services.apigateway.IRequestValidator requestValidator;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.apiKeyRequired = this.jsiiGet("apiKeyRequired", java.lang.Boolean.class);
            this.authorizationType = this.jsiiGet("authorizationType", software.amazon.awscdk.services.apigateway.AuthorizationType.class);
            this.authorizer = this.jsiiGet("authorizer", software.amazon.awscdk.services.apigateway.IAuthorizer.class);
            this.methodResponses = this.jsiiGet("methodResponses", java.util.List.class);
            this.operationName = this.jsiiGet("operationName", java.lang.String.class);
            this.requestModels = this.jsiiGet("requestModels", java.util.Map.class);
            this.requestParameters = this.jsiiGet("requestParameters", java.util.Map.class);
            this.requestValidator = this.jsiiGet("requestValidator", software.amazon.awscdk.services.apigateway.IRequestValidator.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Boolean apiKeyRequired, software.amazon.awscdk.services.apigateway.AuthorizationType authorizationType, software.amazon.awscdk.services.apigateway.IAuthorizer authorizer, java.util.List<software.amazon.awscdk.services.apigateway.MethodResponse> methodResponses, java.lang.String operationName, java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> requestModels, java.util.Map<java.lang.String, java.lang.Boolean> requestParameters, software.amazon.awscdk.services.apigateway.IRequestValidator requestValidator) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiKeyRequired = apiKeyRequired;
            this.authorizationType = authorizationType;
            this.authorizer = authorizer;
            this.methodResponses = methodResponses;
            this.operationName = operationName;
            this.requestModels = requestModels;
            this.requestParameters = requestParameters;
            this.requestValidator = requestValidator;
        }

        @Override
        public java.lang.Boolean getApiKeyRequired() {
            return this.apiKeyRequired;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.AuthorizationType getAuthorizationType() {
            return this.authorizationType;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.IAuthorizer getAuthorizer() {
            return this.authorizer;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.apigateway.MethodResponse> getMethodResponses() {
            return this.methodResponses;
        }

        @Override
        public java.lang.String getOperationName() {
            return this.operationName;
        }

        @Override
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> getRequestModels() {
            return this.requestModels;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.Boolean> getRequestParameters() {
            return this.requestParameters;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.IRequestValidator getRequestValidator() {
            return this.requestValidator;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getApiKeyRequired() != null) {
                obj.set("apiKeyRequired", om.valueToTree(this.getApiKeyRequired()));
            }
            if (this.getAuthorizationType() != null) {
                obj.set("authorizationType", om.valueToTree(this.getAuthorizationType()));
            }
            if (this.getAuthorizer() != null) {
                obj.set("authorizer", om.valueToTree(this.getAuthorizer()));
            }
            if (this.getMethodResponses() != null) {
                obj.set("methodResponses", om.valueToTree(this.getMethodResponses()));
            }
            if (this.getOperationName() != null) {
                obj.set("operationName", om.valueToTree(this.getOperationName()));
            }
            if (this.getRequestModels() != null) {
                obj.set("requestModels", om.valueToTree(this.getRequestModels()));
            }
            if (this.getRequestParameters() != null) {
                obj.set("requestParameters", om.valueToTree(this.getRequestParameters()));
            }
            if (this.getRequestValidator() != null) {
                obj.set("requestValidator", om.valueToTree(this.getRequestValidator()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MethodOptions.Jsii$Proxy that = (MethodOptions.Jsii$Proxy) o;

            if (this.apiKeyRequired != null ? !this.apiKeyRequired.equals(that.apiKeyRequired) : that.apiKeyRequired != null) return false;
            if (this.authorizationType != null ? !this.authorizationType.equals(that.authorizationType) : that.authorizationType != null) return false;
            if (this.authorizer != null ? !this.authorizer.equals(that.authorizer) : that.authorizer != null) return false;
            if (this.methodResponses != null ? !this.methodResponses.equals(that.methodResponses) : that.methodResponses != null) return false;
            if (this.operationName != null ? !this.operationName.equals(that.operationName) : that.operationName != null) return false;
            if (this.requestModels != null ? !this.requestModels.equals(that.requestModels) : that.requestModels != null) return false;
            if (this.requestParameters != null ? !this.requestParameters.equals(that.requestParameters) : that.requestParameters != null) return false;
            return this.requestValidator != null ? this.requestValidator.equals(that.requestValidator) : that.requestValidator == null;
        }

        @Override
        public int hashCode() {
            int result = this.apiKeyRequired != null ? this.apiKeyRequired.hashCode() : 0;
            result = 31 * result + (this.authorizationType != null ? this.authorizationType.hashCode() : 0);
            result = 31 * result + (this.authorizer != null ? this.authorizer.hashCode() : 0);
            result = 31 * result + (this.methodResponses != null ? this.methodResponses.hashCode() : 0);
            result = 31 * result + (this.operationName != null ? this.operationName.hashCode() : 0);
            result = 31 * result + (this.requestModels != null ? this.requestModels.hashCode() : 0);
            result = 31 * result + (this.requestParameters != null ? this.requestParameters.hashCode() : 0);
            result = 31 * result + (this.requestValidator != null ? this.requestValidator.hashCode() : 0);
            return result;
        }
    }
}
