package software.amazon.awscdk.services.apigateway;

/**
 * Specifies the maximum number of requests that clients can make to API Gateway APIs.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-22T08:27:19.676Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface QuotaSettings extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum number of requests that users can make within the specified time period.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getLimit();

    /**
     * For the initial time period, the number of requests to subtract from the specified limit.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getOffset();

    /**
     * The time period for which the maximum limit of requests applies.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.Period getPeriod();

    /**
     * @return a {@link Builder} of {@link QuotaSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link QuotaSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.Number limit;
        private java.lang.Number offset;
        private software.amazon.awscdk.services.apigateway.Period period;

        /**
         * Sets the value of Limit
         * @param limit The maximum number of requests that users can make within the specified time period.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder limit(java.lang.Number limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Sets the value of Offset
         * @param offset For the initial time period, the number of requests to subtract from the specified limit.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder offset(java.lang.Number offset) {
            this.offset = offset;
            return this;
        }

        /**
         * Sets the value of Period
         * @param period The time period for which the maximum limit of requests applies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(software.amazon.awscdk.services.apigateway.Period period) {
            this.period = period;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link QuotaSettings}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public QuotaSettings build() {
            return new Jsii$Proxy(limit, offset, period);
        }
    }

    /**
     * An implementation for {@link QuotaSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QuotaSettings {
        private final java.lang.Number limit;
        private final java.lang.Number offset;
        private final software.amazon.awscdk.services.apigateway.Period period;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.limit = this.jsiiGet("limit", java.lang.Number.class);
            this.offset = this.jsiiGet("offset", java.lang.Number.class);
            this.period = this.jsiiGet("period", software.amazon.awscdk.services.apigateway.Period.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.Number limit, java.lang.Number offset, software.amazon.awscdk.services.apigateway.Period period) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.limit = limit;
            this.offset = offset;
            this.period = period;
        }

        @Override
        public java.lang.Number getLimit() {
            return this.limit;
        }

        @Override
        public java.lang.Number getOffset() {
            return this.offset;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.Period getPeriod() {
            return this.period;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getLimit() != null) {
                obj.set("limit", om.valueToTree(this.getLimit()));
            }
            if (this.getOffset() != null) {
                obj.set("offset", om.valueToTree(this.getOffset()));
            }
            if (this.getPeriod() != null) {
                obj.set("period", om.valueToTree(this.getPeriod()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            QuotaSettings.Jsii$Proxy that = (QuotaSettings.Jsii$Proxy) o;

            if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) return false;
            if (this.offset != null ? !this.offset.equals(that.offset) : that.offset != null) return false;
            return this.period != null ? this.period.equals(that.period) : that.period == null;
        }

        @Override
        public int hashCode() {
            int result = this.limit != null ? this.limit.hashCode() : 0;
            result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
            result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
            return result;
        }
    }
}
