/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.List;
import java.util.Map;
import software.amazon.awscdk.services.apigateway.AuthorizationType;
import software.amazon.awscdk.services.apigateway.IAuthorizer;
import software.amazon.awscdk.services.apigateway.IModel;
import software.amazon.awscdk.services.apigateway.IRequestValidator;
import software.amazon.awscdk.services.apigateway.MethodOptions;
import software.amazon.awscdk.services.apigateway.MethodResponse;
import software.amazon.jsii.JsiiSerializable;

public interface MethodOptions
extends JsiiSerializable {
    public Boolean getApiKeyRequired();

    public AuthorizationType getAuthorizationType();

    public IAuthorizer getAuthorizer();

    public List<MethodResponse> getMethodResponses();

    public String getOperationName();

    public Map<String, IModel> getRequestModels();

    public Map<String, Boolean> getRequestParameters();

    public IRequestValidator getRequestValidator();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean apiKeyRequired;
        private AuthorizationType authorizationType;
        private IAuthorizer authorizer;
        private List<MethodResponse> methodResponses;
        private String operationName;
        private Map<String, IModel> requestModels;
        private Map<String, Boolean> requestParameters;
        private IRequestValidator requestValidator;

        public Builder apiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        public Builder authorizationType(AuthorizationType authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        public Builder authorizer(IAuthorizer authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        public Builder methodResponses(List<MethodResponse> methodResponses) {
            this.methodResponses = methodResponses;
            return this;
        }

        public Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public Builder requestModels(Map<String, IModel> requestModels) {
            this.requestModels = requestModels;
            return this;
        }

        public Builder requestParameters(Map<String, Boolean> requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        public Builder requestValidator(IRequestValidator requestValidator) {
            this.requestValidator = requestValidator;
            return this;
        }

        public MethodOptions build() {
            return new Jsii.Proxy(this.apiKeyRequired, this.authorizationType, this.authorizer, this.methodResponses, this.operationName, this.requestModels, this.requestParameters, this.requestValidator, null);
        }
    }
}

