package software.amazon.awscdk.services.apigateway;

/**
 * OpenAPI specification from a local file.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.assets.*;
 * import software.amazon.awscdk.services.apigateway.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.core.*;
 * DockerImage dockerImage;
 * IGrantable grantable;
 * ILocalBundling localBundling;
 * AssetApiDefinition assetApiDefinition = AssetApiDefinition.Builder.create("path")
 *         .assetHash("assetHash")
 *         .assetHashType(AssetHashType.SOURCE)
 *         .bundling(BundlingOptions.builder()
 *                 .image(dockerImage)
 *                 // the properties below are optional
 *                 .command(List.of("command"))
 *                 .entrypoint(List.of("entrypoint"))
 *                 .environment(Map.of(
 *                         "environmentKey", "environment"))
 *                 .local(localBundling)
 *                 .outputType(BundlingOutput.ARCHIVED)
 *                 .securityOpt("securityOpt")
 *                 .user("user")
 *                 .volumes(List.of(DockerVolume.builder()
 *                         .containerPath("containerPath")
 *                         .hostPath("hostPath")
 *                         // the properties below are optional
 *                         .consistency(DockerVolumeConsistency.CONSISTENT)
 *                         .build()))
 *                 .workingDirectory("workingDirectory")
 *                 .build())
 *         .exclude(List.of("exclude"))
 *         .follow(FollowMode.NEVER)
 *         .followSymlinks(SymlinkFollowMode.NEVER)
 *         .ignoreMode(IgnoreMode.GLOB)
 *         .readers(List.of(grantable))
 *         .sourceHash("sourceHash")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-02-02T10:52:41.400Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.AssetApiDefinition")
public class AssetApiDefinition extends software.amazon.awscdk.services.apigateway.ApiDefinition {

    protected AssetApiDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AssetApiDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param path This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AssetApiDefinition(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.AssetOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AssetApiDefinition(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Called when the specification is initialized to allow this object to bind to the stack, add resources and have fun.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.ApiDefinitionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ApiDefinitionConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * Called after the CFN RestApi resource has been created to allow the Api Definition to bind to it.
     * <p>
     * Specifically it's required to allow assets to add
     * metadata for tooling like SAM CLI to be able to find their origins.
     * <p>
     * @param scope This parameter is required.
     * @param restApi This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bindAfterCreate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IRestApi restApi) {
        software.amazon.jsii.Kernel.call(this, "bindAfterCreate", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(restApi, "restApi is required") });
    }
}
