package software.amazon.awscdk.services.apigateway;

/**
 * Base class for backend integrations for an API Gateway method.
 * <p>
 * Use one of the concrete classes such as <code>MockIntegration</code>, <code>AwsIntegration</code>, <code>LambdaIntegration</code>
 * or implement on your own by specifying the set of props.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Resource books;
 * User iamUser;
 * Method getBooks = books.addMethod("GET", new HttpIntegration("http://amazon.com"), MethodOptions.builder()
 *         .authorizationType(AuthorizationType.IAM)
 *         .build());
 * iamUser.attachInlinePolicy(Policy.Builder.create(this, "AllowBooks")
 *         .statements(List.of(
 *             PolicyStatement.Builder.create()
 *                     .actions(List.of("execute-api:Invoke"))
 *                     .effect(Effect.ALLOW)
 *                     .resources(List.of(getBooks.getMethodArn()))
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-02-02T10:52:41.608Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.Integration")
public class Integration extends software.amazon.jsii.JsiiObject {

    protected Integration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Integration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Integration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IntegrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Can be overridden by subclasses to allow the integration to interact with the method being integrated, access the REST API object, method ARNs, etc.
     * <p>
     * @param _method This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IntegrationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.Method _method) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IntegrationConfig.class), new Object[] { java.util.Objects.requireNonNull(_method, "_method is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.Integration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.Integration> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.apigateway.IntegrationProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.apigateway.IntegrationProps.Builder();
        }

        /**
         * Specifies an API method integration type.
         * <p>
         * @return {@code this}
         * @param type Specifies an API method integration type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final software.amazon.awscdk.services.apigateway.IntegrationType type) {
            this.props.type(type);
            return this;
        }

        /**
         * The integration's HTTP method type.
         * <p>
         * Required unless you use a MOCK integration.
         * <p>
         * @return {@code this}
         * @param integrationHttpMethod The integration's HTTP method type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationHttpMethod(final java.lang.String integrationHttpMethod) {
            this.props.integrationHttpMethod(integrationHttpMethod);
            return this;
        }

        /**
         * Integration options.
         * <p>
         * @return {@code this}
         * @param options Integration options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(final software.amazon.awscdk.services.apigateway.IntegrationOptions options) {
            this.props.options(options);
            return this;
        }

        /**
         * The Uniform Resource Identifier (URI) for the integration.
         * <p>
         * <ul>
         * <li>If you specify HTTP for the <code>type</code> property, specify the API endpoint URL.</li>
         * <li>If you specify MOCK for the <code>type</code> property, don't specify this property.</li>
         * <li>If you specify AWS for the <code>type</code> property, specify an AWS service that
         * follows this form: <code>arn:partition:apigateway:region:subdomain.service|service:path|action/service_api.</code>
         * For example, a Lambda function URI follows this form:
         * arn:partition:apigateway:region:lambda:path/path. The path is usually in the
         * form /2015-03-31/functions/LambdaFunctionARN/invocations.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#uri
         * @param uri The Uniform Resource Identifier (URI) for the integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uri(final java.lang.Object uri) {
            this.props.uri(uri);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.Integration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.Integration build() {
            return new software.amazon.awscdk.services.apigateway.Integration(
                this.props.build()
            );
        }
    }
}
