package software.amazon.awscdk.services.apigateway;

/**
 * Options to integrate with various StepFunction API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * StateMachine stateMachine = StateMachine.Builder.create(this, "MyStateMachine")
 *         .definition(Chain.start(new Pass(this, "Pass")))
 *         .build();
 * RestApi api = RestApi.Builder.create(this, "Api")
 *         .restApiName("MyApi")
 *         .build();
 * api.root.addMethod("GET", StepFunctionsIntegration.startExecution(stateMachine));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.52.1 (build 5ccc8f6)", date = "2022-02-02T10:52:41.720Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.StepFunctionsIntegration")
public class StepFunctionsIntegration extends software.amazon.jsii.JsiiObject {

    protected StepFunctionsIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StepFunctionsIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public StepFunctionsIntegration() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Integrates a Synchronous Express State Machine from AWS Step Functions to an API Gateway method.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * StateMachine stateMachine = StateMachine.Builder.create(this, "MyStateMachine")
     *         .definition(Chain.start(new Pass(this, "Pass")))
     *         .build();
     * RestApi api = RestApi.Builder.create(this, "Api")
     *         .restApiName("MyApi")
     *         .build();
     * api.root.addMethod("GET", StepFunctionsIntegration.startExecution(stateMachine));
     * </pre></blockquote>
     * <p>
     * @param stateMachine This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.AwsIntegration startExecution(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IStateMachine stateMachine, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.StepFunctionsExecutionIntegrationOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.StepFunctionsIntegration.class, "startExecution", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.AwsIntegration.class), new Object[] { java.util.Objects.requireNonNull(stateMachine, "stateMachine is required"), options });
    }

    /**
     * Integrates a Synchronous Express State Machine from AWS Step Functions to an API Gateway method.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * StateMachine stateMachine = StateMachine.Builder.create(this, "MyStateMachine")
     *         .definition(Chain.start(new Pass(this, "Pass")))
     *         .build();
     * RestApi api = RestApi.Builder.create(this, "Api")
     *         .restApiName("MyApi")
     *         .build();
     * api.root.addMethod("GET", StepFunctionsIntegration.startExecution(stateMachine));
     * </pre></blockquote>
     * <p>
     * @param stateMachine This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.AwsIntegration startExecution(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IStateMachine stateMachine) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.StepFunctionsIntegration.class, "startExecution", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.AwsIntegration.class), new Object[] { java.util.Objects.requireNonNull(stateMachine, "stateMachine is required") });
    }
}
