package software.amazon.awscdk.services.apigateway;

/**
 * Represents the API stages that a usage plan applies to.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UsagePlan plan;
 * RestApi api;
 * Method echoMethod;
 * plan.addApiStage(UsagePlanPerApiStage.builder()
 *         .stage(api.getDeploymentStage())
 *         .throttle(List.of(ThrottlingPerMethod.builder()
 *                 .method(echoMethod)
 *                 .throttle(ThrottleSettings.builder()
 *                         .rateLimit(10)
 *                         .burstLimit(2)
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-02-24T23:24:27.335Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.UsagePlanPerApiStage")
@software.amazon.jsii.Jsii.Proxy(UsagePlanPerApiStage.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UsagePlanPerApiStage extends software.amazon.jsii.JsiiSerializable {

    /**
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.IRestApi getApi() {
        return null;
    }

    /**
     * [disable-awslint:ref-via-interface].
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.Stage getStage() {
        return null;
    }

    /**
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.apigateway.ThrottlingPerMethod> getThrottle() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UsagePlanPerApiStage}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UsagePlanPerApiStage}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UsagePlanPerApiStage> {
        software.amazon.awscdk.services.apigateway.IRestApi api;
        software.amazon.awscdk.services.apigateway.Stage stage;
        java.util.List<software.amazon.awscdk.services.apigateway.ThrottlingPerMethod> throttle;

        /**
         * Sets the value of {@link UsagePlanPerApiStage#getApi}
         * @param api the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder api(software.amazon.awscdk.services.apigateway.IRestApi api) {
            this.api = api;
            return this;
        }

        /**
         * Sets the value of {@link UsagePlanPerApiStage#getStage}
         * @param stage [disable-awslint:ref-via-interface].
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stage(software.amazon.awscdk.services.apigateway.Stage stage) {
            this.stage = stage;
            return this;
        }

        /**
         * Sets the value of {@link UsagePlanPerApiStage#getThrottle}
         * @param throttle the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder throttle(java.util.List<? extends software.amazon.awscdk.services.apigateway.ThrottlingPerMethod> throttle) {
            this.throttle = (java.util.List<software.amazon.awscdk.services.apigateway.ThrottlingPerMethod>)throttle;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UsagePlanPerApiStage}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UsagePlanPerApiStage build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UsagePlanPerApiStage}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UsagePlanPerApiStage {
        private final software.amazon.awscdk.services.apigateway.IRestApi api;
        private final software.amazon.awscdk.services.apigateway.Stage stage;
        private final java.util.List<software.amazon.awscdk.services.apigateway.ThrottlingPerMethod> throttle;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.api = software.amazon.jsii.Kernel.get(this, "api", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IRestApi.class));
            this.stage = software.amazon.jsii.Kernel.get(this, "stage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.Stage.class));
            this.throttle = software.amazon.jsii.Kernel.get(this, "throttle", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ThrottlingPerMethod.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.api = builder.api;
            this.stage = builder.stage;
            this.throttle = (java.util.List<software.amazon.awscdk.services.apigateway.ThrottlingPerMethod>)builder.throttle;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.IRestApi getApi() {
            return this.api;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.Stage getStage() {
            return this.stage;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.apigateway.ThrottlingPerMethod> getThrottle() {
            return this.throttle;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApi() != null) {
                data.set("api", om.valueToTree(this.getApi()));
            }
            if (this.getStage() != null) {
                data.set("stage", om.valueToTree(this.getStage()));
            }
            if (this.getThrottle() != null) {
                data.set("throttle", om.valueToTree(this.getThrottle()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.UsagePlanPerApiStage"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UsagePlanPerApiStage.Jsii$Proxy that = (UsagePlanPerApiStage.Jsii$Proxy) o;

            if (this.api != null ? !this.api.equals(that.api) : that.api != null) return false;
            if (this.stage != null ? !this.stage.equals(that.stage) : that.stage != null) return false;
            return this.throttle != null ? this.throttle.equals(that.throttle) : that.throttle == null;
        }

        @Override
        public final int hashCode() {
            int result = this.api != null ? this.api.hashCode() : 0;
            result = 31 * result + (this.stage != null ? this.stage.hashCode() : 0);
            result = 31 * result + (this.throttle != null ? this.throttle.hashCode() : 0);
            return result;
        }
    }
}
