package software.amazon.awscdk.services.apigateway;

/**
 * Properties for a new gateway response.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * ResponseType responseType;
 * RestApi restApi;
 * GatewayResponseProps gatewayResponseProps = GatewayResponseProps.builder()
 *         .restApi(restApi)
 *         .type(responseType)
 *         // the properties below are optional
 *         .responseHeaders(Map.of(
 *                 "responseHeadersKey", "responseHeaders"))
 *         .statusCode("statusCode")
 *         .templates(Map.of(
 *                 "templatesKey", "templates"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T12:21:46.209Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.GatewayResponseProps")
@software.amazon.jsii.Jsii.Proxy(GatewayResponseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GatewayResponseProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.GatewayResponseOptions {

    /**
     * Rest api resource to target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IRestApi getRestApi();

    /**
     * @return a {@link Builder} of {@link GatewayResponseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GatewayResponseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GatewayResponseProps> {
        software.amazon.awscdk.services.apigateway.IRestApi restApi;
        software.amazon.awscdk.services.apigateway.ResponseType type;
        java.util.Map<java.lang.String, java.lang.String> responseHeaders;
        java.lang.String statusCode;
        java.util.Map<java.lang.String, java.lang.String> templates;

        /**
         * Sets the value of {@link GatewayResponseProps#getRestApi}
         * @param restApi Rest api resource to target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApi(software.amazon.awscdk.services.apigateway.IRestApi restApi) {
            this.restApi = restApi;
            return this;
        }

        /**
         * Sets the value of {@link GatewayResponseProps#getType}
         * @param type Response type to associate with gateway response. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.apigateway.ResponseType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link GatewayResponseProps#getResponseHeaders}
         * @param responseHeaders Custom headers parameters for response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseHeaders(java.util.Map<java.lang.String, java.lang.String> responseHeaders) {
            this.responseHeaders = responseHeaders;
            return this;
        }

        /**
         * Sets the value of {@link GatewayResponseProps#getStatusCode}
         * @param statusCode Http status code for response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statusCode(java.lang.String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Sets the value of {@link GatewayResponseProps#getTemplates}
         * @param templates Custom templates to get mapped as response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templates(java.util.Map<java.lang.String, java.lang.String> templates) {
            this.templates = templates;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GatewayResponseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GatewayResponseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GatewayResponseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayResponseProps {
        private final software.amazon.awscdk.services.apigateway.IRestApi restApi;
        private final software.amazon.awscdk.services.apigateway.ResponseType type;
        private final java.util.Map<java.lang.String, java.lang.String> responseHeaders;
        private final java.lang.String statusCode;
        private final java.util.Map<java.lang.String, java.lang.String> templates;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.restApi = software.amazon.jsii.Kernel.get(this, "restApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IRestApi.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ResponseType.class));
            this.responseHeaders = software.amazon.jsii.Kernel.get(this, "responseHeaders", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.statusCode = software.amazon.jsii.Kernel.get(this, "statusCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.templates = software.amazon.jsii.Kernel.get(this, "templates", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.restApi = java.util.Objects.requireNonNull(builder.restApi, "restApi is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.responseHeaders = builder.responseHeaders;
            this.statusCode = builder.statusCode;
            this.templates = builder.templates;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.IRestApi getRestApi() {
            return this.restApi;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.ResponseType getType() {
            return this.type;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getResponseHeaders() {
            return this.responseHeaders;
        }

        @Override
        public final java.lang.String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTemplates() {
            return this.templates;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("restApi", om.valueToTree(this.getRestApi()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getResponseHeaders() != null) {
                data.set("responseHeaders", om.valueToTree(this.getResponseHeaders()));
            }
            if (this.getStatusCode() != null) {
                data.set("statusCode", om.valueToTree(this.getStatusCode()));
            }
            if (this.getTemplates() != null) {
                data.set("templates", om.valueToTree(this.getTemplates()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.GatewayResponseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GatewayResponseProps.Jsii$Proxy that = (GatewayResponseProps.Jsii$Proxy) o;

            if (!restApi.equals(that.restApi)) return false;
            if (!type.equals(that.type)) return false;
            if (this.responseHeaders != null ? !this.responseHeaders.equals(that.responseHeaders) : that.responseHeaders != null) return false;
            if (this.statusCode != null ? !this.statusCode.equals(that.statusCode) : that.statusCode != null) return false;
            return this.templates != null ? this.templates.equals(that.templates) : that.templates == null;
        }

        @Override
        public final int hashCode() {
            int result = this.restApi.hashCode();
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.responseHeaders != null ? this.responseHeaders.hashCode() : 0);
            result = 31 * result + (this.statusCode != null ? this.statusCode.hashCode() : 0);
            result = 31 * result + (this.templates != null ? this.templates.hashCode() : 0);
            return result;
        }
    }
}
