package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a `AWS::ApiGateway::RestApi`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-28T12:27:21.893Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnRestApiProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::ApiGateway::RestApi.ApiKeySourceType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-apikeysourcetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getApiKeySourceType();

    /**
     * `AWS::ApiGateway::RestApi.BinaryMediaTypes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-binarymediatypes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<java.lang.String> getBinaryMediaTypes();

    /**
     * `AWS::ApiGateway::RestApi.Body`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-body
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getBody();

    /**
     * `AWS::ApiGateway::RestApi.BodyS3Location`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-bodys3location
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getBodyS3Location();

    /**
     * `AWS::ApiGateway::RestApi.CloneFrom`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-clonefrom
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getCloneFrom();

    /**
     * `AWS::ApiGateway::RestApi.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDescription();

    /**
     * `AWS::ApiGateway::RestApi.EndpointConfiguration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-endpointconfiguration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getEndpointConfiguration();

    /**
     * `AWS::ApiGateway::RestApi.FailOnWarnings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-failonwarnings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getFailOnWarnings();

    /**
     * `AWS::ApiGateway::RestApi.MinimumCompressionSize`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-minimumcompressionsize
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Number getMinimumCompressionSize();

    /**
     * `AWS::ApiGateway::RestApi.Name`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getName();

    /**
     * `AWS::ApiGateway::RestApi.Parameters`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getParameters();

    /**
     * `AWS::ApiGateway::RestApi.Policy`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html#cfn-apigateway-restapi-policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getPolicy();

    /**
     * @return a {@link Builder} of {@link CfnRestApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRestApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String apiKeySourceType;
        private java.util.List<java.lang.String> binaryMediaTypes;
        private java.lang.Object body;
        private java.lang.Object bodyS3Location;
        private java.lang.String cloneFrom;
        private java.lang.String description;
        private java.lang.Object endpointConfiguration;
        private java.lang.Object failOnWarnings;
        private java.lang.Number minimumCompressionSize;
        private java.lang.String name;
        private java.lang.Object parameters;
        private java.lang.Object policy;

        /**
         * Sets the value of ApiKeySourceType
         * @param apiKeySourceType `AWS::ApiGateway::RestApi.ApiKeySourceType`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder apiKeySourceType(java.lang.String apiKeySourceType) {
            this.apiKeySourceType = apiKeySourceType;
            return this;
        }

        /**
         * Sets the value of BinaryMediaTypes
         * @param binaryMediaTypes `AWS::ApiGateway::RestApi.BinaryMediaTypes`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder binaryMediaTypes(java.util.List<java.lang.String> binaryMediaTypes) {
            this.binaryMediaTypes = binaryMediaTypes;
            return this;
        }

        /**
         * Sets the value of Body
         * @param body `AWS::ApiGateway::RestApi.Body`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder body(java.lang.Object body) {
            this.body = body;
            return this;
        }

        /**
         * Sets the value of BodyS3Location
         * @param bodyS3Location `AWS::ApiGateway::RestApi.BodyS3Location`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder bodyS3Location(software.amazon.awscdk.core.IResolvable bodyS3Location) {
            this.bodyS3Location = bodyS3Location;
            return this;
        }

        /**
         * Sets the value of BodyS3Location
         * @param bodyS3Location `AWS::ApiGateway::RestApi.BodyS3Location`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder bodyS3Location(software.amazon.awscdk.services.apigateway.CfnRestApi.S3LocationProperty bodyS3Location) {
            this.bodyS3Location = bodyS3Location;
            return this;
        }

        /**
         * Sets the value of CloneFrom
         * @param cloneFrom `AWS::ApiGateway::RestApi.CloneFrom`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cloneFrom(java.lang.String cloneFrom) {
            this.cloneFrom = cloneFrom;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description `AWS::ApiGateway::RestApi.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of EndpointConfiguration
         * @param endpointConfiguration `AWS::ApiGateway::RestApi.EndpointConfiguration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder endpointConfiguration(software.amazon.awscdk.core.IResolvable endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        /**
         * Sets the value of EndpointConfiguration
         * @param endpointConfiguration `AWS::ApiGateway::RestApi.EndpointConfiguration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder endpointConfiguration(software.amazon.awscdk.services.apigateway.CfnRestApi.EndpointConfigurationProperty endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        /**
         * Sets the value of FailOnWarnings
         * @param failOnWarnings `AWS::ApiGateway::RestApi.FailOnWarnings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder failOnWarnings(java.lang.Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        /**
         * Sets the value of FailOnWarnings
         * @param failOnWarnings `AWS::ApiGateway::RestApi.FailOnWarnings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder failOnWarnings(software.amazon.awscdk.core.IResolvable failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        /**
         * Sets the value of MinimumCompressionSize
         * @param minimumCompressionSize `AWS::ApiGateway::RestApi.MinimumCompressionSize`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder minimumCompressionSize(java.lang.Number minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
            return this;
        }

        /**
         * Sets the value of Name
         * @param name `AWS::ApiGateway::RestApi.Name`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of Parameters
         * @param parameters `AWS::ApiGateway::RestApi.Parameters`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder parameters(software.amazon.awscdk.core.IResolvable parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of Parameters
         * @param parameters `AWS::ApiGateway::RestApi.Parameters`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of Policy
         * @param policy `AWS::ApiGateway::RestApi.Policy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder policy(java.lang.Object policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRestApiProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnRestApiProps build() {
            return new Jsii$Proxy(apiKeySourceType, binaryMediaTypes, body, bodyS3Location, cloneFrom, description, endpointConfiguration, failOnWarnings, minimumCompressionSize, name, parameters, policy);
        }
    }

    /**
     * An implementation for {@link CfnRestApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRestApiProps {
        private final java.lang.String apiKeySourceType;
        private final java.util.List<java.lang.String> binaryMediaTypes;
        private final java.lang.Object body;
        private final java.lang.Object bodyS3Location;
        private final java.lang.String cloneFrom;
        private final java.lang.String description;
        private final java.lang.Object endpointConfiguration;
        private final java.lang.Object failOnWarnings;
        private final java.lang.Number minimumCompressionSize;
        private final java.lang.String name;
        private final java.lang.Object parameters;
        private final java.lang.Object policy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.apiKeySourceType = this.jsiiGet("apiKeySourceType", java.lang.String.class);
            this.binaryMediaTypes = this.jsiiGet("binaryMediaTypes", java.util.List.class);
            this.body = this.jsiiGet("body", java.lang.Object.class);
            this.bodyS3Location = this.jsiiGet("bodyS3Location", java.lang.Object.class);
            this.cloneFrom = this.jsiiGet("cloneFrom", java.lang.String.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.endpointConfiguration = this.jsiiGet("endpointConfiguration", java.lang.Object.class);
            this.failOnWarnings = this.jsiiGet("failOnWarnings", java.lang.Object.class);
            this.minimumCompressionSize = this.jsiiGet("minimumCompressionSize", java.lang.Number.class);
            this.name = this.jsiiGet("name", java.lang.String.class);
            this.parameters = this.jsiiGet("parameters", java.lang.Object.class);
            this.policy = this.jsiiGet("policy", java.lang.Object.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String apiKeySourceType, java.util.List<java.lang.String> binaryMediaTypes, java.lang.Object body, java.lang.Object bodyS3Location, java.lang.String cloneFrom, java.lang.String description, java.lang.Object endpointConfiguration, java.lang.Object failOnWarnings, java.lang.Number minimumCompressionSize, java.lang.String name, java.lang.Object parameters, java.lang.Object policy) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiKeySourceType = apiKeySourceType;
            this.binaryMediaTypes = binaryMediaTypes;
            this.body = body;
            this.bodyS3Location = bodyS3Location;
            this.cloneFrom = cloneFrom;
            this.description = description;
            this.endpointConfiguration = endpointConfiguration;
            this.failOnWarnings = failOnWarnings;
            this.minimumCompressionSize = minimumCompressionSize;
            this.name = name;
            this.parameters = parameters;
            this.policy = policy;
        }

        @Override
        public java.lang.String getApiKeySourceType() {
            return this.apiKeySourceType;
        }

        @Override
        public java.util.List<java.lang.String> getBinaryMediaTypes() {
            return this.binaryMediaTypes;
        }

        @Override
        public java.lang.Object getBody() {
            return this.body;
        }

        @Override
        public java.lang.Object getBodyS3Location() {
            return this.bodyS3Location;
        }

        @Override
        public java.lang.String getCloneFrom() {
            return this.cloneFrom;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.Object getEndpointConfiguration() {
            return this.endpointConfiguration;
        }

        @Override
        public java.lang.Object getFailOnWarnings() {
            return this.failOnWarnings;
        }

        @Override
        public java.lang.Number getMinimumCompressionSize() {
            return this.minimumCompressionSize;
        }

        @Override
        public java.lang.String getName() {
            return this.name;
        }

        @Override
        public java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public java.lang.Object getPolicy() {
            return this.policy;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getApiKeySourceType() != null) {
                obj.set("apiKeySourceType", om.valueToTree(this.getApiKeySourceType()));
            }
            if (this.getBinaryMediaTypes() != null) {
                obj.set("binaryMediaTypes", om.valueToTree(this.getBinaryMediaTypes()));
            }
            if (this.getBody() != null) {
                obj.set("body", om.valueToTree(this.getBody()));
            }
            if (this.getBodyS3Location() != null) {
                obj.set("bodyS3Location", om.valueToTree(this.getBodyS3Location()));
            }
            if (this.getCloneFrom() != null) {
                obj.set("cloneFrom", om.valueToTree(this.getCloneFrom()));
            }
            if (this.getDescription() != null) {
                obj.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEndpointConfiguration() != null) {
                obj.set("endpointConfiguration", om.valueToTree(this.getEndpointConfiguration()));
            }
            if (this.getFailOnWarnings() != null) {
                obj.set("failOnWarnings", om.valueToTree(this.getFailOnWarnings()));
            }
            if (this.getMinimumCompressionSize() != null) {
                obj.set("minimumCompressionSize", om.valueToTree(this.getMinimumCompressionSize()));
            }
            if (this.getName() != null) {
                obj.set("name", om.valueToTree(this.getName()));
            }
            if (this.getParameters() != null) {
                obj.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getPolicy() != null) {
                obj.set("policy", om.valueToTree(this.getPolicy()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRestApiProps.Jsii$Proxy that = (CfnRestApiProps.Jsii$Proxy) o;

            if (this.apiKeySourceType != null ? !this.apiKeySourceType.equals(that.apiKeySourceType) : that.apiKeySourceType != null) return false;
            if (this.binaryMediaTypes != null ? !this.binaryMediaTypes.equals(that.binaryMediaTypes) : that.binaryMediaTypes != null) return false;
            if (this.body != null ? !this.body.equals(that.body) : that.body != null) return false;
            if (this.bodyS3Location != null ? !this.bodyS3Location.equals(that.bodyS3Location) : that.bodyS3Location != null) return false;
            if (this.cloneFrom != null ? !this.cloneFrom.equals(that.cloneFrom) : that.cloneFrom != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.endpointConfiguration != null ? !this.endpointConfiguration.equals(that.endpointConfiguration) : that.endpointConfiguration != null) return false;
            if (this.failOnWarnings != null ? !this.failOnWarnings.equals(that.failOnWarnings) : that.failOnWarnings != null) return false;
            if (this.minimumCompressionSize != null ? !this.minimumCompressionSize.equals(that.minimumCompressionSize) : that.minimumCompressionSize != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            return this.policy != null ? this.policy.equals(that.policy) : that.policy == null;
        }

        @Override
        public int hashCode() {
            int result = this.apiKeySourceType != null ? this.apiKeySourceType.hashCode() : 0;
            result = 31 * result + (this.binaryMediaTypes != null ? this.binaryMediaTypes.hashCode() : 0);
            result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
            result = 31 * result + (this.bodyS3Location != null ? this.bodyS3Location.hashCode() : 0);
            result = 31 * result + (this.cloneFrom != null ? this.cloneFrom.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.endpointConfiguration != null ? this.endpointConfiguration.hashCode() : 0);
            result = 31 * result + (this.failOnWarnings != null ? this.failOnWarnings.hashCode() : 0);
            result = 31 * result + (this.minimumCompressionSize != null ? this.minimumCompressionSize.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
            return result;
        }
    }
}
