/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.List;
import software.amazon.awscdk.services.apigateway.IApiKey;
import software.amazon.awscdk.services.apigateway.QuotaSettings;
import software.amazon.awscdk.services.apigateway.ThrottleSettings;
import software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage;
import software.amazon.awscdk.services.apigateway.UsagePlanProps;
import software.amazon.jsii.JsiiSerializable;

public interface UsagePlanProps
extends JsiiSerializable {
    public IApiKey getApiKey();

    public List<UsagePlanPerApiStage> getApiStages();

    public String getDescription();

    public String getName();

    public QuotaSettings getQuota();

    public ThrottleSettings getThrottle();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IApiKey apiKey;
        private List<UsagePlanPerApiStage> apiStages;
        private String description;
        private String name;
        private QuotaSettings quota;
        private ThrottleSettings throttle;

        public Builder apiKey(IApiKey apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder apiStages(List<UsagePlanPerApiStage> apiStages) {
            this.apiStages = apiStages;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder quota(QuotaSettings quota) {
            this.quota = quota;
            return this;
        }

        public Builder throttle(ThrottleSettings throttle) {
            this.throttle = throttle;
            return this;
        }

        public UsagePlanProps build() {
            return new Jsii.Proxy(this.apiKey, this.apiStages, this.description, this.name, this.quota, this.throttle, null);
        }
    }
}

