package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * RestApi restApi;
 * RequestValidator requestValidator = RequestValidator.Builder.create(this, "MyRequestValidator")
 *         .restApi(restApi)
 *         // the properties below are optional
 *         .requestValidatorName("requestValidatorName")
 *         .validateRequestBody(false)
 *         .validateRequestParameters(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-01T01:54:48.850Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.RequestValidator")
public class RequestValidator extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.apigateway.IRequestValidator {

    protected RequestValidator(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RequestValidator(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RequestValidator(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.RequestValidatorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param requestValidatorId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IRequestValidator fromRequestValidatorId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String requestValidatorId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.RequestValidator.class, "fromRequestValidatorId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IRequestValidator.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(requestValidatorId, "requestValidatorId is required") });
    }

    /**
     * ID of the request validator, such as abc123.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRequestValidatorId() {
        return software.amazon.jsii.Kernel.get(this, "requestValidatorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.RequestValidator}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.RequestValidator> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.RequestValidatorProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.RequestValidatorProps.Builder();
        }

        /**
         * The name of this request validator.
         * <p>
         * Default: None
         * <p>
         * @return {@code this}
         * @param requestValidatorName The name of this request validator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestValidatorName(final java.lang.String requestValidatorName) {
            this.props.requestValidatorName(requestValidatorName);
            return this;
        }

        /**
         * Indicates whether to validate the request body according to the configured schema for the targeted API and method.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param validateRequestBody Indicates whether to validate the request body according to the configured schema for the targeted API and method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validateRequestBody(final java.lang.Boolean validateRequestBody) {
            this.props.validateRequestBody(validateRequestBody);
            return this;
        }

        /**
         * Indicates whether to validate request parameters.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param validateRequestParameters Indicates whether to validate request parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validateRequestParameters(final java.lang.Boolean validateRequestParameters) {
            this.props.validateRequestParameters(validateRequestParameters);
            return this;
        }

        /**
         * The rest API that this model is part of.
         * <p>
         * The reason we need the RestApi object itself and not just the ID is because the model
         * is being tracked by the top-level RestApi object for the purpose of calculating it's
         * hash to determine the ID of the deployment. This allows us to automatically update
         * the deployment when the model of the REST API changes.
         * <p>
         * @return {@code this}
         * @param restApi The rest API that this model is part of. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApi(final software.amazon.awscdk.services.apigateway.IRestApi restApi) {
            this.props.restApi(restApi);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.RequestValidator}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.RequestValidator build() {
            return new software.amazon.awscdk.services.apigateway.RequestValidator(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
