package software.amazon.awscdk.services.apigateway;

/**
 * A CloudFormation `AWS::ApiGateway::Authorizer`.
 * <p>
 * The <code>AWS::ApiGateway::Authorizer</code> resource creates an authorization layer that API Gateway activates for methods that have authorization enabled. API Gateway activates the authorizer when a client calls those methods.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * CfnAuthorizer cfnAuthorizer = CfnAuthorizer.Builder.create(this, "MyCfnAuthorizer")
 *         .name("name")
 *         .restApiId("restApiId")
 *         .type("type")
 *         // the properties below are optional
 *         .authorizerCredentials("authorizerCredentials")
 *         .authorizerResultTtlInSeconds(123)
 *         .authorizerUri("authorizerUri")
 *         .authType("authType")
 *         .identitySource("identitySource")
 *         .identityValidationExpression("identityValidationExpression")
 *         .providerArns(List.of("providerArns"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-04-23T01:54:34.455Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnAuthorizer")
public class CfnAuthorizer extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnAuthorizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAuthorizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnAuthorizer.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ApiGateway::Authorizer`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAuthorizer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.CfnAuthorizerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID for the authorizer.
     * <p>
     * For example: <code>abc123</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAuthorizerId() {
        return software.amazon.jsii.Kernel.get(this, "attrAuthorizerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The ID of the `RestApi` resource that API Gateway creates the authorizer in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRestApiId() {
        return software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the `RestApi` resource that API Gateway creates the authorizer in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestApiId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "restApiId", java.util.Objects.requireNonNull(value, "restApiId is required"));
    }

    /**
     * The type of authorizer. Valid values include:.
     * <p>
     * <ul>
     * <li><code>TOKEN</code> : A custom authorizer that uses a Lambda function.</li>
     * <li><code>COGNITO_USER_POOLS</code> : An authorizer that uses Amazon Cognito user pools.</li>
     * <li><code>REQUEST</code> : An authorizer that uses a Lambda function using incoming request parameters.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of authorizer. Valid values include:.
     * <p>
     * <ul>
     * <li><code>TOKEN</code> : A custom authorizer that uses a Lambda function.</li>
     * <li><code>COGNITO_USER_POOLS</code> : An authorizer that uses Amazon Cognito user pools.</li>
     * <li><code>REQUEST</code> : An authorizer that uses a Lambda function using incoming request parameters.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * The credentials that are required for the authorizer.
     * <p>
     * To specify an IAM role that API Gateway assumes, specify the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerCredentials() {
        return software.amazon.jsii.Kernel.get(this, "authorizerCredentials", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The credentials that are required for the authorizer.
     * <p>
     * To specify an IAM role that API Gateway assumes, specify the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthorizerCredentials(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "authorizerCredentials", value);
    }

    /**
     * The time-to-live (TTL) period, in seconds, that specifies how long API Gateway caches authorizer results.
     * <p>
     * If you specify a value greater than 0, API Gateway caches the authorizer responses. By default, API Gateway sets this property to 300. The maximum value is 3600, or 1 hour.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getAuthorizerResultTtlInSeconds() {
        return software.amazon.jsii.Kernel.get(this, "authorizerResultTtlInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The time-to-live (TTL) period, in seconds, that specifies how long API Gateway caches authorizer results.
     * <p>
     * If you specify a value greater than 0, API Gateway caches the authorizer responses. By default, API Gateway sets this property to 300. The maximum value is 3600, or 1 hour.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthorizerResultTtlInSeconds(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "authorizerResultTtlInSeconds", value);
    }

    /**
     * The authorizer's Uniform Resource Identifier (URI).
     * <p>
     * If you specify <code>TOKEN</code> for the authorizer's <code>Type</code> property, specify a Lambda function URI that has the form <code>arn:aws:apigateway: *region* :lambda:path/ *path*</code> . The path usually has the form /2015-03-31/functions/ <em>LambdaFunctionARN</em> /invocations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerUri() {
        return software.amazon.jsii.Kernel.get(this, "authorizerUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The authorizer's Uniform Resource Identifier (URI).
     * <p>
     * If you specify <code>TOKEN</code> for the authorizer's <code>Type</code> property, specify a Lambda function URI that has the form <code>arn:aws:apigateway: *region* :lambda:path/ *path*</code> . The path usually has the form /2015-03-31/functions/ <em>LambdaFunctionARN</em> /invocations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthorizerUri(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "authorizerUri", value);
    }

    /**
     * An optional customer-defined field that's used in OpenApi imports and exports without functional impact.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAuthType() {
        return software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An optional customer-defined field that's used in OpenApi imports and exports without functional impact.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "authType", value);
    }

    /**
     * The source of the identity in an incoming request.
     * <p>
     * If you specify <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> for the <code>Type</code> property, this property is required. Specify a header mapping expression using the form <code>method.request.header. *name*</code> , where <em>name</em> is the name of a custom authorization header that clients submit as part of their requests.
     * <p>
     * If you specify <code>REQUEST</code> for the <code>Type</code> property, this property is required when authorization caching is enabled. Specify a comma-separated string of one or more mapping expressions of the specified request parameter using the form <code>method.request.parameter. *name*</code> . For supported parameter types, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/configure-api-gateway-lambda-authorization-with-console.html">Configure Lambda Authorizer Using the API Gateway Console</a> in the <em>API Gateway Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIdentitySource() {
        return software.amazon.jsii.Kernel.get(this, "identitySource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The source of the identity in an incoming request.
     * <p>
     * If you specify <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> for the <code>Type</code> property, this property is required. Specify a header mapping expression using the form <code>method.request.header. *name*</code> , where <em>name</em> is the name of a custom authorization header that clients submit as part of their requests.
     * <p>
     * If you specify <code>REQUEST</code> for the <code>Type</code> property, this property is required when authorization caching is enabled. Specify a comma-separated string of one or more mapping expressions of the specified request parameter using the form <code>method.request.parameter. *name*</code> . For supported parameter types, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/configure-api-gateway-lambda-authorization-with-console.html">Configure Lambda Authorizer Using the API Gateway Console</a> in the <em>API Gateway Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentitySource(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "identitySource", value);
    }

    /**
     * A validation expression for the incoming identity.
     * <p>
     * If you specify <code>TOKEN</code> for the authorizer's <code>Type</code> property, specify a regular expression. API Gateway uses the expression to attempt to match the incoming client token, and proceeds if the token matches. If the token doesn't match, API Gateway responds with a 401 (unauthorized request) error code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIdentityValidationExpression() {
        return software.amazon.jsii.Kernel.get(this, "identityValidationExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A validation expression for the incoming identity.
     * <p>
     * If you specify <code>TOKEN</code> for the authorizer's <code>Type</code> property, specify a regular expression. API Gateway uses the expression to attempt to match the incoming client token, and proceeds if the token matches. If the token doesn't match, API Gateway responds with a 401 (unauthorized request) error code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityValidationExpression(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "identityValidationExpression", value);
    }

    /**
     * A list of the Amazon Cognito user pool Amazon Resource Names (ARNs) to associate with this authorizer.
     * <p>
     * Required if you specify <code>COGNITO_USER_POOLS</code> as the authorizer <code>Type</code> . For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html#apigateway-enable-cognito-user-pool">Use Amazon Cognito User Pools</a> in the <em>API Gateway Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getProviderArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "providerArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of the Amazon Cognito user pool Amazon Resource Names (ARNs) to associate with this authorizer.
     * <p>
     * Required if you specify <code>COGNITO_USER_POOLS</code> as the authorizer <code>Type</code> . For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html#apigateway-enable-cognito-user-pool">Use Amazon Cognito User Pools</a> in the <em>API Gateway Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProviderArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "providerArns", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.CfnAuthorizer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.CfnAuthorizer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.CfnAuthorizerProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.CfnAuthorizerProps.Builder();
        }

        /**
         * The name of the authorizer.
         * <p>
         * @return {@code this}
         * @param name The name of the authorizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The ID of the `RestApi` resource that API Gateway creates the authorizer in.
         * <p>
         * @return {@code this}
         * @param restApiId The ID of the `RestApi` resource that API Gateway creates the authorizer in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiId(final java.lang.String restApiId) {
            this.props.restApiId(restApiId);
            return this;
        }

        /**
         * The type of authorizer. Valid values include:.
         * <p>
         * <ul>
         * <li><code>TOKEN</code> : A custom authorizer that uses a Lambda function.</li>
         * <li><code>COGNITO_USER_POOLS</code> : An authorizer that uses Amazon Cognito user pools.</li>
         * <li><code>REQUEST</code> : An authorizer that uses a Lambda function using incoming request parameters.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param type The type of authorizer. Valid values include:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * The credentials that are required for the authorizer.
         * <p>
         * To specify an IAM role that API Gateway assumes, specify the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.
         * <p>
         * @return {@code this}
         * @param authorizerCredentials The credentials that are required for the authorizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerCredentials(final java.lang.String authorizerCredentials) {
            this.props.authorizerCredentials(authorizerCredentials);
            return this;
        }

        /**
         * The time-to-live (TTL) period, in seconds, that specifies how long API Gateway caches authorizer results.
         * <p>
         * If you specify a value greater than 0, API Gateway caches the authorizer responses. By default, API Gateway sets this property to 300. The maximum value is 3600, or 1 hour.
         * <p>
         * @return {@code this}
         * @param authorizerResultTtlInSeconds The time-to-live (TTL) period, in seconds, that specifies how long API Gateway caches authorizer results. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerResultTtlInSeconds(final java.lang.Number authorizerResultTtlInSeconds) {
            this.props.authorizerResultTtlInSeconds(authorizerResultTtlInSeconds);
            return this;
        }

        /**
         * The authorizer's Uniform Resource Identifier (URI).
         * <p>
         * If you specify <code>TOKEN</code> for the authorizer's <code>Type</code> property, specify a Lambda function URI that has the form <code>arn:aws:apigateway: *region* :lambda:path/ *path*</code> . The path usually has the form /2015-03-31/functions/ <em>LambdaFunctionARN</em> /invocations.
         * <p>
         * @return {@code this}
         * @param authorizerUri The authorizer's Uniform Resource Identifier (URI). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerUri(final java.lang.String authorizerUri) {
            this.props.authorizerUri(authorizerUri);
            return this;
        }

        /**
         * An optional customer-defined field that's used in OpenApi imports and exports without functional impact.
         * <p>
         * @return {@code this}
         * @param authType An optional customer-defined field that's used in OpenApi imports and exports without functional impact. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authType(final java.lang.String authType) {
            this.props.authType(authType);
            return this;
        }

        /**
         * The source of the identity in an incoming request.
         * <p>
         * If you specify <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> for the <code>Type</code> property, this property is required. Specify a header mapping expression using the form <code>method.request.header. *name*</code> , where <em>name</em> is the name of a custom authorization header that clients submit as part of their requests.
         * <p>
         * If you specify <code>REQUEST</code> for the <code>Type</code> property, this property is required when authorization caching is enabled. Specify a comma-separated string of one or more mapping expressions of the specified request parameter using the form <code>method.request.parameter. *name*</code> . For supported parameter types, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/configure-api-gateway-lambda-authorization-with-console.html">Configure Lambda Authorizer Using the API Gateway Console</a> in the <em>API Gateway Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param identitySource The source of the identity in an incoming request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identitySource(final java.lang.String identitySource) {
            this.props.identitySource(identitySource);
            return this;
        }

        /**
         * A validation expression for the incoming identity.
         * <p>
         * If you specify <code>TOKEN</code> for the authorizer's <code>Type</code> property, specify a regular expression. API Gateway uses the expression to attempt to match the incoming client token, and proceeds if the token matches. If the token doesn't match, API Gateway responds with a 401 (unauthorized request) error code.
         * <p>
         * @return {@code this}
         * @param identityValidationExpression A validation expression for the incoming identity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityValidationExpression(final java.lang.String identityValidationExpression) {
            this.props.identityValidationExpression(identityValidationExpression);
            return this;
        }

        /**
         * A list of the Amazon Cognito user pool Amazon Resource Names (ARNs) to associate with this authorizer.
         * <p>
         * Required if you specify <code>COGNITO_USER_POOLS</code> as the authorizer <code>Type</code> . For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html#apigateway-enable-cognito-user-pool">Use Amazon Cognito User Pools</a> in the <em>API Gateway Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param providerArns A list of the Amazon Cognito user pool Amazon Resource Names (ARNs) to associate with this authorizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder providerArns(final java.util.List<java.lang.String> providerArns) {
            this.props.providerArns(providerArns);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.CfnAuthorizer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.CfnAuthorizer build() {
            return new software.amazon.awscdk.services.apigateway.CfnAuthorizer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
