package software.amazon.awscdk.services.apigateway;

/**
 * Properties for controlling items output in JSON standard format.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // production stage
 * LogGroup prdLogGroup = new LogGroup(this, "PrdLogs");
 * RestApi api = RestApi.Builder.create(this, "books")
 *         .deployOptions(StageOptions.builder()
 *                 .accessLogDestination(new LogGroupLogDestination(prdLogGroup))
 *                 .accessLogFormat(AccessLogFormat.jsonWithStandardFields())
 *                 .build())
 *         .build();
 * Deployment deployment = Deployment.Builder.create(this, "Deployment").api(api).build();
 * // development stage
 * LogGroup devLogGroup = new LogGroup(this, "DevLogs");
 * Stage.Builder.create(this, "dev")
 *         .deployment(deployment)
 *         .accessLogDestination(new LogGroupLogDestination(devLogGroup))
 *         .accessLogFormat(AccessLogFormat.jsonWithStandardFields(JsonWithStandardFieldProps.builder()
 *                 .caller(false)
 *                 .httpMethod(true)
 *                 .ip(true)
 *                 .protocol(true)
 *                 .requestTime(true)
 *                 .resourcePath(true)
 *                 .responseLength(true)
 *                 .status(true)
 *                 .user(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-05-04T20:14:14.227Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.JsonWithStandardFieldProps")
@software.amazon.jsii.Jsii.Proxy(JsonWithStandardFieldProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface JsonWithStandardFieldProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * If this flag is enabled, the principal identifier of the caller will be output to the log.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getCaller();

    /**
     * If this flag is enabled, the http method will be output to the log.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getHttpMethod();

    /**
     * If this flag is enabled, the source IP of request will be output to the log.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getIp();

    /**
     * If this flag is enabled, the request protocol will be output to the log.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getProtocol();

    /**
     * If this flag is enabled, the CLF-formatted request time((dd/MMM/yyyy:HH:mm:ss +-hhmm) will be output to the log.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getRequestTime();

    /**
     * If this flag is enabled, the path to your resource will be output to the log.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getResourcePath();

    /**
     * If this flag is enabled, the response payload length will be output to the log.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getResponseLength();

    /**
     * If this flag is enabled, the method response status will be output to the log.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getStatus();

    /**
     * If this flag is enabled, the principal identifier of the user will be output to the log.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getUser();

    /**
     * @return a {@link Builder} of {@link JsonWithStandardFieldProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JsonWithStandardFieldProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<JsonWithStandardFieldProps> {
        java.lang.Boolean caller;
        java.lang.Boolean httpMethod;
        java.lang.Boolean ip;
        java.lang.Boolean protocol;
        java.lang.Boolean requestTime;
        java.lang.Boolean resourcePath;
        java.lang.Boolean responseLength;
        java.lang.Boolean status;
        java.lang.Boolean user;

        /**
         * Sets the value of {@link JsonWithStandardFieldProps#getCaller}
         * @param caller If this flag is enabled, the principal identifier of the caller will be output to the log. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caller(java.lang.Boolean caller) {
            this.caller = caller;
            return this;
        }

        /**
         * Sets the value of {@link JsonWithStandardFieldProps#getHttpMethod}
         * @param httpMethod If this flag is enabled, the http method will be output to the log. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpMethod(java.lang.Boolean httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        /**
         * Sets the value of {@link JsonWithStandardFieldProps#getIp}
         * @param ip If this flag is enabled, the source IP of request will be output to the log. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ip(java.lang.Boolean ip) {
            this.ip = ip;
            return this;
        }

        /**
         * Sets the value of {@link JsonWithStandardFieldProps#getProtocol}
         * @param protocol If this flag is enabled, the request protocol will be output to the log. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(java.lang.Boolean protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link JsonWithStandardFieldProps#getRequestTime}
         * @param requestTime If this flag is enabled, the CLF-formatted request time((dd/MMM/yyyy:HH:mm:ss +-hhmm) will be output to the log. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestTime(java.lang.Boolean requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        /**
         * Sets the value of {@link JsonWithStandardFieldProps#getResourcePath}
         * @param resourcePath If this flag is enabled, the path to your resource will be output to the log. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcePath(java.lang.Boolean resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        /**
         * Sets the value of {@link JsonWithStandardFieldProps#getResponseLength}
         * @param responseLength If this flag is enabled, the response payload length will be output to the log. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseLength(java.lang.Boolean responseLength) {
            this.responseLength = responseLength;
            return this;
        }

        /**
         * Sets the value of {@link JsonWithStandardFieldProps#getStatus}
         * @param status If this flag is enabled, the method response status will be output to the log. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.Boolean status) {
            this.status = status;
            return this;
        }

        /**
         * Sets the value of {@link JsonWithStandardFieldProps#getUser}
         * @param user If this flag is enabled, the principal identifier of the user will be output to the log. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder user(java.lang.Boolean user) {
            this.user = user;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JsonWithStandardFieldProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public JsonWithStandardFieldProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link JsonWithStandardFieldProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JsonWithStandardFieldProps {
        private final java.lang.Boolean caller;
        private final java.lang.Boolean httpMethod;
        private final java.lang.Boolean ip;
        private final java.lang.Boolean protocol;
        private final java.lang.Boolean requestTime;
        private final java.lang.Boolean resourcePath;
        private final java.lang.Boolean responseLength;
        private final java.lang.Boolean status;
        private final java.lang.Boolean user;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.caller = software.amazon.jsii.Kernel.get(this, "caller", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.httpMethod = software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ip = software.amazon.jsii.Kernel.get(this, "ip", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.requestTime = software.amazon.jsii.Kernel.get(this, "requestTime", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.resourcePath = software.amazon.jsii.Kernel.get(this, "resourcePath", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.responseLength = software.amazon.jsii.Kernel.get(this, "responseLength", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.caller = java.util.Objects.requireNonNull(builder.caller, "caller is required");
            this.httpMethod = java.util.Objects.requireNonNull(builder.httpMethod, "httpMethod is required");
            this.ip = java.util.Objects.requireNonNull(builder.ip, "ip is required");
            this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
            this.requestTime = java.util.Objects.requireNonNull(builder.requestTime, "requestTime is required");
            this.resourcePath = java.util.Objects.requireNonNull(builder.resourcePath, "resourcePath is required");
            this.responseLength = java.util.Objects.requireNonNull(builder.responseLength, "responseLength is required");
            this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
            this.user = java.util.Objects.requireNonNull(builder.user, "user is required");
        }

        @Override
        public final java.lang.Boolean getCaller() {
            return this.caller;
        }

        @Override
        public final java.lang.Boolean getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public final java.lang.Boolean getIp() {
            return this.ip;
        }

        @Override
        public final java.lang.Boolean getProtocol() {
            return this.protocol;
        }

        @Override
        public final java.lang.Boolean getRequestTime() {
            return this.requestTime;
        }

        @Override
        public final java.lang.Boolean getResourcePath() {
            return this.resourcePath;
        }

        @Override
        public final java.lang.Boolean getResponseLength() {
            return this.responseLength;
        }

        @Override
        public final java.lang.Boolean getStatus() {
            return this.status;
        }

        @Override
        public final java.lang.Boolean getUser() {
            return this.user;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("caller", om.valueToTree(this.getCaller()));
            data.set("httpMethod", om.valueToTree(this.getHttpMethod()));
            data.set("ip", om.valueToTree(this.getIp()));
            data.set("protocol", om.valueToTree(this.getProtocol()));
            data.set("requestTime", om.valueToTree(this.getRequestTime()));
            data.set("resourcePath", om.valueToTree(this.getResourcePath()));
            data.set("responseLength", om.valueToTree(this.getResponseLength()));
            data.set("status", om.valueToTree(this.getStatus()));
            data.set("user", om.valueToTree(this.getUser()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.JsonWithStandardFieldProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JsonWithStandardFieldProps.Jsii$Proxy that = (JsonWithStandardFieldProps.Jsii$Proxy) o;

            if (!caller.equals(that.caller)) return false;
            if (!httpMethod.equals(that.httpMethod)) return false;
            if (!ip.equals(that.ip)) return false;
            if (!protocol.equals(that.protocol)) return false;
            if (!requestTime.equals(that.requestTime)) return false;
            if (!resourcePath.equals(that.resourcePath)) return false;
            if (!responseLength.equals(that.responseLength)) return false;
            if (!status.equals(that.status)) return false;
            return this.user.equals(that.user);
        }

        @Override
        public final int hashCode() {
            int result = this.caller.hashCode();
            result = 31 * result + (this.httpMethod.hashCode());
            result = 31 * result + (this.ip.hashCode());
            result = 31 * result + (this.protocol.hashCode());
            result = 31 * result + (this.requestTime.hashCode());
            result = 31 * result + (this.resourcePath.hashCode());
            result = 31 * result + (this.responseLength.hashCode());
            result = 31 * result + (this.status.hashCode());
            result = 31 * result + (this.user.hashCode());
            return result;
        }
    }
}
