package software.amazon.awscdk.services.apigateway;

/**
 * Attributes that can be specified when importing a RestApi.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.App;
 * import software.amazon.awscdk.core.CfnOutput;
 * import software.amazon.awscdk.core.NestedStack;
 * import software.amazon.awscdk.core.NestedStackProps;
 * import software.amazon.awscdk.core.Stack;
 * import software.constructs.Construct;
 * import software.amazon.awscdk.services.apigateway.Deployment;
 * import software.amazon.awscdk.services.apigateway.Method;
 * import software.amazon.awscdk.services.apigateway.MockIntegration;
 * import software.amazon.awscdk.services.apigateway.PassthroughBehavior;
 * import software.amazon.awscdk.services.apigateway.RestApi;
 * import software.amazon.awscdk.services.apigateway.Stage;
 * /**
 *  * This file showcases how to split up a RestApi's Resources and Methods across nested stacks.
 *  *
 *  * The root stack 'RootStack' first defines a RestApi.
 *  * Two nested stacks BooksStack and PetsStack, create corresponding Resources '/books' and '/pets'.
 *  * They are then deployed to a 'prod' Stage via a third nested stack - DeployStack.
 *  *
 *  * To verify this worked, go to the APIGateway
 *  *&#47;
 * public class RootStack extends Stack {
 *     public RootStack(Construct scope) {
 *         super(scope, "integ-restapi-import-RootStack");
 *         RestApi restApi = RestApi.Builder.create(this, "RestApi")
 *                 .deploy(false)
 *                 .build();
 *         restApi.root.addMethod("ANY");
 *         PetsStack petsStack = new PetsStack(this, new ResourceNestedStackProps()
 *                 .restApiId(restApi.getRestApiId())
 *                 .rootResourceId(restApi.getRestApiRootResourceId())
 *                 );
 *         BooksStack booksStack = new BooksStack(this, new ResourceNestedStackProps()
 *                 .restApiId(restApi.getRestApiId())
 *                 .rootResourceId(restApi.getRestApiRootResourceId())
 *                 );
 *         new DeployStack(this, new DeployStackProps()
 *                 .restApiId(restApi.getRestApiId())
 *                 .methods(petsStack.methods.concat(booksStack.getMethods()))
 *                 );
 *         CfnOutput.Builder.create(this, "PetsURL")
 *                 .value(String.format("https://%s.execute-api.%s.amazonaws.com/prod/pets", restApi.getRestApiId(), this.region))
 *                 .build();
 *         CfnOutput.Builder.create(this, "BooksURL")
 *                 .value(String.format("https://%s.execute-api.%s.amazonaws.com/prod/books", restApi.getRestApiId(), this.region))
 *                 .build();
 *     }
 * }
 * public class ResourceNestedStackProps extends NestedStackProps {
 *     private String restApiId;
 *     public String getRestApiId() {
 *         return this.restApiId;
 *     }
 *     public ResourceNestedStackProps restApiId(String restApiId) {
 *         this.restApiId = restApiId;
 *         return this;
 *     }
 *     private String rootResourceId;
 *     public String getRootResourceId() {
 *         return this.rootResourceId;
 *     }
 *     public ResourceNestedStackProps rootResourceId(String rootResourceId) {
 *         this.rootResourceId = rootResourceId;
 *         return this;
 *     }
 * }
 * public class PetsStack extends NestedStack {
 *     public final Method[] methods;
 *     public PetsStack(Construct scope, ResourceNestedStackProps props) {
 *         super(scope, "integ-restapi-import-PetsStack", props);
 *         IRestApi api = RestApi.fromRestApiAttributes(this, "RestApi", RestApiAttributes.builder()
 *                 .restApiId(props.getRestApiId())
 *                 .rootResourceId(props.getRootResourceId())
 *                 .build());
 *         Method method = api.root.addResource("pets").addMethod("GET", MockIntegration.Builder.create()
 *                 .integrationResponses(List.of(IntegrationResponse.builder()
 *                         .statusCode("200")
 *                         .build()))
 *                 .passthroughBehavior(PassthroughBehavior.NEVER)
 *                 .requestTemplates(Map.of(
 *                         "application/json", "{ \"statusCode\": 200 }"))
 *                 .build(), MethodOptions.builder()
 *                 .methodResponses(List.of(MethodResponse.builder().statusCode("200").build()))
 *                 .build());
 *         this.methods.push(method);
 *     }
 * }
 * public class BooksStack extends NestedStack {
 *     public final Method[] methods;
 *     public BooksStack(Construct scope, ResourceNestedStackProps props) {
 *         super(scope, "integ-restapi-import-BooksStack", props);
 *         IRestApi api = RestApi.fromRestApiAttributes(this, "RestApi", RestApiAttributes.builder()
 *                 .restApiId(props.getRestApiId())
 *                 .rootResourceId(props.getRootResourceId())
 *                 .build());
 *         Method method = api.root.addResource("books").addMethod("GET", MockIntegration.Builder.create()
 *                 .integrationResponses(List.of(IntegrationResponse.builder()
 *                         .statusCode("200")
 *                         .build()))
 *                 .passthroughBehavior(PassthroughBehavior.NEVER)
 *                 .requestTemplates(Map.of(
 *                         "application/json", "{ \"statusCode\": 200 }"))
 *                 .build(), MethodOptions.builder()
 *                 .methodResponses(List.of(MethodResponse.builder().statusCode("200").build()))
 *                 .build());
 *         this.methods.push(method);
 *     }
 * }
 * public class DeployStackProps extends NestedStackProps {
 *     private String restApiId;
 *     public String getRestApiId() {
 *         return this.restApiId;
 *     }
 *     public DeployStackProps restApiId(String restApiId) {
 *         this.restApiId = restApiId;
 *         return this;
 *     }
 *     private Method[] methods;
 *     public Method[] getMethods() {
 *         return this.methods;
 *     }
 *     public DeployStackProps methods(Method[] methods) {
 *         this.methods = methods;
 *         return this;
 *     }
 * }
 * public class DeployStack extends NestedStack {
 *     public DeployStack(Construct scope, DeployStackProps props) {
 *         super(scope, "integ-restapi-import-DeployStack", props);
 *         Deployment deployment = Deployment.Builder.create(this, "Deployment")
 *                 .api(RestApi.fromRestApiId(this, "RestApi", props.getRestApiId()))
 *                 .build();
 *         if (props.getMethods()) {
 *             for (Object method : props.getMethods()) {
 *                 deployment.node.addDependency(method);
 *             }
 *         }
 *         Stage.Builder.create(this, "Stage").deployment(deployment).build();
 *     }
 * }
 * new RootStack(new App());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-05-04T20:14:14.283Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.RestApiAttributes")
@software.amazon.jsii.Jsii.Proxy(RestApiAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RestApiAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the API Gateway RestApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRestApiId();

    /**
     * The resource ID of the root resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRootResourceId();

    /**
     * @return a {@link Builder} of {@link RestApiAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RestApiAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RestApiAttributes> {
        java.lang.String restApiId;
        java.lang.String rootResourceId;

        /**
         * Sets the value of {@link RestApiAttributes#getRestApiId}
         * @param restApiId The ID of the API Gateway RestApi. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiId(java.lang.String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        /**
         * Sets the value of {@link RestApiAttributes#getRootResourceId}
         * @param rootResourceId The resource ID of the root resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rootResourceId(java.lang.String rootResourceId) {
            this.rootResourceId = rootResourceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RestApiAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RestApiAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RestApiAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RestApiAttributes {
        private final java.lang.String restApiId;
        private final java.lang.String rootResourceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.restApiId = software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rootResourceId = software.amazon.jsii.Kernel.get(this, "rootResourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.restApiId = java.util.Objects.requireNonNull(builder.restApiId, "restApiId is required");
            this.rootResourceId = java.util.Objects.requireNonNull(builder.rootResourceId, "rootResourceId is required");
        }

        @Override
        public final java.lang.String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final java.lang.String getRootResourceId() {
            return this.rootResourceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("restApiId", om.valueToTree(this.getRestApiId()));
            data.set("rootResourceId", om.valueToTree(this.getRootResourceId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.RestApiAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RestApiAttributes.Jsii$Proxy that = (RestApiAttributes.Jsii$Proxy) o;

            if (!restApiId.equals(that.restApiId)) return false;
            return this.rootResourceId.equals(that.rootResourceId);
        }

        @Override
        public final int hashCode() {
            int result = this.restApiId.hashCode();
            result = 31 * result + (this.rootResourceId.hashCode());
            return result;
        }
    }
}
