package software.amazon.awscdk.services.apigateway;

/**
 * Represents per-method throttling for a resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * Method method;
 * ThrottlingPerMethod throttlingPerMethod = ThrottlingPerMethod.builder()
 *         .method(method)
 *         .throttle(ThrottleSettings.builder()
 *                 .burstLimit(123)
 *                 .rateLimit(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-11T19:24:18.386Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.ThrottlingPerMethod")
@software.amazon.jsii.Jsii.Proxy(ThrottlingPerMethod.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ThrottlingPerMethod extends software.amazon.jsii.JsiiSerializable {

    /**
     * [disable-awslint:ref-via-interface] The method for which you specify the throttling settings.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.Method getMethod();

    /**
     * Specifies the overall request rate (average requests per second) and burst capacity.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.ThrottleSettings getThrottle();

    /**
     * @return a {@link Builder} of {@link ThrottlingPerMethod}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ThrottlingPerMethod}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ThrottlingPerMethod> {
        software.amazon.awscdk.services.apigateway.Method method;
        software.amazon.awscdk.services.apigateway.ThrottleSettings throttle;

        /**
         * Sets the value of {@link ThrottlingPerMethod#getMethod}
         * @param method [disable-awslint:ref-via-interface] The method for which you specify the throttling settings. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(software.amazon.awscdk.services.apigateway.Method method) {
            this.method = method;
            return this;
        }

        /**
         * Sets the value of {@link ThrottlingPerMethod#getThrottle}
         * @param throttle Specifies the overall request rate (average requests per second) and burst capacity. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttle(software.amazon.awscdk.services.apigateway.ThrottleSettings throttle) {
            this.throttle = throttle;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ThrottlingPerMethod}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ThrottlingPerMethod build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ThrottlingPerMethod}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThrottlingPerMethod {
        private final software.amazon.awscdk.services.apigateway.Method method;
        private final software.amazon.awscdk.services.apigateway.ThrottleSettings throttle;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.Method.class));
            this.throttle = software.amazon.jsii.Kernel.get(this, "throttle", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ThrottleSettings.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.method = java.util.Objects.requireNonNull(builder.method, "method is required");
            this.throttle = java.util.Objects.requireNonNull(builder.throttle, "throttle is required");
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.Method getMethod() {
            return this.method;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.ThrottleSettings getThrottle() {
            return this.throttle;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("method", om.valueToTree(this.getMethod()));
            data.set("throttle", om.valueToTree(this.getThrottle()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.ThrottlingPerMethod"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ThrottlingPerMethod.Jsii$Proxy that = (ThrottlingPerMethod.Jsii$Proxy) o;

            if (!method.equals(that.method)) return false;
            return this.throttle.equals(that.throttle);
        }

        @Override
        public final int hashCode() {
            int result = this.method.hashCode();
            result = 31 * result + (this.throttle.hashCode());
            return result;
        }
    }
}
