package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * Resource myResource;
 * myResource.addCorsPreflight(CorsOptions.builder()
 *         .allowOrigins(List.of("https://amazon.com"))
 *         .allowMethods(List.of("GET", "PUT"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.58.0 (build f8ba112)", date = "2022-05-13T01:13:36.972Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CorsOptions")
@software.amazon.jsii.Jsii.Proxy(CorsOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CorsOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the list of origins that are allowed to make requests to this resource.
     * <p>
     * If you wish to allow all origins, specify <code>Cors.ALL_ORIGINS</code> or
     * <code>[ * ]</code>.
     * <p>
     * Responses will include the <code>Access-Control-Allow-Origin</code> response header.
     * If <code>Cors.ALL_ORIGINS</code> is specified, the <code>Vary: Origin</code> response header will
     * also be included.
     * <p>
     * @see https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAllowOrigins();

    /**
     * The Access-Control-Allow-Credentials response header tells browsers whether to expose the response to frontend JavaScript code when the request's credentials mode (Request.credentials) is "include".
     * <p>
     * When a request's credentials mode (Request.credentials) is "include",
     * browsers will only expose the response to frontend JavaScript code if the
     * Access-Control-Allow-Credentials value is true.
     * <p>
     * Credentials are cookies, authorization headers or TLS client certificates.
     * <p>
     * Default: false
     * <p>
     * @see https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllowCredentials() {
        return null;
    }

    /**
     * The Access-Control-Allow-Headers response header is used in response to a preflight request which includes the Access-Control-Request-Headers to indicate which HTTP headers can be used during the actual request.
     * <p>
     * Default: Cors.DEFAULT_HEADERS
     * <p>
     * @see https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowHeaders() {
        return null;
    }

    /**
     * The Access-Control-Allow-Methods response header specifies the method or methods allowed when accessing the resource in response to a preflight request.
     * <p>
     * If <code>ANY</code> is specified, it will be expanded to <code>Cors.ALL_METHODS</code>.
     * <p>
     * Default: Cors.ALL_METHODS
     * <p>
     * @see https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowMethods() {
        return null;
    }

    /**
     * Sets Access-Control-Max-Age to -1, which means that caching is disabled.
     * <p>
     * This option cannot be used with <code>maxAge</code>.
     * <p>
     * Default: - cache is enabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDisableCache() {
        return null;
    }

    /**
     * The Access-Control-Expose-Headers response header indicates which headers can be exposed as part of the response by listing their names.
     * <p>
     * If you want clients to be able to access other headers, you have to list
     * them using the Access-Control-Expose-Headers header.
     * <p>
     * Default: - only the 6 CORS-safelisted response headers are exposed:
     * Cache-Control, Content-Language, Content-Type, Expires, Last-Modified,
     * Pragma
     * <p>
     * @see https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExposeHeaders() {
        return null;
    }

    /**
     * The Access-Control-Max-Age response header indicates how long the results of a preflight request (that is the information contained in the Access-Control-Allow-Methods and Access-Control-Allow-Headers headers) can be cached.
     * <p>
     * To disable caching altogether use <code>disableCache: true</code>.
     * <p>
     * Default: - browser-specific (see reference)
     * <p>
     * @see https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Max-Age
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getMaxAge() {
        return null;
    }

    /**
     * Specifies the response status code returned from the OPTIONS method.
     * <p>
     * Default: 204
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getStatusCode() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CorsOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CorsOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CorsOptions> {
        java.util.List<java.lang.String> allowOrigins;
        java.lang.Boolean allowCredentials;
        java.util.List<java.lang.String> allowHeaders;
        java.util.List<java.lang.String> allowMethods;
        java.lang.Boolean disableCache;
        java.util.List<java.lang.String> exposeHeaders;
        software.amazon.awscdk.core.Duration maxAge;
        java.lang.Number statusCode;

        /**
         * Sets the value of {@link CorsOptions#getAllowOrigins}
         * @param allowOrigins Specifies the list of origins that are allowed to make requests to this resource. This parameter is required.
         *                     If you wish to allow all origins, specify <code>Cors.ALL_ORIGINS</code> or
         *                     <code>[ * ]</code>.
         *                     <p>
         *                     Responses will include the <code>Access-Control-Allow-Origin</code> response header.
         *                     If <code>Cors.ALL_ORIGINS</code> is specified, the <code>Vary: Origin</code> response header will
         *                     also be included.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowOrigins(java.util.List<java.lang.String> allowOrigins) {
            this.allowOrigins = allowOrigins;
            return this;
        }

        /**
         * Sets the value of {@link CorsOptions#getAllowCredentials}
         * @param allowCredentials The Access-Control-Allow-Credentials response header tells browsers whether to expose the response to frontend JavaScript code when the request's credentials mode (Request.credentials) is "include".
         *                         When a request's credentials mode (Request.credentials) is "include",
         *                         browsers will only expose the response to frontend JavaScript code if the
         *                         Access-Control-Allow-Credentials value is true.
         *                         <p>
         *                         Credentials are cookies, authorization headers or TLS client certificates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowCredentials(java.lang.Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
            return this;
        }

        /**
         * Sets the value of {@link CorsOptions#getAllowHeaders}
         * @param allowHeaders The Access-Control-Allow-Headers response header is used in response to a preflight request which includes the Access-Control-Request-Headers to indicate which HTTP headers can be used during the actual request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowHeaders(java.util.List<java.lang.String> allowHeaders) {
            this.allowHeaders = allowHeaders;
            return this;
        }

        /**
         * Sets the value of {@link CorsOptions#getAllowMethods}
         * @param allowMethods The Access-Control-Allow-Methods response header specifies the method or methods allowed when accessing the resource in response to a preflight request.
         *                     If <code>ANY</code> is specified, it will be expanded to <code>Cors.ALL_METHODS</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowMethods(java.util.List<java.lang.String> allowMethods) {
            this.allowMethods = allowMethods;
            return this;
        }

        /**
         * Sets the value of {@link CorsOptions#getDisableCache}
         * @param disableCache Sets Access-Control-Max-Age to -1, which means that caching is disabled.
         *                     This option cannot be used with <code>maxAge</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableCache(java.lang.Boolean disableCache) {
            this.disableCache = disableCache;
            return this;
        }

        /**
         * Sets the value of {@link CorsOptions#getExposeHeaders}
         * @param exposeHeaders The Access-Control-Expose-Headers response header indicates which headers can be exposed as part of the response by listing their names.
         *                      If you want clients to be able to access other headers, you have to list
         *                      them using the Access-Control-Expose-Headers header.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exposeHeaders(java.util.List<java.lang.String> exposeHeaders) {
            this.exposeHeaders = exposeHeaders;
            return this;
        }

        /**
         * Sets the value of {@link CorsOptions#getMaxAge}
         * @param maxAge The Access-Control-Max-Age response header indicates how long the results of a preflight request (that is the information contained in the Access-Control-Allow-Methods and Access-Control-Allow-Headers headers) can be cached.
         *               To disable caching altogether use <code>disableCache: true</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAge(software.amazon.awscdk.core.Duration maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        /**
         * Sets the value of {@link CorsOptions#getStatusCode}
         * @param statusCode Specifies the response status code returned from the OPTIONS method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statusCode(java.lang.Number statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CorsOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CorsOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CorsOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CorsOptions {
        private final java.util.List<java.lang.String> allowOrigins;
        private final java.lang.Boolean allowCredentials;
        private final java.util.List<java.lang.String> allowHeaders;
        private final java.util.List<java.lang.String> allowMethods;
        private final java.lang.Boolean disableCache;
        private final java.util.List<java.lang.String> exposeHeaders;
        private final software.amazon.awscdk.core.Duration maxAge;
        private final java.lang.Number statusCode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowOrigins = software.amazon.jsii.Kernel.get(this, "allowOrigins", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.allowCredentials = software.amazon.jsii.Kernel.get(this, "allowCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.allowHeaders = software.amazon.jsii.Kernel.get(this, "allowHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.allowMethods = software.amazon.jsii.Kernel.get(this, "allowMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.disableCache = software.amazon.jsii.Kernel.get(this, "disableCache", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.exposeHeaders = software.amazon.jsii.Kernel.get(this, "exposeHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.maxAge = software.amazon.jsii.Kernel.get(this, "maxAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.statusCode = software.amazon.jsii.Kernel.get(this, "statusCode", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowOrigins = java.util.Objects.requireNonNull(builder.allowOrigins, "allowOrigins is required");
            this.allowCredentials = builder.allowCredentials;
            this.allowHeaders = builder.allowHeaders;
            this.allowMethods = builder.allowMethods;
            this.disableCache = builder.disableCache;
            this.exposeHeaders = builder.exposeHeaders;
            this.maxAge = builder.maxAge;
            this.statusCode = builder.statusCode;
        }

        @Override
        public final java.util.List<java.lang.String> getAllowOrigins() {
            return this.allowOrigins;
        }

        @Override
        public final java.lang.Boolean getAllowCredentials() {
            return this.allowCredentials;
        }

        @Override
        public final java.util.List<java.lang.String> getAllowHeaders() {
            return this.allowHeaders;
        }

        @Override
        public final java.util.List<java.lang.String> getAllowMethods() {
            return this.allowMethods;
        }

        @Override
        public final java.lang.Boolean getDisableCache() {
            return this.disableCache;
        }

        @Override
        public final java.util.List<java.lang.String> getExposeHeaders() {
            return this.exposeHeaders;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getMaxAge() {
            return this.maxAge;
        }

        @Override
        public final java.lang.Number getStatusCode() {
            return this.statusCode;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("allowOrigins", om.valueToTree(this.getAllowOrigins()));
            if (this.getAllowCredentials() != null) {
                data.set("allowCredentials", om.valueToTree(this.getAllowCredentials()));
            }
            if (this.getAllowHeaders() != null) {
                data.set("allowHeaders", om.valueToTree(this.getAllowHeaders()));
            }
            if (this.getAllowMethods() != null) {
                data.set("allowMethods", om.valueToTree(this.getAllowMethods()));
            }
            if (this.getDisableCache() != null) {
                data.set("disableCache", om.valueToTree(this.getDisableCache()));
            }
            if (this.getExposeHeaders() != null) {
                data.set("exposeHeaders", om.valueToTree(this.getExposeHeaders()));
            }
            if (this.getMaxAge() != null) {
                data.set("maxAge", om.valueToTree(this.getMaxAge()));
            }
            if (this.getStatusCode() != null) {
                data.set("statusCode", om.valueToTree(this.getStatusCode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CorsOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CorsOptions.Jsii$Proxy that = (CorsOptions.Jsii$Proxy) o;

            if (!allowOrigins.equals(that.allowOrigins)) return false;
            if (this.allowCredentials != null ? !this.allowCredentials.equals(that.allowCredentials) : that.allowCredentials != null) return false;
            if (this.allowHeaders != null ? !this.allowHeaders.equals(that.allowHeaders) : that.allowHeaders != null) return false;
            if (this.allowMethods != null ? !this.allowMethods.equals(that.allowMethods) : that.allowMethods != null) return false;
            if (this.disableCache != null ? !this.disableCache.equals(that.disableCache) : that.disableCache != null) return false;
            if (this.exposeHeaders != null ? !this.exposeHeaders.equals(that.exposeHeaders) : that.exposeHeaders != null) return false;
            if (this.maxAge != null ? !this.maxAge.equals(that.maxAge) : that.maxAge != null) return false;
            return this.statusCode != null ? this.statusCode.equals(that.statusCode) : that.statusCode == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowOrigins.hashCode();
            result = 31 * result + (this.allowCredentials != null ? this.allowCredentials.hashCode() : 0);
            result = 31 * result + (this.allowHeaders != null ? this.allowHeaders.hashCode() : 0);
            result = 31 * result + (this.allowMethods != null ? this.allowMethods.hashCode() : 0);
            result = 31 * result + (this.disableCache != null ? this.disableCache.hashCode() : 0);
            result = 31 * result + (this.exposeHeaders != null ? this.exposeHeaders.hashCode() : 0);
            result = 31 * result + (this.maxAge != null ? this.maxAge.hashCode() : 0);
            result = 31 * result + (this.statusCode != null ? this.statusCode.hashCode() : 0);
            return result;
        }
    }
}
