package software.amazon.awscdk.services.apigateway;

/**
 * This type of integration lets API Gateway return a response without sending the request further to the backend.
 * 
 * This is useful for API testing because it
 * can be used to test the integration set up without incurring charges for
 * using the backend and to enable collaborative development of an API. In
 * collaborative development, a team can isolate their development effort by
 * setting up simulations of API components owned by other teams by using the
 * MOCK integrations. It is also used to return CORS-related headers to ensure
 * that the API method permits CORS access. In fact, the API Gateway console
 * integrates the OPTIONS method to support CORS with a mock integration.
 * Gateway responses are other examples of mock integrations.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.2 (build faba0be)", date = "2019-11-11T17:17:51.609Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.MockIntegration")
public class MockIntegration extends software.amazon.awscdk.services.apigateway.Integration {

    protected MockIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MockIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public MockIntegration(final software.amazon.awscdk.services.apigateway.IntegrationOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { options });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public MockIntegration() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.MockIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.apigateway.IntegrationOptions.Builder options;

        private Builder() {
        }

        /**
         * @return {@code this}
         * @param cacheKeyParameters A list of request parameters whose values are to be cached. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheKeyParameters(final java.util.List<java.lang.String> cacheKeyParameters) {
            this.options().cacheKeyParameters(cacheKeyParameters);
            return this;
        }

        /**
         * @return {@code this}
         * @param cacheNamespace An API-specific tag group of related cached parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheNamespace(final java.lang.String cacheNamespace) {
            this.options().cacheNamespace(cacheNamespace);
            return this;
        }

        /**
         * @return {@code this}
         * @param connectionType The type of network connection to the integration endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionType(final software.amazon.awscdk.services.apigateway.ConnectionType connectionType) {
            this.options().connectionType(connectionType);
            return this;
        }

        /**
         * @return {@code this}
         * @param contentHandling Specifies how to handle request payload content type conversions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentHandling(final software.amazon.awscdk.services.apigateway.ContentHandling contentHandling) {
            this.options().contentHandling(contentHandling);
            return this;
        }

        /**
         * @return {@code this}
         * @param credentialsPassthrough Requires that the caller's identity be passed through from the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsPassthrough(final java.lang.Boolean credentialsPassthrough) {
            this.options().credentialsPassthrough(credentialsPassthrough);
            return this;
        }

        /**
         * @return {@code this}
         * @param credentialsRole An IAM role that API Gateway assumes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsRole(final software.amazon.awscdk.services.iam.IRole credentialsRole) {
            this.options().credentialsRole(credentialsRole);
            return this;
        }

        /**
         * @return {@code this}
         * @param integrationResponses The response that API Gateway provides after a method's backend completes processing a request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationResponses(final java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> integrationResponses) {
            this.options().integrationResponses(integrationResponses);
            return this;
        }

        /**
         * @return {@code this}
         * @param passthroughBehavior Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passthroughBehavior(final software.amazon.awscdk.services.apigateway.PassthroughBehavior passthroughBehavior) {
            this.options().passthroughBehavior(passthroughBehavior);
            return this;
        }

        /**
         * @return {@code this}
         * @param requestParameters The request parameters that API Gateway sends with the backend request. Specify request parameters as key-value pairs (string-to-string mappings), with a destination as the key and a source as the value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(final java.util.Map<java.lang.String, java.lang.String> requestParameters) {
            this.options().requestParameters(requestParameters);
            return this;
        }

        /**
         * @return {@code this}
         * @param requestTemplates A map of Apache Velocity templates that are applied on the request payload. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestTemplates(final java.util.Map<java.lang.String, java.lang.String> requestTemplates) {
            this.options().requestTemplates(requestTemplates);
            return this;
        }

        /**
         * @return {@code this}
         * @param vpcLink The VpcLink used for the integration. Required if connectionType is VPC_LINK. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcLink(final software.amazon.awscdk.services.apigateway.VpcLink vpcLink) {
            this.options().vpcLink(vpcLink);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.MockIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.apigateway.MockIntegration build() {
            return new software.amazon.awscdk.services.apigateway.MockIntegration(
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.apigateway.IntegrationOptions.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.apigateway.IntegrationOptions.Builder();
            }
            return this.options;
        }
    }
}
