package software.amazon.awscdk.services.apigateway;

/**
 * Defines an API Gateway REST API with AWS Lambda proxy integration.
 * 
 * Use the `proxyPath` property to define a greedy proxy ("{proxy+}") and "ANY"
 * method from the specified path. If not defined, you will need to explicity
 * add resources and methods to the API.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.4 (build 96d89e1)", date = "2019-11-12T11:54:57.903Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.LambdaRestApi")
public class LambdaRestApi extends software.amazon.awscdk.services.apigateway.RestApi {

    protected LambdaRestApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaRestApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LambdaRestApi(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.apigateway.LambdaRestApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.LambdaRestApi}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.LambdaRestApiProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.LambdaRestApiProps.Builder();
        }

        /**
         * @return {@code this}
         * @param defaultCorsPreflightOptions Adds a CORS preflight OPTIONS method to this resource and all child resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCorsPreflightOptions(final software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions) {
            this.props.defaultCorsPreflightOptions(defaultCorsPreflightOptions);
            return this;
        }

        /**
         * @return {@code this}
         * @param defaultIntegration An integration to use as a default for all methods created within this API unless an integration is specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultIntegration(final software.amazon.awscdk.services.apigateway.Integration defaultIntegration) {
            this.props.defaultIntegration(defaultIntegration);
            return this;
        }

        /**
         * @return {@code this}
         * @param defaultMethodOptions Method options to use as a default for all methods created within this API unless custom options are specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultMethodOptions(final software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions) {
            this.props.defaultMethodOptions(defaultMethodOptions);
            return this;
        }

        /**
         * @return {@code this}
         * @param apiKeySourceType The source of the API key for metering requests according to a usage plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeySourceType(final software.amazon.awscdk.services.apigateway.ApiKeySourceType apiKeySourceType) {
            this.props.apiKeySourceType(apiKeySourceType);
            return this;
        }

        /**
         * @return {@code this}
         * @param binaryMediaTypes The list of binary media mime-types that are supported by the RestApi resource, such as "image/png" or "application/octet-stream". This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder binaryMediaTypes(final java.util.List<java.lang.String> binaryMediaTypes) {
            this.props.binaryMediaTypes(binaryMediaTypes);
            return this;
        }

        /**
         * @return {@code this}
         * @param cloneFrom The ID of the API Gateway RestApi resource that you want to clone. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloneFrom(final software.amazon.awscdk.services.apigateway.IRestApi cloneFrom) {
            this.props.cloneFrom(cloneFrom);
            return this;
        }

        /**
         * @return {@code this}
         * @param cloudWatchRole Automatically configure an AWS CloudWatch role for API Gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchRole(final java.lang.Boolean cloudWatchRole) {
            this.props.cloudWatchRole(cloudWatchRole);
            return this;
        }

        /**
         * @return {@code this}
         * @param deploy Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploy(final java.lang.Boolean deploy) {
            this.props.deploy(deploy);
            return this;
        }

        /**
         * @return {@code this}
         * @param deployOptions Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployOptions(final software.amazon.awscdk.services.apigateway.StageOptions deployOptions) {
            this.props.deployOptions(deployOptions);
            return this;
        }

        /**
         * @return {@code this}
         * @param description A description of the purpose of this API Gateway RestApi resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @return {@code this}
         * @param domainName Configure a custom domain name and map it to this API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final software.amazon.awscdk.services.apigateway.DomainNameOptions domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * @return {@code this}
         * @param endpointExportName Export name for the CfnOutput containing the API endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointExportName(final java.lang.String endpointExportName) {
            this.props.endpointExportName(endpointExportName);
            return this;
        }

        /**
         * @return {@code this}
         * @param endpointTypes A list of the endpoint types of the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointTypes(final java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> endpointTypes) {
            this.props.endpointTypes(endpointTypes);
            return this;
        }

        /**
         * @return {@code this}
         * @param failOnWarnings Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(final java.lang.Boolean failOnWarnings) {
            this.props.failOnWarnings(failOnWarnings);
            return this;
        }

        /**
         * @return {@code this}
         * @param minimumCompressionSize A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (when undefined) on an API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumCompressionSize(final java.lang.Number minimumCompressionSize) {
            this.props.minimumCompressionSize(minimumCompressionSize);
            return this;
        }

        /**
         * @return {@code this}
         * @param parameters Custom header parameters for the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * @return {@code this}
         * @param policy A policy document that contains the permissions for this RestApi. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(final software.amazon.awscdk.services.iam.PolicyDocument policy) {
            this.props.policy(policy);
            return this;
        }

        /**
         * @return {@code this}
         * @param restApiName A name for the API Gateway RestApi resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiName(final java.lang.String restApiName) {
            this.props.restApiName(restApiName);
            return this;
        }

        /**
         * @return {@code this}
         * @param retainDeployments Retains old deployment resources when the API changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainDeployments(final java.lang.Boolean retainDeployments) {
            this.props.retainDeployments(retainDeployments);
            return this;
        }

        /**
         * @return {@code this}
         * @param handler The default Lambda function that handles all requests from this API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder handler(final software.amazon.awscdk.services.lambda.IFunction handler) {
            this.props.handler(handler);
            return this;
        }

        /**
         * @return {@code this}
         * @param options This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder options(final software.amazon.awscdk.services.apigateway.RestApiProps options) {
            this.props.options(options);
            return this;
        }

        /**
         * @return {@code this}
         * @param proxy If true, route all requests to the Lambda Function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxy(final java.lang.Boolean proxy) {
            this.props.proxy(proxy);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.LambdaRestApi}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.apigateway.LambdaRestApi build() {
            return new software.amazon.awscdk.services.apigateway.LambdaRestApi(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
