/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.List;
import java.util.Map;
import software.amazon.awscdk.services.apigateway.;
import software.amazon.awscdk.services.apigateway.ApiKeySourceType;
import software.amazon.awscdk.services.apigateway.CorsOptions;
import software.amazon.awscdk.services.apigateway.DomainNameOptions;
import software.amazon.awscdk.services.apigateway.EndpointType;
import software.amazon.awscdk.services.apigateway.IRestApi;
import software.amazon.awscdk.services.apigateway.Integration;
import software.amazon.awscdk.services.apigateway.MethodOptions;
import software.amazon.awscdk.services.apigateway.ResourceOptions;
import software.amazon.awscdk.services.apigateway.RestApiProps;
import software.amazon.awscdk.services.apigateway.StageOptions;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-apigateway.RestApiProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface RestApiProps
extends JsiiSerializable,
ResourceOptions {
    default public ApiKeySourceType getApiKeySourceType() {
        return null;
    }

    default public List<String> getBinaryMediaTypes() {
        return null;
    }

    default public IRestApi getCloneFrom() {
        return null;
    }

    default public Boolean getCloudWatchRole() {
        return null;
    }

    default public Boolean getDeploy() {
        return null;
    }

    default public StageOptions getDeployOptions() {
        return null;
    }

    default public String getDescription() {
        return null;
    }

    default public DomainNameOptions getDomainName() {
        return null;
    }

    default public String getEndpointExportName() {
        return null;
    }

    default public List<EndpointType> getEndpointTypes() {
        return null;
    }

    default public Boolean getFailOnWarnings() {
        return null;
    }

    default public Number getMinimumCompressionSize() {
        return null;
    }

    default public Map<String, String> getParameters() {
        return null;
    }

    default public PolicyDocument getPolicy() {
        return null;
    }

    default public String getRestApiName() {
        return null;
    }

    default public Boolean getRetainDeployments() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ApiKeySourceType apiKeySourceType;
        private List<String> binaryMediaTypes;
        private IRestApi cloneFrom;
        private Boolean cloudWatchRole;
        private Boolean deploy;
        private StageOptions deployOptions;
        private String description;
        private DomainNameOptions domainName;
        private String endpointExportName;
        private List<EndpointType> endpointTypes;
        private Boolean failOnWarnings;
        private Number minimumCompressionSize;
        private Map<String, String> parameters;
        private PolicyDocument policy;
        private String restApiName;
        private Boolean retainDeployments;
        private CorsOptions defaultCorsPreflightOptions;
        private Integration defaultIntegration;
        private MethodOptions defaultMethodOptions;

        public Builder apiKeySourceType(ApiKeySourceType apiKeySourceType) {
            this.apiKeySourceType = apiKeySourceType;
            return this;
        }

        public Builder binaryMediaTypes(List<String> binaryMediaTypes) {
            this.binaryMediaTypes = binaryMediaTypes;
            return this;
        }

        public Builder cloneFrom(IRestApi cloneFrom) {
            this.cloneFrom = cloneFrom;
            return this;
        }

        public Builder cloudWatchRole(Boolean cloudWatchRole) {
            this.cloudWatchRole = cloudWatchRole;
            return this;
        }

        public Builder deploy(Boolean deploy) {
            this.deploy = deploy;
            return this;
        }

        public Builder deployOptions(StageOptions deployOptions) {
            this.deployOptions = deployOptions;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder domainName(DomainNameOptions domainName) {
            this.domainName = domainName;
            return this;
        }

        public Builder endpointExportName(String endpointExportName) {
            this.endpointExportName = endpointExportName;
            return this;
        }

        public Builder endpointTypes(List<EndpointType> endpointTypes) {
            this.endpointTypes = endpointTypes;
            return this;
        }

        public Builder failOnWarnings(Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        public Builder minimumCompressionSize(Number minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder policy(PolicyDocument policy) {
            this.policy = policy;
            return this;
        }

        public Builder restApiName(String restApiName) {
            this.restApiName = restApiName;
            return this;
        }

        public Builder retainDeployments(Boolean retainDeployments) {
            this.retainDeployments = retainDeployments;
            return this;
        }

        public Builder defaultCorsPreflightOptions(CorsOptions defaultCorsPreflightOptions) {
            this.defaultCorsPreflightOptions = defaultCorsPreflightOptions;
            return this;
        }

        public Builder defaultIntegration(Integration defaultIntegration) {
            this.defaultIntegration = defaultIntegration;
            return this;
        }

        public Builder defaultMethodOptions(MethodOptions defaultMethodOptions) {
            this.defaultMethodOptions = defaultMethodOptions;
            return this;
        }

        public RestApiProps build() {
            return new Jsii.Proxy(this.apiKeySourceType, this.binaryMediaTypes, this.cloneFrom, this.cloudWatchRole, this.deploy, this.deployOptions, this.description, this.domainName, this.endpointExportName, this.endpointTypes, this.failOnWarnings, this.minimumCompressionSize, this.parameters, this.policy, this.restApiName, this.retainDeployments, this.defaultCorsPreflightOptions, this.defaultIntegration, this.defaultMethodOptions, null);
        }
    }
}

