package software.amazon.awscdk.services.apigateway;

/**
 * A CloudFormation `AWS::ApiGateway::ApiKey`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.5 (build a820217)", date = "2019-11-13T14:31:32.049Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnApiKey")
public class CfnApiKey extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnApiKey(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApiKey(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnApiKey.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ApiGateway::ApiKey`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnApiKey(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.apigateway.CfnApiKeyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::ApiGateway::ApiKey`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnApiKey(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * 
     * EXPERIMENTAL
     * 
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", Void.class, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::ApiGateway::ApiKey.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::ApiGateway::ApiKey.CustomerId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-customerid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getCustomerId() {
        return this.jsiiGet("customerId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::ApiKey.CustomerId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-customerid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCustomerId(final java.lang.String value) {
        this.jsiiSet("customerId", value);
    }

    /**
     * `AWS::ApiGateway::ApiKey.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::ApiKey.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDescription(final java.lang.String value) {
        this.jsiiSet("description", value);
    }

    /**
     * `AWS::ApiGateway::ApiKey.Enabled`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-enabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getEnabled() {
        return this.jsiiGet("enabled", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::ApiKey.Enabled`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-enabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEnabled(final java.lang.Boolean value) {
        this.jsiiSet("enabled", value);
    }

    /**
     * `AWS::ApiGateway::ApiKey.Enabled`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-enabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setEnabled(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("enabled", value);
    }

    /**
     * `AWS::ApiGateway::ApiKey.GenerateDistinctId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-generatedistinctid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getGenerateDistinctId() {
        return this.jsiiGet("generateDistinctId", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::ApiKey.GenerateDistinctId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-generatedistinctid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setGenerateDistinctId(final java.lang.Boolean value) {
        this.jsiiSet("generateDistinctId", value);
    }

    /**
     * `AWS::ApiGateway::ApiKey.GenerateDistinctId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-generatedistinctid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setGenerateDistinctId(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("generateDistinctId", value);
    }

    /**
     * `AWS::ApiGateway::ApiKey.Name`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getName() {
        return this.jsiiGet("name", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::ApiKey.Name`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setName(final java.lang.String value) {
        this.jsiiSet("name", value);
    }

    /**
     * `AWS::ApiGateway::ApiKey.StageKeys`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-stagekeys
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getStageKeys() {
        return this.jsiiGet("stageKeys", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::ApiKey.StageKeys`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-stagekeys
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setStageKeys(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("stageKeys", value);
    }

    /**
     * `AWS::ApiGateway::ApiKey.StageKeys`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-stagekeys
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setStageKeys(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("stageKeys", value);
    }

    /**
     * `AWS::ApiGateway::ApiKey.Value`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-value
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getValue() {
        return this.jsiiGet("value", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::ApiKey.Value`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html#cfn-apigateway-apikey-value
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setValue(final java.lang.String value) {
        this.jsiiSet("value", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnApiKey.StageKeyProperty")
    @software.amazon.jsii.Jsii.Proxy(StageKeyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface StageKeyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnApiKey.StageKeyProperty.RestApiId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-restapiid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getRestApiId() {
            return null;
        }

        /**
         * `CfnApiKey.StageKeyProperty.StageName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-stagename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getStageName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StageKeyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StageKeyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String restApiId;
            private java.lang.String stageName;

            /**
             * Sets the value of RestApiId
             * @param restApiId `CfnApiKey.StageKeyProperty.RestApiId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder restApiId(java.lang.String restApiId) {
                this.restApiId = restApiId;
                return this;
            }

            /**
             * Sets the value of StageName
             * @param stageName `CfnApiKey.StageKeyProperty.StageName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder stageName(java.lang.String stageName) {
                this.stageName = stageName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StageKeyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public StageKeyProperty build() {
                return new Jsii$Proxy(restApiId, stageName);
            }
        }

        /**
         * An implementation for {@link StageKeyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StageKeyProperty {
            private final java.lang.String restApiId;
            private final java.lang.String stageName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.restApiId = this.jsiiGet("restApiId", java.lang.String.class);
                this.stageName = this.jsiiGet("stageName", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String restApiId, final java.lang.String stageName) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.restApiId = restApiId;
                this.stageName = stageName;
            }

            @Override
            public java.lang.String getRestApiId() {
                return this.restApiId;
            }

            @Override
            public java.lang.String getStageName() {
                return this.stageName;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRestApiId() != null) {
                    data.set("restApiId", om.valueToTree(this.getRestApiId()));
                }
                if (this.getStageName() != null) {
                    data.set("stageName", om.valueToTree(this.getStageName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnApiKey.StageKeyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StageKeyProperty.Jsii$Proxy that = (StageKeyProperty.Jsii$Proxy) o;

                if (this.restApiId != null ? !this.restApiId.equals(that.restApiId) : that.restApiId != null) return false;
                return this.stageName != null ? this.stageName.equals(that.stageName) : that.stageName == null;
            }

            @Override
            public int hashCode() {
                int result = this.restApiId != null ? this.restApiId.hashCode() : 0;
                result = 31 * result + (this.stageName != null ? this.stageName.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.CfnApiKey}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.apigateway.CfnApiKeyProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * @return {@code this}
         * @param customerId `AWS::ApiGateway::ApiKey.CustomerId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder customerId(final java.lang.String customerId) {
            this.props().customerId(customerId);
            return this;
        }

        /**
         * @return {@code this}
         * @param description `AWS::ApiGateway::ApiKey.Description`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * @return {@code this}
         * @param enabled `AWS::ApiGateway::ApiKey.Enabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props().enabled(enabled);
            return this;
        }
        /**
         * @return {@code this}
         * @param enabled `AWS::ApiGateway::ApiKey.Enabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder enabled(final software.amazon.awscdk.core.IResolvable enabled) {
            this.props().enabled(enabled);
            return this;
        }

        /**
         * @return {@code this}
         * @param generateDistinctId `AWS::ApiGateway::ApiKey.GenerateDistinctId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder generateDistinctId(final java.lang.Boolean generateDistinctId) {
            this.props().generateDistinctId(generateDistinctId);
            return this;
        }
        /**
         * @return {@code this}
         * @param generateDistinctId `AWS::ApiGateway::ApiKey.GenerateDistinctId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder generateDistinctId(final software.amazon.awscdk.core.IResolvable generateDistinctId) {
            this.props().generateDistinctId(generateDistinctId);
            return this;
        }

        /**
         * @return {@code this}
         * @param name `AWS::ApiGateway::ApiKey.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * @return {@code this}
         * @param stageKeys `AWS::ApiGateway::ApiKey.StageKeys`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder stageKeys(final software.amazon.awscdk.core.IResolvable stageKeys) {
            this.props().stageKeys(stageKeys);
            return this;
        }
        /**
         * @return {@code this}
         * @param stageKeys `AWS::ApiGateway::ApiKey.StageKeys`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder stageKeys(final java.util.List<java.lang.Object> stageKeys) {
            this.props().stageKeys(stageKeys);
            return this;
        }

        /**
         * @return {@code this}
         * @param tags `AWS::ApiGateway::ApiKey.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return {@code this}
         * @param value `AWS::ApiGateway::ApiKey.Value`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder value(final java.lang.String value) {
            this.props().value(value);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.CfnApiKey}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.apigateway.CfnApiKey build() {
            return new software.amazon.awscdk.services.apigateway.CfnApiKey(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.apigateway.CfnApiKeyProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.apigateway.CfnApiKeyProps.Builder();
            }
            return this.props;
        }
    }
}
