package software.amazon.awscdk.services.apigateway;

/**
 * A CloudFormation `AWS::ApiGatewayV2::Stage`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.5 (build a820217)", date = "2019-11-13T14:31:32.113Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnStageV2")
public class CfnStageV2 extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnStageV2(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStageV2(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnStageV2.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ApiGatewayV2::Stage`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnStageV2(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.apigateway.CfnStageV2Props props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * 
     * EXPERIMENTAL
     * 
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", Void.class, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::ApiGatewayV2::Stage.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::ApiGatewayV2::Stage.ApiId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-apiid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getApiId() {
        return this.jsiiGet("apiId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGatewayV2::Stage.ApiId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-apiid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApiId(final java.lang.String value) {
        this.jsiiSet("apiId", java.util.Objects.requireNonNull(value, "apiId is required"));
    }

    /**
     * `AWS::ApiGatewayV2::Stage.DeploymentId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-deploymentid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getDeploymentId() {
        return this.jsiiGet("deploymentId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGatewayV2::Stage.DeploymentId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-deploymentid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDeploymentId(final java.lang.String value) {
        this.jsiiSet("deploymentId", java.util.Objects.requireNonNull(value, "deploymentId is required"));
    }

    /**
     * `AWS::ApiGatewayV2::Stage.RouteSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-routesettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getRouteSettings() {
        return this.jsiiGet("routeSettings", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGatewayV2::Stage.RouteSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-routesettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRouteSettings(final java.lang.Object value) {
        this.jsiiSet("routeSettings", java.util.Objects.requireNonNull(value, "routeSettings is required"));
    }

    /**
     * `AWS::ApiGatewayV2::Stage.StageName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-stagename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getStageName() {
        return this.jsiiGet("stageName", java.lang.String.class);
    }

    /**
     * `AWS::ApiGatewayV2::Stage.StageName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-stagename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setStageName(final java.lang.String value) {
        this.jsiiSet("stageName", java.util.Objects.requireNonNull(value, "stageName is required"));
    }

    /**
     * `AWS::ApiGatewayV2::Stage.StageVariables`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-stagevariables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getStageVariables() {
        return this.jsiiGet("stageVariables", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGatewayV2::Stage.StageVariables`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-stagevariables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setStageVariables(final java.lang.Object value) {
        this.jsiiSet("stageVariables", java.util.Objects.requireNonNull(value, "stageVariables is required"));
    }

    /**
     * `AWS::ApiGatewayV2::Stage.AccessLogSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-accesslogsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getAccessLogSettings() {
        return this.jsiiGet("accessLogSettings", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGatewayV2::Stage.AccessLogSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-accesslogsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAccessLogSettings(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("accessLogSettings", value);
    }

    /**
     * `AWS::ApiGatewayV2::Stage.AccessLogSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-accesslogsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAccessLogSettings(final software.amazon.awscdk.services.apigateway.CfnStageV2.AccessLogSettingsProperty value) {
        this.jsiiSet("accessLogSettings", value);
    }

    /**
     * `AWS::ApiGatewayV2::Stage.ClientCertificateId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-clientcertificateid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getClientCertificateId() {
        return this.jsiiGet("clientCertificateId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGatewayV2::Stage.ClientCertificateId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-clientcertificateid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setClientCertificateId(final java.lang.String value) {
        this.jsiiSet("clientCertificateId", value);
    }

    /**
     * `AWS::ApiGatewayV2::Stage.DefaultRouteSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-defaultroutesettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getDefaultRouteSettings() {
        return this.jsiiGet("defaultRouteSettings", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGatewayV2::Stage.DefaultRouteSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-defaultroutesettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDefaultRouteSettings(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("defaultRouteSettings", value);
    }

    /**
     * `AWS::ApiGatewayV2::Stage.DefaultRouteSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-defaultroutesettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDefaultRouteSettings(final software.amazon.awscdk.services.apigateway.CfnStageV2.RouteSettingsProperty value) {
        this.jsiiSet("defaultRouteSettings", value);
    }

    /**
     * `AWS::ApiGatewayV2::Stage.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * `AWS::ApiGatewayV2::Stage.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-stage.html#cfn-apigatewayv2-stage-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDescription(final java.lang.String value) {
        this.jsiiSet("description", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-accesslogsettings.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnStageV2.AccessLogSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessLogSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AccessLogSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStageV2.AccessLogSettingsProperty.DestinationArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-accesslogsettings.html#cfn-apigatewayv2-stage-accesslogsettings-destinationarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getDestinationArn() {
            return null;
        }

        /**
         * `CfnStageV2.AccessLogSettingsProperty.Format`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-accesslogsettings.html#cfn-apigatewayv2-stage-accesslogsettings-format
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccessLogSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessLogSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String destinationArn;
            private java.lang.String format;

            /**
             * Sets the value of DestinationArn
             * @param destinationArn `CfnStageV2.AccessLogSettingsProperty.DestinationArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder destinationArn(java.lang.String destinationArn) {
                this.destinationArn = destinationArn;
                return this;
            }

            /**
             * Sets the value of Format
             * @param format `CfnStageV2.AccessLogSettingsProperty.Format`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessLogSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AccessLogSettingsProperty build() {
                return new Jsii$Proxy(destinationArn, format);
            }
        }

        /**
         * An implementation for {@link AccessLogSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessLogSettingsProperty {
            private final java.lang.String destinationArn;
            private final java.lang.String format;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationArn = this.jsiiGet("destinationArn", java.lang.String.class);
                this.format = this.jsiiGet("format", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String destinationArn, final java.lang.String format) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationArn = destinationArn;
                this.format = format;
            }

            @Override
            public java.lang.String getDestinationArn() {
                return this.destinationArn;
            }

            @Override
            public java.lang.String getFormat() {
                return this.format;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinationArn() != null) {
                    data.set("destinationArn", om.valueToTree(this.getDestinationArn()));
                }
                if (this.getFormat() != null) {
                    data.set("format", om.valueToTree(this.getFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnStageV2.AccessLogSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessLogSettingsProperty.Jsii$Proxy that = (AccessLogSettingsProperty.Jsii$Proxy) o;

                if (this.destinationArn != null ? !this.destinationArn.equals(that.destinationArn) : that.destinationArn != null) return false;
                return this.format != null ? this.format.equals(that.format) : that.format == null;
            }

            @Override
            public int hashCode() {
                int result = this.destinationArn != null ? this.destinationArn.hashCode() : 0;
                result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnStageV2.RouteSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(RouteSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface RouteSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStageV2.RouteSettingsProperty.DataTraceEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-datatraceenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getDataTraceEnabled() {
            return null;
        }

        /**
         * `CfnStageV2.RouteSettingsProperty.DetailedMetricsEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-detailedmetricsenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getDetailedMetricsEnabled() {
            return null;
        }

        /**
         * `CfnStageV2.RouteSettingsProperty.LoggingLevel`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-logginglevel
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getLoggingLevel() {
            return null;
        }

        /**
         * `CfnStageV2.RouteSettingsProperty.ThrottlingBurstLimit`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-throttlingburstlimit
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Number getThrottlingBurstLimit() {
            return null;
        }

        /**
         * `CfnStageV2.RouteSettingsProperty.ThrottlingRateLimit`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-stage-routesettings.html#cfn-apigatewayv2-stage-routesettings-throttlingratelimit
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Number getThrottlingRateLimit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RouteSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RouteSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object dataTraceEnabled;
            private java.lang.Object detailedMetricsEnabled;
            private java.lang.String loggingLevel;
            private java.lang.Number throttlingBurstLimit;
            private java.lang.Number throttlingRateLimit;

            /**
             * Sets the value of DataTraceEnabled
             * @param dataTraceEnabled `CfnStageV2.RouteSettingsProperty.DataTraceEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder dataTraceEnabled(java.lang.Boolean dataTraceEnabled) {
                this.dataTraceEnabled = dataTraceEnabled;
                return this;
            }

            /**
             * Sets the value of DataTraceEnabled
             * @param dataTraceEnabled `CfnStageV2.RouteSettingsProperty.DataTraceEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder dataTraceEnabled(software.amazon.awscdk.core.IResolvable dataTraceEnabled) {
                this.dataTraceEnabled = dataTraceEnabled;
                return this;
            }

            /**
             * Sets the value of DetailedMetricsEnabled
             * @param detailedMetricsEnabled `CfnStageV2.RouteSettingsProperty.DetailedMetricsEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder detailedMetricsEnabled(java.lang.Boolean detailedMetricsEnabled) {
                this.detailedMetricsEnabled = detailedMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of DetailedMetricsEnabled
             * @param detailedMetricsEnabled `CfnStageV2.RouteSettingsProperty.DetailedMetricsEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder detailedMetricsEnabled(software.amazon.awscdk.core.IResolvable detailedMetricsEnabled) {
                this.detailedMetricsEnabled = detailedMetricsEnabled;
                return this;
            }

            /**
             * Sets the value of LoggingLevel
             * @param loggingLevel `CfnStageV2.RouteSettingsProperty.LoggingLevel`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder loggingLevel(java.lang.String loggingLevel) {
                this.loggingLevel = loggingLevel;
                return this;
            }

            /**
             * Sets the value of ThrottlingBurstLimit
             * @param throttlingBurstLimit `CfnStageV2.RouteSettingsProperty.ThrottlingBurstLimit`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder throttlingBurstLimit(java.lang.Number throttlingBurstLimit) {
                this.throttlingBurstLimit = throttlingBurstLimit;
                return this;
            }

            /**
             * Sets the value of ThrottlingRateLimit
             * @param throttlingRateLimit `CfnStageV2.RouteSettingsProperty.ThrottlingRateLimit`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder throttlingRateLimit(java.lang.Number throttlingRateLimit) {
                this.throttlingRateLimit = throttlingRateLimit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RouteSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public RouteSettingsProperty build() {
                return new Jsii$Proxy(dataTraceEnabled, detailedMetricsEnabled, loggingLevel, throttlingBurstLimit, throttlingRateLimit);
            }
        }

        /**
         * An implementation for {@link RouteSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouteSettingsProperty {
            private final java.lang.Object dataTraceEnabled;
            private final java.lang.Object detailedMetricsEnabled;
            private final java.lang.String loggingLevel;
            private final java.lang.Number throttlingBurstLimit;
            private final java.lang.Number throttlingRateLimit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataTraceEnabled = this.jsiiGet("dataTraceEnabled", java.lang.Object.class);
                this.detailedMetricsEnabled = this.jsiiGet("detailedMetricsEnabled", java.lang.Object.class);
                this.loggingLevel = this.jsiiGet("loggingLevel", java.lang.String.class);
                this.throttlingBurstLimit = this.jsiiGet("throttlingBurstLimit", java.lang.Number.class);
                this.throttlingRateLimit = this.jsiiGet("throttlingRateLimit", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object dataTraceEnabled, final java.lang.Object detailedMetricsEnabled, final java.lang.String loggingLevel, final java.lang.Number throttlingBurstLimit, final java.lang.Number throttlingRateLimit) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataTraceEnabled = dataTraceEnabled;
                this.detailedMetricsEnabled = detailedMetricsEnabled;
                this.loggingLevel = loggingLevel;
                this.throttlingBurstLimit = throttlingBurstLimit;
                this.throttlingRateLimit = throttlingRateLimit;
            }

            @Override
            public java.lang.Object getDataTraceEnabled() {
                return this.dataTraceEnabled;
            }

            @Override
            public java.lang.Object getDetailedMetricsEnabled() {
                return this.detailedMetricsEnabled;
            }

            @Override
            public java.lang.String getLoggingLevel() {
                return this.loggingLevel;
            }

            @Override
            public java.lang.Number getThrottlingBurstLimit() {
                return this.throttlingBurstLimit;
            }

            @Override
            public java.lang.Number getThrottlingRateLimit() {
                return this.throttlingRateLimit;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataTraceEnabled() != null) {
                    data.set("dataTraceEnabled", om.valueToTree(this.getDataTraceEnabled()));
                }
                if (this.getDetailedMetricsEnabled() != null) {
                    data.set("detailedMetricsEnabled", om.valueToTree(this.getDetailedMetricsEnabled()));
                }
                if (this.getLoggingLevel() != null) {
                    data.set("loggingLevel", om.valueToTree(this.getLoggingLevel()));
                }
                if (this.getThrottlingBurstLimit() != null) {
                    data.set("throttlingBurstLimit", om.valueToTree(this.getThrottlingBurstLimit()));
                }
                if (this.getThrottlingRateLimit() != null) {
                    data.set("throttlingRateLimit", om.valueToTree(this.getThrottlingRateLimit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnStageV2.RouteSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RouteSettingsProperty.Jsii$Proxy that = (RouteSettingsProperty.Jsii$Proxy) o;

                if (this.dataTraceEnabled != null ? !this.dataTraceEnabled.equals(that.dataTraceEnabled) : that.dataTraceEnabled != null) return false;
                if (this.detailedMetricsEnabled != null ? !this.detailedMetricsEnabled.equals(that.detailedMetricsEnabled) : that.detailedMetricsEnabled != null) return false;
                if (this.loggingLevel != null ? !this.loggingLevel.equals(that.loggingLevel) : that.loggingLevel != null) return false;
                if (this.throttlingBurstLimit != null ? !this.throttlingBurstLimit.equals(that.throttlingBurstLimit) : that.throttlingBurstLimit != null) return false;
                return this.throttlingRateLimit != null ? this.throttlingRateLimit.equals(that.throttlingRateLimit) : that.throttlingRateLimit == null;
            }

            @Override
            public int hashCode() {
                int result = this.dataTraceEnabled != null ? this.dataTraceEnabled.hashCode() : 0;
                result = 31 * result + (this.detailedMetricsEnabled != null ? this.detailedMetricsEnabled.hashCode() : 0);
                result = 31 * result + (this.loggingLevel != null ? this.loggingLevel.hashCode() : 0);
                result = 31 * result + (this.throttlingBurstLimit != null ? this.throttlingBurstLimit.hashCode() : 0);
                result = 31 * result + (this.throttlingRateLimit != null ? this.throttlingRateLimit.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.CfnStageV2}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.CfnStageV2Props.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.CfnStageV2Props.Builder();
        }

        /**
         * @return {@code this}
         * @param apiId `AWS::ApiGatewayV2::Stage.ApiId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder apiId(final java.lang.String apiId) {
            this.props.apiId(apiId);
            return this;
        }

        /**
         * @return {@code this}
         * @param deploymentId `AWS::ApiGatewayV2::Stage.DeploymentId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder deploymentId(final java.lang.String deploymentId) {
            this.props.deploymentId(deploymentId);
            return this;
        }

        /**
         * @return {@code this}
         * @param stageName `AWS::ApiGatewayV2::Stage.StageName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder stageName(final java.lang.String stageName) {
            this.props.stageName(stageName);
            return this;
        }

        /**
         * @return {@code this}
         * @param accessLogSettings `AWS::ApiGatewayV2::Stage.AccessLogSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder accessLogSettings(final software.amazon.awscdk.core.IResolvable accessLogSettings) {
            this.props.accessLogSettings(accessLogSettings);
            return this;
        }
        /**
         * @return {@code this}
         * @param accessLogSettings `AWS::ApiGatewayV2::Stage.AccessLogSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder accessLogSettings(final software.amazon.awscdk.services.apigateway.CfnStageV2.AccessLogSettingsProperty accessLogSettings) {
            this.props.accessLogSettings(accessLogSettings);
            return this;
        }

        /**
         * @return {@code this}
         * @param clientCertificateId `AWS::ApiGatewayV2::Stage.ClientCertificateId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder clientCertificateId(final java.lang.String clientCertificateId) {
            this.props.clientCertificateId(clientCertificateId);
            return this;
        }

        /**
         * @return {@code this}
         * @param defaultRouteSettings `AWS::ApiGatewayV2::Stage.DefaultRouteSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder defaultRouteSettings(final software.amazon.awscdk.core.IResolvable defaultRouteSettings) {
            this.props.defaultRouteSettings(defaultRouteSettings);
            return this;
        }
        /**
         * @return {@code this}
         * @param defaultRouteSettings `AWS::ApiGatewayV2::Stage.DefaultRouteSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder defaultRouteSettings(final software.amazon.awscdk.services.apigateway.CfnStageV2.RouteSettingsProperty defaultRouteSettings) {
            this.props.defaultRouteSettings(defaultRouteSettings);
            return this;
        }

        /**
         * @return {@code this}
         * @param description `AWS::ApiGatewayV2::Stage.Description`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @return {@code this}
         * @param routeSettings `AWS::ApiGatewayV2::Stage.RouteSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder routeSettings(final java.lang.Object routeSettings) {
            this.props.routeSettings(routeSettings);
            return this;
        }

        /**
         * @return {@code this}
         * @param stageVariables `AWS::ApiGatewayV2::Stage.StageVariables`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder stageVariables(final java.lang.Object stageVariables) {
            this.props.stageVariables(stageVariables);
            return this;
        }

        /**
         * @return {@code this}
         * @param tags `AWS::ApiGatewayV2::Stage.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(final java.lang.Object tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.CfnStageV2}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.apigateway.CfnStageV2 build() {
            return new software.amazon.awscdk.services.apigateway.CfnStageV2(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
