package software.amazon.awscdk.services.apigateway;

/**
 * Base class for backend integrations for an API Gateway method.
 * 
 * Use one of the concrete classes such as `MockIntegration`, `AwsIntegration`, `LambdaIntegration`
 * or implement on your own by specifying the set of props.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.5 (build a820217)", date = "2019-11-13T14:31:32.128Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.Integration")
public class Integration extends software.amazon.jsii.JsiiObject {

    protected Integration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Integration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Integration(final software.amazon.awscdk.services.apigateway.IntegrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Can be overridden by subclasses to allow the integration to interact with the method being integrated, access the REST API object, method ARNs, etc.
     * 
     * @param _method This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void bind(final software.amazon.awscdk.services.apigateway.Method _method) {
        this.jsiiCall("bind", Void.class, new Object[] { java.util.Objects.requireNonNull(_method, "_method is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.Integration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.apigateway.IntegrationProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.apigateway.IntegrationProps.Builder();
        }

        /**
         * @return {@code this}
         * @param type Specifies an API method integration type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final software.amazon.awscdk.services.apigateway.IntegrationType type) {
            this.props.type(type);
            return this;
        }

        /**
         * @return {@code this}
         * @param integrationHttpMethod The integration's HTTP method type. Required unless you use a MOCK integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationHttpMethod(final java.lang.String integrationHttpMethod) {
            this.props.integrationHttpMethod(integrationHttpMethod);
            return this;
        }

        /**
         * @return {@code this}
         * @param options Integration options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(final software.amazon.awscdk.services.apigateway.IntegrationOptions options) {
            this.props.options(options);
            return this;
        }

        /**
         * @return {@code this}
         * @param uri The Uniform Resource Identifier (URI) for the integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uri(final java.lang.Object uri) {
            this.props.uri(uri);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.Integration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.apigateway.Integration build() {
            return new software.amazon.awscdk.services.apigateway.Integration(
                this.props.build()
            );
        }
    }
}
