package software.amazon.awscdk.services.apigateway;

/**
 * Integrates an AWS Lambda function to an API Gateway method.
 * 
 * Example:
 * 
 *    const handler = new lambda.Function(this, 'MyFunction', ...);
 *    api.addMethod('GET', new LambdaIntegration(handler));
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.5 (build a820217)", date = "2019-11-13T14:31:32.132Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.LambdaIntegration")
public class LambdaIntegration extends software.amazon.awscdk.services.apigateway.AwsIntegration {

    protected LambdaIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param handler This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LambdaIntegration(final software.amazon.awscdk.services.lambda.IFunction handler, final software.amazon.awscdk.services.apigateway.LambdaIntegrationOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(handler, "handler is required"), options });
    }

    /**
     * @param handler This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LambdaIntegration(final software.amazon.awscdk.services.lambda.IFunction handler) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(handler, "handler is required") });
    }

    /**
     * Can be overridden by subclasses to allow the integration to interact with the method being integrated, access the REST API object, method ARNs, etc.
     * 
     * @param method This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final software.amazon.awscdk.services.apigateway.Method method) {
        this.jsiiCall("bind", Void.class, new Object[] { java.util.Objects.requireNonNull(method, "method is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.LambdaIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param handler This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.lambda.IFunction handler) {
            return new Builder(handler);
        }

        private final software.amazon.awscdk.services.lambda.IFunction handler;
        private software.amazon.awscdk.services.apigateway.LambdaIntegrationOptions.Builder options;

        private Builder(final software.amazon.awscdk.services.lambda.IFunction handler) {
            this.handler = handler;
        }

        /**
         * @return {@code this}
         * @param cacheKeyParameters A list of request parameters whose values are to be cached. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheKeyParameters(final java.util.List<java.lang.String> cacheKeyParameters) {
            this.options().cacheKeyParameters(cacheKeyParameters);
            return this;
        }

        /**
         * @return {@code this}
         * @param cacheNamespace An API-specific tag group of related cached parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheNamespace(final java.lang.String cacheNamespace) {
            this.options().cacheNamespace(cacheNamespace);
            return this;
        }

        /**
         * @return {@code this}
         * @param connectionType The type of network connection to the integration endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionType(final software.amazon.awscdk.services.apigateway.ConnectionType connectionType) {
            this.options().connectionType(connectionType);
            return this;
        }

        /**
         * @return {@code this}
         * @param contentHandling Specifies how to handle request payload content type conversions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentHandling(final software.amazon.awscdk.services.apigateway.ContentHandling contentHandling) {
            this.options().contentHandling(contentHandling);
            return this;
        }

        /**
         * @return {@code this}
         * @param credentialsPassthrough Requires that the caller's identity be passed through from the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsPassthrough(final java.lang.Boolean credentialsPassthrough) {
            this.options().credentialsPassthrough(credentialsPassthrough);
            return this;
        }

        /**
         * @return {@code this}
         * @param credentialsRole An IAM role that API Gateway assumes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsRole(final software.amazon.awscdk.services.iam.IRole credentialsRole) {
            this.options().credentialsRole(credentialsRole);
            return this;
        }

        /**
         * @return {@code this}
         * @param integrationResponses The response that API Gateway provides after a method's backend completes processing a request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationResponses(final java.util.List<software.amazon.awscdk.services.apigateway.IntegrationResponse> integrationResponses) {
            this.options().integrationResponses(integrationResponses);
            return this;
        }

        /**
         * @return {@code this}
         * @param passthroughBehavior Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passthroughBehavior(final software.amazon.awscdk.services.apigateway.PassthroughBehavior passthroughBehavior) {
            this.options().passthroughBehavior(passthroughBehavior);
            return this;
        }

        /**
         * @return {@code this}
         * @param requestParameters The request parameters that API Gateway sends with the backend request. Specify request parameters as key-value pairs (string-to-string mappings), with a destination as the key and a source as the value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(final java.util.Map<java.lang.String, java.lang.String> requestParameters) {
            this.options().requestParameters(requestParameters);
            return this;
        }

        /**
         * @return {@code this}
         * @param requestTemplates A map of Apache Velocity templates that are applied on the request payload. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestTemplates(final java.util.Map<java.lang.String, java.lang.String> requestTemplates) {
            this.options().requestTemplates(requestTemplates);
            return this;
        }

        /**
         * @return {@code this}
         * @param vpcLink The VpcLink used for the integration. Required if connectionType is VPC_LINK. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcLink(final software.amazon.awscdk.services.apigateway.VpcLink vpcLink) {
            this.options().vpcLink(vpcLink);
            return this;
        }

        /**
         * @return {@code this}
         * @param allowTestInvoke Allow invoking method from AWS Console UI (for testing purposes). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowTestInvoke(final java.lang.Boolean allowTestInvoke) {
            this.options().allowTestInvoke(allowTestInvoke);
            return this;
        }

        /**
         * @return {@code this}
         * @param proxy Use proxy integration or normal (request/response mapping) integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxy(final java.lang.Boolean proxy) {
            this.options().proxy(proxy);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.LambdaIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.apigateway.LambdaIntegration build() {
            return new software.amazon.awscdk.services.apigateway.LambdaIntegration(
                this.handler,
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.apigateway.LambdaIntegrationOptions.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.apigateway.LambdaIntegrationOptions.Builder();
            }
            return this.options;
        }
    }
}
