package software.amazon.awscdk.services.apigateway;

/**
 * Represents a REST API in Amazon API Gateway.
 * 
 * Use `addResource` and `addMethod` to configure the API model.
 * 
 * By default, the API will automatically be deployed and accessible from a
 * public endpoint.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.5 (build a820217)", date = "2019-11-13T14:31:32.144Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.RestApi")
public class RestApi extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.apigateway.IRestApi {

    protected RestApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RestApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RestApi(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.apigateway.RestApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RestApi(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param restApiId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.services.apigateway.IRestApi fromRestApiId(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final java.lang.String restApiId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.RestApi.class, "fromRestApiId", software.amazon.awscdk.services.apigateway.IRestApi.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(restApiId, "restApiId is required") });
    }

    /**
     * Add an ApiKey.
     * 
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.apigateway.IApiKey addApiKey(final java.lang.String id) {
        return this.jsiiCall("addApiKey", software.amazon.awscdk.services.apigateway.IApiKey.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines an API Gateway domain name and maps it to this API.
     * 
     * @param id The construct id. This parameter is required.
     * @param options custom domain options. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.apigateway.DomainName addDomainName(final java.lang.String id, final software.amazon.awscdk.services.apigateway.DomainNameOptions options) {
        return this.jsiiCall("addDomainName", software.amazon.awscdk.services.apigateway.DomainName.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds a new model.
     * 
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.apigateway.Model addModel(final java.lang.String id, final software.amazon.awscdk.services.apigateway.ModelOptions props) {
        return this.jsiiCall("addModel", software.amazon.awscdk.services.apigateway.Model.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds a new request validator.
     * 
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.apigateway.RequestValidator addRequestValidator(final java.lang.String id, final software.amazon.awscdk.services.apigateway.RequestValidatorOptions props) {
        return this.jsiiCall("addRequestValidator", software.amazon.awscdk.services.apigateway.RequestValidator.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds a usage plan.
     * 
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.apigateway.UsagePlan addUsagePlan(final java.lang.String id, final software.amazon.awscdk.services.apigateway.UsagePlanProps props) {
        return this.jsiiCall("addUsagePlan", software.amazon.awscdk.services.apigateway.UsagePlan.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Adds a usage plan.
     * 
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.apigateway.UsagePlan addUsagePlan(final java.lang.String id) {
        return this.jsiiCall("addUsagePlan", software.amazon.awscdk.services.apigateway.UsagePlan.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Default: "*" returns the execute API ARN for all methods/resources in
     * this API.
     * 
     * @return The "execute-api" ARN.
     * @param method The method (default `*`).
     * @param path The resource path.
     * @param stage The stage (default `*`).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String arnForExecuteApi(final java.lang.String method, final java.lang.String path, final java.lang.String stage) {
        return this.jsiiCall("arnForExecuteApi", java.lang.String.class, new Object[] { method, path, stage });
    }

    /**
     * Default: "*" returns the execute API ARN for all methods/resources in
     * this API.
     * 
     * @return The "execute-api" ARN.
     * @param method The method (default `*`).
     * @param path The resource path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String arnForExecuteApi(final java.lang.String method, final java.lang.String path) {
        return this.jsiiCall("arnForExecuteApi", java.lang.String.class, new Object[] { method, path });
    }

    /**
     * Default: "*" returns the execute API ARN for all methods/resources in
     * this API.
     * 
     * @return The "execute-api" ARN.
     * @param method The method (default `*`).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String arnForExecuteApi(final java.lang.String method) {
        return this.jsiiCall("arnForExecuteApi", java.lang.String.class, new Object[] { method });
    }

    /**
     * Default: "*" returns the execute API ARN for all methods/resources in
     * this API.
     * 
     * @return The "execute-api" ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String arnForExecuteApi() {
        return this.jsiiCall("arnForExecuteApi", java.lang.String.class);
    }

    /**
     * Returns the URL for an HTTP path.
     * 
     * Fails if `deploymentStage` is not set either by `deploy` or explicitly.
     * 
     * @param path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String urlForPath(final java.lang.String path) {
        return this.jsiiCall("urlForPath", java.lang.String.class, new Object[] { path });
    }

    /**
     * Returns the URL for an HTTP path.
     * 
     * Fails if `deploymentStage` is not set either by `deploy` or explicitly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String urlForPath() {
        return this.jsiiCall("urlForPath", java.lang.String.class);
    }

    /**
     * Performs validation of the REST API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected java.util.List<java.lang.String> validate() {
        return java.util.Collections.unmodifiableList(this.jsiiCall("validate", java.util.List.class));
    }

    /**
     * The ID of this API Gateway RestApi.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getRestApiId() {
        return this.jsiiGet("restApiId", java.lang.String.class);
    }

    /**
     * The resource ID of the root resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getRestApiRootResourceId() {
        return this.jsiiGet("restApiRootResourceId", java.lang.String.class);
    }

    /**
     * Represents the root resource ("/") of this API. Use it to define the API model:.
     * 
     * api.root.addMethod('ANY', redirectToHomePage); // "ANY /"
     *     api.root.addResource('friends').addMethod('GET', getFriendsHandler); // "GET /friends"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.apigateway.IResource getRoot() {
        return this.jsiiGet("root", software.amazon.awscdk.services.apigateway.IResource.class);
    }

    /**
     * The deployed root URL of this REST API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getUrl() {
        return this.jsiiGet("url", java.lang.String.class);
    }

    /**
     * The domain name mapped to this API, if defined through the `domainName` configuration prop.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.apigateway.DomainName getDomainName() {
        return this.jsiiGet("domainName", software.amazon.awscdk.services.apigateway.DomainName.class);
    }

    /**
     * API Gateway deployment that represents the latest changes of the API. This resource will be automatically updated every time the REST API model changes. This will be undefined if `deploy` is false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.apigateway.Deployment getLatestDeployment() {
        return this.jsiiGet("latestDeployment", software.amazon.awscdk.services.apigateway.Deployment.class);
    }

    /**
     * API Gateway stage that points to the latest deployment (if defined).
     * 
     * If `deploy` is disabled, you will need to explicitly assign this value in order to
     * set up integrations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.apigateway.Stage getDeploymentStage() {
        return this.jsiiGet("deploymentStage", software.amazon.awscdk.services.apigateway.Stage.class);
    }

    /**
     * API Gateway stage that points to the latest deployment (if defined).
     * 
     * If `deploy` is disabled, you will need to explicitly assign this value in order to
     * set up integrations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentStage(final software.amazon.awscdk.services.apigateway.Stage value) {
        this.jsiiSet("deploymentStage", java.util.Objects.requireNonNull(value, "deploymentStage is required"));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.RestApi}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.apigateway.RestApiProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * @return {@code this}
         * @param defaultCorsPreflightOptions Adds a CORS preflight OPTIONS method to this resource and all child resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCorsPreflightOptions(final software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions) {
            this.props().defaultCorsPreflightOptions(defaultCorsPreflightOptions);
            return this;
        }

        /**
         * @return {@code this}
         * @param defaultIntegration An integration to use as a default for all methods created within this API unless an integration is specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultIntegration(final software.amazon.awscdk.services.apigateway.Integration defaultIntegration) {
            this.props().defaultIntegration(defaultIntegration);
            return this;
        }

        /**
         * @return {@code this}
         * @param defaultMethodOptions Method options to use as a default for all methods created within this API unless custom options are specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultMethodOptions(final software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions) {
            this.props().defaultMethodOptions(defaultMethodOptions);
            return this;
        }

        /**
         * @return {@code this}
         * @param apiKeySourceType The source of the API key for metering requests according to a usage plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeySourceType(final software.amazon.awscdk.services.apigateway.ApiKeySourceType apiKeySourceType) {
            this.props().apiKeySourceType(apiKeySourceType);
            return this;
        }

        /**
         * @return {@code this}
         * @param binaryMediaTypes The list of binary media mime-types that are supported by the RestApi resource, such as "image/png" or "application/octet-stream". This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder binaryMediaTypes(final java.util.List<java.lang.String> binaryMediaTypes) {
            this.props().binaryMediaTypes(binaryMediaTypes);
            return this;
        }

        /**
         * @return {@code this}
         * @param cloneFrom The ID of the API Gateway RestApi resource that you want to clone. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloneFrom(final software.amazon.awscdk.services.apigateway.IRestApi cloneFrom) {
            this.props().cloneFrom(cloneFrom);
            return this;
        }

        /**
         * @return {@code this}
         * @param cloudWatchRole Automatically configure an AWS CloudWatch role for API Gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchRole(final java.lang.Boolean cloudWatchRole) {
            this.props().cloudWatchRole(cloudWatchRole);
            return this;
        }

        /**
         * @return {@code this}
         * @param deploy Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploy(final java.lang.Boolean deploy) {
            this.props().deploy(deploy);
            return this;
        }

        /**
         * @return {@code this}
         * @param deployOptions Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployOptions(final software.amazon.awscdk.services.apigateway.StageOptions deployOptions) {
            this.props().deployOptions(deployOptions);
            return this;
        }

        /**
         * @return {@code this}
         * @param description A description of the purpose of this API Gateway RestApi resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * @return {@code this}
         * @param domainName Configure a custom domain name and map it to this API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final software.amazon.awscdk.services.apigateway.DomainNameOptions domainName) {
            this.props().domainName(domainName);
            return this;
        }

        /**
         * @return {@code this}
         * @param endpointExportName Export name for the CfnOutput containing the API endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointExportName(final java.lang.String endpointExportName) {
            this.props().endpointExportName(endpointExportName);
            return this;
        }

        /**
         * @return {@code this}
         * @param endpointTypes A list of the endpoint types of the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointTypes(final java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> endpointTypes) {
            this.props().endpointTypes(endpointTypes);
            return this;
        }

        /**
         * @return {@code this}
         * @param failOnWarnings Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failOnWarnings(final java.lang.Boolean failOnWarnings) {
            this.props().failOnWarnings(failOnWarnings);
            return this;
        }

        /**
         * @return {@code this}
         * @param minimumCompressionSize A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (when undefined) on an API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumCompressionSize(final java.lang.Number minimumCompressionSize) {
            this.props().minimumCompressionSize(minimumCompressionSize);
            return this;
        }

        /**
         * @return {@code this}
         * @param parameters Custom header parameters for the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props().parameters(parameters);
            return this;
        }

        /**
         * @return {@code this}
         * @param policy A policy document that contains the permissions for this RestApi. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(final software.amazon.awscdk.services.iam.PolicyDocument policy) {
            this.props().policy(policy);
            return this;
        }

        /**
         * @return {@code this}
         * @param restApiName A name for the API Gateway RestApi resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiName(final java.lang.String restApiName) {
            this.props().restApiName(restApiName);
            return this;
        }

        /**
         * @return {@code this}
         * @param retainDeployments Retains old deployment resources when the API changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainDeployments(final java.lang.Boolean retainDeployments) {
            this.props().retainDeployments(retainDeployments);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.RestApi}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.apigateway.RestApi build() {
            return new software.amazon.awscdk.services.apigateway.RestApi(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.apigateway.RestApiProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.apigateway.RestApiProps.Builder();
            }
            return this.props;
        }
    }
}
