/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.apigateway.;
import software.amazon.awscdk.services.apigateway.ApiKeySourceType;
import software.amazon.awscdk.services.apigateway.CorsOptions;
import software.amazon.awscdk.services.apigateway.Deployment;
import software.amazon.awscdk.services.apigateway.DomainName;
import software.amazon.awscdk.services.apigateway.DomainNameOptions;
import software.amazon.awscdk.services.apigateway.EndpointType;
import software.amazon.awscdk.services.apigateway.IApiKey;
import software.amazon.awscdk.services.apigateway.IResource;
import software.amazon.awscdk.services.apigateway.IRestApi;
import software.amazon.awscdk.services.apigateway.Integration;
import software.amazon.awscdk.services.apigateway.MethodOptions;
import software.amazon.awscdk.services.apigateway.Model;
import software.amazon.awscdk.services.apigateway.ModelOptions;
import software.amazon.awscdk.services.apigateway.RequestValidator;
import software.amazon.awscdk.services.apigateway.RequestValidatorOptions;
import software.amazon.awscdk.services.apigateway.RestApiProps;
import software.amazon.awscdk.services.apigateway.Stage;
import software.amazon.awscdk.services.apigateway.StageOptions;
import software.amazon.awscdk.services.apigateway.UsagePlan;
import software.amazon.awscdk.services.apigateway.UsagePlanProps;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-apigateway.RestApi")
public class RestApi
extends Resource
implements IRestApi {
    protected RestApi(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RestApi(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public RestApi(Construct scope, String id, RestApiProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public RestApi(Construct scope, String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public static IRestApi fromRestApiId(Construct scope, String id, String restApiId) {
        return (IRestApi)JsiiObject.jsiiStaticCall(RestApi.class, (String)"fromRestApiId", IRestApi.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(restApiId, "restApiId is required")});
    }

    public IApiKey addApiKey(String id) {
        return (IApiKey)this.jsiiCall("addApiKey", IApiKey.class, new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    public DomainName addDomainName(String id, DomainNameOptions options) {
        return (DomainName)this.jsiiCall("addDomainName", DomainName.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    public Model addModel(String id, ModelOptions props) {
        return (Model)this.jsiiCall("addModel", Model.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public RequestValidator addRequestValidator(String id, RequestValidatorOptions props) {
        return (RequestValidator)this.jsiiCall("addRequestValidator", RequestValidator.class, new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public UsagePlan addUsagePlan(String id, UsagePlanProps props) {
        return (UsagePlan)((Object)this.jsiiCall("addUsagePlan", UsagePlan.class, new Object[]{Objects.requireNonNull(id, "id is required"), props}));
    }

    public UsagePlan addUsagePlan(String id) {
        return (UsagePlan)((Object)this.jsiiCall("addUsagePlan", UsagePlan.class, new Object[]{Objects.requireNonNull(id, "id is required")}));
    }

    public String arnForExecuteApi(String method, String path, String stage) {
        return (String)this.jsiiCall("arnForExecuteApi", String.class, new Object[]{method, path, stage});
    }

    public String arnForExecuteApi(String method, String path) {
        return (String)this.jsiiCall("arnForExecuteApi", String.class, new Object[]{method, path});
    }

    public String arnForExecuteApi(String method) {
        return (String)this.jsiiCall("arnForExecuteApi", String.class, new Object[]{method});
    }

    public String arnForExecuteApi() {
        return (String)this.jsiiCall("arnForExecuteApi", String.class, new Object[0]);
    }

    public String urlForPath(String path) {
        return (String)this.jsiiCall("urlForPath", String.class, new Object[]{path});
    }

    public String urlForPath() {
        return (String)this.jsiiCall("urlForPath", String.class, new Object[0]);
    }

    protected List<String> validate() {
        return Collections.unmodifiableList((List)this.jsiiCall("validate", List.class, new Object[0]));
    }

    @Override
    public String getRestApiId() {
        return (String)this.jsiiGet("restApiId", String.class);
    }

    public String getRestApiRootResourceId() {
        return (String)this.jsiiGet("restApiRootResourceId", String.class);
    }

    public IResource getRoot() {
        return (IResource)this.jsiiGet("root", IResource.class);
    }

    public String getUrl() {
        return (String)this.jsiiGet("url", String.class);
    }

    public DomainName getDomainName() {
        return (DomainName)this.jsiiGet("domainName", DomainName.class);
    }

    public Deployment getLatestDeployment() {
        return (Deployment)((Object)this.jsiiGet("latestDeployment", Deployment.class));
    }

    public Stage getDeploymentStage() {
        return (Stage)((Object)this.jsiiGet("deploymentStage", Stage.class));
    }

    public void setDeploymentStage(Stage value) {
        this.jsiiSet("deploymentStage", (Object)Objects.requireNonNull(value, "deploymentStage is required"));
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private RestApiProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder defaultCorsPreflightOptions(CorsOptions defaultCorsPreflightOptions) {
            this.props().defaultCorsPreflightOptions(defaultCorsPreflightOptions);
            return this;
        }

        public Builder defaultIntegration(Integration defaultIntegration) {
            this.props().defaultIntegration(defaultIntegration);
            return this;
        }

        public Builder defaultMethodOptions(MethodOptions defaultMethodOptions) {
            this.props().defaultMethodOptions(defaultMethodOptions);
            return this;
        }

        public Builder apiKeySourceType(ApiKeySourceType apiKeySourceType) {
            this.props().apiKeySourceType(apiKeySourceType);
            return this;
        }

        public Builder binaryMediaTypes(List<String> binaryMediaTypes) {
            this.props().binaryMediaTypes(binaryMediaTypes);
            return this;
        }

        public Builder cloneFrom(IRestApi cloneFrom) {
            this.props().cloneFrom(cloneFrom);
            return this;
        }

        public Builder cloudWatchRole(Boolean cloudWatchRole) {
            this.props().cloudWatchRole(cloudWatchRole);
            return this;
        }

        public Builder deploy(Boolean deploy) {
            this.props().deploy(deploy);
            return this;
        }

        public Builder deployOptions(StageOptions deployOptions) {
            this.props().deployOptions(deployOptions);
            return this;
        }

        public Builder description(String description) {
            this.props().description(description);
            return this;
        }

        public Builder domainName(DomainNameOptions domainName) {
            this.props().domainName(domainName);
            return this;
        }

        public Builder endpointExportName(String endpointExportName) {
            this.props().endpointExportName(endpointExportName);
            return this;
        }

        public Builder endpointTypes(List<EndpointType> endpointTypes) {
            this.props().endpointTypes(endpointTypes);
            return this;
        }

        public Builder failOnWarnings(Boolean failOnWarnings) {
            this.props().failOnWarnings(failOnWarnings);
            return this;
        }

        public Builder minimumCompressionSize(Number minimumCompressionSize) {
            this.props().minimumCompressionSize(minimumCompressionSize);
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.props().parameters(parameters);
            return this;
        }

        public Builder policy(PolicyDocument policy) {
            this.props().policy(policy);
            return this;
        }

        public Builder restApiName(String restApiName) {
            this.props().restApiName(restApiName);
            return this;
        }

        public Builder retainDeployments(Boolean retainDeployments) {
            this.props().retainDeployments(retainDeployments);
            return this;
        }

        public RestApi build() {
            return new RestApi(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private RestApiProps.Builder props() {
            if (this.props == null) {
                this.props = new RestApiProps.Builder();
            }
            return this.props;
        }
    }
}

