package software.amazon.awscdk.services.apigateway;

/**
 * factory methods for access log format.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * LogGroup logGroup = new LogGroup(this, "ApiGatewayAccessLogs");
 * RestApi.Builder.create(this, "books")
 *         .deployOptions(StageOptions.builder()
 *                 .accessLogDestination(new LogGroupLogDestination(logGroup))
 *                 .accessLogFormat(AccessLogFormat.custom(String.format("%s %s %s", AccessLogField.contextRequestId(), AccessLogField.contextErrorMessage(), AccessLogField.contextErrorMessageString())))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-07-06T20:02:54.890Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.AccessLogFormat")
public class AccessLogFormat extends software.amazon.jsii.JsiiObject {

    protected AccessLogFormat(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AccessLogFormat(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Generate Common Log Format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.AccessLogFormat clf() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogFormat.class, "clf", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.AccessLogFormat.class));
    }

    /**
     * Custom log format.
     * <p>
     * You can create any log format string. You can easily get the $ context variable by using the methods of AccessLogField.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * AccessLogFormat.custom(JSON.stringify(Map.of(
     *         "requestId", AccessLogField.contextRequestId(),
     *         "sourceIp", AccessLogField.contextIdentitySourceIp(),
     *         "method", AccessLogField.contextHttpMethod(),
     *         "userContext", Map.of(
     *                 "sub", AccessLogField.contextAuthorizerClaims("sub"),
     *                 "email", AccessLogField.contextAuthorizerClaims("email")))));
     * </pre></blockquote>
     * <p>
     * @param format This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.AccessLogFormat custom(final @org.jetbrains.annotations.NotNull java.lang.String format) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogFormat.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.AccessLogFormat.class), new Object[] { java.util.Objects.requireNonNull(format, "format is required") });
    }

    /**
     * Access log will be produced in the JSON format with a set of fields most useful in the access log.
     * <p>
     * All fields are turned on by default with the
     * option to turn off specific fields.
     * <p>
     * @param fields
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.AccessLogFormat jsonWithStandardFields(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.JsonWithStandardFieldProps fields) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogFormat.class, "jsonWithStandardFields", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.AccessLogFormat.class), new Object[] { fields });
    }

    /**
     * Access log will be produced in the JSON format with a set of fields most useful in the access log.
     * <p>
     * All fields are turned on by default with the
     * option to turn off specific fields.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.AccessLogFormat jsonWithStandardFields() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.AccessLogFormat.class, "jsonWithStandardFields", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.AccessLogFormat.class));
    }

    /**
     * Output a format string to be used with CloudFormation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
