package software.amazon.awscdk.services.apigateway;

/**
 * Represents an OpenAPI definition asset.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Integration integration;
 * SpecRestApi api = SpecRestApi.Builder.create(this, "books-api")
 *         .apiDefinition(ApiDefinition.fromAsset("path-to-file.json"))
 *         .build();
 * Resource booksResource = api.root.addResource("books");
 * booksResource.addMethod("GET", integration);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-07-06T20:02:54.893Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.ApiDefinition")
public abstract class ApiDefinition extends software.amazon.jsii.JsiiObject {

    protected ApiDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApiDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected ApiDefinition() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Loads the API specification from a local disk asset.
     * <p>
     * @param file This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.AssetApiDefinition fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String file, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.AssetOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.ApiDefinition.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.AssetApiDefinition.class), new Object[] { java.util.Objects.requireNonNull(file, "file is required"), options });
    }

    /**
     * Loads the API specification from a local disk asset.
     * <p>
     * @param file This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.AssetApiDefinition fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String file) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.ApiDefinition.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.AssetApiDefinition.class), new Object[] { java.util.Objects.requireNonNull(file, "file is required") });
    }

    /**
     * Creates an API definition from a specification file in an S3 bucket.
     * <p>
     * @param bucket This parameter is required.
     * @param key This parameter is required.
     * @param objectVersion
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.S3ApiDefinition fromBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.Nullable java.lang.String objectVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.ApiDefinition.class, "fromBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.S3ApiDefinition.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required"), objectVersion });
    }

    /**
     * Creates an API definition from a specification file in an S3 bucket.
     * <p>
     * @param bucket This parameter is required.
     * @param key This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.S3ApiDefinition fromBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.ApiDefinition.class, "fromBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.S3ApiDefinition.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * Create an API definition from an inline object.
     * <p>
     * The inline object must follow the
     * schema of OpenAPI 2.0 or OpenAPI 3.0
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * ApiDefinition.fromInline(Map.of(
     *         "openapi", "3.0.2",
     *         "paths", Map.of(
     *                 "/pets", Map.of(
     *                         "get", Map.of(
     *                                 "responses", Map.of(
     *                                         200, Map.of(
     *                                                 "content", Map.of(
     *                                                         "application/json", Map.of(
     *                                                                 "schema", Map.of(
     *                                                                         "$ref", "#/components/schemas/Empty"))))),
     *                                 "x-amazon-apigateway-integration", Map.of(
     *                                         "responses", Map.of(
     *                                                 "default", Map.of(
     *                                                         "statusCode", "200")),
     *                                         "requestTemplates", Map.of(
     *                                                 "application/json", "{\"statusCode\": 200}"),
     *                                         "passthroughBehavior", "when_no_match",
     *                                         "type", "mock")))),
     *         "components", Map.of(
     *                 "schemas", Map.of(
     *                         "Empty", Map.of(
     *                                 "title", "Empty Schema",
     *                                 "type", "object")))));
     * </pre></blockquote>
     * <p>
     * @param definition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.InlineApiDefinition fromInline(final @org.jetbrains.annotations.NotNull java.lang.Object definition) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.ApiDefinition.class, "fromInline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.InlineApiDefinition.class), new Object[] { definition });
    }

    /**
     * Called when the specification is initialized to allow this object to bind to the stack, add resources and have fun.
     * <p>
     * @param scope The binding scope. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.ApiDefinitionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope);

    /**
     * Called after the CFN RestApi resource has been created to allow the Api Definition to bind to it.
     * <p>
     * Specifically it's required to allow assets to add
     * metadata for tooling like SAM CLI to be able to find their origins.
     * <p>
     * @param _scope This parameter is required.
     * @param _restApi This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void bindAfterCreate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IRestApi _restApi) {
        software.amazon.jsii.Kernel.call(this, "bindAfterCreate", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_restApi, "_restApi is required") });
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.apigateway.ApiDefinition {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Called when the specification is initialized to allow this object to bind to the stack, add resources and have fun.
         * <p>
         * @param scope The binding scope. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.ApiDefinitionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ApiDefinitionConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
