package software.amazon.awscdk.services.apigateway;

/**
 * A CloudFormation `AWS::ApiGateway::Stage`.
 * <p>
 * The <code>AWS::ApiGateway::Stage</code> resource creates a stage for a deployment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * CfnStage cfnStage = CfnStage.Builder.create(this, "MyCfnStage")
 *         .restApiId("restApiId")
 *         // the properties below are optional
 *         .accessLogSetting(AccessLogSettingProperty.builder()
 *                 .destinationArn("destinationArn")
 *                 .format("format")
 *                 .build())
 *         .cacheClusterEnabled(false)
 *         .cacheClusterSize("cacheClusterSize")
 *         .canarySetting(CanarySettingProperty.builder()
 *                 .deploymentId("deploymentId")
 *                 .percentTraffic(123)
 *                 .stageVariableOverrides(Map.of(
 *                         "stageVariableOverridesKey", "stageVariableOverrides"))
 *                 .useStageCache(false)
 *                 .build())
 *         .clientCertificateId("clientCertificateId")
 *         .deploymentId("deploymentId")
 *         .description("description")
 *         .documentationVersion("documentationVersion")
 *         .methodSettings(List.of(MethodSettingProperty.builder()
 *                 .cacheDataEncrypted(false)
 *                 .cacheTtlInSeconds(123)
 *                 .cachingEnabled(false)
 *                 .dataTraceEnabled(false)
 *                 .httpMethod("httpMethod")
 *                 .loggingLevel("loggingLevel")
 *                 .metricsEnabled(false)
 *                 .resourcePath("resourcePath")
 *                 .throttlingBurstLimit(123)
 *                 .throttlingRateLimit(123)
 *                 .build()))
 *         .stageName("stageName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .tracingEnabled(false)
 *         .variables(Map.of(
 *                 "variablesKey", "variables"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-07-13T22:11:58.419Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnStage")
public class CfnStage extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnStage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnStage.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ApiGateway::Stage`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.CfnStageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of arbitrary tags (key-value pairs) to associate with the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The ID of the `RestApi` resource that you're deploying with this stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRestApiId() {
        return software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the `RestApi` resource that you're deploying with this stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestApiId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "restApiId", java.util.Objects.requireNonNull(value, "restApiId is required"));
    }

    /**
     * Specifies settings for logging access in this stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAccessLogSetting() {
        return software.amazon.jsii.Kernel.get(this, "accessLogSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies settings for logging access in this stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessLogSetting(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "accessLogSetting", value);
    }

    /**
     * Specifies settings for logging access in this stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessLogSetting(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CfnStage.AccessLogSettingProperty value) {
        software.amazon.jsii.Kernel.set(this, "accessLogSetting", value);
    }

    /**
     * Indicates whether cache clustering is enabled for the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCacheClusterEnabled() {
        return software.amazon.jsii.Kernel.get(this, "cacheClusterEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether cache clustering is enabled for the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheClusterEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "cacheClusterEnabled", value);
    }

    /**
     * Indicates whether cache clustering is enabled for the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheClusterEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cacheClusterEnabled", value);
    }

    /**
     * The stage's cache cluster size.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCacheClusterSize() {
        return software.amazon.jsii.Kernel.get(this, "cacheClusterSize", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The stage's cache cluster size.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheClusterSize(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cacheClusterSize", value);
    }

    /**
     * Specifies settings for the canary deployment in this stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCanarySetting() {
        return software.amazon.jsii.Kernel.get(this, "canarySetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies settings for the canary deployment in this stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCanarySetting(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "canarySetting", value);
    }

    /**
     * Specifies settings for the canary deployment in this stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCanarySetting(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CfnStage.CanarySettingProperty value) {
        software.amazon.jsii.Kernel.set(this, "canarySetting", value);
    }

    /**
     * The ID of the client certificate that API Gateway uses to call your integration endpoints in the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClientCertificateId() {
        return software.amazon.jsii.Kernel.get(this, "clientCertificateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the client certificate that API Gateway uses to call your integration endpoints in the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientCertificateId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clientCertificateId", value);
    }

    /**
     * The ID of the deployment that the stage is associated with.
     * <p>
     * This parameter is required to create a stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeploymentId() {
        return software.amazon.jsii.Kernel.get(this, "deploymentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the deployment that the stage is associated with.
     * <p>
     * This parameter is required to create a stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deploymentId", value);
    }

    /**
     * A description of the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The version ID of the API documentation snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDocumentationVersion() {
        return software.amazon.jsii.Kernel.get(this, "documentationVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version ID of the API documentation snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDocumentationVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "documentationVersion", value);
    }

    /**
     * Settings for all methods in the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMethodSettings() {
        return software.amazon.jsii.Kernel.get(this, "methodSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings for all methods in the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMethodSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "methodSettings", value);
    }

    /**
     * Settings for all methods in the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMethodSettings(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "methodSettings", value);
    }

    /**
     * The name of the stage, which API Gateway uses as the first path segment in the invoked Uniform Resource Identifier (URI).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStageName() {
        return software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the stage, which API Gateway uses as the first path segment in the invoked Uniform Resource Identifier (URI).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStageName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "stageName", value);
    }

    /**
     * Specifies whether active X-Ray tracing is enabled for this stage.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-xray.html">Trace API Gateway API Execution with AWS X-Ray</a> in the <em>API Gateway Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTracingEnabled() {
        return software.amazon.jsii.Kernel.get(this, "tracingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether active X-Ray tracing is enabled for this stage.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-xray.html">Trace API Gateway API Execution with AWS X-Ray</a> in the <em>API Gateway Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTracingEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "tracingEnabled", value);
    }

    /**
     * Specifies whether active X-Ray tracing is enabled for this stage.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-xray.html">Trace API Gateway API Execution with AWS X-Ray</a> in the <em>API Gateway Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTracingEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tracingEnabled", value);
    }

    /**
     * A map (string-to-string map) that defines the stage variables, where the variable name is the key and the variable value is the value.
     * <p>
     * Variable names are limited to alphanumeric characters. Values must match the following regular expression: <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVariables() {
        return software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A map (string-to-string map) that defines the stage variables, where the variable name is the key and the variable value is the value.
     * <p>
     * Variable names are limited to alphanumeric characters. Values must match the following regular expression: <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVariables(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "variables", value);
    }

    /**
     * A map (string-to-string map) that defines the stage variables, where the variable name is the key and the variable value is the value.
     * <p>
     * Variable names are limited to alphanumeric characters. Values must match the following regular expression: <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVariables(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "variables", value);
    }
    /**
     * The `AccessLogSetting` property type specifies settings for logging access in this stage.
     * <p>
     * <code>AccessLogSetting</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html">AWS::ApiGateway::Stage</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigateway.*;
     * AccessLogSettingProperty accessLogSettingProperty = AccessLogSettingProperty.builder()
     *         .destinationArn("destinationArn")
     *         .format("format")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnStage.AccessLogSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessLogSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessLogSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs.
         * <p>
         * If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with <code>amazon-apigateway-</code> . This parameter is required to enable access logging.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationArn() {
            return null;
        }

        /**
         * A single line format of the access logs of data, as specified by selected [$context variables](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference) . The format must include at least `$context.requestId` . This parameter is required to enable access logging.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessLogSettingProperty> {
            java.lang.String destinationArn;
            java.lang.String format;

            /**
             * Sets the value of {@link AccessLogSettingProperty#getDestinationArn}
             * @param destinationArn The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to receive access logs.
             *                       If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with <code>amazon-apigateway-</code> . This parameter is required to enable access logging.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationArn(java.lang.String destinationArn) {
                this.destinationArn = destinationArn;
                return this;
            }

            /**
             * Sets the value of {@link AccessLogSettingProperty#getFormat}
             * @param format A single line format of the access logs of data, as specified by selected [$context variables](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference) . The format must include at least `$context.requestId` . This parameter is required to enable access logging.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessLogSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessLogSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessLogSettingProperty {
            private final java.lang.String destinationArn;
            private final java.lang.String format;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationArn = software.amazon.jsii.Kernel.get(this, "destinationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationArn = builder.destinationArn;
                this.format = builder.format;
            }

            @Override
            public final java.lang.String getDestinationArn() {
                return this.destinationArn;
            }

            @Override
            public final java.lang.String getFormat() {
                return this.format;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinationArn() != null) {
                    data.set("destinationArn", om.valueToTree(this.getDestinationArn()));
                }
                if (this.getFormat() != null) {
                    data.set("format", om.valueToTree(this.getFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnStage.AccessLogSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessLogSettingProperty.Jsii$Proxy that = (AccessLogSettingProperty.Jsii$Proxy) o;

                if (this.destinationArn != null ? !this.destinationArn.equals(that.destinationArn) : that.destinationArn != null) return false;
                return this.format != null ? this.format.equals(that.format) : that.format == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationArn != null ? this.destinationArn.hashCode() : 0;
                result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `CanarySetting` property type specifies settings for the canary deployment in this stage.
     * <p>
     * <code>CanarySetting</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html">AWS::ApiGateway::Stage</a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigateway.*;
     * CanarySettingProperty canarySettingProperty = CanarySettingProperty.builder()
     *         .deploymentId("deploymentId")
     *         .percentTraffic(123)
     *         .stageVariableOverrides(Map.of(
     *                 "stageVariableOverridesKey", "stageVariableOverrides"))
     *         .useStageCache(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnStage.CanarySettingProperty")
    @software.amazon.jsii.Jsii.Proxy(CanarySettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CanarySettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the deployment that the stage points to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeploymentId() {
            return null;
        }

        /**
         * The percentage (0-100) of traffic diverted to a canary deployment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPercentTraffic() {
            return null;
        }

        /**
         * Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary.
         * <p>
         * These stage variables are represented as a string-to-string map between stage variable names and their values.
         * <p>
         * Duplicates are not allowed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStageVariableOverrides() {
            return null;
        }

        /**
         * Whether the canary deployment uses the stage cache or not.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseStageCache() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CanarySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CanarySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CanarySettingProperty> {
            java.lang.String deploymentId;
            java.lang.Number percentTraffic;
            java.lang.Object stageVariableOverrides;
            java.lang.Object useStageCache;

            /**
             * Sets the value of {@link CanarySettingProperty#getDeploymentId}
             * @param deploymentId The identifier of the deployment that the stage points to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deploymentId(java.lang.String deploymentId) {
                this.deploymentId = deploymentId;
                return this;
            }

            /**
             * Sets the value of {@link CanarySettingProperty#getPercentTraffic}
             * @param percentTraffic The percentage (0-100) of traffic diverted to a canary deployment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder percentTraffic(java.lang.Number percentTraffic) {
                this.percentTraffic = percentTraffic;
                return this;
            }

            /**
             * Sets the value of {@link CanarySettingProperty#getStageVariableOverrides}
             * @param stageVariableOverrides Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary.
             *                               These stage variables are represented as a string-to-string map between stage variable names and their values.
             *                               <p>
             *                               Duplicates are not allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stageVariableOverrides(software.amazon.awscdk.core.IResolvable stageVariableOverrides) {
                this.stageVariableOverrides = stageVariableOverrides;
                return this;
            }

            /**
             * Sets the value of {@link CanarySettingProperty#getStageVariableOverrides}
             * @param stageVariableOverrides Stage variables overridden for a canary release deployment, including new stage variables introduced in the canary.
             *                               These stage variables are represented as a string-to-string map between stage variable names and their values.
             *                               <p>
             *                               Duplicates are not allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stageVariableOverrides(java.util.Map<java.lang.String, java.lang.String> stageVariableOverrides) {
                this.stageVariableOverrides = stageVariableOverrides;
                return this;
            }

            /**
             * Sets the value of {@link CanarySettingProperty#getUseStageCache}
             * @param useStageCache Whether the canary deployment uses the stage cache or not.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useStageCache(java.lang.Boolean useStageCache) {
                this.useStageCache = useStageCache;
                return this;
            }

            /**
             * Sets the value of {@link CanarySettingProperty#getUseStageCache}
             * @param useStageCache Whether the canary deployment uses the stage cache or not.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useStageCache(software.amazon.awscdk.core.IResolvable useStageCache) {
                this.useStageCache = useStageCache;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CanarySettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CanarySettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CanarySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CanarySettingProperty {
            private final java.lang.String deploymentId;
            private final java.lang.Number percentTraffic;
            private final java.lang.Object stageVariableOverrides;
            private final java.lang.Object useStageCache;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deploymentId = software.amazon.jsii.Kernel.get(this, "deploymentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.percentTraffic = software.amazon.jsii.Kernel.get(this, "percentTraffic", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stageVariableOverrides = software.amazon.jsii.Kernel.get(this, "stageVariableOverrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useStageCache = software.amazon.jsii.Kernel.get(this, "useStageCache", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deploymentId = builder.deploymentId;
                this.percentTraffic = builder.percentTraffic;
                this.stageVariableOverrides = builder.stageVariableOverrides;
                this.useStageCache = builder.useStageCache;
            }

            @Override
            public final java.lang.String getDeploymentId() {
                return this.deploymentId;
            }

            @Override
            public final java.lang.Number getPercentTraffic() {
                return this.percentTraffic;
            }

            @Override
            public final java.lang.Object getStageVariableOverrides() {
                return this.stageVariableOverrides;
            }

            @Override
            public final java.lang.Object getUseStageCache() {
                return this.useStageCache;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeploymentId() != null) {
                    data.set("deploymentId", om.valueToTree(this.getDeploymentId()));
                }
                if (this.getPercentTraffic() != null) {
                    data.set("percentTraffic", om.valueToTree(this.getPercentTraffic()));
                }
                if (this.getStageVariableOverrides() != null) {
                    data.set("stageVariableOverrides", om.valueToTree(this.getStageVariableOverrides()));
                }
                if (this.getUseStageCache() != null) {
                    data.set("useStageCache", om.valueToTree(this.getUseStageCache()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnStage.CanarySettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CanarySettingProperty.Jsii$Proxy that = (CanarySettingProperty.Jsii$Proxy) o;

                if (this.deploymentId != null ? !this.deploymentId.equals(that.deploymentId) : that.deploymentId != null) return false;
                if (this.percentTraffic != null ? !this.percentTraffic.equals(that.percentTraffic) : that.percentTraffic != null) return false;
                if (this.stageVariableOverrides != null ? !this.stageVariableOverrides.equals(that.stageVariableOverrides) : that.stageVariableOverrides != null) return false;
                return this.useStageCache != null ? this.useStageCache.equals(that.useStageCache) : that.useStageCache == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deploymentId != null ? this.deploymentId.hashCode() : 0;
                result = 31 * result + (this.percentTraffic != null ? this.percentTraffic.hashCode() : 0);
                result = 31 * result + (this.stageVariableOverrides != null ? this.stageVariableOverrides.hashCode() : 0);
                result = 31 * result + (this.useStageCache != null ? this.useStageCache.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `MethodSetting` property type configures settings for all methods in a stage.
     * <p>
     * The <code>MethodSettings</code> property of the <code>AWS::ApiGateway::Stage</code> resource contains a list of <code>MethodSetting</code> property types.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigateway.*;
     * MethodSettingProperty methodSettingProperty = MethodSettingProperty.builder()
     *         .cacheDataEncrypted(false)
     *         .cacheTtlInSeconds(123)
     *         .cachingEnabled(false)
     *         .dataTraceEnabled(false)
     *         .httpMethod("httpMethod")
     *         .loggingLevel("loggingLevel")
     *         .metricsEnabled(false)
     *         .resourcePath("resourcePath")
     *         .throttlingBurstLimit(123)
     *         .throttlingRateLimit(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnStage.MethodSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(MethodSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MethodSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the cached responses are encrypted.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCacheDataEncrypted() {
            return null;
        }

        /**
         * The time-to-live (TTL) period, in seconds, that specifies how long API Gateway caches responses.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCacheTtlInSeconds() {
            return null;
        }

        /**
         * Indicates whether responses are cached and returned for requests.
         * <p>
         * You must enable a cache cluster on the stage to cache responses.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCachingEnabled() {
            return null;
        }

        /**
         * Indicates whether data trace logging is enabled for methods in the stage.
         * <p>
         * API Gateway pushes these logs to Amazon CloudWatch Logs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataTraceEnabled() {
            return null;
        }

        /**
         * The HTTP method.
         * <p>
         * To apply settings to multiple resources and methods, specify an asterisk ( <code>*</code> ) for the <code>HttpMethod</code> and <code>/*</code> for the <code>ResourcePath</code> . This parameter is required when you specify a <code>MethodSetting</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpMethod() {
            return null;
        }

        /**
         * The logging level for this method.
         * <p>
         * For valid values, see the <code>loggingLevel</code> property of the <a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/stage/#loggingLevel">Stage</a> resource in the <em>Amazon API Gateway API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLoggingLevel() {
            return null;
        }

        /**
         * Indicates whether Amazon CloudWatch metrics are enabled for methods in the stage.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetricsEnabled() {
            return null;
        }

        /**
         * The resource path for this method.
         * <p>
         * Forward slashes ( <code>/</code> ) are encoded as <code>~1</code> and the initial slash must include a forward slash. For example, the path value <code>/resource/subresource</code> must be encoded as <code>/~1resource~1subresource</code> . To specify the root path, use only a slash ( <code>/</code> ). To apply settings to multiple resources and methods, specify an asterisk ( <code>*</code> ) for the <code>HttpMethod</code> and <code>/*</code> for the <code>ResourcePath</code> . This parameter is required when you specify a <code>MethodSetting</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourcePath() {
            return null;
        }

        /**
         * The number of burst requests per second that API Gateway permits across all APIs, stages, and methods in your AWS account .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html">Manage API Request Throttling</a> in the <em>API Gateway Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThrottlingBurstLimit() {
            return null;
        }

        /**
         * The number of steady-state requests per second that API Gateway permits across all APIs, stages, and methods in your AWS account .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html">Manage API Request Throttling</a> in the <em>API Gateway Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThrottlingRateLimit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MethodSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MethodSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MethodSettingProperty> {
            java.lang.Object cacheDataEncrypted;
            java.lang.Number cacheTtlInSeconds;
            java.lang.Object cachingEnabled;
            java.lang.Object dataTraceEnabled;
            java.lang.String httpMethod;
            java.lang.String loggingLevel;
            java.lang.Object metricsEnabled;
            java.lang.String resourcePath;
            java.lang.Number throttlingBurstLimit;
            java.lang.Number throttlingRateLimit;

            /**
             * Sets the value of {@link MethodSettingProperty#getCacheDataEncrypted}
             * @param cacheDataEncrypted Indicates whether the cached responses are encrypted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheDataEncrypted(java.lang.Boolean cacheDataEncrypted) {
                this.cacheDataEncrypted = cacheDataEncrypted;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getCacheDataEncrypted}
             * @param cacheDataEncrypted Indicates whether the cached responses are encrypted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheDataEncrypted(software.amazon.awscdk.core.IResolvable cacheDataEncrypted) {
                this.cacheDataEncrypted = cacheDataEncrypted;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getCacheTtlInSeconds}
             * @param cacheTtlInSeconds The time-to-live (TTL) period, in seconds, that specifies how long API Gateway caches responses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheTtlInSeconds(java.lang.Number cacheTtlInSeconds) {
                this.cacheTtlInSeconds = cacheTtlInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getCachingEnabled}
             * @param cachingEnabled Indicates whether responses are cached and returned for requests.
             *                       You must enable a cache cluster on the stage to cache responses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachingEnabled(java.lang.Boolean cachingEnabled) {
                this.cachingEnabled = cachingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getCachingEnabled}
             * @param cachingEnabled Indicates whether responses are cached and returned for requests.
             *                       You must enable a cache cluster on the stage to cache responses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachingEnabled(software.amazon.awscdk.core.IResolvable cachingEnabled) {
                this.cachingEnabled = cachingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getDataTraceEnabled}
             * @param dataTraceEnabled Indicates whether data trace logging is enabled for methods in the stage.
             *                         API Gateway pushes these logs to Amazon CloudWatch Logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTraceEnabled(java.lang.Boolean dataTraceEnabled) {
                this.dataTraceEnabled = dataTraceEnabled;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getDataTraceEnabled}
             * @param dataTraceEnabled Indicates whether data trace logging is enabled for methods in the stage.
             *                         API Gateway pushes these logs to Amazon CloudWatch Logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTraceEnabled(software.amazon.awscdk.core.IResolvable dataTraceEnabled) {
                this.dataTraceEnabled = dataTraceEnabled;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getHttpMethod}
             * @param httpMethod The HTTP method.
             *                   To apply settings to multiple resources and methods, specify an asterisk ( <code>*</code> ) for the <code>HttpMethod</code> and <code>/*</code> for the <code>ResourcePath</code> . This parameter is required when you specify a <code>MethodSetting</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpMethod(java.lang.String httpMethod) {
                this.httpMethod = httpMethod;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getLoggingLevel}
             * @param loggingLevel The logging level for this method.
             *                     For valid values, see the <code>loggingLevel</code> property of the <a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/stage/#loggingLevel">Stage</a> resource in the <em>Amazon API Gateway API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loggingLevel(java.lang.String loggingLevel) {
                this.loggingLevel = loggingLevel;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getMetricsEnabled}
             * @param metricsEnabled Indicates whether Amazon CloudWatch metrics are enabled for methods in the stage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricsEnabled(java.lang.Boolean metricsEnabled) {
                this.metricsEnabled = metricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getMetricsEnabled}
             * @param metricsEnabled Indicates whether Amazon CloudWatch metrics are enabled for methods in the stage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricsEnabled(software.amazon.awscdk.core.IResolvable metricsEnabled) {
                this.metricsEnabled = metricsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getResourcePath}
             * @param resourcePath The resource path for this method.
             *                     Forward slashes ( <code>/</code> ) are encoded as <code>~1</code> and the initial slash must include a forward slash. For example, the path value <code>/resource/subresource</code> must be encoded as <code>/~1resource~1subresource</code> . To specify the root path, use only a slash ( <code>/</code> ). To apply settings to multiple resources and methods, specify an asterisk ( <code>*</code> ) for the <code>HttpMethod</code> and <code>/*</code> for the <code>ResourcePath</code> . This parameter is required when you specify a <code>MethodSetting</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourcePath(java.lang.String resourcePath) {
                this.resourcePath = resourcePath;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getThrottlingBurstLimit}
             * @param throttlingBurstLimit The number of burst requests per second that API Gateway permits across all APIs, stages, and methods in your AWS account .
             *                             For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html">Manage API Request Throttling</a> in the <em>API Gateway Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throttlingBurstLimit(java.lang.Number throttlingBurstLimit) {
                this.throttlingBurstLimit = throttlingBurstLimit;
                return this;
            }

            /**
             * Sets the value of {@link MethodSettingProperty#getThrottlingRateLimit}
             * @param throttlingRateLimit The number of steady-state requests per second that API Gateway permits across all APIs, stages, and methods in your AWS account .
             *                            For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html">Manage API Request Throttling</a> in the <em>API Gateway Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throttlingRateLimit(java.lang.Number throttlingRateLimit) {
                this.throttlingRateLimit = throttlingRateLimit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MethodSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MethodSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MethodSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MethodSettingProperty {
            private final java.lang.Object cacheDataEncrypted;
            private final java.lang.Number cacheTtlInSeconds;
            private final java.lang.Object cachingEnabled;
            private final java.lang.Object dataTraceEnabled;
            private final java.lang.String httpMethod;
            private final java.lang.String loggingLevel;
            private final java.lang.Object metricsEnabled;
            private final java.lang.String resourcePath;
            private final java.lang.Number throttlingBurstLimit;
            private final java.lang.Number throttlingRateLimit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cacheDataEncrypted = software.amazon.jsii.Kernel.get(this, "cacheDataEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cacheTtlInSeconds = software.amazon.jsii.Kernel.get(this, "cacheTtlInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.cachingEnabled = software.amazon.jsii.Kernel.get(this, "cachingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataTraceEnabled = software.amazon.jsii.Kernel.get(this, "dataTraceEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.httpMethod = software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.loggingLevel = software.amazon.jsii.Kernel.get(this, "loggingLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricsEnabled = software.amazon.jsii.Kernel.get(this, "metricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourcePath = software.amazon.jsii.Kernel.get(this, "resourcePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.throttlingBurstLimit = software.amazon.jsii.Kernel.get(this, "throttlingBurstLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.throttlingRateLimit = software.amazon.jsii.Kernel.get(this, "throttlingRateLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cacheDataEncrypted = builder.cacheDataEncrypted;
                this.cacheTtlInSeconds = builder.cacheTtlInSeconds;
                this.cachingEnabled = builder.cachingEnabled;
                this.dataTraceEnabled = builder.dataTraceEnabled;
                this.httpMethod = builder.httpMethod;
                this.loggingLevel = builder.loggingLevel;
                this.metricsEnabled = builder.metricsEnabled;
                this.resourcePath = builder.resourcePath;
                this.throttlingBurstLimit = builder.throttlingBurstLimit;
                this.throttlingRateLimit = builder.throttlingRateLimit;
            }

            @Override
            public final java.lang.Object getCacheDataEncrypted() {
                return this.cacheDataEncrypted;
            }

            @Override
            public final java.lang.Number getCacheTtlInSeconds() {
                return this.cacheTtlInSeconds;
            }

            @Override
            public final java.lang.Object getCachingEnabled() {
                return this.cachingEnabled;
            }

            @Override
            public final java.lang.Object getDataTraceEnabled() {
                return this.dataTraceEnabled;
            }

            @Override
            public final java.lang.String getHttpMethod() {
                return this.httpMethod;
            }

            @Override
            public final java.lang.String getLoggingLevel() {
                return this.loggingLevel;
            }

            @Override
            public final java.lang.Object getMetricsEnabled() {
                return this.metricsEnabled;
            }

            @Override
            public final java.lang.String getResourcePath() {
                return this.resourcePath;
            }

            @Override
            public final java.lang.Number getThrottlingBurstLimit() {
                return this.throttlingBurstLimit;
            }

            @Override
            public final java.lang.Number getThrottlingRateLimit() {
                return this.throttlingRateLimit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCacheDataEncrypted() != null) {
                    data.set("cacheDataEncrypted", om.valueToTree(this.getCacheDataEncrypted()));
                }
                if (this.getCacheTtlInSeconds() != null) {
                    data.set("cacheTtlInSeconds", om.valueToTree(this.getCacheTtlInSeconds()));
                }
                if (this.getCachingEnabled() != null) {
                    data.set("cachingEnabled", om.valueToTree(this.getCachingEnabled()));
                }
                if (this.getDataTraceEnabled() != null) {
                    data.set("dataTraceEnabled", om.valueToTree(this.getDataTraceEnabled()));
                }
                if (this.getHttpMethod() != null) {
                    data.set("httpMethod", om.valueToTree(this.getHttpMethod()));
                }
                if (this.getLoggingLevel() != null) {
                    data.set("loggingLevel", om.valueToTree(this.getLoggingLevel()));
                }
                if (this.getMetricsEnabled() != null) {
                    data.set("metricsEnabled", om.valueToTree(this.getMetricsEnabled()));
                }
                if (this.getResourcePath() != null) {
                    data.set("resourcePath", om.valueToTree(this.getResourcePath()));
                }
                if (this.getThrottlingBurstLimit() != null) {
                    data.set("throttlingBurstLimit", om.valueToTree(this.getThrottlingBurstLimit()));
                }
                if (this.getThrottlingRateLimit() != null) {
                    data.set("throttlingRateLimit", om.valueToTree(this.getThrottlingRateLimit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnStage.MethodSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MethodSettingProperty.Jsii$Proxy that = (MethodSettingProperty.Jsii$Proxy) o;

                if (this.cacheDataEncrypted != null ? !this.cacheDataEncrypted.equals(that.cacheDataEncrypted) : that.cacheDataEncrypted != null) return false;
                if (this.cacheTtlInSeconds != null ? !this.cacheTtlInSeconds.equals(that.cacheTtlInSeconds) : that.cacheTtlInSeconds != null) return false;
                if (this.cachingEnabled != null ? !this.cachingEnabled.equals(that.cachingEnabled) : that.cachingEnabled != null) return false;
                if (this.dataTraceEnabled != null ? !this.dataTraceEnabled.equals(that.dataTraceEnabled) : that.dataTraceEnabled != null) return false;
                if (this.httpMethod != null ? !this.httpMethod.equals(that.httpMethod) : that.httpMethod != null) return false;
                if (this.loggingLevel != null ? !this.loggingLevel.equals(that.loggingLevel) : that.loggingLevel != null) return false;
                if (this.metricsEnabled != null ? !this.metricsEnabled.equals(that.metricsEnabled) : that.metricsEnabled != null) return false;
                if (this.resourcePath != null ? !this.resourcePath.equals(that.resourcePath) : that.resourcePath != null) return false;
                if (this.throttlingBurstLimit != null ? !this.throttlingBurstLimit.equals(that.throttlingBurstLimit) : that.throttlingBurstLimit != null) return false;
                return this.throttlingRateLimit != null ? this.throttlingRateLimit.equals(that.throttlingRateLimit) : that.throttlingRateLimit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cacheDataEncrypted != null ? this.cacheDataEncrypted.hashCode() : 0;
                result = 31 * result + (this.cacheTtlInSeconds != null ? this.cacheTtlInSeconds.hashCode() : 0);
                result = 31 * result + (this.cachingEnabled != null ? this.cachingEnabled.hashCode() : 0);
                result = 31 * result + (this.dataTraceEnabled != null ? this.dataTraceEnabled.hashCode() : 0);
                result = 31 * result + (this.httpMethod != null ? this.httpMethod.hashCode() : 0);
                result = 31 * result + (this.loggingLevel != null ? this.loggingLevel.hashCode() : 0);
                result = 31 * result + (this.metricsEnabled != null ? this.metricsEnabled.hashCode() : 0);
                result = 31 * result + (this.resourcePath != null ? this.resourcePath.hashCode() : 0);
                result = 31 * result + (this.throttlingBurstLimit != null ? this.throttlingBurstLimit.hashCode() : 0);
                result = 31 * result + (this.throttlingRateLimit != null ? this.throttlingRateLimit.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.CfnStage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.CfnStage> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.CfnStageProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.CfnStageProps.Builder();
        }

        /**
         * The ID of the `RestApi` resource that you're deploying with this stage.
         * <p>
         * @return {@code this}
         * @param restApiId The ID of the `RestApi` resource that you're deploying with this stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiId(final java.lang.String restApiId) {
            this.props.restApiId(restApiId);
            return this;
        }

        /**
         * Specifies settings for logging access in this stage.
         * <p>
         * @return {@code this}
         * @param accessLogSetting Specifies settings for logging access in this stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLogSetting(final software.amazon.awscdk.core.IResolvable accessLogSetting) {
            this.props.accessLogSetting(accessLogSetting);
            return this;
        }
        /**
         * Specifies settings for logging access in this stage.
         * <p>
         * @return {@code this}
         * @param accessLogSetting Specifies settings for logging access in this stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLogSetting(final software.amazon.awscdk.services.apigateway.CfnStage.AccessLogSettingProperty accessLogSetting) {
            this.props.accessLogSetting(accessLogSetting);
            return this;
        }

        /**
         * Indicates whether cache clustering is enabled for the stage.
         * <p>
         * @return {@code this}
         * @param cacheClusterEnabled Indicates whether cache clustering is enabled for the stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheClusterEnabled(final java.lang.Boolean cacheClusterEnabled) {
            this.props.cacheClusterEnabled(cacheClusterEnabled);
            return this;
        }
        /**
         * Indicates whether cache clustering is enabled for the stage.
         * <p>
         * @return {@code this}
         * @param cacheClusterEnabled Indicates whether cache clustering is enabled for the stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheClusterEnabled(final software.amazon.awscdk.core.IResolvable cacheClusterEnabled) {
            this.props.cacheClusterEnabled(cacheClusterEnabled);
            return this;
        }

        /**
         * The stage's cache cluster size.
         * <p>
         * @return {@code this}
         * @param cacheClusterSize The stage's cache cluster size. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheClusterSize(final java.lang.String cacheClusterSize) {
            this.props.cacheClusterSize(cacheClusterSize);
            return this;
        }

        /**
         * Specifies settings for the canary deployment in this stage.
         * <p>
         * @return {@code this}
         * @param canarySetting Specifies settings for the canary deployment in this stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder canarySetting(final software.amazon.awscdk.core.IResolvable canarySetting) {
            this.props.canarySetting(canarySetting);
            return this;
        }
        /**
         * Specifies settings for the canary deployment in this stage.
         * <p>
         * @return {@code this}
         * @param canarySetting Specifies settings for the canary deployment in this stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder canarySetting(final software.amazon.awscdk.services.apigateway.CfnStage.CanarySettingProperty canarySetting) {
            this.props.canarySetting(canarySetting);
            return this;
        }

        /**
         * The ID of the client certificate that API Gateway uses to call your integration endpoints in the stage.
         * <p>
         * @return {@code this}
         * @param clientCertificateId The ID of the client certificate that API Gateway uses to call your integration endpoints in the stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientCertificateId(final java.lang.String clientCertificateId) {
            this.props.clientCertificateId(clientCertificateId);
            return this;
        }

        /**
         * The ID of the deployment that the stage is associated with.
         * <p>
         * This parameter is required to create a stage.
         * <p>
         * @return {@code this}
         * @param deploymentId The ID of the deployment that the stage is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentId(final java.lang.String deploymentId) {
            this.props.deploymentId(deploymentId);
            return this;
        }

        /**
         * A description of the stage.
         * <p>
         * @return {@code this}
         * @param description A description of the stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The version ID of the API documentation snapshot.
         * <p>
         * @return {@code this}
         * @param documentationVersion The version ID of the API documentation snapshot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentationVersion(final java.lang.String documentationVersion) {
            this.props.documentationVersion(documentationVersion);
            return this;
        }

        /**
         * Settings for all methods in the stage.
         * <p>
         * @return {@code this}
         * @param methodSettings Settings for all methods in the stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder methodSettings(final software.amazon.awscdk.core.IResolvable methodSettings) {
            this.props.methodSettings(methodSettings);
            return this;
        }
        /**
         * Settings for all methods in the stage.
         * <p>
         * @return {@code this}
         * @param methodSettings Settings for all methods in the stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder methodSettings(final java.util.List<? extends java.lang.Object> methodSettings) {
            this.props.methodSettings(methodSettings);
            return this;
        }

        /**
         * The name of the stage, which API Gateway uses as the first path segment in the invoked Uniform Resource Identifier (URI).
         * <p>
         * @return {@code this}
         * @param stageName The name of the stage, which API Gateway uses as the first path segment in the invoked Uniform Resource Identifier (URI). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(final java.lang.String stageName) {
            this.props.stageName(stageName);
            return this;
        }

        /**
         * An array of arbitrary tags (key-value pairs) to associate with the stage.
         * <p>
         * @return {@code this}
         * @param tags An array of arbitrary tags (key-value pairs) to associate with the stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Specifies whether active X-Ray tracing is enabled for this stage.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-xray.html">Trace API Gateway API Execution with AWS X-Ray</a> in the <em>API Gateway Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param tracingEnabled Specifies whether active X-Ray tracing is enabled for this stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracingEnabled(final java.lang.Boolean tracingEnabled) {
            this.props.tracingEnabled(tracingEnabled);
            return this;
        }
        /**
         * Specifies whether active X-Ray tracing is enabled for this stage.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-xray.html">Trace API Gateway API Execution with AWS X-Ray</a> in the <em>API Gateway Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param tracingEnabled Specifies whether active X-Ray tracing is enabled for this stage. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracingEnabled(final software.amazon.awscdk.core.IResolvable tracingEnabled) {
            this.props.tracingEnabled(tracingEnabled);
            return this;
        }

        /**
         * A map (string-to-string map) that defines the stage variables, where the variable name is the key and the variable value is the value.
         * <p>
         * Variable names are limited to alphanumeric characters. Values must match the following regular expression: <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code> .
         * <p>
         * @return {@code this}
         * @param variables A map (string-to-string map) that defines the stage variables, where the variable name is the key and the variable value is the value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variables(final software.amazon.awscdk.core.IResolvable variables) {
            this.props.variables(variables);
            return this;
        }
        /**
         * A map (string-to-string map) that defines the stage variables, where the variable name is the key and the variable value is the value.
         * <p>
         * Variable names are limited to alphanumeric characters. Values must match the following regular expression: <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code> .
         * <p>
         * @return {@code this}
         * @param variables A map (string-to-string map) that defines the stage variables, where the variable name is the key and the variable value is the value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variables(final java.util.Map<java.lang.String, java.lang.String> variables) {
            this.props.variables(variables);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.CfnStage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.CfnStage build() {
            return new software.amazon.awscdk.services.apigateway.CfnStage(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
