package software.amazon.awscdk.services.apigateway;

/**
 * Result of binding an Integration to a Method.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.core.*;
 * Role role;
 * VpcLink vpcLink;
 * IntegrationConfig integrationConfig = IntegrationConfig.builder()
 *         .type(IntegrationType.AWS)
 *         // the properties below are optional
 *         .deploymentToken("deploymentToken")
 *         .integrationHttpMethod("integrationHttpMethod")
 *         .options(IntegrationOptions.builder()
 *                 .cacheKeyParameters(List.of("cacheKeyParameters"))
 *                 .cacheNamespace("cacheNamespace")
 *                 .connectionType(ConnectionType.INTERNET)
 *                 .contentHandling(ContentHandling.CONVERT_TO_BINARY)
 *                 .credentialsPassthrough(false)
 *                 .credentialsRole(role)
 *                 .integrationResponses(List.of(IntegrationResponse.builder()
 *                         .statusCode("statusCode")
 *                         // the properties below are optional
 *                         .contentHandling(ContentHandling.CONVERT_TO_BINARY)
 *                         .responseParameters(Map.of(
 *                                 "responseParametersKey", "responseParameters"))
 *                         .responseTemplates(Map.of(
 *                                 "responseTemplatesKey", "responseTemplates"))
 *                         .selectionPattern("selectionPattern")
 *                         .build()))
 *                 .passthroughBehavior(PassthroughBehavior.WHEN_NO_MATCH)
 *                 .requestParameters(Map.of(
 *                         "requestParametersKey", "requestParameters"))
 *                 .requestTemplates(Map.of(
 *                         "requestTemplatesKey", "requestTemplates"))
 *                 .timeout(Duration.minutes(30))
 *                 .vpcLink(vpcLink)
 *                 .build())
 *         .uri("uri")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.60.0 (build ebcefe6)", date = "2022-07-13T22:11:58.492Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.IntegrationConfig")
@software.amazon.jsii.Jsii.Proxy(IntegrationConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IntegrationConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies an API method integration type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IntegrationType getType();

    /**
     * This value is included in computing the Deployment's fingerprint.
     * <p>
     * When the fingerprint
     * changes, a new deployment is triggered.
     * This property should contain values associated with the Integration that upon changing
     * should trigger a fresh the Deployment needs to be refreshed.
     * <p>
     * Default: undefined deployments are not triggered for any change to this integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeploymentToken() {
        return null;
    }

    /**
     * The integration's HTTP method type.
     * <p>
     * Default: - no integration method specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIntegrationHttpMethod() {
        return null;
    }

    /**
     * Integration options.
     * <p>
     * Default: - no integration options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions() {
        return null;
    }

    /**
     * The Uniform Resource Identifier (URI) for the integration.
     * <p>
     * Default: - no URI. Usually applies to MOCK integration
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#uri">https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#uri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUri() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IntegrationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IntegrationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IntegrationConfig> {
        software.amazon.awscdk.services.apigateway.IntegrationType type;
        java.lang.String deploymentToken;
        java.lang.String integrationHttpMethod;
        software.amazon.awscdk.services.apigateway.IntegrationOptions options;
        java.lang.String uri;

        /**
         * Sets the value of {@link IntegrationConfig#getType}
         * @param type Specifies an API method integration type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.apigateway.IntegrationType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationConfig#getDeploymentToken}
         * @param deploymentToken This value is included in computing the Deployment's fingerprint.
         *                        When the fingerprint
         *                        changes, a new deployment is triggered.
         *                        This property should contain values associated with the Integration that upon changing
         *                        should trigger a fresh the Deployment needs to be refreshed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentToken(java.lang.String deploymentToken) {
            this.deploymentToken = deploymentToken;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationConfig#getIntegrationHttpMethod}
         * @param integrationHttpMethod The integration's HTTP method type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationHttpMethod(java.lang.String integrationHttpMethod) {
            this.integrationHttpMethod = integrationHttpMethod;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationConfig#getOptions}
         * @param options Integration options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(software.amazon.awscdk.services.apigateway.IntegrationOptions options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationConfig#getUri}
         * @param uri The Uniform Resource Identifier (URI) for the integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uri(java.lang.String uri) {
            this.uri = uri;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IntegrationConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IntegrationConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IntegrationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegrationConfig {
        private final software.amazon.awscdk.services.apigateway.IntegrationType type;
        private final java.lang.String deploymentToken;
        private final java.lang.String integrationHttpMethod;
        private final software.amazon.awscdk.services.apigateway.IntegrationOptions options;
        private final java.lang.String uri;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IntegrationType.class));
            this.deploymentToken = software.amazon.jsii.Kernel.get(this, "deploymentToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationHttpMethod = software.amazon.jsii.Kernel.get(this, "integrationHttpMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IntegrationOptions.class));
            this.uri = software.amazon.jsii.Kernel.get(this, "uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.deploymentToken = builder.deploymentToken;
            this.integrationHttpMethod = builder.integrationHttpMethod;
            this.options = builder.options;
            this.uri = builder.uri;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.IntegrationType getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getDeploymentToken() {
            return this.deploymentToken;
        }

        @Override
        public final java.lang.String getIntegrationHttpMethod() {
            return this.integrationHttpMethod;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions() {
            return this.options;
        }

        @Override
        public final java.lang.String getUri() {
            return this.uri;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getDeploymentToken() != null) {
                data.set("deploymentToken", om.valueToTree(this.getDeploymentToken()));
            }
            if (this.getIntegrationHttpMethod() != null) {
                data.set("integrationHttpMethod", om.valueToTree(this.getIntegrationHttpMethod()));
            }
            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }
            if (this.getUri() != null) {
                data.set("uri", om.valueToTree(this.getUri()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.IntegrationConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IntegrationConfig.Jsii$Proxy that = (IntegrationConfig.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.deploymentToken != null ? !this.deploymentToken.equals(that.deploymentToken) : that.deploymentToken != null) return false;
            if (this.integrationHttpMethod != null ? !this.integrationHttpMethod.equals(that.integrationHttpMethod) : that.integrationHttpMethod != null) return false;
            if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
            return this.uri != null ? this.uri.equals(that.uri) : that.uri == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.deploymentToken != null ? this.deploymentToken.hashCode() : 0);
            result = 31 * result + (this.integrationHttpMethod != null ? this.integrationHttpMethod.hashCode() : 0);
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
            return result;
        }
    }
}
