package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * DomainName domainName;
 * RestApi restApi;
 * Stage stage;
 * BasePathMappingProps basePathMappingProps = BasePathMappingProps.builder()
 *         .domainName(domainName)
 *         .restApi(restApi)
 *         // the properties below are optional
 *         .basePath("basePath")
 *         .stage(stage)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-02T20:25:34.547Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.BasePathMappingProps")
@software.amazon.jsii.Jsii.Proxy(BasePathMappingProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BasePathMappingProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.BasePathMappingOptions {

    /**
     * The DomainName to associate with this base path mapping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IDomainName getDomainName();

    /**
     * The RestApi resource to target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IRestApi getRestApi();

    /**
     * @return a {@link Builder} of {@link BasePathMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BasePathMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BasePathMappingProps> {
        software.amazon.awscdk.services.apigateway.IDomainName domainName;
        software.amazon.awscdk.services.apigateway.IRestApi restApi;
        java.lang.String basePath;
        software.amazon.awscdk.services.apigateway.Stage stage;

        /**
         * Sets the value of {@link BasePathMappingProps#getDomainName}
         * @param domainName The DomainName to associate with this base path mapping. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(software.amazon.awscdk.services.apigateway.IDomainName domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link BasePathMappingProps#getRestApi}
         * @param restApi The RestApi resource to target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApi(software.amazon.awscdk.services.apigateway.IRestApi restApi) {
            this.restApi = restApi;
            return this;
        }

        /**
         * Sets the value of {@link BasePathMappingProps#getBasePath}
         * @param basePath The base path name that callers of the API must provide in the URL after the domain name (e.g. `example.com/base-path`). If you specify this property, it can't be an empty string.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder basePath(java.lang.String basePath) {
            this.basePath = basePath;
            return this;
        }

        /**
         * Sets the value of {@link BasePathMappingProps#getStage}
         * @param stage The Deployment stage of API [disable-awslint:ref-via-interface].
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stage(software.amazon.awscdk.services.apigateway.Stage stage) {
            this.stage = stage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BasePathMappingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BasePathMappingProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BasePathMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BasePathMappingProps {
        private final software.amazon.awscdk.services.apigateway.IDomainName domainName;
        private final software.amazon.awscdk.services.apigateway.IRestApi restApi;
        private final java.lang.String basePath;
        private final software.amazon.awscdk.services.apigateway.Stage stage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IDomainName.class));
            this.restApi = software.amazon.jsii.Kernel.get(this, "restApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IRestApi.class));
            this.basePath = software.amazon.jsii.Kernel.get(this, "basePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stage = software.amazon.jsii.Kernel.get(this, "stage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.Stage.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.restApi = java.util.Objects.requireNonNull(builder.restApi, "restApi is required");
            this.basePath = builder.basePath;
            this.stage = builder.stage;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.IDomainName getDomainName() {
            return this.domainName;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.IRestApi getRestApi() {
            return this.restApi;
        }

        @Override
        public final java.lang.String getBasePath() {
            return this.basePath;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.Stage getStage() {
            return this.stage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainName", om.valueToTree(this.getDomainName()));
            data.set("restApi", om.valueToTree(this.getRestApi()));
            if (this.getBasePath() != null) {
                data.set("basePath", om.valueToTree(this.getBasePath()));
            }
            if (this.getStage() != null) {
                data.set("stage", om.valueToTree(this.getStage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.BasePathMappingProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BasePathMappingProps.Jsii$Proxy that = (BasePathMappingProps.Jsii$Proxy) o;

            if (!domainName.equals(that.domainName)) return false;
            if (!restApi.equals(that.restApi)) return false;
            if (this.basePath != null ? !this.basePath.equals(that.basePath) : that.basePath != null) return false;
            return this.stage != null ? this.stage.equals(that.stage) : that.stage == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainName.hashCode();
            result = 31 * result + (this.restApi.hashCode());
            result = 31 * result + (this.basePath != null ? this.basePath.hashCode() : 0);
            result = 31 * result + (this.stage != null ? this.stage.hashCode() : 0);
            return result;
        }
    }
}
