package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a `CfnAuthorizer`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * CfnAuthorizerProps cfnAuthorizerProps = CfnAuthorizerProps.builder()
 *         .name("name")
 *         .restApiId("restApiId")
 *         .type("type")
 *         // the properties below are optional
 *         .authorizerCredentials("authorizerCredentials")
 *         .authorizerResultTtlInSeconds(123)
 *         .authorizerUri("authorizerUri")
 *         .authType("authType")
 *         .identitySource("identitySource")
 *         .identityValidationExpression("identityValidationExpression")
 *         .providerArns(List.of("providerArns"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-09T19:16:41.873Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnAuthorizerProps")
@software.amazon.jsii.Jsii.Proxy(CfnAuthorizerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAuthorizerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The ID of the `RestApi` resource that API Gateway creates the authorizer in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRestApiId();

    /**
     * The type of authorizer. Valid values include:.
     * <p>
     * <ul>
     * <li><code>TOKEN</code> : A custom authorizer that uses a Lambda function.</li>
     * <li><code>COGNITO_USER_POOLS</code> : An authorizer that uses Amazon Cognito user pools.</li>
     * <li><code>REQUEST</code> : An authorizer that uses a Lambda function using incoming request parameters.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * The credentials that are required for the authorizer.
     * <p>
     * To specify an IAM role that API Gateway assumes, specify the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerCredentials() {
        return null;
    }

    /**
     * The time-to-live (TTL) period, in seconds, that specifies how long API Gateway caches authorizer results.
     * <p>
     * If you specify a value greater than 0, API Gateway caches the authorizer responses. By default, API Gateway sets this property to 300. The maximum value is 3600, or 1 hour.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAuthorizerResultTtlInSeconds() {
        return null;
    }

    /**
     * The authorizer's Uniform Resource Identifier (URI).
     * <p>
     * If you specify <code>TOKEN</code> for the authorizer's <code>Type</code> property, specify a Lambda function URI that has the form <code>arn:aws:apigateway: *region* :lambda:path/ *path*</code> . The path usually has the form /2015-03-31/functions/ <em>LambdaFunctionARN</em> /invocations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerUri() {
        return null;
    }

    /**
     * An optional customer-defined field that's used in OpenApi imports and exports without functional impact.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthType() {
        return null;
    }

    /**
     * The source of the identity in an incoming request.
     * <p>
     * If you specify <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> for the <code>Type</code> property, this property is required. Specify a header mapping expression using the form <code>method.request.header. *name*</code> , where <em>name</em> is the name of a custom authorization header that clients submit as part of their requests.
     * <p>
     * If you specify <code>REQUEST</code> for the <code>Type</code> property, this property is required when authorization caching is enabled. Specify a comma-separated string of one or more mapping expressions of the specified request parameter using the form <code>method.request.parameter. *name*</code> . For supported parameter types, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/configure-api-gateway-lambda-authorization-with-console.html">Configure Lambda Authorizer Using the API Gateway Console</a> in the <em>API Gateway Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIdentitySource() {
        return null;
    }

    /**
     * A validation expression for the incoming identity.
     * <p>
     * If you specify <code>TOKEN</code> for the authorizer's <code>Type</code> property, specify a regular expression. API Gateway uses the expression to attempt to match the incoming client token, and proceeds if the token matches. If the token doesn't match, API Gateway responds with a 401 (unauthorized request) error code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIdentityValidationExpression() {
        return null;
    }

    /**
     * A list of the Amazon Cognito user pool Amazon Resource Names (ARNs) to associate with this authorizer.
     * <p>
     * Required if you specify <code>COGNITO_USER_POOLS</code> as the authorizer <code>Type</code> . For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html#apigateway-enable-cognito-user-pool">Use Amazon Cognito User Pools</a> in the <em>API Gateway Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getProviderArns() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAuthorizerProps> {
        java.lang.String name;
        java.lang.String restApiId;
        java.lang.String type;
        java.lang.String authorizerCredentials;
        java.lang.Number authorizerResultTtlInSeconds;
        java.lang.String authorizerUri;
        java.lang.String authType;
        java.lang.String identitySource;
        java.lang.String identityValidationExpression;
        java.util.List<java.lang.String> providerArns;

        /**
         * Sets the value of {@link CfnAuthorizerProps#getName}
         * @param name The name of the authorizer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getRestApiId}
         * @param restApiId The ID of the `RestApi` resource that API Gateway creates the authorizer in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiId(java.lang.String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getType}
         * @param type The type of authorizer. Valid values include:. This parameter is required.
         *             <ul>
         *             <li><code>TOKEN</code> : A custom authorizer that uses a Lambda function.</li>
         *             <li><code>COGNITO_USER_POOLS</code> : An authorizer that uses Amazon Cognito user pools.</li>
         *             <li><code>REQUEST</code> : An authorizer that uses a Lambda function using incoming request parameters.</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getAuthorizerCredentials}
         * @param authorizerCredentials The credentials that are required for the authorizer.
         *                              To specify an IAM role that API Gateway assumes, specify the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerCredentials(java.lang.String authorizerCredentials) {
            this.authorizerCredentials = authorizerCredentials;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getAuthorizerResultTtlInSeconds}
         * @param authorizerResultTtlInSeconds The time-to-live (TTL) period, in seconds, that specifies how long API Gateway caches authorizer results.
         *                                     If you specify a value greater than 0, API Gateway caches the authorizer responses. By default, API Gateway sets this property to 300. The maximum value is 3600, or 1 hour.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerResultTtlInSeconds(java.lang.Number authorizerResultTtlInSeconds) {
            this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getAuthorizerUri}
         * @param authorizerUri The authorizer's Uniform Resource Identifier (URI).
         *                      If you specify <code>TOKEN</code> for the authorizer's <code>Type</code> property, specify a Lambda function URI that has the form <code>arn:aws:apigateway: *region* :lambda:path/ *path*</code> . The path usually has the form /2015-03-31/functions/ <em>LambdaFunctionARN</em> /invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerUri(java.lang.String authorizerUri) {
            this.authorizerUri = authorizerUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getAuthType}
         * @param authType An optional customer-defined field that's used in OpenApi imports and exports without functional impact.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authType(java.lang.String authType) {
            this.authType = authType;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getIdentitySource}
         * @param identitySource The source of the identity in an incoming request.
         *                       If you specify <code>TOKEN</code> or <code>COGNITO_USER_POOLS</code> for the <code>Type</code> property, this property is required. Specify a header mapping expression using the form <code>method.request.header. *name*</code> , where <em>name</em> is the name of a custom authorization header that clients submit as part of their requests.
         *                       <p>
         *                       If you specify <code>REQUEST</code> for the <code>Type</code> property, this property is required when authorization caching is enabled. Specify a comma-separated string of one or more mapping expressions of the specified request parameter using the form <code>method.request.parameter. *name*</code> . For supported parameter types, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/configure-api-gateway-lambda-authorization-with-console.html">Configure Lambda Authorizer Using the API Gateway Console</a> in the <em>API Gateway Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identitySource(java.lang.String identitySource) {
            this.identitySource = identitySource;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getIdentityValidationExpression}
         * @param identityValidationExpression A validation expression for the incoming identity.
         *                                     If you specify <code>TOKEN</code> for the authorizer's <code>Type</code> property, specify a regular expression. API Gateway uses the expression to attempt to match the incoming client token, and proceeds if the token matches. If the token doesn't match, API Gateway responds with a 401 (unauthorized request) error code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityValidationExpression(java.lang.String identityValidationExpression) {
            this.identityValidationExpression = identityValidationExpression;
            return this;
        }

        /**
         * Sets the value of {@link CfnAuthorizerProps#getProviderArns}
         * @param providerArns A list of the Amazon Cognito user pool Amazon Resource Names (ARNs) to associate with this authorizer.
         *                     Required if you specify <code>COGNITO_USER_POOLS</code> as the authorizer <code>Type</code> . For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html#apigateway-enable-cognito-user-pool">Use Amazon Cognito User Pools</a> in the <em>API Gateway Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder providerArns(java.util.List<java.lang.String> providerArns) {
            this.providerArns = providerArns;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAuthorizerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAuthorizerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAuthorizerProps {
        private final java.lang.String name;
        private final java.lang.String restApiId;
        private final java.lang.String type;
        private final java.lang.String authorizerCredentials;
        private final java.lang.Number authorizerResultTtlInSeconds;
        private final java.lang.String authorizerUri;
        private final java.lang.String authType;
        private final java.lang.String identitySource;
        private final java.lang.String identityValidationExpression;
        private final java.util.List<java.lang.String> providerArns;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restApiId = software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizerCredentials = software.amazon.jsii.Kernel.get(this, "authorizerCredentials", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizerResultTtlInSeconds = software.amazon.jsii.Kernel.get(this, "authorizerResultTtlInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.authorizerUri = software.amazon.jsii.Kernel.get(this, "authorizerUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identitySource = software.amazon.jsii.Kernel.get(this, "identitySource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identityValidationExpression = software.amazon.jsii.Kernel.get(this, "identityValidationExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.providerArns = software.amazon.jsii.Kernel.get(this, "providerArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.restApiId = java.util.Objects.requireNonNull(builder.restApiId, "restApiId is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.authorizerCredentials = builder.authorizerCredentials;
            this.authorizerResultTtlInSeconds = builder.authorizerResultTtlInSeconds;
            this.authorizerUri = builder.authorizerUri;
            this.authType = builder.authType;
            this.identitySource = builder.identitySource;
            this.identityValidationExpression = builder.identityValidationExpression;
            this.providerArns = builder.providerArns;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getAuthorizerCredentials() {
            return this.authorizerCredentials;
        }

        @Override
        public final java.lang.Number getAuthorizerResultTtlInSeconds() {
            return this.authorizerResultTtlInSeconds;
        }

        @Override
        public final java.lang.String getAuthorizerUri() {
            return this.authorizerUri;
        }

        @Override
        public final java.lang.String getAuthType() {
            return this.authType;
        }

        @Override
        public final java.lang.String getIdentitySource() {
            return this.identitySource;
        }

        @Override
        public final java.lang.String getIdentityValidationExpression() {
            return this.identityValidationExpression;
        }

        @Override
        public final java.util.List<java.lang.String> getProviderArns() {
            return this.providerArns;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("restApiId", om.valueToTree(this.getRestApiId()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getAuthorizerCredentials() != null) {
                data.set("authorizerCredentials", om.valueToTree(this.getAuthorizerCredentials()));
            }
            if (this.getAuthorizerResultTtlInSeconds() != null) {
                data.set("authorizerResultTtlInSeconds", om.valueToTree(this.getAuthorizerResultTtlInSeconds()));
            }
            if (this.getAuthorizerUri() != null) {
                data.set("authorizerUri", om.valueToTree(this.getAuthorizerUri()));
            }
            if (this.getAuthType() != null) {
                data.set("authType", om.valueToTree(this.getAuthType()));
            }
            if (this.getIdentitySource() != null) {
                data.set("identitySource", om.valueToTree(this.getIdentitySource()));
            }
            if (this.getIdentityValidationExpression() != null) {
                data.set("identityValidationExpression", om.valueToTree(this.getIdentityValidationExpression()));
            }
            if (this.getProviderArns() != null) {
                data.set("providerArns", om.valueToTree(this.getProviderArns()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnAuthorizerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAuthorizerProps.Jsii$Proxy that = (CfnAuthorizerProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!restApiId.equals(that.restApiId)) return false;
            if (!type.equals(that.type)) return false;
            if (this.authorizerCredentials != null ? !this.authorizerCredentials.equals(that.authorizerCredentials) : that.authorizerCredentials != null) return false;
            if (this.authorizerResultTtlInSeconds != null ? !this.authorizerResultTtlInSeconds.equals(that.authorizerResultTtlInSeconds) : that.authorizerResultTtlInSeconds != null) return false;
            if (this.authorizerUri != null ? !this.authorizerUri.equals(that.authorizerUri) : that.authorizerUri != null) return false;
            if (this.authType != null ? !this.authType.equals(that.authType) : that.authType != null) return false;
            if (this.identitySource != null ? !this.identitySource.equals(that.identitySource) : that.identitySource != null) return false;
            if (this.identityValidationExpression != null ? !this.identityValidationExpression.equals(that.identityValidationExpression) : that.identityValidationExpression != null) return false;
            return this.providerArns != null ? this.providerArns.equals(that.providerArns) : that.providerArns == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.restApiId.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.authorizerCredentials != null ? this.authorizerCredentials.hashCode() : 0);
            result = 31 * result + (this.authorizerResultTtlInSeconds != null ? this.authorizerResultTtlInSeconds.hashCode() : 0);
            result = 31 * result + (this.authorizerUri != null ? this.authorizerUri.hashCode() : 0);
            result = 31 * result + (this.authType != null ? this.authType.hashCode() : 0);
            result = 31 * result + (this.identitySource != null ? this.identitySource.hashCode() : 0);
            result = 31 * result + (this.identityValidationExpression != null ? this.identityValidationExpression.hashCode() : 0);
            result = 31 * result + (this.providerArns != null ? this.providerArns.hashCode() : 0);
            return result;
        }
    }
}
