package software.amazon.awscdk.services.apigateway;

/**
 * ApiKey Properties.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.6 (build 17f281e)", date = "2019-11-19T17:18:13.964Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.ApiKeyProps")
@software.amazon.jsii.Jsii.Proxy(ApiKeyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApiKeyProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.ResourceOptions {

    /**
     * A name for the API key.
     * 
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the API key name.
     * 
     * Default: automically generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getApiKeyName() {
        return null;
    }

    /**
     * An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getCustomerId() {
        return null;
    }

    /**
     * A description of the purpose of the API key.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.String getDescription() {
        return null;
    }

    /**
     * Indicates whether the API key can be used by clients.
     * 
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * Specifies whether the key identifier is distinct from the created API key value.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Boolean getGenerateDistinctId() {
        return null;
    }

    /**
     * A list of resources this api key is associated with.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<software.amazon.awscdk.services.apigateway.RestApi> getResources() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApiKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApiKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String apiKeyName;
        private java.lang.String customerId;
        private java.lang.String description;
        private java.lang.Boolean enabled;
        private java.lang.Boolean generateDistinctId;
        private java.util.List<software.amazon.awscdk.services.apigateway.RestApi> resources;
        private software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions;
        private software.amazon.awscdk.services.apigateway.Integration defaultIntegration;
        private software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions;

        /**
         * Sets the value of ApiKeyName
         * @param apiKeyName A name for the API key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyName(java.lang.String apiKeyName) {
            this.apiKeyName = apiKeyName;
            return this;
        }

        /**
         * Sets the value of CustomerId
         * @param customerId An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerId(java.lang.String customerId) {
            this.customerId = customerId;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description A description of the purpose of the API key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of Enabled
         * @param enabled Indicates whether the API key can be used by clients.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of GenerateDistinctId
         * @param generateDistinctId Specifies whether the key identifier is distinct from the created API key value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateDistinctId(java.lang.Boolean generateDistinctId) {
            this.generateDistinctId = generateDistinctId;
            return this;
        }

        /**
         * Sets the value of Resources
         * @param resources A list of resources this api key is associated with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(java.util.List<software.amazon.awscdk.services.apigateway.RestApi> resources) {
            this.resources = resources;
            return this;
        }

        /**
         * Sets the value of DefaultCorsPreflightOptions
         * @param defaultCorsPreflightOptions Adds a CORS preflight OPTIONS method to this resource and all child resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCorsPreflightOptions(software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions) {
            this.defaultCorsPreflightOptions = defaultCorsPreflightOptions;
            return this;
        }

        /**
         * Sets the value of DefaultIntegration
         * @param defaultIntegration An integration to use as a default for all methods created within this API unless an integration is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultIntegration(software.amazon.awscdk.services.apigateway.Integration defaultIntegration) {
            this.defaultIntegration = defaultIntegration;
            return this;
        }

        /**
         * Sets the value of DefaultMethodOptions
         * @param defaultMethodOptions Method options to use as a default for all methods created within this API unless custom options are specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultMethodOptions(software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions) {
            this.defaultMethodOptions = defaultMethodOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApiKeyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ApiKeyProps build() {
            return new Jsii$Proxy(apiKeyName, customerId, description, enabled, generateDistinctId, resources, defaultCorsPreflightOptions, defaultIntegration, defaultMethodOptions);
        }
    }

    /**
     * An implementation for {@link ApiKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiKeyProps {
        private final java.lang.String apiKeyName;
        private final java.lang.String customerId;
        private final java.lang.String description;
        private final java.lang.Boolean enabled;
        private final java.lang.Boolean generateDistinctId;
        private final java.util.List<software.amazon.awscdk.services.apigateway.RestApi> resources;
        private final software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions;
        private final software.amazon.awscdk.services.apigateway.Integration defaultIntegration;
        private final software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiKeyName = this.jsiiGet("apiKeyName", java.lang.String.class);
            this.customerId = this.jsiiGet("customerId", java.lang.String.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.enabled = this.jsiiGet("enabled", java.lang.Boolean.class);
            this.generateDistinctId = this.jsiiGet("generateDistinctId", java.lang.Boolean.class);
            this.resources = this.jsiiGet("resources", java.util.List.class);
            this.defaultCorsPreflightOptions = this.jsiiGet("defaultCorsPreflightOptions", software.amazon.awscdk.services.apigateway.CorsOptions.class);
            this.defaultIntegration = this.jsiiGet("defaultIntegration", software.amazon.awscdk.services.apigateway.Integration.class);
            this.defaultMethodOptions = this.jsiiGet("defaultMethodOptions", software.amazon.awscdk.services.apigateway.MethodOptions.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String apiKeyName, final java.lang.String customerId, final java.lang.String description, final java.lang.Boolean enabled, final java.lang.Boolean generateDistinctId, final java.util.List<software.amazon.awscdk.services.apigateway.RestApi> resources, final software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions, final software.amazon.awscdk.services.apigateway.Integration defaultIntegration, final software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiKeyName = apiKeyName;
            this.customerId = customerId;
            this.description = description;
            this.enabled = enabled;
            this.generateDistinctId = generateDistinctId;
            this.resources = resources;
            this.defaultCorsPreflightOptions = defaultCorsPreflightOptions;
            this.defaultIntegration = defaultIntegration;
            this.defaultMethodOptions = defaultMethodOptions;
        }

        @Override
        public java.lang.String getApiKeyName() {
            return this.apiKeyName;
        }

        @Override
        public java.lang.String getCustomerId() {
            return this.customerId;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public java.lang.Boolean getGenerateDistinctId() {
            return this.generateDistinctId;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.apigateway.RestApi> getResources() {
            return this.resources;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.CorsOptions getDefaultCorsPreflightOptions() {
            return this.defaultCorsPreflightOptions;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.Integration getDefaultIntegration() {
            return this.defaultIntegration;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.MethodOptions getDefaultMethodOptions() {
            return this.defaultMethodOptions;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApiKeyName() != null) {
                data.set("apiKeyName", om.valueToTree(this.getApiKeyName()));
            }
            if (this.getCustomerId() != null) {
                data.set("customerId", om.valueToTree(this.getCustomerId()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getGenerateDistinctId() != null) {
                data.set("generateDistinctId", om.valueToTree(this.getGenerateDistinctId()));
            }
            if (this.getResources() != null) {
                data.set("resources", om.valueToTree(this.getResources()));
            }
            if (this.getDefaultCorsPreflightOptions() != null) {
                data.set("defaultCorsPreflightOptions", om.valueToTree(this.getDefaultCorsPreflightOptions()));
            }
            if (this.getDefaultIntegration() != null) {
                data.set("defaultIntegration", om.valueToTree(this.getDefaultIntegration()));
            }
            if (this.getDefaultMethodOptions() != null) {
                data.set("defaultMethodOptions", om.valueToTree(this.getDefaultMethodOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.ApiKeyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApiKeyProps.Jsii$Proxy that = (ApiKeyProps.Jsii$Proxy) o;

            if (this.apiKeyName != null ? !this.apiKeyName.equals(that.apiKeyName) : that.apiKeyName != null) return false;
            if (this.customerId != null ? !this.customerId.equals(that.customerId) : that.customerId != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.generateDistinctId != null ? !this.generateDistinctId.equals(that.generateDistinctId) : that.generateDistinctId != null) return false;
            if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) return false;
            if (this.defaultCorsPreflightOptions != null ? !this.defaultCorsPreflightOptions.equals(that.defaultCorsPreflightOptions) : that.defaultCorsPreflightOptions != null) return false;
            if (this.defaultIntegration != null ? !this.defaultIntegration.equals(that.defaultIntegration) : that.defaultIntegration != null) return false;
            return this.defaultMethodOptions != null ? this.defaultMethodOptions.equals(that.defaultMethodOptions) : that.defaultMethodOptions == null;
        }

        @Override
        public int hashCode() {
            int result = this.apiKeyName != null ? this.apiKeyName.hashCode() : 0;
            result = 31 * result + (this.customerId != null ? this.customerId.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.generateDistinctId != null ? this.generateDistinctId.hashCode() : 0);
            result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
            result = 31 * result + (this.defaultCorsPreflightOptions != null ? this.defaultCorsPreflightOptions.hashCode() : 0);
            result = 31 * result + (this.defaultIntegration != null ? this.defaultIntegration.hashCode() : 0);
            result = 31 * result + (this.defaultMethodOptions != null ? this.defaultMethodOptions.hashCode() : 0);
            return result;
        }
    }
}
