package software.amazon.awscdk.services.apigateway;

/**
 * Container for defining throttling parameters to API stages or methods.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.6 (build 17f281e)", date = "2019-11-19T17:18:14.023Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.ThrottleSettings")
@software.amazon.jsii.Jsii.Proxy(ThrottleSettings.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ThrottleSettings extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum API request rate limit over a time ranging from one to a few seconds.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Number getBurstLimit() {
        return null;
    }

    /**
     * The API request steady-state rate limit (average requests per second over an extended period of time).
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Number getRateLimit() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ThrottleSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ThrottleSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.Number burstLimit;
        private java.lang.Number rateLimit;

        /**
         * Sets the value of BurstLimit
         * @param burstLimit The maximum API request rate limit over a time ranging from one to a few seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder burstLimit(java.lang.Number burstLimit) {
            this.burstLimit = burstLimit;
            return this;
        }

        /**
         * Sets the value of RateLimit
         * @param rateLimit The API request steady-state rate limit (average requests per second over an extended period of time).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rateLimit(java.lang.Number rateLimit) {
            this.rateLimit = rateLimit;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ThrottleSettings}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ThrottleSettings build() {
            return new Jsii$Proxy(burstLimit, rateLimit);
        }
    }

    /**
     * An implementation for {@link ThrottleSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThrottleSettings {
        private final java.lang.Number burstLimit;
        private final java.lang.Number rateLimit;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.burstLimit = this.jsiiGet("burstLimit", java.lang.Number.class);
            this.rateLimit = this.jsiiGet("rateLimit", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Number burstLimit, final java.lang.Number rateLimit) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.burstLimit = burstLimit;
            this.rateLimit = rateLimit;
        }

        @Override
        public java.lang.Number getBurstLimit() {
            return this.burstLimit;
        }

        @Override
        public java.lang.Number getRateLimit() {
            return this.rateLimit;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBurstLimit() != null) {
                data.set("burstLimit", om.valueToTree(this.getBurstLimit()));
            }
            if (this.getRateLimit() != null) {
                data.set("rateLimit", om.valueToTree(this.getRateLimit()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.ThrottleSettings"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ThrottleSettings.Jsii$Proxy that = (ThrottleSettings.Jsii$Proxy) o;

            if (this.burstLimit != null ? !this.burstLimit.equals(that.burstLimit) : that.burstLimit != null) return false;
            return this.rateLimit != null ? this.rateLimit.equals(that.rateLimit) : that.rateLimit == null;
        }

        @Override
        public int hashCode() {
            int result = this.burstLimit != null ? this.burstLimit.hashCode() : 0;
            result = 31 * result + (this.rateLimit != null ? this.rateLimit.hashCode() : 0);
            return result;
        }
    }
}
