package software.amazon.awscdk.services.apigateway;

/**
 * Represents per-method throttling for a resource.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.6 (build 17f281e)", date = "2019-11-19T17:18:14.023Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.ThrottlingPerMethod")
@software.amazon.jsii.Jsii.Proxy(ThrottlingPerMethod.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ThrottlingPerMethod extends software.amazon.jsii.JsiiSerializable {

    /**
     * [disable-awslint:ref-via-interface] The method for which you specify the throttling settings.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.Method getMethod();

    /**
     * Specifies the overall request rate (average requests per second) and burst capacity.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.ThrottleSettings getThrottle();

    /**
     * @return a {@link Builder} of {@link ThrottlingPerMethod}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ThrottlingPerMethod}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.apigateway.Method method;
        private software.amazon.awscdk.services.apigateway.ThrottleSettings throttle;

        /**
         * Sets the value of Method
         * @param method [disable-awslint:ref-via-interface] The method for which you specify the throttling settings. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(software.amazon.awscdk.services.apigateway.Method method) {
            this.method = method;
            return this;
        }

        /**
         * Sets the value of Throttle
         * @param throttle Specifies the overall request rate (average requests per second) and burst capacity. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttle(software.amazon.awscdk.services.apigateway.ThrottleSettings throttle) {
            this.throttle = throttle;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ThrottlingPerMethod}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ThrottlingPerMethod build() {
            return new Jsii$Proxy(method, throttle);
        }
    }

    /**
     * An implementation for {@link ThrottlingPerMethod}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThrottlingPerMethod {
        private final software.amazon.awscdk.services.apigateway.Method method;
        private final software.amazon.awscdk.services.apigateway.ThrottleSettings throttle;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.method = this.jsiiGet("method", software.amazon.awscdk.services.apigateway.Method.class);
            this.throttle = this.jsiiGet("throttle", software.amazon.awscdk.services.apigateway.ThrottleSettings.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.apigateway.Method method, final software.amazon.awscdk.services.apigateway.ThrottleSettings throttle) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.method = java.util.Objects.requireNonNull(method, "method is required");
            this.throttle = java.util.Objects.requireNonNull(throttle, "throttle is required");
        }

        @Override
        public software.amazon.awscdk.services.apigateway.Method getMethod() {
            return this.method;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.ThrottleSettings getThrottle() {
            return this.throttle;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("method", om.valueToTree(this.getMethod()));
            data.set("throttle", om.valueToTree(this.getThrottle()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.ThrottlingPerMethod"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ThrottlingPerMethod.Jsii$Proxy that = (ThrottlingPerMethod.Jsii$Proxy) o;

            if (!method.equals(that.method)) return false;
            return this.throttle.equals(that.throttle);
        }

        @Override
        public int hashCode() {
            int result = this.method.hashCode();
            result = 31 * result + (this.throttle.hashCode());
            return result;
        }
    }
}
