/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awscdk.services.apigateway.;
import software.amazon.awscdk.services.apigateway.AwsIntegration;
import software.amazon.awscdk.services.apigateway.ConnectionType;
import software.amazon.awscdk.services.apigateway.ContentHandling;
import software.amazon.awscdk.services.apigateway.IntegrationResponse;
import software.amazon.awscdk.services.apigateway.LambdaIntegrationOptions;
import software.amazon.awscdk.services.apigateway.Method;
import software.amazon.awscdk.services.apigateway.PassthroughBehavior;
import software.amazon.awscdk.services.apigateway.VpcLink;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-apigateway.LambdaIntegration")
public class LambdaIntegration
extends AwsIntegration {
    protected LambdaIntegration(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaIntegration(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public LambdaIntegration(IFunction handler, LambdaIntegrationOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(handler, "handler is required"), options});
    }

    public LambdaIntegration(IFunction handler) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(handler, "handler is required")});
    }

    @Override
    public void bind(Method method) {
        this.jsiiCall("bind", Void.class, new Object[]{Objects.requireNonNull(method, "method is required")});
    }

    public static final class Builder {
        private final IFunction handler;
        private LambdaIntegrationOptions.Builder options;

        public static Builder create(IFunction handler) {
            return new Builder(handler);
        }

        private Builder(IFunction handler) {
            this.handler = handler;
        }

        public Builder cacheKeyParameters(List<String> cacheKeyParameters) {
            this.options().cacheKeyParameters(cacheKeyParameters);
            return this;
        }

        public Builder cacheNamespace(String cacheNamespace) {
            this.options().cacheNamespace(cacheNamespace);
            return this;
        }

        public Builder connectionType(ConnectionType connectionType) {
            this.options().connectionType(connectionType);
            return this;
        }

        public Builder contentHandling(ContentHandling contentHandling) {
            this.options().contentHandling(contentHandling);
            return this;
        }

        public Builder credentialsPassthrough(Boolean credentialsPassthrough) {
            this.options().credentialsPassthrough(credentialsPassthrough);
            return this;
        }

        public Builder credentialsRole(IRole credentialsRole) {
            this.options().credentialsRole(credentialsRole);
            return this;
        }

        public Builder integrationResponses(List<IntegrationResponse> integrationResponses) {
            this.options().integrationResponses(integrationResponses);
            return this;
        }

        public Builder passthroughBehavior(PassthroughBehavior passthroughBehavior) {
            this.options().passthroughBehavior(passthroughBehavior);
            return this;
        }

        public Builder requestParameters(Map<String, String> requestParameters) {
            this.options().requestParameters(requestParameters);
            return this;
        }

        public Builder requestTemplates(Map<String, String> requestTemplates) {
            this.options().requestTemplates(requestTemplates);
            return this;
        }

        public Builder vpcLink(VpcLink vpcLink) {
            this.options().vpcLink(vpcLink);
            return this;
        }

        public Builder allowTestInvoke(Boolean allowTestInvoke) {
            this.options().allowTestInvoke(allowTestInvoke);
            return this;
        }

        public Builder proxy(Boolean proxy) {
            this.options().proxy(proxy);
            return this;
        }

        public LambdaIntegration build() {
            return new LambdaIntegration(this.handler, this.options != null ? this.options.build() : null);
        }

        private LambdaIntegrationOptions.Builder options() {
            if (this.options == null) {
                this.options = new LambdaIntegrationOptions.Builder();
            }
            return this.options;
        }
    }
}

