/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.apigateway.;
import software.amazon.awscdk.services.apigateway.CfnMethod;
import software.amazon.awscdk.services.apigateway.CfnMethodProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-apigateway.CfnMethod")
public class CfnMethod
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnMethod.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnMethod(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMethod(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnMethod(Construct scope, String id, CfnMethodProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(TreeInspector inspector) {
        this.jsiiCall("inspect", Void.class, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    protected Map<String, Object> renderProperties(Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", Map.class, new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", Map.class));
    }

    public String getHttpMethod() {
        return (String)this.jsiiGet("httpMethod", String.class);
    }

    public void setHttpMethod(String value) {
        this.jsiiSet("httpMethod", Objects.requireNonNull(value, "httpMethod is required"));
    }

    public String getResourceId() {
        return (String)this.jsiiGet("resourceId", String.class);
    }

    public void setResourceId(String value) {
        this.jsiiSet("resourceId", Objects.requireNonNull(value, "resourceId is required"));
    }

    public String getRestApiId() {
        return (String)this.jsiiGet("restApiId", String.class);
    }

    public void setRestApiId(String value) {
        this.jsiiSet("restApiId", Objects.requireNonNull(value, "restApiId is required"));
    }

    public Object getApiKeyRequired() {
        return this.jsiiGet("apiKeyRequired", Object.class);
    }

    public void setApiKeyRequired(Boolean value) {
        this.jsiiSet("apiKeyRequired", value);
    }

    public void setApiKeyRequired(IResolvable value) {
        this.jsiiSet("apiKeyRequired", value);
    }

    public List<String> getAuthorizationScopes() {
        return Optional.ofNullable((List)this.jsiiGet("authorizationScopes", List.class)).map(Collections::unmodifiableList).orElse(null);
    }

    public void setAuthorizationScopes(List<String> value) {
        this.jsiiSet("authorizationScopes", value);
    }

    public String getAuthorizationType() {
        return (String)this.jsiiGet("authorizationType", String.class);
    }

    public void setAuthorizationType(String value) {
        this.jsiiSet("authorizationType", value);
    }

    public String getAuthorizerId() {
        return (String)this.jsiiGet("authorizerId", String.class);
    }

    public void setAuthorizerId(String value) {
        this.jsiiSet("authorizerId", value);
    }

    public Object getIntegration() {
        return this.jsiiGet("integration", Object.class);
    }

    public void setIntegration(IResolvable value) {
        this.jsiiSet("integration", value);
    }

    public void setIntegration(IntegrationProperty value) {
        this.jsiiSet("integration", value);
    }

    public Object getMethodResponses() {
        return this.jsiiGet("methodResponses", Object.class);
    }

    public void setMethodResponses(IResolvable value) {
        this.jsiiSet("methodResponses", value);
    }

    public void setMethodResponses(List<Object> value) {
        this.jsiiSet("methodResponses", value);
    }

    public String getOperationName() {
        return (String)this.jsiiGet("operationName", String.class);
    }

    public void setOperationName(String value) {
        this.jsiiSet("operationName", value);
    }

    public Object getRequestModels() {
        return this.jsiiGet("requestModels", Object.class);
    }

    public void setRequestModels(IResolvable value) {
        this.jsiiSet("requestModels", value);
    }

    public void setRequestModels(Map<String, String> value) {
        this.jsiiSet("requestModels", value);
    }

    public Object getRequestParameters() {
        return this.jsiiGet("requestParameters", Object.class);
    }

    public void setRequestParameters(IResolvable value) {
        this.jsiiSet("requestParameters", value);
    }

    public void setRequestParameters(Map<String, Object> value) {
        this.jsiiSet("requestParameters", value);
    }

    public String getRequestValidatorId() {
        return (String)this.jsiiGet("requestValidatorId", String.class);
    }

    public void setRequestValidatorId(String value) {
        this.jsiiSet("requestValidatorId", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final CfnMethodProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnMethodProps.Builder();
        }

        public Builder httpMethod(String httpMethod) {
            this.props.httpMethod(httpMethod);
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.props.resourceId(resourceId);
            return this;
        }

        public Builder restApiId(String restApiId) {
            this.props.restApiId(restApiId);
            return this;
        }

        public Builder apiKeyRequired(Boolean apiKeyRequired) {
            this.props.apiKeyRequired(apiKeyRequired);
            return this;
        }

        public Builder apiKeyRequired(IResolvable apiKeyRequired) {
            this.props.apiKeyRequired(apiKeyRequired);
            return this;
        }

        public Builder authorizationScopes(List<String> authorizationScopes) {
            this.props.authorizationScopes(authorizationScopes);
            return this;
        }

        public Builder authorizationType(String authorizationType) {
            this.props.authorizationType(authorizationType);
            return this;
        }

        public Builder authorizerId(String authorizerId) {
            this.props.authorizerId(authorizerId);
            return this;
        }

        public Builder integration(IResolvable integration) {
            this.props.integration(integration);
            return this;
        }

        public Builder integration(IntegrationProperty integration) {
            this.props.integration(integration);
            return this;
        }

        public Builder methodResponses(IResolvable methodResponses) {
            this.props.methodResponses(methodResponses);
            return this;
        }

        public Builder methodResponses(List<Object> methodResponses) {
            this.props.methodResponses(methodResponses);
            return this;
        }

        public Builder operationName(String operationName) {
            this.props.operationName(operationName);
            return this;
        }

        public Builder requestModels(IResolvable requestModels) {
            this.props.requestModels(requestModels);
            return this;
        }

        public Builder requestModels(Map<String, String> requestModels) {
            this.props.requestModels(requestModels);
            return this;
        }

        public Builder requestParameters(IResolvable requestParameters) {
            this.props.requestParameters(requestParameters);
            return this;
        }

        public Builder requestParameters(Map<String, Object> requestParameters) {
            this.props.requestParameters(requestParameters);
            return this;
        }

        public Builder requestValidatorId(String requestValidatorId) {
            this.props.requestValidatorId(requestValidatorId);
            return this;
        }

        public CfnMethod build() {
            return new CfnMethod(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-apigateway.CfnMethod.MethodResponseProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MethodResponseProperty
    extends JsiiSerializable {
        public String getStatusCode();

        default public Object getResponseModels() {
            return null;
        }

        default public Object getResponseParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String statusCode;
            private Object responseModels;
            private Object responseParameters;

            public Builder statusCode(String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            public Builder responseModels(IResolvable responseModels) {
                this.responseModels = responseModels;
                return this;
            }

            public Builder responseModels(Map<String, String> responseModels) {
                this.responseModels = responseModels;
                return this;
            }

            public Builder responseParameters(IResolvable responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            public Builder responseParameters(Map<String, Object> responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            public MethodResponseProperty build() {
                return new Jsii.Proxy(this.statusCode, this.responseModels, this.responseParameters, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-apigateway.CfnMethod.IntegrationResponseProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IntegrationResponseProperty
    extends JsiiSerializable {
        public String getStatusCode();

        default public String getContentHandling() {
            return null;
        }

        default public Object getResponseParameters() {
            return null;
        }

        default public Object getResponseTemplates() {
            return null;
        }

        default public String getSelectionPattern() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String statusCode;
            private String contentHandling;
            private Object responseParameters;
            private Object responseTemplates;
            private String selectionPattern;

            public Builder statusCode(String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            public Builder contentHandling(String contentHandling) {
                this.contentHandling = contentHandling;
                return this;
            }

            public Builder responseParameters(IResolvable responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            public Builder responseParameters(Map<String, String> responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            public Builder responseTemplates(IResolvable responseTemplates) {
                this.responseTemplates = responseTemplates;
                return this;
            }

            public Builder responseTemplates(Map<String, String> responseTemplates) {
                this.responseTemplates = responseTemplates;
                return this;
            }

            public Builder selectionPattern(String selectionPattern) {
                this.selectionPattern = selectionPattern;
                return this;
            }

            public IntegrationResponseProperty build() {
                return new Jsii.Proxy(this.statusCode, this.contentHandling, this.responseParameters, this.responseTemplates, this.selectionPattern, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-apigateway.CfnMethod.IntegrationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IntegrationProperty
    extends JsiiSerializable {
        default public List<String> getCacheKeyParameters() {
            return null;
        }

        default public String getCacheNamespace() {
            return null;
        }

        default public String getConnectionId() {
            return null;
        }

        default public String getConnectionType() {
            return null;
        }

        default public String getContentHandling() {
            return null;
        }

        default public String getCredentials() {
            return null;
        }

        default public String getIntegrationHttpMethod() {
            return null;
        }

        default public Object getIntegrationResponses() {
            return null;
        }

        default public String getPassthroughBehavior() {
            return null;
        }

        default public Object getRequestParameters() {
            return null;
        }

        default public Object getRequestTemplates() {
            return null;
        }

        default public Number getTimeoutInMillis() {
            return null;
        }

        default public String getType() {
            return null;
        }

        default public String getUri() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<String> cacheKeyParameters;
            private String cacheNamespace;
            private String connectionId;
            private String connectionType;
            private String contentHandling;
            private String credentials;
            private String integrationHttpMethod;
            private Object integrationResponses;
            private String passthroughBehavior;
            private Object requestParameters;
            private Object requestTemplates;
            private Number timeoutInMillis;
            private String type;
            private String uri;

            public Builder cacheKeyParameters(List<String> cacheKeyParameters) {
                this.cacheKeyParameters = cacheKeyParameters;
                return this;
            }

            public Builder cacheNamespace(String cacheNamespace) {
                this.cacheNamespace = cacheNamespace;
                return this;
            }

            public Builder connectionId(String connectionId) {
                this.connectionId = connectionId;
                return this;
            }

            public Builder connectionType(String connectionType) {
                this.connectionType = connectionType;
                return this;
            }

            public Builder contentHandling(String contentHandling) {
                this.contentHandling = contentHandling;
                return this;
            }

            public Builder credentials(String credentials) {
                this.credentials = credentials;
                return this;
            }

            public Builder integrationHttpMethod(String integrationHttpMethod) {
                this.integrationHttpMethod = integrationHttpMethod;
                return this;
            }

            public Builder integrationResponses(IResolvable integrationResponses) {
                this.integrationResponses = integrationResponses;
                return this;
            }

            public Builder integrationResponses(List<Object> integrationResponses) {
                this.integrationResponses = integrationResponses;
                return this;
            }

            public Builder passthroughBehavior(String passthroughBehavior) {
                this.passthroughBehavior = passthroughBehavior;
                return this;
            }

            public Builder requestParameters(IResolvable requestParameters) {
                this.requestParameters = requestParameters;
                return this;
            }

            public Builder requestParameters(Map<String, String> requestParameters) {
                this.requestParameters = requestParameters;
                return this;
            }

            public Builder requestTemplates(IResolvable requestTemplates) {
                this.requestTemplates = requestTemplates;
                return this;
            }

            public Builder requestTemplates(Map<String, String> requestTemplates) {
                this.requestTemplates = requestTemplates;
                return this;
            }

            public Builder timeoutInMillis(Number timeoutInMillis) {
                this.timeoutInMillis = timeoutInMillis;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder uri(String uri) {
                this.uri = uri;
                return this;
            }

            public IntegrationProperty build() {
                return new Jsii.Proxy(this.cacheKeyParameters, this.cacheNamespace, this.connectionId, this.connectionType, this.contentHandling, this.credentials, this.integrationHttpMethod, this.integrationResponses, this.passthroughBehavior, this.requestParameters, this.requestTemplates, this.timeoutInMillis, this.type, this.uri, null);
            }
        }
    }
}

