package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a `CfnStage`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * CfnStageProps cfnStageProps = CfnStageProps.builder()
 *         .restApiId("restApiId")
 *         // the properties below are optional
 *         .accessLogSetting(AccessLogSettingProperty.builder()
 *                 .destinationArn("destinationArn")
 *                 .format("format")
 *                 .build())
 *         .cacheClusterEnabled(false)
 *         .cacheClusterSize("cacheClusterSize")
 *         .canarySetting(CanarySettingProperty.builder()
 *                 .deploymentId("deploymentId")
 *                 .percentTraffic(123)
 *                 .stageVariableOverrides(Map.of(
 *                         "stageVariableOverridesKey", "stageVariableOverrides"))
 *                 .useStageCache(false)
 *                 .build())
 *         .clientCertificateId("clientCertificateId")
 *         .deploymentId("deploymentId")
 *         .description("description")
 *         .documentationVersion("documentationVersion")
 *         .methodSettings(List.of(MethodSettingProperty.builder()
 *                 .cacheDataEncrypted(false)
 *                 .cacheTtlInSeconds(123)
 *                 .cachingEnabled(false)
 *                 .dataTraceEnabled(false)
 *                 .httpMethod("httpMethod")
 *                 .loggingLevel("loggingLevel")
 *                 .metricsEnabled(false)
 *                 .resourcePath("resourcePath")
 *                 .throttlingBurstLimit(123)
 *                 .throttlingRateLimit(123)
 *                 .build()))
 *         .stageName("stageName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .tracingEnabled(false)
 *         .variables(Map.of(
 *                 "variablesKey", "variables"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.66.0 (build 3c9512b)", date = "2022-08-31T20:25:17.821Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnStageProps")
@software.amazon.jsii.Jsii.Proxy(CfnStageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStageProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the `RestApi` resource that you're deploying with this stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRestApiId();

    /**
     * Specifies settings for logging access in this stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccessLogSetting() {
        return null;
    }

    /**
     * Indicates whether cache clustering is enabled for the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCacheClusterEnabled() {
        return null;
    }

    /**
     * The stage's cache cluster size.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCacheClusterSize() {
        return null;
    }

    /**
     * Specifies settings for the canary deployment in this stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCanarySetting() {
        return null;
    }

    /**
     * The ID of the client certificate that API Gateway uses to call your integration endpoints in the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClientCertificateId() {
        return null;
    }

    /**
     * The ID of the deployment that the stage is associated with.
     * <p>
     * This parameter is required to create a stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeploymentId() {
        return null;
    }

    /**
     * A description of the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The version ID of the API documentation snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDocumentationVersion() {
        return null;
    }

    /**
     * Settings for all methods in the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMethodSettings() {
        return null;
    }

    /**
     * The name of the stage, which API Gateway uses as the first path segment in the invoked Uniform Resource Identifier (URI).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStageName() {
        return null;
    }

    /**
     * An array of arbitrary tags (key-value pairs) to associate with the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * Specifies whether active X-Ray tracing is enabled for this stage.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-xray.html">Trace API Gateway API Execution with AWS X-Ray</a> in the <em>API Gateway Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTracingEnabled() {
        return null;
    }

    /**
     * A map (string-to-string map) that defines the stage variables, where the variable name is the key and the variable value is the value.
     * <p>
     * Variable names are limited to alphanumeric characters. Values must match the following regular expression: <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVariables() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStageProps> {
        java.lang.String restApiId;
        java.lang.Object accessLogSetting;
        java.lang.Object cacheClusterEnabled;
        java.lang.String cacheClusterSize;
        java.lang.Object canarySetting;
        java.lang.String clientCertificateId;
        java.lang.String deploymentId;
        java.lang.String description;
        java.lang.String documentationVersion;
        java.lang.Object methodSettings;
        java.lang.String stageName;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        java.lang.Object tracingEnabled;
        java.lang.Object variables;

        /**
         * Sets the value of {@link CfnStageProps#getRestApiId}
         * @param restApiId The ID of the `RestApi` resource that you're deploying with this stage. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiId(java.lang.String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getAccessLogSetting}
         * @param accessLogSetting Specifies settings for logging access in this stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLogSetting(software.amazon.awscdk.core.IResolvable accessLogSetting) {
            this.accessLogSetting = accessLogSetting;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getAccessLogSetting}
         * @param accessLogSetting Specifies settings for logging access in this stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLogSetting(software.amazon.awscdk.services.apigateway.CfnStage.AccessLogSettingProperty accessLogSetting) {
            this.accessLogSetting = accessLogSetting;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getCacheClusterEnabled}
         * @param cacheClusterEnabled Indicates whether cache clustering is enabled for the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheClusterEnabled(java.lang.Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getCacheClusterEnabled}
         * @param cacheClusterEnabled Indicates whether cache clustering is enabled for the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheClusterEnabled(software.amazon.awscdk.core.IResolvable cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getCacheClusterSize}
         * @param cacheClusterSize The stage's cache cluster size.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheClusterSize(java.lang.String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getCanarySetting}
         * @param canarySetting Specifies settings for the canary deployment in this stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder canarySetting(software.amazon.awscdk.core.IResolvable canarySetting) {
            this.canarySetting = canarySetting;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getCanarySetting}
         * @param canarySetting Specifies settings for the canary deployment in this stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder canarySetting(software.amazon.awscdk.services.apigateway.CfnStage.CanarySettingProperty canarySetting) {
            this.canarySetting = canarySetting;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getClientCertificateId}
         * @param clientCertificateId The ID of the client certificate that API Gateway uses to call your integration endpoints in the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientCertificateId(java.lang.String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getDeploymentId}
         * @param deploymentId The ID of the deployment that the stage is associated with.
         *                     This parameter is required to create a stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentId(java.lang.String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getDescription}
         * @param description A description of the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getDocumentationVersion}
         * @param documentationVersion The version ID of the API documentation snapshot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentationVersion(java.lang.String documentationVersion) {
            this.documentationVersion = documentationVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getMethodSettings}
         * @param methodSettings Settings for all methods in the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder methodSettings(software.amazon.awscdk.core.IResolvable methodSettings) {
            this.methodSettings = methodSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getMethodSettings}
         * @param methodSettings Settings for all methods in the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder methodSettings(java.util.List<? extends java.lang.Object> methodSettings) {
            this.methodSettings = methodSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getStageName}
         * @param stageName The name of the stage, which API Gateway uses as the first path segment in the invoked Uniform Resource Identifier (URI).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(java.lang.String stageName) {
            this.stageName = stageName;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getTags}
         * @param tags An array of arbitrary tags (key-value pairs) to associate with the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getTracingEnabled}
         * @param tracingEnabled Specifies whether active X-Ray tracing is enabled for this stage.
         *                       For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-xray.html">Trace API Gateway API Execution with AWS X-Ray</a> in the <em>API Gateway Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracingEnabled(java.lang.Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getTracingEnabled}
         * @param tracingEnabled Specifies whether active X-Ray tracing is enabled for this stage.
         *                       For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-xray.html">Trace API Gateway API Execution with AWS X-Ray</a> in the <em>API Gateway Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracingEnabled(software.amazon.awscdk.core.IResolvable tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getVariables}
         * @param variables A map (string-to-string map) that defines the stage variables, where the variable name is the key and the variable value is the value.
         *                  Variable names are limited to alphanumeric characters. Values must match the following regular expression: <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variables(software.amazon.awscdk.core.IResolvable variables) {
            this.variables = variables;
            return this;
        }

        /**
         * Sets the value of {@link CfnStageProps#getVariables}
         * @param variables A map (string-to-string map) that defines the stage variables, where the variable name is the key and the variable value is the value.
         *                  Variable names are limited to alphanumeric characters. Values must match the following regular expression: <code>[A-Za-z0-9-._~:/?#&amp;=,]+</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variables(java.util.Map<java.lang.String, java.lang.String> variables) {
            this.variables = variables;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStageProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStageProps {
        private final java.lang.String restApiId;
        private final java.lang.Object accessLogSetting;
        private final java.lang.Object cacheClusterEnabled;
        private final java.lang.String cacheClusterSize;
        private final java.lang.Object canarySetting;
        private final java.lang.String clientCertificateId;
        private final java.lang.String deploymentId;
        private final java.lang.String description;
        private final java.lang.String documentationVersion;
        private final java.lang.Object methodSettings;
        private final java.lang.String stageName;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.Object tracingEnabled;
        private final java.lang.Object variables;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.restApiId = software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessLogSetting = software.amazon.jsii.Kernel.get(this, "accessLogSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cacheClusterEnabled = software.amazon.jsii.Kernel.get(this, "cacheClusterEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cacheClusterSize = software.amazon.jsii.Kernel.get(this, "cacheClusterSize", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.canarySetting = software.amazon.jsii.Kernel.get(this, "canarySetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.clientCertificateId = software.amazon.jsii.Kernel.get(this, "clientCertificateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deploymentId = software.amazon.jsii.Kernel.get(this, "deploymentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.documentationVersion = software.amazon.jsii.Kernel.get(this, "documentationVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.methodSettings = software.amazon.jsii.Kernel.get(this, "methodSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.stageName = software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
            this.tracingEnabled = software.amazon.jsii.Kernel.get(this, "tracingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.variables = software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.restApiId = java.util.Objects.requireNonNull(builder.restApiId, "restApiId is required");
            this.accessLogSetting = builder.accessLogSetting;
            this.cacheClusterEnabled = builder.cacheClusterEnabled;
            this.cacheClusterSize = builder.cacheClusterSize;
            this.canarySetting = builder.canarySetting;
            this.clientCertificateId = builder.clientCertificateId;
            this.deploymentId = builder.deploymentId;
            this.description = builder.description;
            this.documentationVersion = builder.documentationVersion;
            this.methodSettings = builder.methodSettings;
            this.stageName = builder.stageName;
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
            this.tracingEnabled = builder.tracingEnabled;
            this.variables = builder.variables;
        }

        @Override
        public final java.lang.String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final java.lang.Object getAccessLogSetting() {
            return this.accessLogSetting;
        }

        @Override
        public final java.lang.Object getCacheClusterEnabled() {
            return this.cacheClusterEnabled;
        }

        @Override
        public final java.lang.String getCacheClusterSize() {
            return this.cacheClusterSize;
        }

        @Override
        public final java.lang.Object getCanarySetting() {
            return this.canarySetting;
        }

        @Override
        public final java.lang.String getClientCertificateId() {
            return this.clientCertificateId;
        }

        @Override
        public final java.lang.String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDocumentationVersion() {
            return this.documentationVersion;
        }

        @Override
        public final java.lang.Object getMethodSettings() {
            return this.methodSettings;
        }

        @Override
        public final java.lang.String getStageName() {
            return this.stageName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTracingEnabled() {
            return this.tracingEnabled;
        }

        @Override
        public final java.lang.Object getVariables() {
            return this.variables;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("restApiId", om.valueToTree(this.getRestApiId()));
            if (this.getAccessLogSetting() != null) {
                data.set("accessLogSetting", om.valueToTree(this.getAccessLogSetting()));
            }
            if (this.getCacheClusterEnabled() != null) {
                data.set("cacheClusterEnabled", om.valueToTree(this.getCacheClusterEnabled()));
            }
            if (this.getCacheClusterSize() != null) {
                data.set("cacheClusterSize", om.valueToTree(this.getCacheClusterSize()));
            }
            if (this.getCanarySetting() != null) {
                data.set("canarySetting", om.valueToTree(this.getCanarySetting()));
            }
            if (this.getClientCertificateId() != null) {
                data.set("clientCertificateId", om.valueToTree(this.getClientCertificateId()));
            }
            if (this.getDeploymentId() != null) {
                data.set("deploymentId", om.valueToTree(this.getDeploymentId()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDocumentationVersion() != null) {
                data.set("documentationVersion", om.valueToTree(this.getDocumentationVersion()));
            }
            if (this.getMethodSettings() != null) {
                data.set("methodSettings", om.valueToTree(this.getMethodSettings()));
            }
            if (this.getStageName() != null) {
                data.set("stageName", om.valueToTree(this.getStageName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTracingEnabled() != null) {
                data.set("tracingEnabled", om.valueToTree(this.getTracingEnabled()));
            }
            if (this.getVariables() != null) {
                data.set("variables", om.valueToTree(this.getVariables()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnStageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStageProps.Jsii$Proxy that = (CfnStageProps.Jsii$Proxy) o;

            if (!restApiId.equals(that.restApiId)) return false;
            if (this.accessLogSetting != null ? !this.accessLogSetting.equals(that.accessLogSetting) : that.accessLogSetting != null) return false;
            if (this.cacheClusterEnabled != null ? !this.cacheClusterEnabled.equals(that.cacheClusterEnabled) : that.cacheClusterEnabled != null) return false;
            if (this.cacheClusterSize != null ? !this.cacheClusterSize.equals(that.cacheClusterSize) : that.cacheClusterSize != null) return false;
            if (this.canarySetting != null ? !this.canarySetting.equals(that.canarySetting) : that.canarySetting != null) return false;
            if (this.clientCertificateId != null ? !this.clientCertificateId.equals(that.clientCertificateId) : that.clientCertificateId != null) return false;
            if (this.deploymentId != null ? !this.deploymentId.equals(that.deploymentId) : that.deploymentId != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.documentationVersion != null ? !this.documentationVersion.equals(that.documentationVersion) : that.documentationVersion != null) return false;
            if (this.methodSettings != null ? !this.methodSettings.equals(that.methodSettings) : that.methodSettings != null) return false;
            if (this.stageName != null ? !this.stageName.equals(that.stageName) : that.stageName != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.tracingEnabled != null ? !this.tracingEnabled.equals(that.tracingEnabled) : that.tracingEnabled != null) return false;
            return this.variables != null ? this.variables.equals(that.variables) : that.variables == null;
        }

        @Override
        public final int hashCode() {
            int result = this.restApiId.hashCode();
            result = 31 * result + (this.accessLogSetting != null ? this.accessLogSetting.hashCode() : 0);
            result = 31 * result + (this.cacheClusterEnabled != null ? this.cacheClusterEnabled.hashCode() : 0);
            result = 31 * result + (this.cacheClusterSize != null ? this.cacheClusterSize.hashCode() : 0);
            result = 31 * result + (this.canarySetting != null ? this.canarySetting.hashCode() : 0);
            result = 31 * result + (this.clientCertificateId != null ? this.clientCertificateId.hashCode() : 0);
            result = 31 * result + (this.deploymentId != null ? this.deploymentId.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.documentationVersion != null ? this.documentationVersion.hashCode() : 0);
            result = 31 * result + (this.methodSettings != null ? this.methodSettings.hashCode() : 0);
            result = 31 * result + (this.stageName != null ? this.stageName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.tracingEnabled != null ? this.tracingEnabled.hashCode() : 0);
            result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
            return result;
        }
    }
}
