package software.amazon.awscdk.services.apigateway;

/**
 * Request-based lambda authorizer that recognizes the caller's identity via request parameters, such as headers, paths, query strings, stage variables, or context variables.
 * <p>
 * Based on the request, authorization is performed by a lambda function.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function authFn;
 * Resource books;
 * RequestAuthorizer auth = RequestAuthorizer.Builder.create(this, "booksAuthorizer")
 *         .handler(authFn)
 *         .identitySources(List.of(IdentitySource.header("Authorization")))
 *         .build();
 * books.addMethod("GET", new HttpIntegration("http://amazon.com"), MethodOptions.builder()
 *         .authorizer(auth)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.66.0 (build 3c9512b)", date = "2022-08-31T20:25:17.958Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.RequestAuthorizer")
public class RequestAuthorizer extends software.amazon.awscdk.services.apigateway.Authorizer implements software.amazon.awscdk.services.apigateway.IAuthorizer {

    protected RequestAuthorizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RequestAuthorizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RequestAuthorizer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.RequestAuthorizerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns a token that resolves to the Rest Api Id at the time of synthesis.
     * <p>
     * Throws an error, during token resolution, if no RestApi is attached to this authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.String lazyRestApiId() {
        return software.amazon.jsii.Kernel.call(this, "lazyRestApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Sets up the permissions necessary for the API Gateway service to invoke the Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setupPermissions() {
        software.amazon.jsii.Kernel.call(this, "setupPermissions", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * The ARN of the authorizer to be used in permission policies, such as IAM and resource-based grants.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuthorizerArn() {
        return software.amazon.jsii.Kernel.get(this, "authorizerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The id of the authorizer.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuthorizerId() {
        return software.amazon.jsii.Kernel.get(this, "authorizerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Lambda function handler that this authorizer uses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getHandler() {
        return software.amazon.jsii.Kernel.get(this, "handler", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
    }

    /**
     * The IAM role that the API Gateway service assumes while invoking the Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.lang.String getRestApiId() {
        return software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setRestApiId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "restApiId", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.RequestAuthorizer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.RequestAuthorizer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.RequestAuthorizerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.RequestAuthorizerProps.Builder();
        }

        /**
         * The handler for the authorizer lambda function.
         * <p>
         * The handler must follow a very specific protocol on the input it receives and the output it needs to produce.
         * API Gateway has documented the handler's input specification
         * {&#64;link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-input.html | here} and output specification
         * {&#64;link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html | here}.
         * <p>
         * @return {@code this}
         * @param handler The handler for the authorizer lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder handler(final software.amazon.awscdk.services.lambda.IFunction handler) {
            this.props.handler(handler);
            return this;
        }

        /**
         * An optional IAM role for APIGateway to assume before calling the Lambda-based authorizer.
         * <p>
         * The IAM role must be
         * assumable by 'apigateway.amazonaws.com'.
         * <p>
         * Default: - A resource policy is added to the Lambda function allowing apigateway.amazonaws.com to invoke the function.
         * <p>
         * @return {@code this}
         * @param assumeRole An optional IAM role for APIGateway to assume before calling the Lambda-based authorizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumeRole(final software.amazon.awscdk.services.iam.IRole assumeRole) {
            this.props.assumeRole(assumeRole);
            return this;
        }

        /**
         * An optional human friendly name for the authorizer.
         * <p>
         * Note that, this is not the primary identifier of the authorizer.
         * <p>
         * Default: - the unique construcrt ID
         * <p>
         * @return {@code this}
         * @param authorizerName An optional human friendly name for the authorizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerName(final java.lang.String authorizerName) {
            this.props.authorizerName(authorizerName);
            return this;
        }

        /**
         * How long APIGateway should cache the results.
         * <p>
         * Max 1 hour.
         * Disable caching by setting this to 0.
         * <p>
         * Default: Duration.minutes(5)
         * <p>
         * @return {@code this}
         * @param resultsCacheTtl How long APIGateway should cache the results. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultsCacheTtl(final software.amazon.awscdk.core.Duration resultsCacheTtl) {
            this.props.resultsCacheTtl(resultsCacheTtl);
            return this;
        }

        /**
         * An array of request header mapping expressions for identities.
         * <p>
         * Supported parameter types are
         * Header, Query String, Stage Variable, and Context. For instance, extracting an authorization
         * token from a header would use the identity source <code>IdentitySource.header('Authorizer')</code>.
         * <p>
         * Note: API Gateway uses the specified identity sources as the request authorizer caching key. When caching is
         * enabled, API Gateway calls the authorizer's Lambda function only after successfully verifying that all the
         * specified identity sources are present at runtime. If a specified identify source is missing, null, or empty,
         * API Gateway returns a 401 Unauthorized response without calling the authorizer Lambda function.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/apigateway/api-reference/link-relation/authorizer-create/#identitySource">https://docs.aws.amazon.com/apigateway/api-reference/link-relation/authorizer-create/#identitySource</a>
         * @param identitySources An array of request header mapping expressions for identities. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identitySources(final java.util.List<java.lang.String> identitySources) {
            this.props.identitySources(identitySources);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.RequestAuthorizer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.RequestAuthorizer build() {
            return new software.amazon.awscdk.services.apigateway.RequestAuthorizer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
