package software.amazon.awscdk.services.apigateway;

/**
 * Base implementation that are common to various implementations of IRestApi.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.route53.*;
 * import software.amazon.awscdk.services.route53.targets.*;
 * RestApi api;
 * Object hostedZoneForExampleCom;
 * ARecord.Builder.create(this, "CustomDomainAliasRecord")
 *         .zone(hostedZoneForExampleCom)
 *         .target(RecordTarget.fromAlias(new ApiGateway(api)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.66.0 (build 3c9512b)", date = "2022-08-31T20:25:17.984Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.RestApiBase")
public abstract class RestApiBase extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.apigateway.IRestApi {

    protected RestApiBase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RestApiBase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected RestApiBase(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.RestApiBaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected RestApiBase(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Add an ApiKey.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IApiKey addApiKey(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.ApiKeyOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addApiKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IApiKey.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Add an ApiKey.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IApiKey addApiKey(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addApiKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IApiKey.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines an API Gateway domain name and maps it to this API.
     * <p>
     * @param id The construct id. This parameter is required.
     * @param options custom domain options. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.DomainName addDomainName(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.DomainNameOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addDomainName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.DomainName.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds a new gateway response.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.GatewayResponse addGatewayResponse(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.GatewayResponseOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addGatewayResponse", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.GatewayResponse.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds a usage plan.
     * <p>
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.UsagePlan addUsagePlan(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.UsagePlanProps props) {
        return software.amazon.jsii.Kernel.call(this, "addUsagePlan", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.UsagePlan.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Adds a usage plan.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.UsagePlan addUsagePlan(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addUsagePlan", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.UsagePlan.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Gets the "execute-api" ARN.
     * <p>
     * @param method
     * @param path
     * @param stage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi(final @org.jetbrains.annotations.Nullable java.lang.String method, final @org.jetbrains.annotations.Nullable java.lang.String path, final @org.jetbrains.annotations.Nullable java.lang.String stage) {
        return software.amazon.jsii.Kernel.call(this, "arnForExecuteApi", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { method, path, stage });
    }

    /**
     * Gets the "execute-api" ARN.
     * <p>
     * @param method
     * @param path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi(final @org.jetbrains.annotations.Nullable java.lang.String method, final @org.jetbrains.annotations.Nullable java.lang.String path) {
        return software.amazon.jsii.Kernel.call(this, "arnForExecuteApi", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { method, path });
    }

    /**
     * Gets the "execute-api" ARN.
     * <p>
     * @param method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi(final @org.jetbrains.annotations.Nullable java.lang.String method) {
        return software.amazon.jsii.Kernel.call(this, "arnForExecuteApi", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { method });
    }

    /**
     * Gets the "execute-api" ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi() {
        return software.amazon.jsii.Kernel.call(this, "arnForExecuteApi", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @deprecated This method will be made internal. No replacement
     * @param apiResource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    protected void configureCloudWatchRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.CfnRestApi apiResource) {
        software.amazon.jsii.Kernel.call(this, "configureCloudWatchRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(apiResource, "apiResource is required") });
    }

    /**
     * @deprecated This method will be made internal. No replacement
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    protected void configureDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.RestApiBaseProps props) {
        software.amazon.jsii.Kernel.call(this, "configureDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns the given named metric for this API.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Returns the given named metric for this API.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * Metric for the number of requests served from the API cache in a given period.
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCacheHitCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricCacheHitCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the number of requests served from the API cache in a given period.
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCacheHitCount() {
        return software.amazon.jsii.Kernel.call(this, "metricCacheHitCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the number of requests served from the backend in a given period, when API caching is enabled.
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCacheMissCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricCacheMissCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the number of requests served from the backend in a given period, when API caching is enabled.
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCacheMissCount() {
        return software.amazon.jsii.Kernel.call(this, "metricCacheMissCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the number of client-side errors captured in a given period.
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClientError(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricClientError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the number of client-side errors captured in a given period.
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClientError() {
        return software.amazon.jsii.Kernel.call(this, "metricClientError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the total number API requests in a given period.
     * <p>
     * Default: sample count over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the total number API requests in a given period.
     * <p>
     * Default: sample count over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCount() {
        return software.amazon.jsii.Kernel.call(this, "metricCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the time between when API Gateway relays a request to the backend and when it receives a response from the backend.
     * <p>
     * Default: average over 5 minutes.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIntegrationLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricIntegrationLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the time between when API Gateway relays a request to the backend and when it receives a response from the backend.
     * <p>
     * Default: average over 5 minutes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIntegrationLatency() {
        return software.amazon.jsii.Kernel.call(this, "metricIntegrationLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The time between when API Gateway receives a request from a client and when it returns a response to the client.
     * <p>
     * The latency includes the integration latency and other API Gateway overhead.
     * <p>
     * Default: average over 5 minutes.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The time between when API Gateway receives a request from a client and when it returns a response to the client.
     * <p>
     * The latency includes the integration latency and other API Gateway overhead.
     * <p>
     * Default: average over 5 minutes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricLatency() {
        return software.amazon.jsii.Kernel.call(this, "metricLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the number of server-side errors captured in a given period.
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricServerError(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricServerError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the number of server-side errors captured in a given period.
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricServerError() {
        return software.amazon.jsii.Kernel.call(this, "metricServerError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Returns the URL for an HTTP path.
     * <p>
     * Fails if <code>deploymentStage</code> is not set either by <code>deploy</code> or explicitly.
     * <p>
     * @param path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String urlForPath(final @org.jetbrains.annotations.Nullable java.lang.String path) {
        return software.amazon.jsii.Kernel.call(this, "urlForPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { path });
    }

    /**
     * Returns the URL for an HTTP path.
     * <p>
     * Fails if <code>deploymentStage</code> is not set either by <code>deploy</code> or explicitly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String urlForPath() {
        return software.amazon.jsii.Kernel.call(this, "urlForPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of this API Gateway RestApi.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getRestApiId();

    /**
     * A human friendly name for this Rest API.
     * <p>
     * Note that this is different from <code>restApiId</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRestApiName() {
        return software.amazon.jsii.Kernel.get(this, "restApiName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The resource ID of the root resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getRestApiRootResourceId();

    /**
     * Represents the root resource of this API endpoint ('/').
     * <p>
     * Resources and Methods are added to this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IResource getRoot();

    /**
     * The first domain name mapped to this API, if defined through the `domainName` configuration prop, or added via `addDomainName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.DomainName getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.DomainName.class));
    }

    /**
     * API Gateway deployment that represents the latest changes of the API.
     * <p>
     * This resource will be automatically updated every time the REST API model changes.
     * This will be undefined if <code>deploy</code> is false.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.Deployment getLatestDeployment() {
        return software.amazon.jsii.Kernel.get(this, "latestDeployment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.Deployment.class));
    }

    /**
     * API Gateway stage that points to the latest deployment (if defined).
     * <p>
     * If <code>deploy</code> is disabled, you will need to explicitly assign this value in order to
     * set up integrations.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.Stage getDeploymentStage() {
        return software.amazon.jsii.Kernel.get(this, "deploymentStage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.Stage.class));
    }

    /**
     * API Gateway stage that points to the latest deployment (if defined).
     * <p>
     * If <code>deploy</code> is disabled, you will need to explicitly assign this value in order to
     * set up integrations.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.Stage value) {
        software.amazon.jsii.Kernel.set(this, "deploymentStage", java.util.Objects.requireNonNull(value, "deploymentStage is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CfnAccount getCloudWatchAccount() {
        return software.amazon.jsii.Kernel.get(this, "cloudWatchAccount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.CfnAccount.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setCloudWatchAccount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CfnAccount value) {
        software.amazon.jsii.Kernel.set(this, "cloudWatchAccount", value);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.apigateway.RestApiBase implements software.amazon.awscdk.services.apigateway.IRestApi.Jsii$Default, software.amazon.awscdk.core.IResource.Jsii$Default, software.amazon.awscdk.core.IConstruct.Jsii$Default, software.constructs.IConstruct.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The ID of this API Gateway RestApi.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getRestApiId() {
            return software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The resource ID of the root resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getRestApiRootResourceId() {
            return software.amazon.jsii.Kernel.get(this, "restApiRootResourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Represents the root resource of this API endpoint ('/').
         * <p>
         * Resources and Methods are added to this resource.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IResource getRoot() {
            return software.amazon.jsii.Kernel.get(this, "root", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IResource.class));
        }
    }
}
