package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * AwsIntegration getMessageIntegration = AwsIntegration.Builder.create()
 *         .service("sqs")
 *         .path("queueName")
 *         .region("eu-west-1")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-21T22:31:07.532Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.AwsIntegrationProps")
@software.amazon.jsii.Jsii.Proxy(AwsIntegrationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AwsIntegrationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the integrated AWS service (e.g. `s3`).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getService();

    /**
     * The AWS action to perform in the integration.
     * <p>
     * Use <code>actionParams</code> to specify key-value params for the action.
     * <p>
     * Mutually exclusive with <code>path</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAction() {
        return null;
    }

    /**
     * Parameters for the action.
     * <p>
     * <code>action</code> must be set, and <code>path</code> must be undefined.
     * The action params will be URL encoded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getActionParameters() {
        return null;
    }

    /**
     * The integration's HTTP method type.
     * <p>
     * Default: POST
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIntegrationHttpMethod() {
        return null;
    }

    /**
     * Integration options, such as content handling, request/response mapping, etc.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions() {
        return null;
    }

    /**
     * The path to use for path-base APIs.
     * <p>
     * For example, for S3 GET, you can set path to <code>bucket/key</code>.
     * For lambda, you can set path to <code>2015-03-31/functions/${function-arn}/invocations</code>
     * <p>
     * Mutually exclusive with the <code>action</code> options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
        return null;
    }

    /**
     * Use AWS_PROXY integration.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getProxy() {
        return null;
    }

    /**
     * The region of the integrated AWS service.
     * <p>
     * Default: - same region as the stack
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * A designated subdomain supported by certain AWS service for fast host-name lookup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubdomain() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AwsIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AwsIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AwsIntegrationProps> {
        java.lang.String service;
        java.lang.String action;
        java.util.Map<java.lang.String, java.lang.String> actionParameters;
        java.lang.String integrationHttpMethod;
        software.amazon.awscdk.services.apigateway.IntegrationOptions options;
        java.lang.String path;
        java.lang.Boolean proxy;
        java.lang.String region;
        java.lang.String subdomain;

        /**
         * Sets the value of {@link AwsIntegrationProps#getService}
         * @param service The name of the integrated AWS service (e.g. `s3`). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(java.lang.String service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of {@link AwsIntegrationProps#getAction}
         * @param action The AWS action to perform in the integration.
         *               Use <code>actionParams</code> to specify key-value params for the action.
         *               <p>
         *               Mutually exclusive with <code>path</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link AwsIntegrationProps#getActionParameters}
         * @param actionParameters Parameters for the action.
         *                         <code>action</code> must be set, and <code>path</code> must be undefined.
         *                         The action params will be URL encoded.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionParameters(java.util.Map<java.lang.String, java.lang.String> actionParameters) {
            this.actionParameters = actionParameters;
            return this;
        }

        /**
         * Sets the value of {@link AwsIntegrationProps#getIntegrationHttpMethod}
         * @param integrationHttpMethod The integration's HTTP method type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationHttpMethod(java.lang.String integrationHttpMethod) {
            this.integrationHttpMethod = integrationHttpMethod;
            return this;
        }

        /**
         * Sets the value of {@link AwsIntegrationProps#getOptions}
         * @param options Integration options, such as content handling, request/response mapping, etc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(software.amazon.awscdk.services.apigateway.IntegrationOptions options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link AwsIntegrationProps#getPath}
         * @param path The path to use for path-base APIs.
         *             For example, for S3 GET, you can set path to <code>bucket/key</code>.
         *             For lambda, you can set path to <code>2015-03-31/functions/${function-arn}/invocations</code>
         *             <p>
         *             Mutually exclusive with the <code>action</code> options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link AwsIntegrationProps#getProxy}
         * @param proxy Use AWS_PROXY integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxy(java.lang.Boolean proxy) {
            this.proxy = proxy;
            return this;
        }

        /**
         * Sets the value of {@link AwsIntegrationProps#getRegion}
         * @param region The region of the integrated AWS service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link AwsIntegrationProps#getSubdomain}
         * @param subdomain A designated subdomain supported by certain AWS service for fast host-name lookup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subdomain(java.lang.String subdomain) {
            this.subdomain = subdomain;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsIntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AwsIntegrationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AwsIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsIntegrationProps {
        private final java.lang.String service;
        private final java.lang.String action;
        private final java.util.Map<java.lang.String, java.lang.String> actionParameters;
        private final java.lang.String integrationHttpMethod;
        private final software.amazon.awscdk.services.apigateway.IntegrationOptions options;
        private final java.lang.String path;
        private final java.lang.Boolean proxy;
        private final java.lang.String region;
        private final java.lang.String subdomain;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.service = software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.actionParameters = software.amazon.jsii.Kernel.get(this, "actionParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.integrationHttpMethod = software.amazon.jsii.Kernel.get(this, "integrationHttpMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IntegrationOptions.class));
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.proxy = software.amazon.jsii.Kernel.get(this, "proxy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subdomain = software.amazon.jsii.Kernel.get(this, "subdomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.service = java.util.Objects.requireNonNull(builder.service, "service is required");
            this.action = builder.action;
            this.actionParameters = builder.actionParameters;
            this.integrationHttpMethod = builder.integrationHttpMethod;
            this.options = builder.options;
            this.path = builder.path;
            this.proxy = builder.proxy;
            this.region = builder.region;
            this.subdomain = builder.subdomain;
        }

        @Override
        public final java.lang.String getService() {
            return this.service;
        }

        @Override
        public final java.lang.String getAction() {
            return this.action;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getActionParameters() {
            return this.actionParameters;
        }

        @Override
        public final java.lang.String getIntegrationHttpMethod() {
            return this.integrationHttpMethod;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions() {
            return this.options;
        }

        @Override
        public final java.lang.String getPath() {
            return this.path;
        }

        @Override
        public final java.lang.Boolean getProxy() {
            return this.proxy;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getSubdomain() {
            return this.subdomain;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("service", om.valueToTree(this.getService()));
            if (this.getAction() != null) {
                data.set("action", om.valueToTree(this.getAction()));
            }
            if (this.getActionParameters() != null) {
                data.set("actionParameters", om.valueToTree(this.getActionParameters()));
            }
            if (this.getIntegrationHttpMethod() != null) {
                data.set("integrationHttpMethod", om.valueToTree(this.getIntegrationHttpMethod()));
            }
            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }
            if (this.getPath() != null) {
                data.set("path", om.valueToTree(this.getPath()));
            }
            if (this.getProxy() != null) {
                data.set("proxy", om.valueToTree(this.getProxy()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getSubdomain() != null) {
                data.set("subdomain", om.valueToTree(this.getSubdomain()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.AwsIntegrationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AwsIntegrationProps.Jsii$Proxy that = (AwsIntegrationProps.Jsii$Proxy) o;

            if (!service.equals(that.service)) return false;
            if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
            if (this.actionParameters != null ? !this.actionParameters.equals(that.actionParameters) : that.actionParameters != null) return false;
            if (this.integrationHttpMethod != null ? !this.integrationHttpMethod.equals(that.integrationHttpMethod) : that.integrationHttpMethod != null) return false;
            if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
            if (this.proxy != null ? !this.proxy.equals(that.proxy) : that.proxy != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            return this.subdomain != null ? this.subdomain.equals(that.subdomain) : that.subdomain == null;
        }

        @Override
        public final int hashCode() {
            int result = this.service.hashCode();
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            result = 31 * result + (this.actionParameters != null ? this.actionParameters.hashCode() : 0);
            result = 31 * result + (this.integrationHttpMethod != null ? this.integrationHttpMethod.hashCode() : 0);
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.proxy != null ? this.proxy.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.subdomain != null ? this.subdomain.hashCode() : 0);
            return result;
        }
    }
}
