package software.amazon.awscdk.services.apigateway;

/**
 * Specifies the maximum number of requests that clients can make to API Gateway APIs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * RestApi api;
 * RateLimitedApiKey key = RateLimitedApiKey.Builder.create(this, "rate-limited-api-key")
 *         .customerId("hello-customer")
 *         .resources(List.of(api))
 *         .quota(QuotaSettings.builder()
 *                 .limit(10000)
 *                 .period(Period.MONTH)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-10-06T13:25:06.837Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.QuotaSettings")
@software.amazon.jsii.Jsii.Proxy(QuotaSettings.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface QuotaSettings extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum number of requests that users can make within the specified time period.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getLimit() {
        return null;
    }

    /**
     * For the initial time period, the number of requests to subtract from the specified limit.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getOffset() {
        return null;
    }

    /**
     * The time period for which the maximum limit of requests applies.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.Period getPeriod() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link QuotaSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link QuotaSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<QuotaSettings> {
        java.lang.Number limit;
        java.lang.Number offset;
        software.amazon.awscdk.services.apigateway.Period period;

        /**
         * Sets the value of {@link QuotaSettings#getLimit}
         * @param limit The maximum number of requests that users can make within the specified time period.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder limit(java.lang.Number limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Sets the value of {@link QuotaSettings#getOffset}
         * @param offset For the initial time period, the number of requests to subtract from the specified limit.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder offset(java.lang.Number offset) {
            this.offset = offset;
            return this;
        }

        /**
         * Sets the value of {@link QuotaSettings#getPeriod}
         * @param period The time period for which the maximum limit of requests applies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(software.amazon.awscdk.services.apigateway.Period period) {
            this.period = period;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link QuotaSettings}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public QuotaSettings build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link QuotaSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QuotaSettings {
        private final java.lang.Number limit;
        private final java.lang.Number offset;
        private final software.amazon.awscdk.services.apigateway.Period period;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.limit = software.amazon.jsii.Kernel.get(this, "limit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.offset = software.amazon.jsii.Kernel.get(this, "offset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.Period.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.limit = builder.limit;
            this.offset = builder.offset;
            this.period = builder.period;
        }

        @Override
        public final java.lang.Number getLimit() {
            return this.limit;
        }

        @Override
        public final java.lang.Number getOffset() {
            return this.offset;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.Period getPeriod() {
            return this.period;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getLimit() != null) {
                data.set("limit", om.valueToTree(this.getLimit()));
            }
            if (this.getOffset() != null) {
                data.set("offset", om.valueToTree(this.getOffset()));
            }
            if (this.getPeriod() != null) {
                data.set("period", om.valueToTree(this.getPeriod()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.QuotaSettings"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            QuotaSettings.Jsii$Proxy that = (QuotaSettings.Jsii$Proxy) o;

            if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) return false;
            if (this.offset != null ? !this.offset.equals(that.offset) : that.offset != null) return false;
            return this.period != null ? this.period.equals(that.period) : that.period == null;
        }

        @Override
        public final int hashCode() {
            int result = this.limit != null ? this.limit.hashCode() : 0;
            result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
            result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
            return result;
        }
    }
}
