package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * RestApi restApi;
 * RequestValidatorProps requestValidatorProps = RequestValidatorProps.builder()
 *         .restApi(restApi)
 *         // the properties below are optional
 *         .requestValidatorName("requestValidatorName")
 *         .validateRequestBody(false)
 *         .validateRequestParameters(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.70.0 (build 03c2f6f)", date = "2022-10-27T14:10:50.615Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.RequestValidatorProps")
@software.amazon.jsii.Jsii.Proxy(RequestValidatorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RequestValidatorProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.RequestValidatorOptions {

    /**
     * The rest API that this model is part of.
     * <p>
     * The reason we need the RestApi object itself and not just the ID is because the model
     * is being tracked by the top-level RestApi object for the purpose of calculating it's
     * hash to determine the ID of the deployment. This allows us to automatically update
     * the deployment when the model of the REST API changes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IRestApi getRestApi();

    /**
     * @return a {@link Builder} of {@link RequestValidatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RequestValidatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RequestValidatorProps> {
        software.amazon.awscdk.services.apigateway.IRestApi restApi;
        java.lang.String requestValidatorName;
        java.lang.Boolean validateRequestBody;
        java.lang.Boolean validateRequestParameters;

        /**
         * Sets the value of {@link RequestValidatorProps#getRestApi}
         * @param restApi The rest API that this model is part of. This parameter is required.
         *                The reason we need the RestApi object itself and not just the ID is because the model
         *                is being tracked by the top-level RestApi object for the purpose of calculating it's
         *                hash to determine the ID of the deployment. This allows us to automatically update
         *                the deployment when the model of the REST API changes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApi(software.amazon.awscdk.services.apigateway.IRestApi restApi) {
            this.restApi = restApi;
            return this;
        }

        /**
         * Sets the value of {@link RequestValidatorProps#getRequestValidatorName}
         * @param requestValidatorName The name of this request validator.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestValidatorName(java.lang.String requestValidatorName) {
            this.requestValidatorName = requestValidatorName;
            return this;
        }

        /**
         * Sets the value of {@link RequestValidatorProps#getValidateRequestBody}
         * @param validateRequestBody Indicates whether to validate the request body according to the configured schema for the targeted API and method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validateRequestBody(java.lang.Boolean validateRequestBody) {
            this.validateRequestBody = validateRequestBody;
            return this;
        }

        /**
         * Sets the value of {@link RequestValidatorProps#getValidateRequestParameters}
         * @param validateRequestParameters Indicates whether to validate request parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validateRequestParameters(java.lang.Boolean validateRequestParameters) {
            this.validateRequestParameters = validateRequestParameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RequestValidatorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RequestValidatorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RequestValidatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RequestValidatorProps {
        private final software.amazon.awscdk.services.apigateway.IRestApi restApi;
        private final java.lang.String requestValidatorName;
        private final java.lang.Boolean validateRequestBody;
        private final java.lang.Boolean validateRequestParameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.restApi = software.amazon.jsii.Kernel.get(this, "restApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IRestApi.class));
            this.requestValidatorName = software.amazon.jsii.Kernel.get(this, "requestValidatorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.validateRequestBody = software.amazon.jsii.Kernel.get(this, "validateRequestBody", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.validateRequestParameters = software.amazon.jsii.Kernel.get(this, "validateRequestParameters", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.restApi = java.util.Objects.requireNonNull(builder.restApi, "restApi is required");
            this.requestValidatorName = builder.requestValidatorName;
            this.validateRequestBody = builder.validateRequestBody;
            this.validateRequestParameters = builder.validateRequestParameters;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.IRestApi getRestApi() {
            return this.restApi;
        }

        @Override
        public final java.lang.String getRequestValidatorName() {
            return this.requestValidatorName;
        }

        @Override
        public final java.lang.Boolean getValidateRequestBody() {
            return this.validateRequestBody;
        }

        @Override
        public final java.lang.Boolean getValidateRequestParameters() {
            return this.validateRequestParameters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("restApi", om.valueToTree(this.getRestApi()));
            if (this.getRequestValidatorName() != null) {
                data.set("requestValidatorName", om.valueToTree(this.getRequestValidatorName()));
            }
            if (this.getValidateRequestBody() != null) {
                data.set("validateRequestBody", om.valueToTree(this.getValidateRequestBody()));
            }
            if (this.getValidateRequestParameters() != null) {
                data.set("validateRequestParameters", om.valueToTree(this.getValidateRequestParameters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.RequestValidatorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RequestValidatorProps.Jsii$Proxy that = (RequestValidatorProps.Jsii$Proxy) o;

            if (!restApi.equals(that.restApi)) return false;
            if (this.requestValidatorName != null ? !this.requestValidatorName.equals(that.requestValidatorName) : that.requestValidatorName != null) return false;
            if (this.validateRequestBody != null ? !this.validateRequestBody.equals(that.validateRequestBody) : that.validateRequestBody != null) return false;
            return this.validateRequestParameters != null ? this.validateRequestParameters.equals(that.validateRequestParameters) : that.validateRequestParameters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.restApi.hashCode();
            result = 31 * result + (this.requestValidatorName != null ? this.requestValidatorName.hashCode() : 0);
            result = 31 * result + (this.validateRequestBody != null ? this.validateRequestBody.hashCode() : 0);
            result = 31 * result + (this.validateRequestParameters != null ? this.validateRequestParameters.hashCode() : 0);
            return result;
        }
    }
}
