package software.amazon.awscdk.services.apigateway;

/**
 * A CloudFormation `AWS::ApiGateway::Stage`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:25.333Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnStage")
public class CfnStage extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnStage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnStage.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ApiGateway::Stage`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnStage(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.apigateway.CfnStageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * 
     * EXPERIMENTAL
     * 
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", Void.class, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::ApiGateway::Stage.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::ApiGateway::Stage.RestApiId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-restapiid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getRestApiId() {
        return this.jsiiGet("restApiId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Stage.RestApiId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-restapiid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRestApiId(final java.lang.String value) {
        this.jsiiSet("restApiId", java.util.Objects.requireNonNull(value, "restApiId is required"));
    }

    /**
     * `AWS::ApiGateway::Stage.AccessLogSetting`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-accesslogsetting
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getAccessLogSetting() {
        return this.jsiiGet("accessLogSetting", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Stage.AccessLogSetting`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-accesslogsetting
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAccessLogSetting(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("accessLogSetting", value);
    }

    /**
     * `AWS::ApiGateway::Stage.AccessLogSetting`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-accesslogsetting
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAccessLogSetting(final software.amazon.awscdk.services.apigateway.CfnStage.AccessLogSettingProperty value) {
        this.jsiiSet("accessLogSetting", value);
    }

    /**
     * `AWS::ApiGateway::Stage.CacheClusterEnabled`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-cacheclusterenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getCacheClusterEnabled() {
        return this.jsiiGet("cacheClusterEnabled", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Stage.CacheClusterEnabled`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-cacheclusterenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCacheClusterEnabled(final java.lang.Boolean value) {
        this.jsiiSet("cacheClusterEnabled", value);
    }

    /**
     * `AWS::ApiGateway::Stage.CacheClusterEnabled`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-cacheclusterenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCacheClusterEnabled(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("cacheClusterEnabled", value);
    }

    /**
     * `AWS::ApiGateway::Stage.CacheClusterSize`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-cacheclustersize
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getCacheClusterSize() {
        return this.jsiiGet("cacheClusterSize", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Stage.CacheClusterSize`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-cacheclustersize
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCacheClusterSize(final java.lang.String value) {
        this.jsiiSet("cacheClusterSize", value);
    }

    /**
     * `AWS::ApiGateway::Stage.CanarySetting`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-canarysetting
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getCanarySetting() {
        return this.jsiiGet("canarySetting", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Stage.CanarySetting`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-canarysetting
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCanarySetting(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("canarySetting", value);
    }

    /**
     * `AWS::ApiGateway::Stage.CanarySetting`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-canarysetting
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setCanarySetting(final software.amazon.awscdk.services.apigateway.CfnStage.CanarySettingProperty value) {
        this.jsiiSet("canarySetting", value);
    }

    /**
     * `AWS::ApiGateway::Stage.ClientCertificateId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-clientcertificateid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getClientCertificateId() {
        return this.jsiiGet("clientCertificateId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Stage.ClientCertificateId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-clientcertificateid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setClientCertificateId(final java.lang.String value) {
        this.jsiiSet("clientCertificateId", value);
    }

    /**
     * `AWS::ApiGateway::Stage.DeploymentId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-deploymentid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getDeploymentId() {
        return this.jsiiGet("deploymentId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Stage.DeploymentId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-deploymentid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDeploymentId(final java.lang.String value) {
        this.jsiiSet("deploymentId", value);
    }

    /**
     * `AWS::ApiGateway::Stage.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getDescription() {
        return this.jsiiGet("description", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Stage.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDescription(final java.lang.String value) {
        this.jsiiSet("description", value);
    }

    /**
     * `AWS::ApiGateway::Stage.DocumentationVersion`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-documentationversion
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getDocumentationVersion() {
        return this.jsiiGet("documentationVersion", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Stage.DocumentationVersion`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-documentationversion
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDocumentationVersion(final java.lang.String value) {
        this.jsiiSet("documentationVersion", value);
    }

    /**
     * `AWS::ApiGateway::Stage.MethodSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-methodsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getMethodSettings() {
        return this.jsiiGet("methodSettings", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Stage.MethodSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-methodsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMethodSettings(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("methodSettings", value);
    }

    /**
     * `AWS::ApiGateway::Stage.MethodSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-methodsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMethodSettings(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("methodSettings", value);
    }

    /**
     * `AWS::ApiGateway::Stage.StageName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-stagename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getStageName() {
        return this.jsiiGet("stageName", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Stage.StageName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-stagename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setStageName(final java.lang.String value) {
        this.jsiiSet("stageName", value);
    }

    /**
     * `AWS::ApiGateway::Stage.TracingEnabled`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-tracingenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getTracingEnabled() {
        return this.jsiiGet("tracingEnabled", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Stage.TracingEnabled`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-tracingenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTracingEnabled(final java.lang.Boolean value) {
        this.jsiiSet("tracingEnabled", value);
    }

    /**
     * `AWS::ApiGateway::Stage.TracingEnabled`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-tracingenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setTracingEnabled(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("tracingEnabled", value);
    }

    /**
     * `AWS::ApiGateway::Stage.Variables`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-variables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getVariables() {
        return this.jsiiGet("variables", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Stage.Variables`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-variables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVariables(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("variables", value);
    }

    /**
     * `AWS::ApiGateway::Stage.Variables`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-variables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setVariables(final java.util.Map<java.lang.String, java.lang.String> value) {
        this.jsiiSet("variables", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnStage.AccessLogSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessLogSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface AccessLogSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStage.AccessLogSettingProperty.DestinationArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-destinationarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getDestinationArn() {
            return null;
        }

        /**
         * `CfnStage.AccessLogSettingProperty.Format`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-accesslogsetting.html#cfn-apigateway-stage-accesslogsetting-format
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String destinationArn;
            private java.lang.String format;

            /**
             * Sets the value of DestinationArn
             * @param destinationArn `CfnStage.AccessLogSettingProperty.DestinationArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder destinationArn(java.lang.String destinationArn) {
                this.destinationArn = destinationArn;
                return this;
            }

            /**
             * Sets the value of Format
             * @param format `CfnStage.AccessLogSettingProperty.Format`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessLogSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public AccessLogSettingProperty build() {
                return new Jsii$Proxy(destinationArn, format);
            }
        }

        /**
         * An implementation for {@link AccessLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessLogSettingProperty {
            private final java.lang.String destinationArn;
            private final java.lang.String format;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationArn = this.jsiiGet("destinationArn", java.lang.String.class);
                this.format = this.jsiiGet("format", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String destinationArn, final java.lang.String format) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationArn = destinationArn;
                this.format = format;
            }

            @Override
            public java.lang.String getDestinationArn() {
                return this.destinationArn;
            }

            @Override
            public java.lang.String getFormat() {
                return this.format;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinationArn() != null) {
                    data.set("destinationArn", om.valueToTree(this.getDestinationArn()));
                }
                if (this.getFormat() != null) {
                    data.set("format", om.valueToTree(this.getFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnStage.AccessLogSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessLogSettingProperty.Jsii$Proxy that = (AccessLogSettingProperty.Jsii$Proxy) o;

                if (this.destinationArn != null ? !this.destinationArn.equals(that.destinationArn) : that.destinationArn != null) return false;
                return this.format != null ? this.format.equals(that.format) : that.format == null;
            }

            @Override
            public int hashCode() {
                int result = this.destinationArn != null ? this.destinationArn.hashCode() : 0;
                result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnStage.CanarySettingProperty")
    @software.amazon.jsii.Jsii.Proxy(CanarySettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface CanarySettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStage.CanarySettingProperty.DeploymentId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-deploymentid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getDeploymentId() {
            return null;
        }

        /**
         * `CfnStage.CanarySettingProperty.PercentTraffic`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-percenttraffic
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Number getPercentTraffic() {
            return null;
        }

        /**
         * `CfnStage.CanarySettingProperty.StageVariableOverrides`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-stagevariableoverrides
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getStageVariableOverrides() {
            return null;
        }

        /**
         * `CfnStage.CanarySettingProperty.UseStageCache`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-stage-canarysetting.html#cfn-apigateway-stage-canarysetting-usestagecache
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getUseStageCache() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CanarySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CanarySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String deploymentId;
            private java.lang.Number percentTraffic;
            private java.lang.Object stageVariableOverrides;
            private java.lang.Object useStageCache;

            /**
             * Sets the value of DeploymentId
             * @param deploymentId `CfnStage.CanarySettingProperty.DeploymentId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder deploymentId(java.lang.String deploymentId) {
                this.deploymentId = deploymentId;
                return this;
            }

            /**
             * Sets the value of PercentTraffic
             * @param percentTraffic `CfnStage.CanarySettingProperty.PercentTraffic`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder percentTraffic(java.lang.Number percentTraffic) {
                this.percentTraffic = percentTraffic;
                return this;
            }

            /**
             * Sets the value of StageVariableOverrides
             * @param stageVariableOverrides `CfnStage.CanarySettingProperty.StageVariableOverrides`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder stageVariableOverrides(software.amazon.awscdk.core.IResolvable stageVariableOverrides) {
                this.stageVariableOverrides = stageVariableOverrides;
                return this;
            }

            /**
             * Sets the value of StageVariableOverrides
             * @param stageVariableOverrides `CfnStage.CanarySettingProperty.StageVariableOverrides`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder stageVariableOverrides(java.util.Map<java.lang.String, java.lang.String> stageVariableOverrides) {
                this.stageVariableOverrides = stageVariableOverrides;
                return this;
            }

            /**
             * Sets the value of UseStageCache
             * @param useStageCache `CfnStage.CanarySettingProperty.UseStageCache`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder useStageCache(java.lang.Boolean useStageCache) {
                this.useStageCache = useStageCache;
                return this;
            }

            /**
             * Sets the value of UseStageCache
             * @param useStageCache `CfnStage.CanarySettingProperty.UseStageCache`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder useStageCache(software.amazon.awscdk.core.IResolvable useStageCache) {
                this.useStageCache = useStageCache;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CanarySettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public CanarySettingProperty build() {
                return new Jsii$Proxy(deploymentId, percentTraffic, stageVariableOverrides, useStageCache);
            }
        }

        /**
         * An implementation for {@link CanarySettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CanarySettingProperty {
            private final java.lang.String deploymentId;
            private final java.lang.Number percentTraffic;
            private final java.lang.Object stageVariableOverrides;
            private final java.lang.Object useStageCache;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deploymentId = this.jsiiGet("deploymentId", java.lang.String.class);
                this.percentTraffic = this.jsiiGet("percentTraffic", java.lang.Number.class);
                this.stageVariableOverrides = this.jsiiGet("stageVariableOverrides", java.lang.Object.class);
                this.useStageCache = this.jsiiGet("useStageCache", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String deploymentId, final java.lang.Number percentTraffic, final java.lang.Object stageVariableOverrides, final java.lang.Object useStageCache) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deploymentId = deploymentId;
                this.percentTraffic = percentTraffic;
                this.stageVariableOverrides = stageVariableOverrides;
                this.useStageCache = useStageCache;
            }

            @Override
            public java.lang.String getDeploymentId() {
                return this.deploymentId;
            }

            @Override
            public java.lang.Number getPercentTraffic() {
                return this.percentTraffic;
            }

            @Override
            public java.lang.Object getStageVariableOverrides() {
                return this.stageVariableOverrides;
            }

            @Override
            public java.lang.Object getUseStageCache() {
                return this.useStageCache;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeploymentId() != null) {
                    data.set("deploymentId", om.valueToTree(this.getDeploymentId()));
                }
                if (this.getPercentTraffic() != null) {
                    data.set("percentTraffic", om.valueToTree(this.getPercentTraffic()));
                }
                if (this.getStageVariableOverrides() != null) {
                    data.set("stageVariableOverrides", om.valueToTree(this.getStageVariableOverrides()));
                }
                if (this.getUseStageCache() != null) {
                    data.set("useStageCache", om.valueToTree(this.getUseStageCache()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnStage.CanarySettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CanarySettingProperty.Jsii$Proxy that = (CanarySettingProperty.Jsii$Proxy) o;

                if (this.deploymentId != null ? !this.deploymentId.equals(that.deploymentId) : that.deploymentId != null) return false;
                if (this.percentTraffic != null ? !this.percentTraffic.equals(that.percentTraffic) : that.percentTraffic != null) return false;
                if (this.stageVariableOverrides != null ? !this.stageVariableOverrides.equals(that.stageVariableOverrides) : that.stageVariableOverrides != null) return false;
                return this.useStageCache != null ? this.useStageCache.equals(that.useStageCache) : that.useStageCache == null;
            }

            @Override
            public int hashCode() {
                int result = this.deploymentId != null ? this.deploymentId.hashCode() : 0;
                result = 31 * result + (this.percentTraffic != null ? this.percentTraffic.hashCode() : 0);
                result = 31 * result + (this.stageVariableOverrides != null ? this.stageVariableOverrides.hashCode() : 0);
                result = 31 * result + (this.useStageCache != null ? this.useStageCache.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnStage.MethodSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(MethodSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface MethodSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnStage.MethodSettingProperty.CacheDataEncrypted`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachedataencrypted
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getCacheDataEncrypted() {
            return null;
        }

        /**
         * `CfnStage.MethodSettingProperty.CacheTtlInSeconds`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachettlinseconds
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Number getCacheTtlInSeconds() {
            return null;
        }

        /**
         * `CfnStage.MethodSettingProperty.CachingEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachingenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getCachingEnabled() {
            return null;
        }

        /**
         * `CfnStage.MethodSettingProperty.DataTraceEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-datatraceenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getDataTraceEnabled() {
            return null;
        }

        /**
         * `CfnStage.MethodSettingProperty.HttpMethod`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-httpmethod
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getHttpMethod() {
            return null;
        }

        /**
         * `CfnStage.MethodSettingProperty.LoggingLevel`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-logginglevel
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getLoggingLevel() {
            return null;
        }

        /**
         * `CfnStage.MethodSettingProperty.MetricsEnabled`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-metricsenabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Object getMetricsEnabled() {
            return null;
        }

        /**
         * `CfnStage.MethodSettingProperty.ResourcePath`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-resourcepath
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.String getResourcePath() {
            return null;
        }

        /**
         * `CfnStage.MethodSettingProperty.ThrottlingBurstLimit`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingburstlimit
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Number getThrottlingBurstLimit() {
            return null;
        }

        /**
         * `CfnStage.MethodSettingProperty.ThrottlingRateLimit`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingratelimit
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        default java.lang.Number getThrottlingRateLimit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MethodSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MethodSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.Object cacheDataEncrypted;
            private java.lang.Number cacheTtlInSeconds;
            private java.lang.Object cachingEnabled;
            private java.lang.Object dataTraceEnabled;
            private java.lang.String httpMethod;
            private java.lang.String loggingLevel;
            private java.lang.Object metricsEnabled;
            private java.lang.String resourcePath;
            private java.lang.Number throttlingBurstLimit;
            private java.lang.Number throttlingRateLimit;

            /**
             * Sets the value of CacheDataEncrypted
             * @param cacheDataEncrypted `CfnStage.MethodSettingProperty.CacheDataEncrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cacheDataEncrypted(java.lang.Boolean cacheDataEncrypted) {
                this.cacheDataEncrypted = cacheDataEncrypted;
                return this;
            }

            /**
             * Sets the value of CacheDataEncrypted
             * @param cacheDataEncrypted `CfnStage.MethodSettingProperty.CacheDataEncrypted`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cacheDataEncrypted(software.amazon.awscdk.core.IResolvable cacheDataEncrypted) {
                this.cacheDataEncrypted = cacheDataEncrypted;
                return this;
            }

            /**
             * Sets the value of CacheTtlInSeconds
             * @param cacheTtlInSeconds `CfnStage.MethodSettingProperty.CacheTtlInSeconds`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cacheTtlInSeconds(java.lang.Number cacheTtlInSeconds) {
                this.cacheTtlInSeconds = cacheTtlInSeconds;
                return this;
            }

            /**
             * Sets the value of CachingEnabled
             * @param cachingEnabled `CfnStage.MethodSettingProperty.CachingEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cachingEnabled(java.lang.Boolean cachingEnabled) {
                this.cachingEnabled = cachingEnabled;
                return this;
            }

            /**
             * Sets the value of CachingEnabled
             * @param cachingEnabled `CfnStage.MethodSettingProperty.CachingEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cachingEnabled(software.amazon.awscdk.core.IResolvable cachingEnabled) {
                this.cachingEnabled = cachingEnabled;
                return this;
            }

            /**
             * Sets the value of DataTraceEnabled
             * @param dataTraceEnabled `CfnStage.MethodSettingProperty.DataTraceEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder dataTraceEnabled(java.lang.Boolean dataTraceEnabled) {
                this.dataTraceEnabled = dataTraceEnabled;
                return this;
            }

            /**
             * Sets the value of DataTraceEnabled
             * @param dataTraceEnabled `CfnStage.MethodSettingProperty.DataTraceEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder dataTraceEnabled(software.amazon.awscdk.core.IResolvable dataTraceEnabled) {
                this.dataTraceEnabled = dataTraceEnabled;
                return this;
            }

            /**
             * Sets the value of HttpMethod
             * @param httpMethod `CfnStage.MethodSettingProperty.HttpMethod`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder httpMethod(java.lang.String httpMethod) {
                this.httpMethod = httpMethod;
                return this;
            }

            /**
             * Sets the value of LoggingLevel
             * @param loggingLevel `CfnStage.MethodSettingProperty.LoggingLevel`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder loggingLevel(java.lang.String loggingLevel) {
                this.loggingLevel = loggingLevel;
                return this;
            }

            /**
             * Sets the value of MetricsEnabled
             * @param metricsEnabled `CfnStage.MethodSettingProperty.MetricsEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder metricsEnabled(java.lang.Boolean metricsEnabled) {
                this.metricsEnabled = metricsEnabled;
                return this;
            }

            /**
             * Sets the value of MetricsEnabled
             * @param metricsEnabled `CfnStage.MethodSettingProperty.MetricsEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder metricsEnabled(software.amazon.awscdk.core.IResolvable metricsEnabled) {
                this.metricsEnabled = metricsEnabled;
                return this;
            }

            /**
             * Sets the value of ResourcePath
             * @param resourcePath `CfnStage.MethodSettingProperty.ResourcePath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder resourcePath(java.lang.String resourcePath) {
                this.resourcePath = resourcePath;
                return this;
            }

            /**
             * Sets the value of ThrottlingBurstLimit
             * @param throttlingBurstLimit `CfnStage.MethodSettingProperty.ThrottlingBurstLimit`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder throttlingBurstLimit(java.lang.Number throttlingBurstLimit) {
                this.throttlingBurstLimit = throttlingBurstLimit;
                return this;
            }

            /**
             * Sets the value of ThrottlingRateLimit
             * @param throttlingRateLimit `CfnStage.MethodSettingProperty.ThrottlingRateLimit`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder throttlingRateLimit(java.lang.Number throttlingRateLimit) {
                this.throttlingRateLimit = throttlingRateLimit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MethodSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public MethodSettingProperty build() {
                return new Jsii$Proxy(cacheDataEncrypted, cacheTtlInSeconds, cachingEnabled, dataTraceEnabled, httpMethod, loggingLevel, metricsEnabled, resourcePath, throttlingBurstLimit, throttlingRateLimit);
            }
        }

        /**
         * An implementation for {@link MethodSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MethodSettingProperty {
            private final java.lang.Object cacheDataEncrypted;
            private final java.lang.Number cacheTtlInSeconds;
            private final java.lang.Object cachingEnabled;
            private final java.lang.Object dataTraceEnabled;
            private final java.lang.String httpMethod;
            private final java.lang.String loggingLevel;
            private final java.lang.Object metricsEnabled;
            private final java.lang.String resourcePath;
            private final java.lang.Number throttlingBurstLimit;
            private final java.lang.Number throttlingRateLimit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cacheDataEncrypted = this.jsiiGet("cacheDataEncrypted", java.lang.Object.class);
                this.cacheTtlInSeconds = this.jsiiGet("cacheTtlInSeconds", java.lang.Number.class);
                this.cachingEnabled = this.jsiiGet("cachingEnabled", java.lang.Object.class);
                this.dataTraceEnabled = this.jsiiGet("dataTraceEnabled", java.lang.Object.class);
                this.httpMethod = this.jsiiGet("httpMethod", java.lang.String.class);
                this.loggingLevel = this.jsiiGet("loggingLevel", java.lang.String.class);
                this.metricsEnabled = this.jsiiGet("metricsEnabled", java.lang.Object.class);
                this.resourcePath = this.jsiiGet("resourcePath", java.lang.String.class);
                this.throttlingBurstLimit = this.jsiiGet("throttlingBurstLimit", java.lang.Number.class);
                this.throttlingRateLimit = this.jsiiGet("throttlingRateLimit", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object cacheDataEncrypted, final java.lang.Number cacheTtlInSeconds, final java.lang.Object cachingEnabled, final java.lang.Object dataTraceEnabled, final java.lang.String httpMethod, final java.lang.String loggingLevel, final java.lang.Object metricsEnabled, final java.lang.String resourcePath, final java.lang.Number throttlingBurstLimit, final java.lang.Number throttlingRateLimit) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cacheDataEncrypted = cacheDataEncrypted;
                this.cacheTtlInSeconds = cacheTtlInSeconds;
                this.cachingEnabled = cachingEnabled;
                this.dataTraceEnabled = dataTraceEnabled;
                this.httpMethod = httpMethod;
                this.loggingLevel = loggingLevel;
                this.metricsEnabled = metricsEnabled;
                this.resourcePath = resourcePath;
                this.throttlingBurstLimit = throttlingBurstLimit;
                this.throttlingRateLimit = throttlingRateLimit;
            }

            @Override
            public java.lang.Object getCacheDataEncrypted() {
                return this.cacheDataEncrypted;
            }

            @Override
            public java.lang.Number getCacheTtlInSeconds() {
                return this.cacheTtlInSeconds;
            }

            @Override
            public java.lang.Object getCachingEnabled() {
                return this.cachingEnabled;
            }

            @Override
            public java.lang.Object getDataTraceEnabled() {
                return this.dataTraceEnabled;
            }

            @Override
            public java.lang.String getHttpMethod() {
                return this.httpMethod;
            }

            @Override
            public java.lang.String getLoggingLevel() {
                return this.loggingLevel;
            }

            @Override
            public java.lang.Object getMetricsEnabled() {
                return this.metricsEnabled;
            }

            @Override
            public java.lang.String getResourcePath() {
                return this.resourcePath;
            }

            @Override
            public java.lang.Number getThrottlingBurstLimit() {
                return this.throttlingBurstLimit;
            }

            @Override
            public java.lang.Number getThrottlingRateLimit() {
                return this.throttlingRateLimit;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCacheDataEncrypted() != null) {
                    data.set("cacheDataEncrypted", om.valueToTree(this.getCacheDataEncrypted()));
                }
                if (this.getCacheTtlInSeconds() != null) {
                    data.set("cacheTtlInSeconds", om.valueToTree(this.getCacheTtlInSeconds()));
                }
                if (this.getCachingEnabled() != null) {
                    data.set("cachingEnabled", om.valueToTree(this.getCachingEnabled()));
                }
                if (this.getDataTraceEnabled() != null) {
                    data.set("dataTraceEnabled", om.valueToTree(this.getDataTraceEnabled()));
                }
                if (this.getHttpMethod() != null) {
                    data.set("httpMethod", om.valueToTree(this.getHttpMethod()));
                }
                if (this.getLoggingLevel() != null) {
                    data.set("loggingLevel", om.valueToTree(this.getLoggingLevel()));
                }
                if (this.getMetricsEnabled() != null) {
                    data.set("metricsEnabled", om.valueToTree(this.getMetricsEnabled()));
                }
                if (this.getResourcePath() != null) {
                    data.set("resourcePath", om.valueToTree(this.getResourcePath()));
                }
                if (this.getThrottlingBurstLimit() != null) {
                    data.set("throttlingBurstLimit", om.valueToTree(this.getThrottlingBurstLimit()));
                }
                if (this.getThrottlingRateLimit() != null) {
                    data.set("throttlingRateLimit", om.valueToTree(this.getThrottlingRateLimit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnStage.MethodSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MethodSettingProperty.Jsii$Proxy that = (MethodSettingProperty.Jsii$Proxy) o;

                if (this.cacheDataEncrypted != null ? !this.cacheDataEncrypted.equals(that.cacheDataEncrypted) : that.cacheDataEncrypted != null) return false;
                if (this.cacheTtlInSeconds != null ? !this.cacheTtlInSeconds.equals(that.cacheTtlInSeconds) : that.cacheTtlInSeconds != null) return false;
                if (this.cachingEnabled != null ? !this.cachingEnabled.equals(that.cachingEnabled) : that.cachingEnabled != null) return false;
                if (this.dataTraceEnabled != null ? !this.dataTraceEnabled.equals(that.dataTraceEnabled) : that.dataTraceEnabled != null) return false;
                if (this.httpMethod != null ? !this.httpMethod.equals(that.httpMethod) : that.httpMethod != null) return false;
                if (this.loggingLevel != null ? !this.loggingLevel.equals(that.loggingLevel) : that.loggingLevel != null) return false;
                if (this.metricsEnabled != null ? !this.metricsEnabled.equals(that.metricsEnabled) : that.metricsEnabled != null) return false;
                if (this.resourcePath != null ? !this.resourcePath.equals(that.resourcePath) : that.resourcePath != null) return false;
                if (this.throttlingBurstLimit != null ? !this.throttlingBurstLimit.equals(that.throttlingBurstLimit) : that.throttlingBurstLimit != null) return false;
                return this.throttlingRateLimit != null ? this.throttlingRateLimit.equals(that.throttlingRateLimit) : that.throttlingRateLimit == null;
            }

            @Override
            public int hashCode() {
                int result = this.cacheDataEncrypted != null ? this.cacheDataEncrypted.hashCode() : 0;
                result = 31 * result + (this.cacheTtlInSeconds != null ? this.cacheTtlInSeconds.hashCode() : 0);
                result = 31 * result + (this.cachingEnabled != null ? this.cachingEnabled.hashCode() : 0);
                result = 31 * result + (this.dataTraceEnabled != null ? this.dataTraceEnabled.hashCode() : 0);
                result = 31 * result + (this.httpMethod != null ? this.httpMethod.hashCode() : 0);
                result = 31 * result + (this.loggingLevel != null ? this.loggingLevel.hashCode() : 0);
                result = 31 * result + (this.metricsEnabled != null ? this.metricsEnabled.hashCode() : 0);
                result = 31 * result + (this.resourcePath != null ? this.resourcePath.hashCode() : 0);
                result = 31 * result + (this.throttlingBurstLimit != null ? this.throttlingBurstLimit.hashCode() : 0);
                result = 31 * result + (this.throttlingRateLimit != null ? this.throttlingRateLimit.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.CfnStage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.CfnStageProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.CfnStageProps.Builder();
        }

        /**
         * @return {@code this}
         * @param restApiId `AWS::ApiGateway::Stage.RestApiId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder restApiId(final java.lang.String restApiId) {
            this.props.restApiId(restApiId);
            return this;
        }

        /**
         * @return {@code this}
         * @param accessLogSetting `AWS::ApiGateway::Stage.AccessLogSetting`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder accessLogSetting(final software.amazon.awscdk.core.IResolvable accessLogSetting) {
            this.props.accessLogSetting(accessLogSetting);
            return this;
        }
        /**
         * @return {@code this}
         * @param accessLogSetting `AWS::ApiGateway::Stage.AccessLogSetting`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder accessLogSetting(final software.amazon.awscdk.services.apigateway.CfnStage.AccessLogSettingProperty accessLogSetting) {
            this.props.accessLogSetting(accessLogSetting);
            return this;
        }

        /**
         * @return {@code this}
         * @param cacheClusterEnabled `AWS::ApiGateway::Stage.CacheClusterEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cacheClusterEnabled(final java.lang.Boolean cacheClusterEnabled) {
            this.props.cacheClusterEnabled(cacheClusterEnabled);
            return this;
        }
        /**
         * @return {@code this}
         * @param cacheClusterEnabled `AWS::ApiGateway::Stage.CacheClusterEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cacheClusterEnabled(final software.amazon.awscdk.core.IResolvable cacheClusterEnabled) {
            this.props.cacheClusterEnabled(cacheClusterEnabled);
            return this;
        }

        /**
         * @return {@code this}
         * @param cacheClusterSize `AWS::ApiGateway::Stage.CacheClusterSize`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cacheClusterSize(final java.lang.String cacheClusterSize) {
            this.props.cacheClusterSize(cacheClusterSize);
            return this;
        }

        /**
         * @return {@code this}
         * @param canarySetting `AWS::ApiGateway::Stage.CanarySetting`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder canarySetting(final software.amazon.awscdk.core.IResolvable canarySetting) {
            this.props.canarySetting(canarySetting);
            return this;
        }
        /**
         * @return {@code this}
         * @param canarySetting `AWS::ApiGateway::Stage.CanarySetting`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder canarySetting(final software.amazon.awscdk.services.apigateway.CfnStage.CanarySettingProperty canarySetting) {
            this.props.canarySetting(canarySetting);
            return this;
        }

        /**
         * @return {@code this}
         * @param clientCertificateId `AWS::ApiGateway::Stage.ClientCertificateId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder clientCertificateId(final java.lang.String clientCertificateId) {
            this.props.clientCertificateId(clientCertificateId);
            return this;
        }

        /**
         * @return {@code this}
         * @param deploymentId `AWS::ApiGateway::Stage.DeploymentId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder deploymentId(final java.lang.String deploymentId) {
            this.props.deploymentId(deploymentId);
            return this;
        }

        /**
         * @return {@code this}
         * @param description `AWS::ApiGateway::Stage.Description`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @return {@code this}
         * @param documentationVersion `AWS::ApiGateway::Stage.DocumentationVersion`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder documentationVersion(final java.lang.String documentationVersion) {
            this.props.documentationVersion(documentationVersion);
            return this;
        }

        /**
         * @return {@code this}
         * @param methodSettings `AWS::ApiGateway::Stage.MethodSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder methodSettings(final software.amazon.awscdk.core.IResolvable methodSettings) {
            this.props.methodSettings(methodSettings);
            return this;
        }
        /**
         * @return {@code this}
         * @param methodSettings `AWS::ApiGateway::Stage.MethodSettings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder methodSettings(final java.util.List<java.lang.Object> methodSettings) {
            this.props.methodSettings(methodSettings);
            return this;
        }

        /**
         * @return {@code this}
         * @param stageName `AWS::ApiGateway::Stage.StageName`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder stageName(final java.lang.String stageName) {
            this.props.stageName(stageName);
            return this;
        }

        /**
         * @return {@code this}
         * @param tags `AWS::ApiGateway::Stage.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return {@code this}
         * @param tracingEnabled `AWS::ApiGateway::Stage.TracingEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tracingEnabled(final java.lang.Boolean tracingEnabled) {
            this.props.tracingEnabled(tracingEnabled);
            return this;
        }
        /**
         * @return {@code this}
         * @param tracingEnabled `AWS::ApiGateway::Stage.TracingEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tracingEnabled(final software.amazon.awscdk.core.IResolvable tracingEnabled) {
            this.props.tracingEnabled(tracingEnabled);
            return this;
        }

        /**
         * @return {@code this}
         * @param variables `AWS::ApiGateway::Stage.Variables`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder variables(final software.amazon.awscdk.core.IResolvable variables) {
            this.props.variables(variables);
            return this;
        }
        /**
         * @return {@code this}
         * @param variables `AWS::ApiGateway::Stage.Variables`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder variables(final java.util.Map<java.lang.String, java.lang.String> variables) {
            this.props.variables(variables);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.CfnStage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public software.amazon.awscdk.services.apigateway.CfnStage build() {
            return new software.amazon.awscdk.services.apigateway.CfnStage(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
