package software.amazon.awscdk.services.apigateway;

/**
 * Defines a {proxy+} greedy resource and an ANY method on a route.
 * 
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-set-up-simple-proxy.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:25.357Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.ProxyResource")
public class ProxyResource extends software.amazon.awscdk.services.apigateway.Resource {

    protected ProxyResource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ProxyResource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ProxyResource(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.apigateway.ProxyResourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Defines a new method for this resource.
     * 
     * @param httpMethod This parameter is required.
     * @param integration
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.apigateway.Method addMethod(final java.lang.String httpMethod, final software.amazon.awscdk.services.apigateway.Integration integration, final software.amazon.awscdk.services.apigateway.MethodOptions options) {
        return this.jsiiCall("addMethod", software.amazon.awscdk.services.apigateway.Method.class, new Object[] { java.util.Objects.requireNonNull(httpMethod, "httpMethod is required"), integration, options });
    }

    /**
     * Defines a new method for this resource.
     * 
     * @param httpMethod This parameter is required.
     * @param integration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.apigateway.Method addMethod(final java.lang.String httpMethod, final software.amazon.awscdk.services.apigateway.Integration integration) {
        return this.jsiiCall("addMethod", software.amazon.awscdk.services.apigateway.Method.class, new Object[] { java.util.Objects.requireNonNull(httpMethod, "httpMethod is required"), integration });
    }

    /**
     * Defines a new method for this resource.
     * 
     * @param httpMethod This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.apigateway.Method addMethod(final java.lang.String httpMethod) {
        return this.jsiiCall("addMethod", software.amazon.awscdk.services.apigateway.Method.class, new Object[] { java.util.Objects.requireNonNull(httpMethod, "httpMethod is required") });
    }

    /**
     * If `props.anyMethod` is `true`, this will be the reference to the 'ANY' method associated with this proxy resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.apigateway.Method getAnyMethod() {
        return this.jsiiGet("anyMethod", software.amazon.awscdk.services.apigateway.Method.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.ProxyResource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.ProxyResourceProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.ProxyResourceProps.Builder();
        }

        /**
         * @return {@code this}
         * @param defaultCorsPreflightOptions Adds a CORS preflight OPTIONS method to this resource and all child resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCorsPreflightOptions(final software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions) {
            this.props.defaultCorsPreflightOptions(defaultCorsPreflightOptions);
            return this;
        }

        /**
         * @return {@code this}
         * @param defaultIntegration An integration to use as a default for all methods created within this API unless an integration is specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultIntegration(final software.amazon.awscdk.services.apigateway.Integration defaultIntegration) {
            this.props.defaultIntegration(defaultIntegration);
            return this;
        }

        /**
         * @return {@code this}
         * @param defaultMethodOptions Method options to use as a default for all methods created within this API unless custom options are specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultMethodOptions(final software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions) {
            this.props.defaultMethodOptions(defaultMethodOptions);
            return this;
        }

        /**
         * @return {@code this}
         * @param anyMethod Adds an "ANY" method to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder anyMethod(final java.lang.Boolean anyMethod) {
            this.props.anyMethod(anyMethod);
            return this;
        }

        /**
         * @return {@code this}
         * @param parent The parent resource of this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parent(final software.amazon.awscdk.services.apigateway.IResource parent) {
            this.props.parent(parent);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.ProxyResource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.apigateway.ProxyResource build() {
            return new software.amazon.awscdk.services.apigateway.ProxyResource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
