package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a `CfnRequestValidator`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * CfnRequestValidatorProps cfnRequestValidatorProps = CfnRequestValidatorProps.builder()
 *         .restApiId("restApiId")
 *         // the properties below are optional
 *         .name("name")
 *         .validateRequestBody(false)
 *         .validateRequestParameters(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-29T04:32:25.239Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnRequestValidatorProps")
@software.amazon.jsii.Jsii.Proxy(CfnRequestValidatorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRequestValidatorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of the targeted API entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRestApiId();

    /**
     * The name of this request validator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Indicates whether to validate the request body according to the configured schema for the targeted API and method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getValidateRequestBody() {
        return null;
    }

    /**
     * Indicates whether to validate request parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getValidateRequestParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRequestValidatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRequestValidatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRequestValidatorProps> {
        java.lang.String restApiId;
        java.lang.String name;
        java.lang.Object validateRequestBody;
        java.lang.Object validateRequestParameters;

        /**
         * Sets the value of {@link CfnRequestValidatorProps#getRestApiId}
         * @param restApiId The identifier of the targeted API entity. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiId(java.lang.String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        /**
         * Sets the value of {@link CfnRequestValidatorProps#getName}
         * @param name The name of this request validator.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnRequestValidatorProps#getValidateRequestBody}
         * @param validateRequestBody Indicates whether to validate the request body according to the configured schema for the targeted API and method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validateRequestBody(java.lang.Boolean validateRequestBody) {
            this.validateRequestBody = validateRequestBody;
            return this;
        }

        /**
         * Sets the value of {@link CfnRequestValidatorProps#getValidateRequestBody}
         * @param validateRequestBody Indicates whether to validate the request body according to the configured schema for the targeted API and method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validateRequestBody(software.amazon.awscdk.core.IResolvable validateRequestBody) {
            this.validateRequestBody = validateRequestBody;
            return this;
        }

        /**
         * Sets the value of {@link CfnRequestValidatorProps#getValidateRequestParameters}
         * @param validateRequestParameters Indicates whether to validate request parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validateRequestParameters(java.lang.Boolean validateRequestParameters) {
            this.validateRequestParameters = validateRequestParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnRequestValidatorProps#getValidateRequestParameters}
         * @param validateRequestParameters Indicates whether to validate request parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validateRequestParameters(software.amazon.awscdk.core.IResolvable validateRequestParameters) {
            this.validateRequestParameters = validateRequestParameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRequestValidatorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRequestValidatorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRequestValidatorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRequestValidatorProps {
        private final java.lang.String restApiId;
        private final java.lang.String name;
        private final java.lang.Object validateRequestBody;
        private final java.lang.Object validateRequestParameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.restApiId = software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.validateRequestBody = software.amazon.jsii.Kernel.get(this, "validateRequestBody", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.validateRequestParameters = software.amazon.jsii.Kernel.get(this, "validateRequestParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.restApiId = java.util.Objects.requireNonNull(builder.restApiId, "restApiId is required");
            this.name = builder.name;
            this.validateRequestBody = builder.validateRequestBody;
            this.validateRequestParameters = builder.validateRequestParameters;
        }

        @Override
        public final java.lang.String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getValidateRequestBody() {
            return this.validateRequestBody;
        }

        @Override
        public final java.lang.Object getValidateRequestParameters() {
            return this.validateRequestParameters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("restApiId", om.valueToTree(this.getRestApiId()));
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getValidateRequestBody() != null) {
                data.set("validateRequestBody", om.valueToTree(this.getValidateRequestBody()));
            }
            if (this.getValidateRequestParameters() != null) {
                data.set("validateRequestParameters", om.valueToTree(this.getValidateRequestParameters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnRequestValidatorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRequestValidatorProps.Jsii$Proxy that = (CfnRequestValidatorProps.Jsii$Proxy) o;

            if (!restApiId.equals(that.restApiId)) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.validateRequestBody != null ? !this.validateRequestBody.equals(that.validateRequestBody) : that.validateRequestBody != null) return false;
            return this.validateRequestParameters != null ? this.validateRequestParameters.equals(that.validateRequestParameters) : that.validateRequestParameters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.restApiId.hashCode();
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.validateRequestBody != null ? this.validateRequestBody.hashCode() : 0);
            result = 31 * result + (this.validateRequestParameters != null ? this.validateRequestParameters.hashCode() : 0);
            return result;
        }
    }
}
