package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * LogGroup logGroup = new LogGroup(this, "ApiGatewayAccessLogs");
 * RestApi api = RestApi.Builder.create(this, "books")
 *         .deployOptions(StageOptions.builder()
 *                 .accessLogDestination(new LogGroupLogDestination(logGroup))
 *                 .accessLogFormat(AccessLogFormat.clf())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-14T20:30:54.129Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.StageOptions")
@software.amazon.jsii.Jsii.Proxy(StageOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StageOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions {

    /**
     * The CloudWatch Logs log group.
     * <p>
     * Default: - No destination
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.IAccessLogDestination getAccessLogDestination() {
        return null;
    }

    /**
     * A single line format of access logs of data, as specified by selected $content variables.
     * <p>
     * The format must include at least <code>AccessLogFormat.contextRequestId()</code>.
     * <p>
     * Default: - Common Log Format
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference">https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.AccessLogFormat getAccessLogFormat() {
        return null;
    }

    /**
     * Indicates whether cache clustering is enabled for the stage.
     * <p>
     * Default: - Disabled for the stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCacheClusterEnabled() {
        return null;
    }

    /**
     * The stage's cache cluster size.
     * <p>
     * Default: 0.5
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCacheClusterSize() {
        return null;
    }

    /**
     * The identifier of the client certificate that API Gateway uses to call your integration endpoints in the stage.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClientCertificateId() {
        return null;
    }

    /**
     * A description of the purpose of the stage.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The version identifier of the API documentation snapshot.
     * <p>
     * Default: - No documentation version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDocumentationVersion() {
        return null;
    }

    /**
     * Method deployment options for specific resources/methods.
     * <p>
     * These will
     * override common options defined in <code>StageOptions#methodOptions</code>.
     * <p>
     * Default: - Common options will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> getMethodOptions() {
        return null;
    }

    /**
     * The name of the stage, which API Gateway uses as the first path segment in the invoked Uniform Resource Identifier (URI).
     * <p>
     * Default: - "prod"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStageName() {
        return null;
    }

    /**
     * Specifies whether Amazon X-Ray tracing is enabled for this method.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getTracingEnabled() {
        return null;
    }

    /**
     * A map that defines the stage variables.
     * <p>
     * Variable names must consist of
     * alphanumeric characters, and the values must match the following regular
     * expression: [A-Za-z0-9-._~:/?#&amp;=,]+.
     * <p>
     * Default: - No stage variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getVariables() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StageOptions> {
        software.amazon.awscdk.services.apigateway.IAccessLogDestination accessLogDestination;
        software.amazon.awscdk.services.apigateway.AccessLogFormat accessLogFormat;
        java.lang.Boolean cacheClusterEnabled;
        java.lang.String cacheClusterSize;
        java.lang.String clientCertificateId;
        java.lang.String description;
        java.lang.String documentationVersion;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> methodOptions;
        java.lang.String stageName;
        java.lang.Boolean tracingEnabled;
        java.util.Map<java.lang.String, java.lang.String> variables;
        java.lang.Boolean cacheDataEncrypted;
        software.amazon.awscdk.core.Duration cacheTtl;
        java.lang.Boolean cachingEnabled;
        java.lang.Boolean dataTraceEnabled;
        software.amazon.awscdk.services.apigateway.MethodLoggingLevel loggingLevel;
        java.lang.Boolean metricsEnabled;
        java.lang.Number throttlingBurstLimit;
        java.lang.Number throttlingRateLimit;

        /**
         * Sets the value of {@link StageOptions#getAccessLogDestination}
         * @param accessLogDestination The CloudWatch Logs log group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLogDestination(software.amazon.awscdk.services.apigateway.IAccessLogDestination accessLogDestination) {
            this.accessLogDestination = accessLogDestination;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getAccessLogFormat}
         * @param accessLogFormat A single line format of access logs of data, as specified by selected $content variables.
         *                        The format must include at least <code>AccessLogFormat.contextRequestId()</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLogFormat(software.amazon.awscdk.services.apigateway.AccessLogFormat accessLogFormat) {
            this.accessLogFormat = accessLogFormat;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getCacheClusterEnabled}
         * @param cacheClusterEnabled Indicates whether cache clustering is enabled for the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheClusterEnabled(java.lang.Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getCacheClusterSize}
         * @param cacheClusterSize The stage's cache cluster size.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheClusterSize(java.lang.String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getClientCertificateId}
         * @param clientCertificateId The identifier of the client certificate that API Gateway uses to call your integration endpoints in the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientCertificateId(java.lang.String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getDescription}
         * @param description A description of the purpose of the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getDocumentationVersion}
         * @param documentationVersion The version identifier of the API documentation snapshot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentationVersion(java.lang.String documentationVersion) {
            this.documentationVersion = documentationVersion;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getMethodOptions}
         * @param methodOptions Method deployment options for specific resources/methods.
         *                      These will
         *                      override common options defined in <code>StageOptions#methodOptions</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder methodOptions(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> methodOptions) {
            this.methodOptions = (java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions>)methodOptions;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getStageName}
         * @param stageName The name of the stage, which API Gateway uses as the first path segment in the invoked Uniform Resource Identifier (URI).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(java.lang.String stageName) {
            this.stageName = stageName;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getTracingEnabled}
         * @param tracingEnabled Specifies whether Amazon X-Ray tracing is enabled for this method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracingEnabled(java.lang.Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getVariables}
         * @param variables A map that defines the stage variables.
         *                  Variable names must consist of
         *                  alphanumeric characters, and the values must match the following regular
         *                  expression: [A-Za-z0-9-._~:/?#&amp;=,]+.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variables(java.util.Map<java.lang.String, java.lang.String> variables) {
            this.variables = variables;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getCacheDataEncrypted}
         * @param cacheDataEncrypted Indicates whether the cached responses are encrypted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheDataEncrypted(java.lang.Boolean cacheDataEncrypted) {
            this.cacheDataEncrypted = cacheDataEncrypted;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getCacheTtl}
         * @param cacheTtl Specifies the time to live (TTL), in seconds, for cached responses.
         *                 The
         *                 higher the TTL, the longer the response will be cached.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheTtl(software.amazon.awscdk.core.Duration cacheTtl) {
            this.cacheTtl = cacheTtl;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getCachingEnabled}
         * @param cachingEnabled Specifies whether responses should be cached and returned for requests.
         *                       A
         *                       cache cluster must be enabled on the stage for responses to be cached.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachingEnabled(java.lang.Boolean cachingEnabled) {
            this.cachingEnabled = cachingEnabled;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getDataTraceEnabled}
         * @param dataTraceEnabled Specifies whether data trace logging is enabled for this method.
         *                         When enabled, API gateway will log the full API requests and responses.
         *                         This can be useful to troubleshoot APIs, but can result in logging sensitive data.
         *                         We recommend that you don't enable this feature for production APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataTraceEnabled(java.lang.Boolean dataTraceEnabled) {
            this.dataTraceEnabled = dataTraceEnabled;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getLoggingLevel}
         * @param loggingLevel Specifies the logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingLevel(software.amazon.awscdk.services.apigateway.MethodLoggingLevel loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getMetricsEnabled}
         * @param metricsEnabled Specifies whether Amazon CloudWatch metrics are enabled for this method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsEnabled(java.lang.Boolean metricsEnabled) {
            this.metricsEnabled = metricsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getThrottlingBurstLimit}
         * @param throttlingBurstLimit Specifies the throttling burst limit.
         *                             The total rate of all requests in your AWS account is limited to 5,000 requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttlingBurstLimit(java.lang.Number throttlingBurstLimit) {
            this.throttlingBurstLimit = throttlingBurstLimit;
            return this;
        }

        /**
         * Sets the value of {@link StageOptions#getThrottlingRateLimit}
         * @param throttlingRateLimit Specifies the throttling rate limit.
         *                            The total rate of all requests in your AWS account is limited to 10,000 requests per second (rps).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttlingRateLimit(java.lang.Number throttlingRateLimit) {
            this.throttlingRateLimit = throttlingRateLimit;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StageOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StageOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StageOptions {
        private final software.amazon.awscdk.services.apigateway.IAccessLogDestination accessLogDestination;
        private final software.amazon.awscdk.services.apigateway.AccessLogFormat accessLogFormat;
        private final java.lang.Boolean cacheClusterEnabled;
        private final java.lang.String cacheClusterSize;
        private final java.lang.String clientCertificateId;
        private final java.lang.String description;
        private final java.lang.String documentationVersion;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> methodOptions;
        private final java.lang.String stageName;
        private final java.lang.Boolean tracingEnabled;
        private final java.util.Map<java.lang.String, java.lang.String> variables;
        private final java.lang.Boolean cacheDataEncrypted;
        private final software.amazon.awscdk.core.Duration cacheTtl;
        private final java.lang.Boolean cachingEnabled;
        private final java.lang.Boolean dataTraceEnabled;
        private final software.amazon.awscdk.services.apigateway.MethodLoggingLevel loggingLevel;
        private final java.lang.Boolean metricsEnabled;
        private final java.lang.Number throttlingBurstLimit;
        private final java.lang.Number throttlingRateLimit;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessLogDestination = software.amazon.jsii.Kernel.get(this, "accessLogDestination", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IAccessLogDestination.class));
            this.accessLogFormat = software.amazon.jsii.Kernel.get(this, "accessLogFormat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.AccessLogFormat.class));
            this.cacheClusterEnabled = software.amazon.jsii.Kernel.get(this, "cacheClusterEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.cacheClusterSize = software.amazon.jsii.Kernel.get(this, "cacheClusterSize", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clientCertificateId = software.amazon.jsii.Kernel.get(this, "clientCertificateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.documentationVersion = software.amazon.jsii.Kernel.get(this, "documentationVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.methodOptions = software.amazon.jsii.Kernel.get(this, "methodOptions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.MethodDeploymentOptions.class)));
            this.stageName = software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tracingEnabled = software.amazon.jsii.Kernel.get(this, "tracingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.variables = software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cacheDataEncrypted = software.amazon.jsii.Kernel.get(this, "cacheDataEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.cacheTtl = software.amazon.jsii.Kernel.get(this, "cacheTtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.cachingEnabled = software.amazon.jsii.Kernel.get(this, "cachingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.dataTraceEnabled = software.amazon.jsii.Kernel.get(this, "dataTraceEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.loggingLevel = software.amazon.jsii.Kernel.get(this, "loggingLevel", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.MethodLoggingLevel.class));
            this.metricsEnabled = software.amazon.jsii.Kernel.get(this, "metricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.throttlingBurstLimit = software.amazon.jsii.Kernel.get(this, "throttlingBurstLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.throttlingRateLimit = software.amazon.jsii.Kernel.get(this, "throttlingRateLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessLogDestination = builder.accessLogDestination;
            this.accessLogFormat = builder.accessLogFormat;
            this.cacheClusterEnabled = builder.cacheClusterEnabled;
            this.cacheClusterSize = builder.cacheClusterSize;
            this.clientCertificateId = builder.clientCertificateId;
            this.description = builder.description;
            this.documentationVersion = builder.documentationVersion;
            this.methodOptions = (java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions>)builder.methodOptions;
            this.stageName = builder.stageName;
            this.tracingEnabled = builder.tracingEnabled;
            this.variables = builder.variables;
            this.cacheDataEncrypted = builder.cacheDataEncrypted;
            this.cacheTtl = builder.cacheTtl;
            this.cachingEnabled = builder.cachingEnabled;
            this.dataTraceEnabled = builder.dataTraceEnabled;
            this.loggingLevel = builder.loggingLevel;
            this.metricsEnabled = builder.metricsEnabled;
            this.throttlingBurstLimit = builder.throttlingBurstLimit;
            this.throttlingRateLimit = builder.throttlingRateLimit;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.IAccessLogDestination getAccessLogDestination() {
            return this.accessLogDestination;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.AccessLogFormat getAccessLogFormat() {
            return this.accessLogFormat;
        }

        @Override
        public final java.lang.Boolean getCacheClusterEnabled() {
            return this.cacheClusterEnabled;
        }

        @Override
        public final java.lang.String getCacheClusterSize() {
            return this.cacheClusterSize;
        }

        @Override
        public final java.lang.String getClientCertificateId() {
            return this.clientCertificateId;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDocumentationVersion() {
            return this.documentationVersion;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> getMethodOptions() {
            return this.methodOptions;
        }

        @Override
        public final java.lang.String getStageName() {
            return this.stageName;
        }

        @Override
        public final java.lang.Boolean getTracingEnabled() {
            return this.tracingEnabled;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getVariables() {
            return this.variables;
        }

        @Override
        public final java.lang.Boolean getCacheDataEncrypted() {
            return this.cacheDataEncrypted;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getCacheTtl() {
            return this.cacheTtl;
        }

        @Override
        public final java.lang.Boolean getCachingEnabled() {
            return this.cachingEnabled;
        }

        @Override
        public final java.lang.Boolean getDataTraceEnabled() {
            return this.dataTraceEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.MethodLoggingLevel getLoggingLevel() {
            return this.loggingLevel;
        }

        @Override
        public final java.lang.Boolean getMetricsEnabled() {
            return this.metricsEnabled;
        }

        @Override
        public final java.lang.Number getThrottlingBurstLimit() {
            return this.throttlingBurstLimit;
        }

        @Override
        public final java.lang.Number getThrottlingRateLimit() {
            return this.throttlingRateLimit;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccessLogDestination() != null) {
                data.set("accessLogDestination", om.valueToTree(this.getAccessLogDestination()));
            }
            if (this.getAccessLogFormat() != null) {
                data.set("accessLogFormat", om.valueToTree(this.getAccessLogFormat()));
            }
            if (this.getCacheClusterEnabled() != null) {
                data.set("cacheClusterEnabled", om.valueToTree(this.getCacheClusterEnabled()));
            }
            if (this.getCacheClusterSize() != null) {
                data.set("cacheClusterSize", om.valueToTree(this.getCacheClusterSize()));
            }
            if (this.getClientCertificateId() != null) {
                data.set("clientCertificateId", om.valueToTree(this.getClientCertificateId()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDocumentationVersion() != null) {
                data.set("documentationVersion", om.valueToTree(this.getDocumentationVersion()));
            }
            if (this.getMethodOptions() != null) {
                data.set("methodOptions", om.valueToTree(this.getMethodOptions()));
            }
            if (this.getStageName() != null) {
                data.set("stageName", om.valueToTree(this.getStageName()));
            }
            if (this.getTracingEnabled() != null) {
                data.set("tracingEnabled", om.valueToTree(this.getTracingEnabled()));
            }
            if (this.getVariables() != null) {
                data.set("variables", om.valueToTree(this.getVariables()));
            }
            if (this.getCacheDataEncrypted() != null) {
                data.set("cacheDataEncrypted", om.valueToTree(this.getCacheDataEncrypted()));
            }
            if (this.getCacheTtl() != null) {
                data.set("cacheTtl", om.valueToTree(this.getCacheTtl()));
            }
            if (this.getCachingEnabled() != null) {
                data.set("cachingEnabled", om.valueToTree(this.getCachingEnabled()));
            }
            if (this.getDataTraceEnabled() != null) {
                data.set("dataTraceEnabled", om.valueToTree(this.getDataTraceEnabled()));
            }
            if (this.getLoggingLevel() != null) {
                data.set("loggingLevel", om.valueToTree(this.getLoggingLevel()));
            }
            if (this.getMetricsEnabled() != null) {
                data.set("metricsEnabled", om.valueToTree(this.getMetricsEnabled()));
            }
            if (this.getThrottlingBurstLimit() != null) {
                data.set("throttlingBurstLimit", om.valueToTree(this.getThrottlingBurstLimit()));
            }
            if (this.getThrottlingRateLimit() != null) {
                data.set("throttlingRateLimit", om.valueToTree(this.getThrottlingRateLimit()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.StageOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StageOptions.Jsii$Proxy that = (StageOptions.Jsii$Proxy) o;

            if (this.accessLogDestination != null ? !this.accessLogDestination.equals(that.accessLogDestination) : that.accessLogDestination != null) return false;
            if (this.accessLogFormat != null ? !this.accessLogFormat.equals(that.accessLogFormat) : that.accessLogFormat != null) return false;
            if (this.cacheClusterEnabled != null ? !this.cacheClusterEnabled.equals(that.cacheClusterEnabled) : that.cacheClusterEnabled != null) return false;
            if (this.cacheClusterSize != null ? !this.cacheClusterSize.equals(that.cacheClusterSize) : that.cacheClusterSize != null) return false;
            if (this.clientCertificateId != null ? !this.clientCertificateId.equals(that.clientCertificateId) : that.clientCertificateId != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.documentationVersion != null ? !this.documentationVersion.equals(that.documentationVersion) : that.documentationVersion != null) return false;
            if (this.methodOptions != null ? !this.methodOptions.equals(that.methodOptions) : that.methodOptions != null) return false;
            if (this.stageName != null ? !this.stageName.equals(that.stageName) : that.stageName != null) return false;
            if (this.tracingEnabled != null ? !this.tracingEnabled.equals(that.tracingEnabled) : that.tracingEnabled != null) return false;
            if (this.variables != null ? !this.variables.equals(that.variables) : that.variables != null) return false;
            if (this.cacheDataEncrypted != null ? !this.cacheDataEncrypted.equals(that.cacheDataEncrypted) : that.cacheDataEncrypted != null) return false;
            if (this.cacheTtl != null ? !this.cacheTtl.equals(that.cacheTtl) : that.cacheTtl != null) return false;
            if (this.cachingEnabled != null ? !this.cachingEnabled.equals(that.cachingEnabled) : that.cachingEnabled != null) return false;
            if (this.dataTraceEnabled != null ? !this.dataTraceEnabled.equals(that.dataTraceEnabled) : that.dataTraceEnabled != null) return false;
            if (this.loggingLevel != null ? !this.loggingLevel.equals(that.loggingLevel) : that.loggingLevel != null) return false;
            if (this.metricsEnabled != null ? !this.metricsEnabled.equals(that.metricsEnabled) : that.metricsEnabled != null) return false;
            if (this.throttlingBurstLimit != null ? !this.throttlingBurstLimit.equals(that.throttlingBurstLimit) : that.throttlingBurstLimit != null) return false;
            return this.throttlingRateLimit != null ? this.throttlingRateLimit.equals(that.throttlingRateLimit) : that.throttlingRateLimit == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessLogDestination != null ? this.accessLogDestination.hashCode() : 0;
            result = 31 * result + (this.accessLogFormat != null ? this.accessLogFormat.hashCode() : 0);
            result = 31 * result + (this.cacheClusterEnabled != null ? this.cacheClusterEnabled.hashCode() : 0);
            result = 31 * result + (this.cacheClusterSize != null ? this.cacheClusterSize.hashCode() : 0);
            result = 31 * result + (this.clientCertificateId != null ? this.clientCertificateId.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.documentationVersion != null ? this.documentationVersion.hashCode() : 0);
            result = 31 * result + (this.methodOptions != null ? this.methodOptions.hashCode() : 0);
            result = 31 * result + (this.stageName != null ? this.stageName.hashCode() : 0);
            result = 31 * result + (this.tracingEnabled != null ? this.tracingEnabled.hashCode() : 0);
            result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
            result = 31 * result + (this.cacheDataEncrypted != null ? this.cacheDataEncrypted.hashCode() : 0);
            result = 31 * result + (this.cacheTtl != null ? this.cacheTtl.hashCode() : 0);
            result = 31 * result + (this.cachingEnabled != null ? this.cachingEnabled.hashCode() : 0);
            result = 31 * result + (this.dataTraceEnabled != null ? this.dataTraceEnabled.hashCode() : 0);
            result = 31 * result + (this.loggingLevel != null ? this.loggingLevel.hashCode() : 0);
            result = 31 * result + (this.metricsEnabled != null ? this.metricsEnabled.hashCode() : 0);
            result = 31 * result + (this.throttlingBurstLimit != null ? this.throttlingBurstLimit.hashCode() : 0);
            result = 31 * result + (this.throttlingRateLimit != null ? this.throttlingRateLimit.hashCode() : 0);
            return result;
        }
    }
}
