package software.amazon.awscdk.services.apigateway;

/**
 * A CloudFormation `AWS::ApiGateway::UsagePlan`.
 * <p>
 * The <code>AWS::ApiGateway::UsagePlan</code> resource creates a usage plan for deployed APIs. A usage plan sets a target for the throttling and quota limits on individual client API keys. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Creating and Using API Usage Plans in Amazon API Gateway</a> in the <em>API Gateway Developer Guide</em> .
 * <p>
 * In some cases clients can exceed the targets that you set. Don’t rely on usage plans to control costs. Consider using <a href="https://docs.aws.amazon.com/cost-management/latest/userguide/budgets-managing-costs.html">AWS Budgets</a> to monitor costs and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF</a> to manage API requests.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * CfnUsagePlan cfnUsagePlan = CfnUsagePlan.Builder.create(this, "MyCfnUsagePlan")
 *         .apiStages(List.of(ApiStageProperty.builder()
 *                 .apiId("apiId")
 *                 .stage("stage")
 *                 .throttle(Map.of(
 *                         "throttleKey", ThrottleSettingsProperty.builder()
 *                                 .burstLimit(123)
 *                                 .rateLimit(123)
 *                                 .build()))
 *                 .build()))
 *         .description("description")
 *         .quota(QuotaSettingsProperty.builder()
 *                 .limit(123)
 *                 .offset(123)
 *                 .period("period")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .throttle(ThrottleSettingsProperty.builder()
 *                 .burstLimit(123)
 *                 .rateLimit(123)
 *                 .build())
 *         .usagePlanName("usagePlanName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:46.300Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnUsagePlan")
public class CfnUsagePlan extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnUsagePlan(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnUsagePlan(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnUsagePlan.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ApiGateway::UsagePlan`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnUsagePlan(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CfnUsagePlanProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::ApiGateway::UsagePlan`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnUsagePlan(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID for the usage plan.
     * <p>
     * For example: <code>abc123</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of arbitrary tags (key-value pairs) to associate with the usage plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The API stages to associate with this usage plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getApiStages() {
        return software.amazon.jsii.Kernel.get(this, "apiStages", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The API stages to associate with this usage plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApiStages(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "apiStages", value);
    }

    /**
     * The API stages to associate with this usage plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApiStages(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.apigateway.CfnUsagePlan.ApiStageProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.apigateway.CfnUsagePlan.ApiStageProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "apiStages", value);
    }

    /**
     * A description of the usage plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the usage plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Configures the number of requests that users can make within a given interval.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getQuota() {
        return software.amazon.jsii.Kernel.get(this, "quota", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configures the number of requests that users can make within a given interval.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQuota(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "quota", value);
    }

    /**
     * Configures the number of requests that users can make within a given interval.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQuota(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CfnUsagePlan.QuotaSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "quota", value);
    }

    /**
     * Configures the overall request rate (average requests per second) and burst capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getThrottle() {
        return software.amazon.jsii.Kernel.get(this, "throttle", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configures the overall request rate (average requests per second) and burst capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setThrottle(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "throttle", value);
    }

    /**
     * Configures the overall request rate (average requests per second) and burst capacity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setThrottle(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CfnUsagePlan.ThrottleSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "throttle", value);
    }

    /**
     * A name for the usage plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getUsagePlanName() {
        return software.amazon.jsii.Kernel.get(this, "usagePlanName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the usage plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUsagePlanName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "usagePlanName", value);
    }
    /**
     * `ApiStage` is a property of the [AWS::ApiGateway::UsagePlan](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html) resource that specifies which stages and APIs to associate with a usage plan.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigateway.*;
     * ApiStageProperty apiStageProperty = ApiStageProperty.builder()
     *         .apiId("apiId")
     *         .stage("stage")
     *         .throttle(Map.of(
     *                 "throttleKey", ThrottleSettingsProperty.builder()
     *                         .burstLimit(123)
     *                         .rateLimit(123)
     *                         .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnUsagePlan.ApiStageProperty")
    @software.amazon.jsii.Jsii.Proxy(ApiStageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApiStageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of an API that is in the specified `Stage` property that you want to associate with the usage plan.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApiId() {
            return null;
        }

        /**
         * The name of the stage to associate with the usage plan.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStage() {
            return null;
        }

        /**
         * Map containing method-level throttling information for an API stage in a usage plan.
         * <p>
         * The key for the map is the path and method for which to configure custom throttling, for example, "/pets/GET".
         * <p>
         * Duplicates are not allowed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getThrottle() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ApiStageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApiStageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApiStageProperty> {
            java.lang.String apiId;
            java.lang.String stage;
            java.lang.Object throttle;

            /**
             * Sets the value of {@link ApiStageProperty#getApiId}
             * @param apiId The ID of an API that is in the specified `Stage` property that you want to associate with the usage plan.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiId(java.lang.String apiId) {
                this.apiId = apiId;
                return this;
            }

            /**
             * Sets the value of {@link ApiStageProperty#getStage}
             * @param stage The name of the stage to associate with the usage plan.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stage(java.lang.String stage) {
                this.stage = stage;
                return this;
            }

            /**
             * Sets the value of {@link ApiStageProperty#getThrottle}
             * @param throttle Map containing method-level throttling information for an API stage in a usage plan.
             *                 The key for the map is the path and method for which to configure custom throttling, for example, "/pets/GET".
             *                 <p>
             *                 Duplicates are not allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throttle(software.amazon.awscdk.core.IResolvable throttle) {
                this.throttle = throttle;
                return this;
            }

            /**
             * Sets the value of {@link ApiStageProperty#getThrottle}
             * @param throttle Map containing method-level throttling information for an API stage in a usage plan.
             *                 The key for the map is the path and method for which to configure custom throttling, for example, "/pets/GET".
             *                 <p>
             *                 Duplicates are not allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throttle(java.util.Map<java.lang.String, ? extends java.lang.Object> throttle) {
                this.throttle = throttle;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApiStageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApiStageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApiStageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiStageProperty {
            private final java.lang.String apiId;
            private final java.lang.String stage;
            private final java.lang.Object throttle;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apiId = software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stage = software.amazon.jsii.Kernel.get(this, "stage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.throttle = software.amazon.jsii.Kernel.get(this, "throttle", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiId = builder.apiId;
                this.stage = builder.stage;
                this.throttle = builder.throttle;
            }

            @Override
            public final java.lang.String getApiId() {
                return this.apiId;
            }

            @Override
            public final java.lang.String getStage() {
                return this.stage;
            }

            @Override
            public final java.lang.Object getThrottle() {
                return this.throttle;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApiId() != null) {
                    data.set("apiId", om.valueToTree(this.getApiId()));
                }
                if (this.getStage() != null) {
                    data.set("stage", om.valueToTree(this.getStage()));
                }
                if (this.getThrottle() != null) {
                    data.set("throttle", om.valueToTree(this.getThrottle()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnUsagePlan.ApiStageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApiStageProperty.Jsii$Proxy that = (ApiStageProperty.Jsii$Proxy) o;

                if (this.apiId != null ? !this.apiId.equals(that.apiId) : that.apiId != null) return false;
                if (this.stage != null ? !this.stage.equals(that.stage) : that.stage != null) return false;
                return this.throttle != null ? this.throttle.equals(that.throttle) : that.throttle == null;
            }

            @Override
            public final int hashCode() {
                int result = this.apiId != null ? this.apiId.hashCode() : 0;
                result = 31 * result + (this.stage != null ? this.stage.hashCode() : 0);
                result = 31 * result + (this.throttle != null ? this.throttle.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `QuotaSettings` is a property of the [AWS::ApiGateway::UsagePlan](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html) resource that specifies a target for the maximum number of requests users can make to your REST APIs.
     * <p>
     * In some cases clients can exceed the targets that you set. Don’t rely on usage plans to control costs. Consider using <a href="https://docs.aws.amazon.com/cost-management/latest/userguide/budgets-managing-costs.html">AWS Budgets</a> to monitor costs and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF</a> to manage API requests.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigateway.*;
     * QuotaSettingsProperty quotaSettingsProperty = QuotaSettingsProperty.builder()
     *         .limit(123)
     *         .offset(123)
     *         .period("period")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnUsagePlan.QuotaSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(QuotaSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QuotaSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The target maximum number of requests that can be made in a given time period.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLimit() {
            return null;
        }

        /**
         * The day that a time period starts.
         * <p>
         * For example, with a time period of <code>WEEK</code> , an offset of <code>0</code> starts on Sunday, and an offset of <code>1</code> starts on Monday.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOffset() {
            return null;
        }

        /**
         * The time period for which the target maximum limit of requests applies, such as `DAY` or `WEEK` .
         * <p>
         * For valid values, see the period property for the <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_UsagePlan.html">UsagePlan</a> resource in the <em>Amazon API Gateway REST API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPeriod() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link QuotaSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QuotaSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QuotaSettingsProperty> {
            java.lang.Number limit;
            java.lang.Number offset;
            java.lang.String period;

            /**
             * Sets the value of {@link QuotaSettingsProperty#getLimit}
             * @param limit The target maximum number of requests that can be made in a given time period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder limit(java.lang.Number limit) {
                this.limit = limit;
                return this;
            }

            /**
             * Sets the value of {@link QuotaSettingsProperty#getOffset}
             * @param offset The day that a time period starts.
             *               For example, with a time period of <code>WEEK</code> , an offset of <code>0</code> starts on Sunday, and an offset of <code>1</code> starts on Monday.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder offset(java.lang.Number offset) {
                this.offset = offset;
                return this;
            }

            /**
             * Sets the value of {@link QuotaSettingsProperty#getPeriod}
             * @param period The time period for which the target maximum limit of requests applies, such as `DAY` or `WEEK` .
             *               For valid values, see the period property for the <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_UsagePlan.html">UsagePlan</a> resource in the <em>Amazon API Gateway REST API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder period(java.lang.String period) {
                this.period = period;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QuotaSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QuotaSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QuotaSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QuotaSettingsProperty {
            private final java.lang.Number limit;
            private final java.lang.Number offset;
            private final java.lang.String period;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.limit = software.amazon.jsii.Kernel.get(this, "limit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.offset = software.amazon.jsii.Kernel.get(this, "offset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.period = software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.limit = builder.limit;
                this.offset = builder.offset;
                this.period = builder.period;
            }

            @Override
            public final java.lang.Number getLimit() {
                return this.limit;
            }

            @Override
            public final java.lang.Number getOffset() {
                return this.offset;
            }

            @Override
            public final java.lang.String getPeriod() {
                return this.period;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLimit() != null) {
                    data.set("limit", om.valueToTree(this.getLimit()));
                }
                if (this.getOffset() != null) {
                    data.set("offset", om.valueToTree(this.getOffset()));
                }
                if (this.getPeriod() != null) {
                    data.set("period", om.valueToTree(this.getPeriod()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnUsagePlan.QuotaSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QuotaSettingsProperty.Jsii$Proxy that = (QuotaSettingsProperty.Jsii$Proxy) o;

                if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) return false;
                if (this.offset != null ? !this.offset.equals(that.offset) : that.offset != null) return false;
                return this.period != null ? this.period.equals(that.period) : that.period == null;
            }

            @Override
            public final int hashCode() {
                int result = this.limit != null ? this.limit.hashCode() : 0;
                result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
                result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `ThrottleSettings` is a property of the [AWS::ApiGateway::UsagePlan](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html) resource that specifies the overall request rate (average requests per second) and burst capacity when users call your REST APIs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigateway.*;
     * ThrottleSettingsProperty throttleSettingsProperty = ThrottleSettingsProperty.builder()
     *         .burstLimit(123)
     *         .rateLimit(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnUsagePlan.ThrottleSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ThrottleSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ThrottleSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The API target request burst rate limit.
         * <p>
         * This allows more requests through for a period of time than the target rate limit. For more information about request throttling, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html">Manage API Request Throttling</a> in the <em>API Gateway Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBurstLimit() {
            return null;
        }

        /**
         * The API target request steady-state rate limit.
         * <p>
         * For more information about request throttling, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html">Manage API Request Throttling</a> in the <em>API Gateway Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRateLimit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ThrottleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ThrottleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ThrottleSettingsProperty> {
            java.lang.Number burstLimit;
            java.lang.Number rateLimit;

            /**
             * Sets the value of {@link ThrottleSettingsProperty#getBurstLimit}
             * @param burstLimit The API target request burst rate limit.
             *                   This allows more requests through for a period of time than the target rate limit. For more information about request throttling, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html">Manage API Request Throttling</a> in the <em>API Gateway Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder burstLimit(java.lang.Number burstLimit) {
                this.burstLimit = burstLimit;
                return this;
            }

            /**
             * Sets the value of {@link ThrottleSettingsProperty#getRateLimit}
             * @param rateLimit The API target request steady-state rate limit.
             *                  For more information about request throttling, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html">Manage API Request Throttling</a> in the <em>API Gateway Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rateLimit(java.lang.Number rateLimit) {
                this.rateLimit = rateLimit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ThrottleSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ThrottleSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ThrottleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThrottleSettingsProperty {
            private final java.lang.Number burstLimit;
            private final java.lang.Number rateLimit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.burstLimit = software.amazon.jsii.Kernel.get(this, "burstLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.rateLimit = software.amazon.jsii.Kernel.get(this, "rateLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.burstLimit = builder.burstLimit;
                this.rateLimit = builder.rateLimit;
            }

            @Override
            public final java.lang.Number getBurstLimit() {
                return this.burstLimit;
            }

            @Override
            public final java.lang.Number getRateLimit() {
                return this.rateLimit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBurstLimit() != null) {
                    data.set("burstLimit", om.valueToTree(this.getBurstLimit()));
                }
                if (this.getRateLimit() != null) {
                    data.set("rateLimit", om.valueToTree(this.getRateLimit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnUsagePlan.ThrottleSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ThrottleSettingsProperty.Jsii$Proxy that = (ThrottleSettingsProperty.Jsii$Proxy) o;

                if (this.burstLimit != null ? !this.burstLimit.equals(that.burstLimit) : that.burstLimit != null) return false;
                return this.rateLimit != null ? this.rateLimit.equals(that.rateLimit) : that.rateLimit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.burstLimit != null ? this.burstLimit.hashCode() : 0;
                result = 31 * result + (this.rateLimit != null ? this.rateLimit.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.CfnUsagePlan}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.CfnUsagePlan> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.apigateway.CfnUsagePlanProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The API stages to associate with this usage plan.
         * <p>
         * @return {@code this}
         * @param apiStages The API stages to associate with this usage plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiStages(final software.amazon.awscdk.core.IResolvable apiStages) {
            this.props().apiStages(apiStages);
            return this;
        }
        /**
         * The API stages to associate with this usage plan.
         * <p>
         * @return {@code this}
         * @param apiStages The API stages to associate with this usage plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiStages(final java.util.List<? extends java.lang.Object> apiStages) {
            this.props().apiStages(apiStages);
            return this;
        }

        /**
         * A description of the usage plan.
         * <p>
         * @return {@code this}
         * @param description A description of the usage plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * Configures the number of requests that users can make within a given interval.
         * <p>
         * @return {@code this}
         * @param quota Configures the number of requests that users can make within a given interval. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quota(final software.amazon.awscdk.core.IResolvable quota) {
            this.props().quota(quota);
            return this;
        }
        /**
         * Configures the number of requests that users can make within a given interval.
         * <p>
         * @return {@code this}
         * @param quota Configures the number of requests that users can make within a given interval. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quota(final software.amazon.awscdk.services.apigateway.CfnUsagePlan.QuotaSettingsProperty quota) {
            this.props().quota(quota);
            return this;
        }

        /**
         * An array of arbitrary tags (key-value pairs) to associate with the usage plan.
         * <p>
         * @return {@code this}
         * @param tags An array of arbitrary tags (key-value pairs) to associate with the usage plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * Configures the overall request rate (average requests per second) and burst capacity.
         * <p>
         * @return {@code this}
         * @param throttle Configures the overall request rate (average requests per second) and burst capacity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttle(final software.amazon.awscdk.core.IResolvable throttle) {
            this.props().throttle(throttle);
            return this;
        }
        /**
         * Configures the overall request rate (average requests per second) and burst capacity.
         * <p>
         * @return {@code this}
         * @param throttle Configures the overall request rate (average requests per second) and burst capacity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttle(final software.amazon.awscdk.services.apigateway.CfnUsagePlan.ThrottleSettingsProperty throttle) {
            this.props().throttle(throttle);
            return this;
        }

        /**
         * A name for the usage plan.
         * <p>
         * @return {@code this}
         * @param usagePlanName A name for the usage plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usagePlanName(final java.lang.String usagePlanName) {
            this.props().usagePlanName(usagePlanName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.CfnUsagePlan}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.CfnUsagePlan build() {
            return new software.amazon.awscdk.services.apigateway.CfnUsagePlan(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.apigateway.CfnUsagePlanProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.apigateway.CfnUsagePlanProps.Builder();
            }
            return this.props;
        }
    }
}
