package software.amazon.awscdk.services.apigateway;

/**
 * A CloudFormation `AWS::ApiGateway::Method`.
 * <p>
 * The <code>AWS::ApiGateway::Method</code> resource creates API Gateway methods that define the parameters and body that clients must send in their requests.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * CfnMethod cfnMethod = CfnMethod.Builder.create(this, "MyCfnMethod")
 *         .httpMethod("httpMethod")
 *         .resourceId("resourceId")
 *         .restApiId("restApiId")
 *         // the properties below are optional
 *         .apiKeyRequired(false)
 *         .authorizationScopes(List.of("authorizationScopes"))
 *         .authorizationType("authorizationType")
 *         .authorizerId("authorizerId")
 *         .integration(IntegrationProperty.builder()
 *                 .cacheKeyParameters(List.of("cacheKeyParameters"))
 *                 .cacheNamespace("cacheNamespace")
 *                 .connectionId("connectionId")
 *                 .connectionType("connectionType")
 *                 .contentHandling("contentHandling")
 *                 .credentials("credentials")
 *                 .integrationHttpMethod("integrationHttpMethod")
 *                 .integrationResponses(List.of(IntegrationResponseProperty.builder()
 *                         .statusCode("statusCode")
 *                         // the properties below are optional
 *                         .contentHandling("contentHandling")
 *                         .responseParameters(Map.of(
 *                                 "responseParametersKey", "responseParameters"))
 *                         .responseTemplates(Map.of(
 *                                 "responseTemplatesKey", "responseTemplates"))
 *                         .selectionPattern("selectionPattern")
 *                         .build()))
 *                 .passthroughBehavior("passthroughBehavior")
 *                 .requestParameters(Map.of(
 *                         "requestParametersKey", "requestParameters"))
 *                 .requestTemplates(Map.of(
 *                         "requestTemplatesKey", "requestTemplates"))
 *                 .timeoutInMillis(123)
 *                 .type("type")
 *                 .uri("uri")
 *                 .build())
 *         .methodResponses(List.of(MethodResponseProperty.builder()
 *                 .statusCode("statusCode")
 *                 // the properties below are optional
 *                 .responseModels(Map.of(
 *                         "responseModelsKey", "responseModels"))
 *                 .responseParameters(Map.of(
 *                         "responseParametersKey", false))
 *                 .build()))
 *         .operationName("operationName")
 *         .requestModels(Map.of(
 *                 "requestModelsKey", "requestModels"))
 *         .requestParameters(Map.of(
 *                 "requestParametersKey", false))
 *         .requestValidatorId("requestValidatorId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-30T16:29:50.062Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnMethod")
public class CfnMethod extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnMethod(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMethod(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnMethod.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ApiGateway::Method`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMethod(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.CfnMethodProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The HTTP method that clients use to call this method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getHttpMethod() {
        return software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The HTTP method that clients use to call this method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHttpMethod(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "httpMethod", java.util.Objects.requireNonNull(value, "httpMethod is required"));
    }

    /**
     * The ID of an API Gateway [resource](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html) . For root resource methods, specify the `RestApi` root resource ID, such as `{ "Fn::GetAtt": ["MyRestApi", "RootResourceId"] }` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceId() {
        return software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of an API Gateway [resource](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html) . For root resource methods, specify the `RestApi` root resource ID, such as `{ "Fn::GetAtt": ["MyRestApi", "RootResourceId"] }` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceId", java.util.Objects.requireNonNull(value, "resourceId is required"));
    }

    /**
     * The ID of the [RestApi](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html) resource in which API Gateway creates the method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRestApiId() {
        return software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the [RestApi](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html) resource in which API Gateway creates the method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestApiId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "restApiId", java.util.Objects.requireNonNull(value, "restApiId is required"));
    }

    /**
     * Indicates whether the method requires clients to submit a valid API key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getApiKeyRequired() {
        return software.amazon.jsii.Kernel.get(this, "apiKeyRequired", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether the method requires clients to submit a valid API key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApiKeyRequired(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "apiKeyRequired", value);
    }

    /**
     * Indicates whether the method requires clients to submit a valid API key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApiKeyRequired(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "apiKeyRequired", value);
    }

    /**
     * A list of authorization scopes configured on the method.
     * <p>
     * The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes match a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAuthorizationScopes() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "authorizationScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of authorization scopes configured on the method.
     * <p>
     * The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes match a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthorizationScopes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "authorizationScopes", value);
    }

    /**
     * The method's authorization type.
     * <p>
     * This parameter is required. For valid values, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_Method.html">Method</a> in the <em>API Gateway API Reference</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>AuthorizerId</code> property, specify <code>CUSTOM</code> or <code>COGNITO_USER_POOLS</code> for this property.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAuthorizationType() {
        return software.amazon.jsii.Kernel.get(this, "authorizationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The method's authorization type.
     * <p>
     * This parameter is required. For valid values, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_Method.html">Method</a> in the <em>API Gateway API Reference</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>AuthorizerId</code> property, specify <code>CUSTOM</code> or <code>COGNITO_USER_POOLS</code> for this property.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthorizationType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "authorizationType", value);
    }

    /**
     * The identifier of the [authorizer](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html) to use on this method. If you specify this property, specify `CUSTOM` or `COGNITO_USER_POOLS` for the `AuthorizationType` property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerId() {
        return software.amazon.jsii.Kernel.get(this, "authorizerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the [authorizer](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html) to use on this method. If you specify this property, specify `CUSTOM` or `COGNITO_USER_POOLS` for the `AuthorizationType` property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthorizerId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "authorizerId", value);
    }

    /**
     * The backend system that the method calls when it receives a request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIntegration() {
        return software.amazon.jsii.Kernel.get(this, "integration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The backend system that the method calls when it receives a request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIntegration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "integration", value);
    }

    /**
     * The backend system that the method calls when it receives a request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIntegration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CfnMethod.IntegrationProperty value) {
        software.amazon.jsii.Kernel.set(this, "integration", value);
    }

    /**
     * The responses that can be sent to the client who calls the method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMethodResponses() {
        return software.amazon.jsii.Kernel.get(this, "methodResponses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The responses that can be sent to the client who calls the method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMethodResponses(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "methodResponses", value);
    }

    /**
     * The responses that can be sent to the client who calls the method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMethodResponses(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.apigateway.CfnMethod.MethodResponseProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.services.apigateway.CfnMethod.MethodResponseProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "methodResponses", value);
    }

    /**
     * A friendly operation name for the method.
     * <p>
     * For example, you can assign the <code>OperationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOperationName() {
        return software.amazon.jsii.Kernel.get(this, "operationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A friendly operation name for the method.
     * <p>
     * For example, you can assign the <code>OperationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOperationName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "operationName", value);
    }

    /**
     * The resources that are used for the request's content type.
     * <p>
     * Specify request models as key-value pairs (string-to-string mapping), with a content type as the key and a <code>Model</code> resource name as the value. To use the same model regardless of the content type, specify <code>$default</code> as the key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRequestModels() {
        return software.amazon.jsii.Kernel.get(this, "requestModels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The resources that are used for the request's content type.
     * <p>
     * Specify request models as key-value pairs (string-to-string mapping), with a content type as the key and a <code>Model</code> resource name as the value. To use the same model regardless of the content type, specify <code>$default</code> as the key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequestModels(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "requestModels", value);
    }

    /**
     * The resources that are used for the request's content type.
     * <p>
     * Specify request models as key-value pairs (string-to-string mapping), with a content type as the key and a <code>Model</code> resource name as the value. To use the same model regardless of the content type, specify <code>$default</code> as the key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequestModels(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "requestModels", value);
    }

    /**
     * The request parameters that API Gateway accepts.
     * <p>
     * Specify request parameters as key-value pairs (string-to-Boolean mapping), with a source as the key and a Boolean as the value. The Boolean specifies whether a parameter is required. A source must match the format <code>method.request. *location* . *name*</code> , where the location is querystring, path, or header, and <em>name</em> is a valid, unique parameter name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRequestParameters() {
        return software.amazon.jsii.Kernel.get(this, "requestParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The request parameters that API Gateway accepts.
     * <p>
     * Specify request parameters as key-value pairs (string-to-Boolean mapping), with a source as the key and a Boolean as the value. The Boolean specifies whether a parameter is required. A source must match the format <code>method.request. *location* . *name*</code> , where the location is querystring, path, or header, and <em>name</em> is a valid, unique parameter name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequestParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "requestParameters", value);
    }

    /**
     * The request parameters that API Gateway accepts.
     * <p>
     * Specify request parameters as key-value pairs (string-to-Boolean mapping), with a source as the key and a Boolean as the value. The Boolean specifies whether a parameter is required. A source must match the format <code>method.request. *location* . *name*</code> , where the location is querystring, path, or header, and <em>name</em> is a valid, unique parameter name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequestParameters(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof java.lang.Boolean)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: java.lang.Boolean, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "requestParameters", value);
    }

    /**
     * The ID of the associated request validator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRequestValidatorId() {
        return software.amazon.jsii.Kernel.get(this, "requestValidatorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the associated request validator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequestValidatorId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "requestValidatorId", value);
    }
    /**
     * `Integration` is a property of the [AWS::ApiGateway::Method](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html) resource that specifies information about the target backend that a method calls.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigateway.*;
     * IntegrationProperty integrationProperty = IntegrationProperty.builder()
     *         .cacheKeyParameters(List.of("cacheKeyParameters"))
     *         .cacheNamespace("cacheNamespace")
     *         .connectionId("connectionId")
     *         .connectionType("connectionType")
     *         .contentHandling("contentHandling")
     *         .credentials("credentials")
     *         .integrationHttpMethod("integrationHttpMethod")
     *         .integrationResponses(List.of(IntegrationResponseProperty.builder()
     *                 .statusCode("statusCode")
     *                 // the properties below are optional
     *                 .contentHandling("contentHandling")
     *                 .responseParameters(Map.of(
     *                         "responseParametersKey", "responseParameters"))
     *                 .responseTemplates(Map.of(
     *                         "responseTemplatesKey", "responseTemplates"))
     *                 .selectionPattern("selectionPattern")
     *                 .build()))
     *         .passthroughBehavior("passthroughBehavior")
     *         .requestParameters(Map.of(
     *                 "requestParametersKey", "requestParameters"))
     *         .requestTemplates(Map.of(
     *                 "requestTemplatesKey", "requestTemplates"))
     *         .timeoutInMillis(123)
     *         .type("type")
     *         .uri("uri")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnMethod.IntegrationProperty")
    @software.amazon.jsii.Jsii.Proxy(IntegrationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntegrationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of request parameters whose values API Gateway caches.
         * <p>
         * For cases where the integration type allows for RequestParameters to be set, these parameters must also be specified in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters">RequestParameters</a> to be supported in <code>CacheKeyParameters</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCacheKeyParameters() {
            return null;
        }

        /**
         * An API-specific tag group of related cached parameters.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCacheNamespace() {
            return null;
        }

        /**
         * The ID of the `VpcLink` used for the integration when `connectionType=VPC_LINK` , otherwise undefined.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionId() {
            return null;
        }

        /**
         * The type of the network connection to the integration endpoint.
         * <p>
         * The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectionType() {
            return null;
        }

        /**
         * Specifies how to handle request payload content type conversions. Valid values are:.
         * <p>
         * <ul>
         * <li><code>CONVERT_TO_BINARY</code> : Converts a request payload from a base64-encoded string to a binary blob.</li>
         * <li><code>CONVERT_TO_TEXT</code> : Converts a request payload from a binary blob to a base64-encoded string.</li>
         * </ul>
         * <p>
         * If this property isn't defined, the request payload is passed through from the method request to the integration request without modification, provided that the <code>PassthroughBehaviors</code> property is configured to support payload pass-through.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContentHandling() {
            return null;
        }

        /**
         * The credentials that are required for the integration.
         * <p>
         * To specify an AWS Identity and Access Management (IAM) role that API Gateway assumes, specify the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::<em>:user/</em>.
         * <p>
         * To use resource-based permissions on the AWS Lambda (Lambda) function, don't specify this property. Use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html">AWS::Lambda::Permission</a> resource to permit API Gateway to call the function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html#access-control-resource-based-example-apigateway-invoke-function">Allow Amazon API Gateway to Invoke a Lambda Function</a> in the <em>AWS Lambda Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCredentials() {
            return null;
        }

        /**
         * The integration's HTTP method type.
         * <p>
         * For the <code>Type</code> property, if you specify <code>MOCK</code> , this property is optional. For all other types, you must specify this property.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIntegrationHttpMethod() {
            return null;
        }

        /**
         * The response that API Gateway provides after a method's backend completes processing a request.
         * <p>
         * API Gateway intercepts the response from the backend so that you can control how API Gateway surfaces backend responses. For example, you can map the backend status codes to codes that you define.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntegrationResponses() {
            return null;
        }

        /**
         * Indicates when API Gateway passes requests to the targeted backend.
         * <p>
         * This behavior depends on the request's <code>Content-Type</code> header and whether you defined a mapping template for it.
         * <p>
         * For more information and valid values, see the <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_PutIntegration.html#passthroughBehavior">passthroughBehavior</a> field in the <em>API Gateway API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassthroughBehavior() {
            return null;
        }

        /**
         * The request parameters that API Gateway sends with the backend request.
         * <p>
         * Specify request parameters as key-value pairs (string-to-string mappings), with a destination as the key and a source as the value.
         * <p>
         * Specify the destination by using the following pattern <code>integration.request. *location* . *name*</code> , where <em>location</em> is query string, path, or header, and <em>name</em> is a valid, unique parameter name.
         * <p>
         * The source must be an existing method request parameter or a static value. You must enclose static values in single quotation marks and pre-encode these values based on their destination in the request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequestParameters() {
            return null;
        }

        /**
         * A map of Apache Velocity templates that are applied on the request payload.
         * <p>
         * The template that API Gateway uses is based on the value of the <code>Content-Type</code> header that's sent by the client. The content type value is the key, and the template is the value (specified as a string), such as the following snippet:
         * <p>
         * <code>"application/json": "{\n \"statusCode\": 200\n}"</code>
         * <p>
         * For more information about templates, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html">API Gateway Mapping Template and Access Logging Variable Reference</a> in the <em>API Gateway Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequestTemplates() {
            return null;
        }

        /**
         * Custom timeout between 50 and 29,000 milliseconds.
         * <p>
         * The default value is 29,000 milliseconds or 29 seconds.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInMillis() {
            return null;
        }

        /**
         * The type of backend that your method is running, such as `HTTP` or `MOCK` .
         * <p>
         * For all of the valid values, see the <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html#type">type</a> property for the <code>Integration</code> resource in the <em>Amazon API Gateway REST API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * The Uniform Resource Identifier (URI) for the integration.
         * <p>
         * If you specify <code>HTTP</code> for the <code>Type</code> property, specify the API endpoint URL.
         * <p>
         * If you specify <code>MOCK</code> for the <code>Type</code> property, don't specify this property.
         * <p>
         * If you specify <code>AWS</code> for the <code>Type</code> property, specify an AWS service that follows this form: arn:aws:apigateway: <em>region</em> : <em>subdomain</em> . <em>service|service</em> : <em>path|action</em> / <em>service_api</em> . For example, a Lambda function URI follows this form: arn:aws:apigateway: <em>region</em> :lambda:path/ <em>path</em> . The path is usually in the form /2015-03-31/functions/ <em>LambdaFunctionARN</em> /invocations. For more information, see the <code>uri</code> property of the <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html">Integration</a> resource in the Amazon API Gateway REST API Reference.
         * <p>
         * If you specified <code>HTTP</code> or <code>AWS</code> for the <code>Type</code> property, you must specify this property.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IntegrationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntegrationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntegrationProperty> {
            java.util.List<java.lang.String> cacheKeyParameters;
            java.lang.String cacheNamespace;
            java.lang.String connectionId;
            java.lang.String connectionType;
            java.lang.String contentHandling;
            java.lang.String credentials;
            java.lang.String integrationHttpMethod;
            java.lang.Object integrationResponses;
            java.lang.String passthroughBehavior;
            java.lang.Object requestParameters;
            java.lang.Object requestTemplates;
            java.lang.Number timeoutInMillis;
            java.lang.String type;
            java.lang.String uri;

            /**
             * Sets the value of {@link IntegrationProperty#getCacheKeyParameters}
             * @param cacheKeyParameters A list of request parameters whose values API Gateway caches.
             *                           For cases where the integration type allows for RequestParameters to be set, these parameters must also be specified in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters">RequestParameters</a> to be supported in <code>CacheKeyParameters</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheKeyParameters(java.util.List<java.lang.String> cacheKeyParameters) {
                this.cacheKeyParameters = cacheKeyParameters;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getCacheNamespace}
             * @param cacheNamespace An API-specific tag group of related cached parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheNamespace(java.lang.String cacheNamespace) {
                this.cacheNamespace = cacheNamespace;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getConnectionId}
             * @param connectionId The ID of the `VpcLink` used for the integration when `connectionType=VPC_LINK` , otherwise undefined.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionId(java.lang.String connectionId) {
                this.connectionId = connectionId;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getConnectionType}
             * @param connectionType The type of the network connection to the integration endpoint.
             *                       The valid value is <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and a network load balancer in a VPC. The default value is <code>INTERNET</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionType(java.lang.String connectionType) {
                this.connectionType = connectionType;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getContentHandling}
             * @param contentHandling Specifies how to handle request payload content type conversions. Valid values are:.
             *                        <ul>
             *                        <li><code>CONVERT_TO_BINARY</code> : Converts a request payload from a base64-encoded string to a binary blob.</li>
             *                        <li><code>CONVERT_TO_TEXT</code> : Converts a request payload from a binary blob to a base64-encoded string.</li>
             *                        </ul>
             *                        <p>
             *                        If this property isn't defined, the request payload is passed through from the method request to the integration request without modification, provided that the <code>PassthroughBehaviors</code> property is configured to support payload pass-through.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentHandling(java.lang.String contentHandling) {
                this.contentHandling = contentHandling;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getCredentials}
             * @param credentials The credentials that are required for the integration.
             *                    To specify an AWS Identity and Access Management (IAM) role that API Gateway assumes, specify the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::<em>:user/</em>.
             *                    <p>
             *                    To use resource-based permissions on the AWS Lambda (Lambda) function, don't specify this property. Use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html">AWS::Lambda::Permission</a> resource to permit API Gateway to call the function. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html#access-control-resource-based-example-apigateway-invoke-function">Allow Amazon API Gateway to Invoke a Lambda Function</a> in the <em>AWS Lambda Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentials(java.lang.String credentials) {
                this.credentials = credentials;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getIntegrationHttpMethod}
             * @param integrationHttpMethod The integration's HTTP method type.
             *                              For the <code>Type</code> property, if you specify <code>MOCK</code> , this property is optional. For all other types, you must specify this property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integrationHttpMethod(java.lang.String integrationHttpMethod) {
                this.integrationHttpMethod = integrationHttpMethod;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getIntegrationResponses}
             * @param integrationResponses The response that API Gateway provides after a method's backend completes processing a request.
             *                             API Gateway intercepts the response from the backend so that you can control how API Gateway surfaces backend responses. For example, you can map the backend status codes to codes that you define.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integrationResponses(software.amazon.awscdk.core.IResolvable integrationResponses) {
                this.integrationResponses = integrationResponses;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getIntegrationResponses}
             * @param integrationResponses The response that API Gateway provides after a method's backend completes processing a request.
             *                             API Gateway intercepts the response from the backend so that you can control how API Gateway surfaces backend responses. For example, you can map the backend status codes to codes that you define.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integrationResponses(java.util.List<? extends java.lang.Object> integrationResponses) {
                this.integrationResponses = integrationResponses;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getPassthroughBehavior}
             * @param passthroughBehavior Indicates when API Gateway passes requests to the targeted backend.
             *                            This behavior depends on the request's <code>Content-Type</code> header and whether you defined a mapping template for it.
             *                            <p>
             *                            For more information and valid values, see the <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_PutIntegration.html#passthroughBehavior">passthroughBehavior</a> field in the <em>API Gateway API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder passthroughBehavior(java.lang.String passthroughBehavior) {
                this.passthroughBehavior = passthroughBehavior;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getRequestParameters}
             * @param requestParameters The request parameters that API Gateway sends with the backend request.
             *                          Specify request parameters as key-value pairs (string-to-string mappings), with a destination as the key and a source as the value.
             *                          <p>
             *                          Specify the destination by using the following pattern <code>integration.request. *location* . *name*</code> , where <em>location</em> is query string, path, or header, and <em>name</em> is a valid, unique parameter name.
             *                          <p>
             *                          The source must be an existing method request parameter or a static value. You must enclose static values in single quotation marks and pre-encode these values based on their destination in the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestParameters(software.amazon.awscdk.core.IResolvable requestParameters) {
                this.requestParameters = requestParameters;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getRequestParameters}
             * @param requestParameters The request parameters that API Gateway sends with the backend request.
             *                          Specify request parameters as key-value pairs (string-to-string mappings), with a destination as the key and a source as the value.
             *                          <p>
             *                          Specify the destination by using the following pattern <code>integration.request. *location* . *name*</code> , where <em>location</em> is query string, path, or header, and <em>name</em> is a valid, unique parameter name.
             *                          <p>
             *                          The source must be an existing method request parameter or a static value. You must enclose static values in single quotation marks and pre-encode these values based on their destination in the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestParameters(java.util.Map<java.lang.String, java.lang.String> requestParameters) {
                this.requestParameters = requestParameters;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getRequestTemplates}
             * @param requestTemplates A map of Apache Velocity templates that are applied on the request payload.
             *                         The template that API Gateway uses is based on the value of the <code>Content-Type</code> header that's sent by the client. The content type value is the key, and the template is the value (specified as a string), such as the following snippet:
             *                         <p>
             *                         <code>"application/json": "{\n \"statusCode\": 200\n}"</code>
             *                         <p>
             *                         For more information about templates, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html">API Gateway Mapping Template and Access Logging Variable Reference</a> in the <em>API Gateway Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestTemplates(software.amazon.awscdk.core.IResolvable requestTemplates) {
                this.requestTemplates = requestTemplates;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getRequestTemplates}
             * @param requestTemplates A map of Apache Velocity templates that are applied on the request payload.
             *                         The template that API Gateway uses is based on the value of the <code>Content-Type</code> header that's sent by the client. The content type value is the key, and the template is the value (specified as a string), such as the following snippet:
             *                         <p>
             *                         <code>"application/json": "{\n \"statusCode\": 200\n}"</code>
             *                         <p>
             *                         For more information about templates, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html">API Gateway Mapping Template and Access Logging Variable Reference</a> in the <em>API Gateway Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestTemplates(java.util.Map<java.lang.String, java.lang.String> requestTemplates) {
                this.requestTemplates = requestTemplates;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getTimeoutInMillis}
             * @param timeoutInMillis Custom timeout between 50 and 29,000 milliseconds.
             *                        The default value is 29,000 milliseconds or 29 seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutInMillis(java.lang.Number timeoutInMillis) {
                this.timeoutInMillis = timeoutInMillis;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getType}
             * @param type The type of backend that your method is running, such as `HTTP` or `MOCK` .
             *             For all of the valid values, see the <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html#type">type</a> property for the <code>Integration</code> resource in the <em>Amazon API Gateway REST API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationProperty#getUri}
             * @param uri The Uniform Resource Identifier (URI) for the integration.
             *            If you specify <code>HTTP</code> for the <code>Type</code> property, specify the API endpoint URL.
             *            <p>
             *            If you specify <code>MOCK</code> for the <code>Type</code> property, don't specify this property.
             *            <p>
             *            If you specify <code>AWS</code> for the <code>Type</code> property, specify an AWS service that follows this form: arn:aws:apigateway: <em>region</em> : <em>subdomain</em> . <em>service|service</em> : <em>path|action</em> / <em>service_api</em> . For example, a Lambda function URI follows this form: arn:aws:apigateway: <em>region</em> :lambda:path/ <em>path</em> . The path is usually in the form /2015-03-31/functions/ <em>LambdaFunctionARN</em> /invocations. For more information, see the <code>uri</code> property of the <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html">Integration</a> resource in the Amazon API Gateway REST API Reference.
             *            <p>
             *            If you specified <code>HTTP</code> or <code>AWS</code> for the <code>Type</code> property, you must specify this property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uri(java.lang.String uri) {
                this.uri = uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntegrationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntegrationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntegrationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegrationProperty {
            private final java.util.List<java.lang.String> cacheKeyParameters;
            private final java.lang.String cacheNamespace;
            private final java.lang.String connectionId;
            private final java.lang.String connectionType;
            private final java.lang.String contentHandling;
            private final java.lang.String credentials;
            private final java.lang.String integrationHttpMethod;
            private final java.lang.Object integrationResponses;
            private final java.lang.String passthroughBehavior;
            private final java.lang.Object requestParameters;
            private final java.lang.Object requestTemplates;
            private final java.lang.Number timeoutInMillis;
            private final java.lang.String type;
            private final java.lang.String uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cacheKeyParameters = software.amazon.jsii.Kernel.get(this, "cacheKeyParameters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cacheNamespace = software.amazon.jsii.Kernel.get(this, "cacheNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectionId = software.amazon.jsii.Kernel.get(this, "connectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectionType = software.amazon.jsii.Kernel.get(this, "connectionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.contentHandling = software.amazon.jsii.Kernel.get(this, "contentHandling", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.integrationHttpMethod = software.amazon.jsii.Kernel.get(this, "integrationHttpMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.integrationResponses = software.amazon.jsii.Kernel.get(this, "integrationResponses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.passthroughBehavior = software.amazon.jsii.Kernel.get(this, "passthroughBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.requestParameters = software.amazon.jsii.Kernel.get(this, "requestParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requestTemplates = software.amazon.jsii.Kernel.get(this, "requestTemplates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeoutInMillis = software.amazon.jsii.Kernel.get(this, "timeoutInMillis", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.uri = software.amazon.jsii.Kernel.get(this, "uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cacheKeyParameters = builder.cacheKeyParameters;
                this.cacheNamespace = builder.cacheNamespace;
                this.connectionId = builder.connectionId;
                this.connectionType = builder.connectionType;
                this.contentHandling = builder.contentHandling;
                this.credentials = builder.credentials;
                this.integrationHttpMethod = builder.integrationHttpMethod;
                this.integrationResponses = builder.integrationResponses;
                this.passthroughBehavior = builder.passthroughBehavior;
                this.requestParameters = builder.requestParameters;
                this.requestTemplates = builder.requestTemplates;
                this.timeoutInMillis = builder.timeoutInMillis;
                this.type = builder.type;
                this.uri = builder.uri;
            }

            @Override
            public final java.util.List<java.lang.String> getCacheKeyParameters() {
                return this.cacheKeyParameters;
            }

            @Override
            public final java.lang.String getCacheNamespace() {
                return this.cacheNamespace;
            }

            @Override
            public final java.lang.String getConnectionId() {
                return this.connectionId;
            }

            @Override
            public final java.lang.String getConnectionType() {
                return this.connectionType;
            }

            @Override
            public final java.lang.String getContentHandling() {
                return this.contentHandling;
            }

            @Override
            public final java.lang.String getCredentials() {
                return this.credentials;
            }

            @Override
            public final java.lang.String getIntegrationHttpMethod() {
                return this.integrationHttpMethod;
            }

            @Override
            public final java.lang.Object getIntegrationResponses() {
                return this.integrationResponses;
            }

            @Override
            public final java.lang.String getPassthroughBehavior() {
                return this.passthroughBehavior;
            }

            @Override
            public final java.lang.Object getRequestParameters() {
                return this.requestParameters;
            }

            @Override
            public final java.lang.Object getRequestTemplates() {
                return this.requestTemplates;
            }

            @Override
            public final java.lang.Number getTimeoutInMillis() {
                return this.timeoutInMillis;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getUri() {
                return this.uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCacheKeyParameters() != null) {
                    data.set("cacheKeyParameters", om.valueToTree(this.getCacheKeyParameters()));
                }
                if (this.getCacheNamespace() != null) {
                    data.set("cacheNamespace", om.valueToTree(this.getCacheNamespace()));
                }
                if (this.getConnectionId() != null) {
                    data.set("connectionId", om.valueToTree(this.getConnectionId()));
                }
                if (this.getConnectionType() != null) {
                    data.set("connectionType", om.valueToTree(this.getConnectionType()));
                }
                if (this.getContentHandling() != null) {
                    data.set("contentHandling", om.valueToTree(this.getContentHandling()));
                }
                if (this.getCredentials() != null) {
                    data.set("credentials", om.valueToTree(this.getCredentials()));
                }
                if (this.getIntegrationHttpMethod() != null) {
                    data.set("integrationHttpMethod", om.valueToTree(this.getIntegrationHttpMethod()));
                }
                if (this.getIntegrationResponses() != null) {
                    data.set("integrationResponses", om.valueToTree(this.getIntegrationResponses()));
                }
                if (this.getPassthroughBehavior() != null) {
                    data.set("passthroughBehavior", om.valueToTree(this.getPassthroughBehavior()));
                }
                if (this.getRequestParameters() != null) {
                    data.set("requestParameters", om.valueToTree(this.getRequestParameters()));
                }
                if (this.getRequestTemplates() != null) {
                    data.set("requestTemplates", om.valueToTree(this.getRequestTemplates()));
                }
                if (this.getTimeoutInMillis() != null) {
                    data.set("timeoutInMillis", om.valueToTree(this.getTimeoutInMillis()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getUri() != null) {
                    data.set("uri", om.valueToTree(this.getUri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnMethod.IntegrationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntegrationProperty.Jsii$Proxy that = (IntegrationProperty.Jsii$Proxy) o;

                if (this.cacheKeyParameters != null ? !this.cacheKeyParameters.equals(that.cacheKeyParameters) : that.cacheKeyParameters != null) return false;
                if (this.cacheNamespace != null ? !this.cacheNamespace.equals(that.cacheNamespace) : that.cacheNamespace != null) return false;
                if (this.connectionId != null ? !this.connectionId.equals(that.connectionId) : that.connectionId != null) return false;
                if (this.connectionType != null ? !this.connectionType.equals(that.connectionType) : that.connectionType != null) return false;
                if (this.contentHandling != null ? !this.contentHandling.equals(that.contentHandling) : that.contentHandling != null) return false;
                if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
                if (this.integrationHttpMethod != null ? !this.integrationHttpMethod.equals(that.integrationHttpMethod) : that.integrationHttpMethod != null) return false;
                if (this.integrationResponses != null ? !this.integrationResponses.equals(that.integrationResponses) : that.integrationResponses != null) return false;
                if (this.passthroughBehavior != null ? !this.passthroughBehavior.equals(that.passthroughBehavior) : that.passthroughBehavior != null) return false;
                if (this.requestParameters != null ? !this.requestParameters.equals(that.requestParameters) : that.requestParameters != null) return false;
                if (this.requestTemplates != null ? !this.requestTemplates.equals(that.requestTemplates) : that.requestTemplates != null) return false;
                if (this.timeoutInMillis != null ? !this.timeoutInMillis.equals(that.timeoutInMillis) : that.timeoutInMillis != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.uri != null ? this.uri.equals(that.uri) : that.uri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cacheKeyParameters != null ? this.cacheKeyParameters.hashCode() : 0;
                result = 31 * result + (this.cacheNamespace != null ? this.cacheNamespace.hashCode() : 0);
                result = 31 * result + (this.connectionId != null ? this.connectionId.hashCode() : 0);
                result = 31 * result + (this.connectionType != null ? this.connectionType.hashCode() : 0);
                result = 31 * result + (this.contentHandling != null ? this.contentHandling.hashCode() : 0);
                result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
                result = 31 * result + (this.integrationHttpMethod != null ? this.integrationHttpMethod.hashCode() : 0);
                result = 31 * result + (this.integrationResponses != null ? this.integrationResponses.hashCode() : 0);
                result = 31 * result + (this.passthroughBehavior != null ? this.passthroughBehavior.hashCode() : 0);
                result = 31 * result + (this.requestParameters != null ? this.requestParameters.hashCode() : 0);
                result = 31 * result + (this.requestTemplates != null ? this.requestTemplates.hashCode() : 0);
                result = 31 * result + (this.timeoutInMillis != null ? this.timeoutInMillis.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `IntegrationResponse` is a property of the [Amazon API Gateway Method Integration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html) property type that specifies the response that API Gateway sends after a method's backend finishes processing a request.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigateway.*;
     * IntegrationResponseProperty integrationResponseProperty = IntegrationResponseProperty.builder()
     *         .statusCode("statusCode")
     *         // the properties below are optional
     *         .contentHandling("contentHandling")
     *         .responseParameters(Map.of(
     *                 "responseParametersKey", "responseParameters"))
     *         .responseTemplates(Map.of(
     *                 "responseTemplatesKey", "responseTemplates"))
     *         .selectionPattern("selectionPattern")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnMethod.IntegrationResponseProperty")
    @software.amazon.jsii.Jsii.Proxy(IntegrationResponseProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntegrationResponseProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The status code that API Gateway uses to map the integration response to a [MethodResponse](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html) status code.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatusCode();

        /**
         * Specifies how to handle request payload content type conversions. Valid values are:.
         * <p>
         * <ul>
         * <li><code>CONVERT_TO_BINARY</code> : Converts a request payload from a base64-encoded string to a binary blob.</li>
         * <li><code>CONVERT_TO_TEXT</code> : Converts a request payload from a binary blob to a base64-encoded string.</li>
         * </ul>
         * <p>
         * If this property isn't defined, the request payload is passed through from the method request to the integration request without modification.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContentHandling() {
            return null;
        }

        /**
         * The response parameters from the backend response that API Gateway sends to the method response.
         * <p>
         * Specify response parameters as key-value pairs ( <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/mappings-section-structure.html">string-to-string mappings</a> ).
         * <p>
         * Use the destination as the key and the source as the value:
         * <p>
         * <ul>
         * <li>The destination must be an existing response parameter in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html">MethodResponse</a> property.</li>
         * <li>The source must be an existing method request parameter or a static value. You must enclose static values in single quotation marks and pre-encode these values based on the destination specified in the request.</li>
         * </ul>
         * <p>
         * For more information about templates, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html">API Gateway Mapping Template and Access Logging Variable Reference</a> in the <em>API Gateway Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResponseParameters() {
            return null;
        }

        /**
         * The templates that are used to transform the integration response body.
         * <p>
         * Specify templates as key-value pairs (string-to-string mappings), with a content type as the key and a template as the value. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html">API Gateway Mapping Template and Access Logging Variable Reference</a> in the <em>API Gateway Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResponseTemplates() {
            return null;
        }

        /**
         * A [regular expression](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-regexes.html) that specifies which error strings or status codes from the backend map to the integration response.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSelectionPattern() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IntegrationResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntegrationResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntegrationResponseProperty> {
            java.lang.String statusCode;
            java.lang.String contentHandling;
            java.lang.Object responseParameters;
            java.lang.Object responseTemplates;
            java.lang.String selectionPattern;

            /**
             * Sets the value of {@link IntegrationResponseProperty#getStatusCode}
             * @param statusCode The status code that API Gateway uses to map the integration response to a [MethodResponse](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html) status code. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusCode(java.lang.String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationResponseProperty#getContentHandling}
             * @param contentHandling Specifies how to handle request payload content type conversions. Valid values are:.
             *                        <ul>
             *                        <li><code>CONVERT_TO_BINARY</code> : Converts a request payload from a base64-encoded string to a binary blob.</li>
             *                        <li><code>CONVERT_TO_TEXT</code> : Converts a request payload from a binary blob to a base64-encoded string.</li>
             *                        </ul>
             *                        <p>
             *                        If this property isn't defined, the request payload is passed through from the method request to the integration request without modification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentHandling(java.lang.String contentHandling) {
                this.contentHandling = contentHandling;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationResponseProperty#getResponseParameters}
             * @param responseParameters The response parameters from the backend response that API Gateway sends to the method response.
             *                           Specify response parameters as key-value pairs ( <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/mappings-section-structure.html">string-to-string mappings</a> ).
             *                           <p>
             *                           Use the destination as the key and the source as the value:
             *                           <p>
             *                           <ul>
             *                           <li>The destination must be an existing response parameter in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html">MethodResponse</a> property.</li>
             *                           <li>The source must be an existing method request parameter or a static value. You must enclose static values in single quotation marks and pre-encode these values based on the destination specified in the request.</li>
             *                           </ul>
             *                           <p>
             *                           For more information about templates, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html">API Gateway Mapping Template and Access Logging Variable Reference</a> in the <em>API Gateway Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseParameters(software.amazon.awscdk.core.IResolvable responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationResponseProperty#getResponseParameters}
             * @param responseParameters The response parameters from the backend response that API Gateway sends to the method response.
             *                           Specify response parameters as key-value pairs ( <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/mappings-section-structure.html">string-to-string mappings</a> ).
             *                           <p>
             *                           Use the destination as the key and the source as the value:
             *                           <p>
             *                           <ul>
             *                           <li>The destination must be an existing response parameter in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html">MethodResponse</a> property.</li>
             *                           <li>The source must be an existing method request parameter or a static value. You must enclose static values in single quotation marks and pre-encode these values based on the destination specified in the request.</li>
             *                           </ul>
             *                           <p>
             *                           For more information about templates, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html">API Gateway Mapping Template and Access Logging Variable Reference</a> in the <em>API Gateway Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseParameters(java.util.Map<java.lang.String, java.lang.String> responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationResponseProperty#getResponseTemplates}
             * @param responseTemplates The templates that are used to transform the integration response body.
             *                          Specify templates as key-value pairs (string-to-string mappings), with a content type as the key and a template as the value. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html">API Gateway Mapping Template and Access Logging Variable Reference</a> in the <em>API Gateway Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseTemplates(software.amazon.awscdk.core.IResolvable responseTemplates) {
                this.responseTemplates = responseTemplates;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationResponseProperty#getResponseTemplates}
             * @param responseTemplates The templates that are used to transform the integration response body.
             *                          Specify templates as key-value pairs (string-to-string mappings), with a content type as the key and a template as the value. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html">API Gateway Mapping Template and Access Logging Variable Reference</a> in the <em>API Gateway Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseTemplates(java.util.Map<java.lang.String, java.lang.String> responseTemplates) {
                this.responseTemplates = responseTemplates;
                return this;
            }

            /**
             * Sets the value of {@link IntegrationResponseProperty#getSelectionPattern}
             * @param selectionPattern A [regular expression](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-regexes.html) that specifies which error strings or status codes from the backend map to the integration response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectionPattern(java.lang.String selectionPattern) {
                this.selectionPattern = selectionPattern;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntegrationResponseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntegrationResponseProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntegrationResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegrationResponseProperty {
            private final java.lang.String statusCode;
            private final java.lang.String contentHandling;
            private final java.lang.Object responseParameters;
            private final java.lang.Object responseTemplates;
            private final java.lang.String selectionPattern;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statusCode = software.amazon.jsii.Kernel.get(this, "statusCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.contentHandling = software.amazon.jsii.Kernel.get(this, "contentHandling", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.responseParameters = software.amazon.jsii.Kernel.get(this, "responseParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.responseTemplates = software.amazon.jsii.Kernel.get(this, "responseTemplates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.selectionPattern = software.amazon.jsii.Kernel.get(this, "selectionPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statusCode = java.util.Objects.requireNonNull(builder.statusCode, "statusCode is required");
                this.contentHandling = builder.contentHandling;
                this.responseParameters = builder.responseParameters;
                this.responseTemplates = builder.responseTemplates;
                this.selectionPattern = builder.selectionPattern;
            }

            @Override
            public final java.lang.String getStatusCode() {
                return this.statusCode;
            }

            @Override
            public final java.lang.String getContentHandling() {
                return this.contentHandling;
            }

            @Override
            public final java.lang.Object getResponseParameters() {
                return this.responseParameters;
            }

            @Override
            public final java.lang.Object getResponseTemplates() {
                return this.responseTemplates;
            }

            @Override
            public final java.lang.String getSelectionPattern() {
                return this.selectionPattern;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statusCode", om.valueToTree(this.getStatusCode()));
                if (this.getContentHandling() != null) {
                    data.set("contentHandling", om.valueToTree(this.getContentHandling()));
                }
                if (this.getResponseParameters() != null) {
                    data.set("responseParameters", om.valueToTree(this.getResponseParameters()));
                }
                if (this.getResponseTemplates() != null) {
                    data.set("responseTemplates", om.valueToTree(this.getResponseTemplates()));
                }
                if (this.getSelectionPattern() != null) {
                    data.set("selectionPattern", om.valueToTree(this.getSelectionPattern()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnMethod.IntegrationResponseProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntegrationResponseProperty.Jsii$Proxy that = (IntegrationResponseProperty.Jsii$Proxy) o;

                if (!statusCode.equals(that.statusCode)) return false;
                if (this.contentHandling != null ? !this.contentHandling.equals(that.contentHandling) : that.contentHandling != null) return false;
                if (this.responseParameters != null ? !this.responseParameters.equals(that.responseParameters) : that.responseParameters != null) return false;
                if (this.responseTemplates != null ? !this.responseTemplates.equals(that.responseTemplates) : that.responseTemplates != null) return false;
                return this.selectionPattern != null ? this.selectionPattern.equals(that.selectionPattern) : that.selectionPattern == null;
            }

            @Override
            public final int hashCode() {
                int result = this.statusCode.hashCode();
                result = 31 * result + (this.contentHandling != null ? this.contentHandling.hashCode() : 0);
                result = 31 * result + (this.responseParameters != null ? this.responseParameters.hashCode() : 0);
                result = 31 * result + (this.responseTemplates != null ? this.responseTemplates.hashCode() : 0);
                result = 31 * result + (this.selectionPattern != null ? this.selectionPattern.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `MethodResponse` is a property of the [AWS::ApiGateway::Method](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html) resource that defines the responses that can be sent to the client that calls a method.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigateway.*;
     * MethodResponseProperty methodResponseProperty = MethodResponseProperty.builder()
     *         .statusCode("statusCode")
     *         // the properties below are optional
     *         .responseModels(Map.of(
     *                 "responseModelsKey", "responseModels"))
     *         .responseParameters(Map.of(
     *                 "responseParametersKey", false))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnMethod.MethodResponseProperty")
    @software.amazon.jsii.Jsii.Proxy(MethodResponseProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MethodResponseProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The method response's status code, which you map to an [IntegrationResponse](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html) .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatusCode();

        /**
         * The resources used for the response's content type.
         * <p>
         * Specify response models as key-value pairs (string-to-string maps), with a content type as the key and a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html">Model</a> resource name as the value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResponseModels() {
            return null;
        }

        /**
         * Response parameters that API Gateway sends to the client that called a method.
         * <p>
         * Specify response parameters as key-value pairs (string-to-Boolean maps), with a destination as the key and a Boolean as the value. Specify the destination using the following pattern: <code>method.response.header. *name*</code> , where <em>name</em> is a valid, unique header name. The Boolean specifies whether a parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResponseParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MethodResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MethodResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MethodResponseProperty> {
            java.lang.String statusCode;
            java.lang.Object responseModels;
            java.lang.Object responseParameters;

            /**
             * Sets the value of {@link MethodResponseProperty#getStatusCode}
             * @param statusCode The method response's status code, which you map to an [IntegrationResponse](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html) . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusCode(java.lang.String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            /**
             * Sets the value of {@link MethodResponseProperty#getResponseModels}
             * @param responseModels The resources used for the response's content type.
             *                       Specify response models as key-value pairs (string-to-string maps), with a content type as the key and a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html">Model</a> resource name as the value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseModels(software.amazon.awscdk.core.IResolvable responseModels) {
                this.responseModels = responseModels;
                return this;
            }

            /**
             * Sets the value of {@link MethodResponseProperty#getResponseModels}
             * @param responseModels The resources used for the response's content type.
             *                       Specify response models as key-value pairs (string-to-string maps), with a content type as the key and a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-model.html">Model</a> resource name as the value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseModels(java.util.Map<java.lang.String, java.lang.String> responseModels) {
                this.responseModels = responseModels;
                return this;
            }

            /**
             * Sets the value of {@link MethodResponseProperty#getResponseParameters}
             * @param responseParameters Response parameters that API Gateway sends to the client that called a method.
             *                           Specify response parameters as key-value pairs (string-to-Boolean maps), with a destination as the key and a Boolean as the value. Specify the destination using the following pattern: <code>method.response.header. *name*</code> , where <em>name</em> is a valid, unique header name. The Boolean specifies whether a parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseParameters(software.amazon.awscdk.core.IResolvable responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            /**
             * Sets the value of {@link MethodResponseProperty#getResponseParameters}
             * @param responseParameters Response parameters that API Gateway sends to the client that called a method.
             *                           Specify response parameters as key-value pairs (string-to-Boolean maps), with a destination as the key and a Boolean as the value. Specify the destination using the following pattern: <code>method.response.header. *name*</code> , where <em>name</em> is a valid, unique header name. The Boolean specifies whether a parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseParameters(java.util.Map<java.lang.String, ? extends java.lang.Object> responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MethodResponseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MethodResponseProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MethodResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MethodResponseProperty {
            private final java.lang.String statusCode;
            private final java.lang.Object responseModels;
            private final java.lang.Object responseParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statusCode = software.amazon.jsii.Kernel.get(this, "statusCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.responseModels = software.amazon.jsii.Kernel.get(this, "responseModels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.responseParameters = software.amazon.jsii.Kernel.get(this, "responseParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statusCode = java.util.Objects.requireNonNull(builder.statusCode, "statusCode is required");
                this.responseModels = builder.responseModels;
                this.responseParameters = builder.responseParameters;
            }

            @Override
            public final java.lang.String getStatusCode() {
                return this.statusCode;
            }

            @Override
            public final java.lang.Object getResponseModels() {
                return this.responseModels;
            }

            @Override
            public final java.lang.Object getResponseParameters() {
                return this.responseParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statusCode", om.valueToTree(this.getStatusCode()));
                if (this.getResponseModels() != null) {
                    data.set("responseModels", om.valueToTree(this.getResponseModels()));
                }
                if (this.getResponseParameters() != null) {
                    data.set("responseParameters", om.valueToTree(this.getResponseParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CfnMethod.MethodResponseProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MethodResponseProperty.Jsii$Proxy that = (MethodResponseProperty.Jsii$Proxy) o;

                if (!statusCode.equals(that.statusCode)) return false;
                if (this.responseModels != null ? !this.responseModels.equals(that.responseModels) : that.responseModels != null) return false;
                return this.responseParameters != null ? this.responseParameters.equals(that.responseParameters) : that.responseParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.statusCode.hashCode();
                result = 31 * result + (this.responseModels != null ? this.responseModels.hashCode() : 0);
                result = 31 * result + (this.responseParameters != null ? this.responseParameters.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.CfnMethod}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.CfnMethod> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.CfnMethodProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.CfnMethodProps.Builder();
        }

        /**
         * The HTTP method that clients use to call this method.
         * <p>
         * @return {@code this}
         * @param httpMethod The HTTP method that clients use to call this method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpMethod(final java.lang.String httpMethod) {
            this.props.httpMethod(httpMethod);
            return this;
        }

        /**
         * The ID of an API Gateway [resource](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html) . For root resource methods, specify the `RestApi` root resource ID, such as `{ "Fn::GetAtt": ["MyRestApi", "RootResourceId"] }` .
         * <p>
         * @return {@code this}
         * @param resourceId The ID of an API Gateway [resource](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html) . For root resource methods, specify the `RestApi` root resource ID, such as `{ "Fn::GetAtt": ["MyRestApi", "RootResourceId"] }` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(final java.lang.String resourceId) {
            this.props.resourceId(resourceId);
            return this;
        }

        /**
         * The ID of the [RestApi](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html) resource in which API Gateway creates the method.
         * <p>
         * @return {@code this}
         * @param restApiId The ID of the [RestApi](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html) resource in which API Gateway creates the method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiId(final java.lang.String restApiId) {
            this.props.restApiId(restApiId);
            return this;
        }

        /**
         * Indicates whether the method requires clients to submit a valid API key.
         * <p>
         * @return {@code this}
         * @param apiKeyRequired Indicates whether the method requires clients to submit a valid API key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyRequired(final java.lang.Boolean apiKeyRequired) {
            this.props.apiKeyRequired(apiKeyRequired);
            return this;
        }
        /**
         * Indicates whether the method requires clients to submit a valid API key.
         * <p>
         * @return {@code this}
         * @param apiKeyRequired Indicates whether the method requires clients to submit a valid API key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyRequired(final software.amazon.awscdk.core.IResolvable apiKeyRequired) {
            this.props.apiKeyRequired(apiKeyRequired);
            return this;
        }

        /**
         * A list of authorization scopes configured on the method.
         * <p>
         * The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes match a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
         * <p>
         * @return {@code this}
         * @param authorizationScopes A list of authorization scopes configured on the method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationScopes(final java.util.List<java.lang.String> authorizationScopes) {
            this.props.authorizationScopes(authorizationScopes);
            return this;
        }

        /**
         * The method's authorization type.
         * <p>
         * This parameter is required. For valid values, see <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_Method.html">Method</a> in the <em>API Gateway API Reference</em> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify the <code>AuthorizerId</code> property, specify <code>CUSTOM</code> or <code>COGNITO_USER_POOLS</code> for this property.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param authorizationType The method's authorization type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationType(final java.lang.String authorizationType) {
            this.props.authorizationType(authorizationType);
            return this;
        }

        /**
         * The identifier of the [authorizer](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html) to use on this method. If you specify this property, specify `CUSTOM` or `COGNITO_USER_POOLS` for the `AuthorizationType` property.
         * <p>
         * @return {@code this}
         * @param authorizerId The identifier of the [authorizer](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html) to use on this method. If you specify this property, specify `CUSTOM` or `COGNITO_USER_POOLS` for the `AuthorizationType` property. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerId(final java.lang.String authorizerId) {
            this.props.authorizerId(authorizerId);
            return this;
        }

        /**
         * The backend system that the method calls when it receives a request.
         * <p>
         * @return {@code this}
         * @param integration The backend system that the method calls when it receives a request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integration(final software.amazon.awscdk.core.IResolvable integration) {
            this.props.integration(integration);
            return this;
        }
        /**
         * The backend system that the method calls when it receives a request.
         * <p>
         * @return {@code this}
         * @param integration The backend system that the method calls when it receives a request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integration(final software.amazon.awscdk.services.apigateway.CfnMethod.IntegrationProperty integration) {
            this.props.integration(integration);
            return this;
        }

        /**
         * The responses that can be sent to the client who calls the method.
         * <p>
         * @return {@code this}
         * @param methodResponses The responses that can be sent to the client who calls the method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder methodResponses(final software.amazon.awscdk.core.IResolvable methodResponses) {
            this.props.methodResponses(methodResponses);
            return this;
        }
        /**
         * The responses that can be sent to the client who calls the method.
         * <p>
         * @return {@code this}
         * @param methodResponses The responses that can be sent to the client who calls the method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder methodResponses(final java.util.List<? extends java.lang.Object> methodResponses) {
            this.props.methodResponses(methodResponses);
            return this;
        }

        /**
         * A friendly operation name for the method.
         * <p>
         * For example, you can assign the <code>OperationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method.
         * <p>
         * @return {@code this}
         * @param operationName A friendly operation name for the method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operationName(final java.lang.String operationName) {
            this.props.operationName(operationName);
            return this;
        }

        /**
         * The resources that are used for the request's content type.
         * <p>
         * Specify request models as key-value pairs (string-to-string mapping), with a content type as the key and a <code>Model</code> resource name as the value. To use the same model regardless of the content type, specify <code>$default</code> as the key.
         * <p>
         * @return {@code this}
         * @param requestModels The resources that are used for the request's content type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestModels(final software.amazon.awscdk.core.IResolvable requestModels) {
            this.props.requestModels(requestModels);
            return this;
        }
        /**
         * The resources that are used for the request's content type.
         * <p>
         * Specify request models as key-value pairs (string-to-string mapping), with a content type as the key and a <code>Model</code> resource name as the value. To use the same model regardless of the content type, specify <code>$default</code> as the key.
         * <p>
         * @return {@code this}
         * @param requestModels The resources that are used for the request's content type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestModels(final java.util.Map<java.lang.String, java.lang.String> requestModels) {
            this.props.requestModels(requestModels);
            return this;
        }

        /**
         * The request parameters that API Gateway accepts.
         * <p>
         * Specify request parameters as key-value pairs (string-to-Boolean mapping), with a source as the key and a Boolean as the value. The Boolean specifies whether a parameter is required. A source must match the format <code>method.request. *location* . *name*</code> , where the location is querystring, path, or header, and <em>name</em> is a valid, unique parameter name.
         * <p>
         * @return {@code this}
         * @param requestParameters The request parameters that API Gateway accepts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(final software.amazon.awscdk.core.IResolvable requestParameters) {
            this.props.requestParameters(requestParameters);
            return this;
        }
        /**
         * The request parameters that API Gateway accepts.
         * <p>
         * Specify request parameters as key-value pairs (string-to-Boolean mapping), with a source as the key and a Boolean as the value. The Boolean specifies whether a parameter is required. A source must match the format <code>method.request. *location* . *name*</code> , where the location is querystring, path, or header, and <em>name</em> is a valid, unique parameter name.
         * <p>
         * @return {@code this}
         * @param requestParameters The request parameters that API Gateway accepts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(final java.util.Map<java.lang.String, ? extends java.lang.Object> requestParameters) {
            this.props.requestParameters(requestParameters);
            return this;
        }

        /**
         * The ID of the associated request validator.
         * <p>
         * @return {@code this}
         * @param requestValidatorId The ID of the associated request validator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestValidatorId(final java.lang.String requestValidatorId) {
            this.props.requestValidatorId(requestValidatorId);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.CfnMethod}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.CfnMethod build() {
            return new software.amazon.awscdk.services.apigateway.CfnMethod(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
